/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.io.File;
import java.net.URL;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.model.NodeFactory;
import oracle.bpm.fusion.core.model.ObjectContainerNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.javatools.marshal.TransientMarker;

public final class StudioNodeFactory<E>
implements NodeFactory<TreeNode> {
    private static StudioNodeFactory instance;

    public static synchronized StudioNodeFactory getInstance() {
        if (instance == null) {
            instance = new StudioNodeFactory();
        }
        return instance;
    }

    public static URL calculateURL(TreeNode treeNode) throws TransientMarker {
        URL result = (URL)treeNode.as(URL.class);
        if (result == null) {
            File objectFile = (File)treeNode.as(File.class);
            result = StudioNodeFactory.asUrl(objectFile);
        }
        if (result == null) {
            TreeNode[] treeNodes = treeNode.getPath();
            StringBuffer url = new StringBuffer();
            boolean first = true;
            for (TreeNode node : treeNodes) {
                if (first) {
                    first = false;
                    continue;
                }
                url.append("/").append(node.getText());
            }
            result = URLFactory.newDirURL((String)"file", (String)url.toString());
        }
        return result;
    }

    @Override
    public Element createNode(TreeNode treeNode) {
        URL url = null;
        if (url == null) {
            url = StudioNodeFactory.calculateURL(treeNode);
        }
        return this.createNode(treeNode, url);
    }

    public Element createNodeWithNullUrl(TreeNode treeNode) {
        return new TreeNodeAdapter(treeNode, null);
    }

    private static URL asUrl(File objecFile) {
        if (objecFile != null) {
            if (objecFile.isDirectory()) {
                return URLFactory.newDirURL((File)objecFile);
            }
            return URLFactory.newFileURL((File)objecFile);
        }
        return null;
    }

    private Element createNode(TreeNode treeNode, URL url) {
        Object studioNode;
        Class<?> userObjClass = treeNode.getUserObject().getClass();
        if (TreeNodeAdapter.isExternalNode(userObjClass)) {
            try {
                studioNode = oracle.ide.model.NodeFactory.findOrCreate((URL)url);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (treeNode.isRoot() && url != null) {
            studioNode = new ObjectContainerNode(treeNode, url);
        } else if (ProjectObject.class.isAssignableFrom(treeNode.getUserObject().getClass())) {
            if (ResourceContainer.class.isAssignableFrom(treeNode.getUserObject().getClass())) {
                studioNode = new ObjectContainerNode(treeNode, url);
            } else {
                Class<?> aClass = treeNode.getUserObject().getClass();
                if (ResourceFilesContainer.class.isAssignableFrom(aClass) || CatalogModule.class.isAssignableFrom(aClass) || VirtualContainer.class.isAssignableFrom(aClass)) {
                    studioNode = new ObjectContainerNode(treeNode, url);
                } else {
                    boolean cachedUnknown;
                    Object userObject = treeNode.getUserObject();
                    Node node = null;
                    try {
                        if (this.isCacheableNode(userObject)) {
                            DefaultProjectObject projectObject = (DefaultProjectObject)userObject;
                            Node isNodeCached = oracle.ide.model.NodeFactory.find((URL)url);
                            if (isNodeCached != null && isNodeCached instanceof ProjectObjectNode && !((ProjectObjectNode)isNodeCached).getObject().equals(userObject)) {
                                oracle.ide.model.NodeFactory.uncache((URL)url);
                                isNodeCached = null;
                            }
                            if (isNodeCached == null) {
                                node = oracle.ide.model.NodeFactory.findOrCreate((URL)url);
                                if (node != null && !(node instanceof TreeNodeAdapter)) {
                                    projectObject.addAdapter((Object)node);
                                }
                            } else {
                                node = isNodeCached;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    boolean bl = cachedUnknown = node instanceof ProjectObjectNode && ((ProjectObjectNode)node).isUnknownNode();
                    studioNode = node != null && node instanceof StudioNode && !cachedUnknown ? node : (userObject instanceof CatalogModule ? new ObjectContainerNode(treeNode, url) : new TreeNodeAdapter(treeNode, url));
                    if (userObject instanceof CatalogObject && (((CatalogObject)userObject).isSynthesized() || ((CatalogObject)userObject).isModule())) {
                        studioNode.getAttributes().unset(ElementAttributes.SAVEABLE);
                        studioNode.getAttributes().set(ElementAttributes.READ_ONLY);
                    }
                }
            }
        } else {
            studioNode = new ObjectContainerNode(treeNode, url);
        }
        return studioNode;
    }

    private boolean isCacheableNode(Object userObject) {
        boolean isCatalogObject = userObject instanceof CatalogObject;
        return !isCatalogObject && userObject instanceof ResourceObject;
    }
}

