/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.fusion.core.model.AbstractContainerNode;
import oracle.bpm.fusion.core.model.PositionableNode;
import oracle.bpm.fusion.core.model.StudioNodeFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;

public class ObjectContainerNode<E>
extends AbstractContainerNode<E>
implements PositionableNode {
    private final TreeNode treeNode;

    public ObjectContainerNode(TreeNode treeNode, URL url) {
        super(treeNode.getUserObject());
        this.setURL(url);
        this.treeNode = treeNode;
        this.getAttributes().set(ElementAttributes.NON_RELOADABLE);
    }

    @Override
    public ActionGroup createActions() {
        return this.treeNode.createActions();
    }

    public String getShortLabel() {
        return this.treeNode.getText();
    }

    public Icon getIcon() {
        return this.resolveIcon();
    }

    @Override
    public int getPosition() {
        if (this.getObject() instanceof ProjectObject) {
            return ((ProjectObject)this.getObject()).getPosition();
        }
        return -1;
    }

    @Override
    public void markDirty(boolean b) {
    }

    @Override
    public void invalidateIcon() {
        if (this.treeNode != null) {
            this.treeNode.reloadIcon();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectContainerNode && this.treeNode != null) {
            return this.treeNode.equals(((ObjectContainerNode)obj).treeNode);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.treeNode != null) {
            return this.treeNode.hashCode();
        }
        return super.hashCode();
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    protected Icon resolveIcon() {
        Image icon = this.treeNode.getIcon();
        return icon != null ? icon.asSwingIcon() : super.getIcon();
    }

    protected void openImpl() throws IOException {
        for (TreeNode childNode : this.treeNode.getChildren()) {
            Element childNodeAdapter = StudioNodeFactory.getInstance().createNode(childNode);
            if (childNodeAdapter == null) continue;
            this.add(childNodeAdapter, true);
        }
        this.markDirty(false);
    }
}

