/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.net.URL;
import java.util.Iterator;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.ide.model.DataNode;
import oracle.ide.model.Element;

public abstract class AbstractNodeAdapter<E>
extends DataNode
implements StudioNode<E>,
Comparable<AbstractNodeAdapter<E>> {
    public AbstractNodeAdapter(URL url) {
        super(url);
    }

    @Override
    public abstract E getObject();

    public Iterator<Element> getChildren() {
        return CollectionUtils.emptyIterator();
    }

    @Override
    public <T> T as(Class<T> targetType) {
        T result = null;
        if (targetType.isAssignableFrom(this.getClass())) {
            result = targetType.cast(this);
        } else {
            E object = this.getObject();
            if (object != null) {
                if (targetType.isAssignableFrom(object.getClass())) {
                    result = targetType.cast(object);
                } else if (object instanceof Adaptable) {
                    Adaptable adaptable = (Adaptable)object;
                    result = adaptable.as(targetType);
                }
            }
        }
        return result;
    }

    @Override
    public Class<? extends E> getObjectClass() {
        return this.getObject().getClass();
    }

    @Override
    public int compareTo(AbstractNodeAdapter<E> other) {
        return this.compareNames(this.getObject(), other.getObject());
    }

    private int compareNames(E element1, E element2) {
        String label1 = this.getLabel(element1);
        String label2 = this.getLabel(element2);
        int result = 0;
        if (label1 != null && label2 != null) {
            result = label1.compareTo(label2);
        }
        if (result == 0 && element1 != element2) {
            String id1 = this.getId(element1);
            String id2 = this.getId(element2);
            result = id1.compareTo(id2);
        }
        return result;
    }

    private String getLabel(E element) {
        String label = null;
        if (element instanceof Localizable) {
            Localizable localizable = (Localizable)element;
            label = localizable.getDefaultLabel();
        }
        return label;
    }

    private String getId(E element) {
        String id = "";
        if (element instanceof ProjectObject) {
            id = ((ProjectObject)element).getId();
        }
        if (id == null) {
            id = "";
        }
        id = id + element.toString();
        id = id + Platform.getAdapterService().adaptTo(element, URL.class);
        id = id + System.identityHashCode(element);
        return id;
    }
}

