/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.fusion.core.model.StudioFolder;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogObjectComparator;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.ui.action.ActionGroup;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;

public abstract class AbstractContainerNode<E>
extends DefaultContainer
implements StudioFolder<E> {
    private E object;
    private static final String BPEL_NODE = "BPELNode";
    private static final String CASE_NODE = "CaseNode";
    private static final String CASE_ACTIVITY_NODE = "CaseActivityNode";
    private static final String RULE_NODE = "RulesRepositoryNode";
    private static final String ROUTING_SLIP_NODE = "RoutingSlipNode";
    private static final String MAPPER_NODE = "MapperNode";
    private static final String DOT_TASK = ".task";
    private static final String DOT_BPEL = ".bpel";
    private static final String DOT_CASE = ".case";
    private static final String DOT_CASE_ACTIVITY = ".caseactivity";
    private static final String DOT_RULES = ".rules";
    private static final String DOT_XSL = ".xsl";

    public AbstractContainerNode(E object) {
        this.object = object;
    }

    public static StudioNode findChildByData(StudioNode studioNode, Object object) {
        Element element = AbstractContainerNode.findChildElementByData(studioNode, object);
        return element instanceof StudioNode ? (StudioNode)element : null;
    }

    public static Element findChildElementByData(StudioNode studioNode, Object object) {
        StudioNode result = null;
        Iterator it = studioNode.getChildren();
        while (it.hasNext()) {
            String shortLabel;
            Element element = (Element)it.next();
            if (element instanceof StudioNode) {
                StudioNode child = (StudioNode)element;
                Object childObject = child.getObject();
                if (!childObject.equals(object) && (!(childObject instanceof CatalogObject) || !CatalogObjectComparator.simpleComparator((CatalogObject)((CatalogObject)childObject), (Object)object))) continue;
                result = child;
                break;
            }
            if (object instanceof HumanTask && element.getClass().getSimpleName().equals(ROUTING_SLIP_NODE)) {
                HumanTask humanTask = (HumanTask)object;
                shortLabel = element.getShortLabel();
                if (shortLabel.endsWith(DOT_TASK)) {
                    shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_TASK.length());
                }
                if (!humanTask.getName().equals(shortLabel)) continue;
                result = element;
                break;
            }
            if (object instanceof BpelProcess && element.getClass().getSimpleName().equals(BPEL_NODE)) {
                BpelProcess bpelProcess = (BpelProcess)object;
                shortLabel = element.getShortLabel();
                if (shortLabel.endsWith(DOT_BPEL)) {
                    shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_BPEL.length());
                }
                if (!bpelProcess.getName().equals(shortLabel)) continue;
                result = element;
                break;
            }
            if (object instanceof ProjectCase && element.getClass().getSimpleName().equals(CASE_NODE)) {
                ProjectCase projectCase = (ProjectCase)object;
                shortLabel = element.getShortLabel();
                if (shortLabel.endsWith(DOT_CASE)) {
                    shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_CASE.length());
                }
                if (!projectCase.getName().equals(shortLabel)) continue;
                result = element;
                break;
            }
            if (object instanceof ProjectCaseActivity && element.getClass().getSimpleName().equals(CASE_ACTIVITY_NODE)) {
                ProjectCaseActivity projectCaseActivity = (ProjectCaseActivity)object;
                shortLabel = element.getShortLabel();
                if (shortLabel.endsWith(DOT_CASE_ACTIVITY)) {
                    shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_CASE_ACTIVITY.length());
                }
                if (!projectCaseActivity.getName().equals(shortLabel)) continue;
                result = element;
                break;
            }
            if (object instanceof BusinessRule && element.getClass().getSimpleName().equals(RULE_NODE)) {
                BusinessRule rule = (BusinessRule)object;
                shortLabel = element.getShortLabel();
                if (shortLabel.endsWith(DOT_RULES)) {
                    shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_RULES.length());
                }
                if (!rule.getName().equals(shortLabel)) continue;
                result = element;
                break;
            }
            if (!(object instanceof XSLTransformation) || !element.getClass().getSimpleName().equals(MAPPER_NODE)) continue;
            XSLTransformation transformation = (XSLTransformation)object;
            shortLabel = element.getShortLabel();
            if (shortLabel.endsWith(DOT_XSL)) {
                shortLabel = shortLabel.substring(0, shortLabel.length() - DOT_XSL.length());
            }
            if (!transformation.getName().equals(shortLabel)) continue;
            result = element;
            break;
        }
        return result;
    }

    public static StudioNode findNode(StudioNode rootNode, List<? extends Object> objectPath) {
        StudioNode current = rootNode;
        for (Object object : objectPath) {
            if (current.getObject() != object) {
                current = AbstractContainerNode.findChildByData(current, object);
            }
            if (current != null) continue;
            break;
        }
        return current;
    }

    @Override
    public void replaceObject(E replacement) {
        this.object = replacement;
        UpdateMessage message1 = new UpdateMessage(UpdateMessage.CHILD_RENAMED, (Object)this);
        this.notifyObservers(this, message1);
        UpdateMessage message = new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this);
        this.notifyObservers(this, message);
    }

    @Override
    public void invalidateIcon() {
    }

    @Override
    public E getObject() {
        return this.object;
    }

    @Override
    public final <T> T as(Class<T> targetType) {
        T result = null;
        if (targetType.isAssignableFrom(this.getClass())) {
            result = targetType.cast(this);
        } else {
            E object = this.getObject();
            if (object != null) {
                if (targetType.isAssignableFrom(object.getClass())) {
                    result = targetType.cast(object);
                } else if (object instanceof Adaptable) {
                    Adaptable adaptable = (Adaptable)object;
                    result = adaptable.as(targetType);
                }
            }
        }
        return result;
    }

    @Override
    public Class<? extends E> getObjectClass() {
        return this.getObject().getClass();
    }

    @Override
    public void postChildModified() {
        this.refreshTimestamp();
    }

    @Override
    public ActionGroup createActions() {
        return ActionGroup.create(this.getObject());
    }

    public void reloadChildren(Iterable<? extends Element> children) {
        this.removeAll();
        if (children != null) {
            for (Element element : children) {
                this.add(element, false);
            }
        } else {
            try {
                this.openImpl();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void closeImpl() throws IOException {
        this._children.clear();
    }
}

