/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.customhooks;

import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.bpm.fusion.core.customhooks.ActionRef;
import oracle.bpm.fusion.core.customhooks.Button;
import oracle.bpm.fusion.core.customhooks.MenuButtonHandler;
import oracle.bpm.fusion.core.customhooks.ToolbarButtonsModel;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class ToolbarButtonsHook
extends ExtensionHook {
    private ToolbarButtonsModel buttonsContainer = new ToolbarButtonsModel();
    public static final ElementName TOOLBAR_BUTTONS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "toolbar-buttons");
    static final ElementName ACTION_MENU_BUTTON_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "action-menu-button");
    static final ElementName ACTION_ITEM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "action-item");
    static final String TOOLBAR_BUTTONS_MODEL = "toolbar-buttons-model";
    static final String MENU_BUTTON = "menu-button";

    public void installButtons() {
        for (Button button : this.getButtonContainer().getButtons()) {
            this.configureButton(button);
        }
    }

    public ToolbarButtonsModel getButtonContainer() {
        return this.buttonsContainer;
    }

    public void start(ElementStartContext context) {
        context.getScopeData().put(TOOLBAR_BUTTONS_MODEL, this.getButtonContainer());
        context.registerChildVisitor(ACTION_MENU_BUTTON_ELEMENT, (ElementVisitor)new MenuButtonHandler());
        super.start(context);
    }

    private void configureButton(Button button) {
        ToggleAction[] actions = new ToggleAction[button.getActionsCount()];
        int index = 0;
        for (ActionRef actionRef : button.getActionsRef()) {
            ToggleAction action;
            actions[index] = action = this.findAction(actionRef);
            ++index;
        }
        actions[0].putValue("ActionMenuActions", (Object)actions);
    }

    private ToggleAction findAction(ActionRef actionRef) {
        IdeAction action = IdeAction.find((String)actionRef.getActionRef());
        return action;
    }
}

