/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.ide.net.URLFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlInputSource
implements InputSource {
    private final URL url;

    private UrlInputSource(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/core/UrlInputSource.<init> must not be null");
        }
        this.url = url;
    }

    public static UrlInputSource create(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/core/UrlInputSource.create must not be null");
        }
        return new UrlInputSource(url);
    }

    @Override
    @Nullable
    public String getFileName() {
        return URLFileSystem.getFileName((URL)this.url);
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        return URLFileSystem.openInputStream((URL)this.url);
    }

    @Override
    public boolean isFolder() {
        return URLFileSystem.isDirectory((URL)this.url);
    }
}

