/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.fusion.core.UrlInputSource;
import oracle.bpm.fusion.core.model.AbstractNodeAdapter;
import oracle.bpm.fusion.core.model.PositionableNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.recognizer.ProjectRecognizer;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.util.LoggingUtils;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.marshal.ObjectStore;

public class ProjectObjectNode
extends AbstractNodeAdapter<ProjectObject>
implements StudioNode<ProjectObject>,
PositionableNode {
    private Icon cachedIcon;
    private ProjectObject object;
    private Class<? extends ProjectObject> objectClass;
    private TreeNode treeNode;
    private static final ProjectRecognizer RECOGNIZER = ProjectRecognizer.getInstance();

    public ProjectObjectNode(URL url) {
        this(url, null);
    }

    protected ProjectObjectNode(URL url, TreeNode treeNode) {
        super(url);
        this.getAttributes().set(ElementAttributes.NON_HISTORIED | ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE);
        this.treeNode = treeNode;
    }

    @Override
    public void replaceObject(ProjectObject replacement) {
        this.object = replacement;
        UpdateMessage message1 = new UpdateMessage(UpdateMessage.CHILD_RENAMED, (Object)this);
        this.notifyObservers(this, message1);
        UpdateMessage message = new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this);
        this.notifyObservers(this, message);
    }

    @Override
    public void invalidateIcon() {
        this.cachedIcon = null;
        TreeNode node = this.treeNode;
        if (node != null) {
            node.reloadIcon();
        }
    }

    @Override
    public Class<? extends ProjectObject> getObjectClass() {
        if (this.objectClass == null) {
            this.objectClass = this.resolveClass();
        }
        return this.objectClass;
    }

    @Override
    public ProjectObject getObject() {
        if (this.object == null) {
            this.object = this.loadObject();
            if (this.objectClass != null && !this.objectClass.isAssignableFrom(this.object.getClass())) {
                throw new IllegalArgumentException("Unexpected project object class: " + this.object.getClass().toString() + ", recognized class was: " + this.objectClass.toString());
            }
            this.objectClass = this.object.getClass();
        }
        return this.object;
    }

    @Override
    public ActionGroup createActions() {
        return ActionGroup.create((Object)this.getObject());
    }

    public Icon getIcon() {
        if (this.cachedIcon == null) {
            this.cachedIcon = this.resolveIcon();
        }
        return this.cachedIcon;
    }

    @Override
    public void markDirty(boolean b) {
        if (this.getAttributes().isSet(ElementAttributes.SAVEABLE) && this.getObject() instanceof ResourceObject) {
            super.markDirty(b);
        }
    }

    public String getShortLabel() {
        try {
            TreeNode treeNode = this.getTreeNode();
            return treeNode != null ? treeNode.getText() : "";
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace();
            return String.valueOf(this.getURL());
        }
    }

    @Override
    public int getPosition() {
        try {
            return this.getObject().getPosition();
        }
        catch (IllegalStateException e) {
            assert (Log.logDebug("Cannot get Posistion - Object for node " + this + "not adapted"));
            return -1;
        }
    }

    public boolean isUnknownNode() {
        return this.treeNode instanceof UnknownProjectObjectTreeNode;
    }

    protected void revertImpl() throws IOException {
        ProjectObject projectObject = this.getObject();
        ProjectLoader loader = projectObject.getProject().getLoader();
        if (loader != null) {
            try {
                ProjectObject newProjectObject = loader.replaceProjectObject(projectObject);
                this.replaceObject(newProjectObject);
            }
            catch (ProjectException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }
    }

    protected Icon resolveIcon() {
        TreeNode treeNode = this.getTreeNode();
        Image icon = treeNode != null ? treeNode.getIcon() : null;
        return icon != null ? icon.asSwingIcon() : null;
    }

    protected void saveImpl() throws IOException {
        super.saveImpl();
    }

    protected final ObjectStore newObjectStore() {
        return new ProjectObjectNodeObjectStore();
    }

    protected TreeNode getTreeNode() {
        if (this.treeNode == null) {
            try {
                ProjectObject object = this.getObject();
                if (object != null) {
                    this.treeNode = TreeNode.createDynamic((Object)object);
                }
            }
            catch (RuntimeException e) {
                LoggingUtils.assertPrintStackTrace(e);
                this.treeNode = UnknownProjectObjectTreeNode.create();
            }
        }
        return this.treeNode;
    }

    protected void registerAdapter(ProjectObject result) {
        ((DefaultProjectObject)result).addAdapter((Object)this);
    }

    private ProjectObject loadObject() {
        AdapterService service = Platform.getAdapterService();
        ProjectObject result = service.adaptTo(this.getURL(), ProjectObject.class);
        if (result == null) {
            throw new IllegalStateException("Could not adapt url '" + this.getURL() + "' to a project object.");
        }
        this.registerAdapter(result);
        return result;
    }

    private Class<? extends ProjectObject> resolveClass() {
        Class<Object> objectClass = this.object != null ? this.object.getClass() : RECOGNIZER.recognize(UrlInputSource.create(this.getURL()));
        return objectClass;
    }

    private class ProjectObjectNodeObjectStore
    implements ObjectStore {
        private ProjectObjectNodeObjectStore() {
        }

        public Object load(URL url) throws IOException {
            System.out.println("ProjectObjectNodeObjectStore.load() " + url);
            return null;
        }

        public boolean open(URL url, Object object) throws IOException {
            return true;
        }

        public boolean save(URL url, Object object) throws IOException {
            ProjectObject object1 = ProjectObjectNode.this.getObject();
            if (object1 != null && object1.getProject() != null) {
                ProjectWriter projectWriter = object1.getProject().getWriter();
                ResourceObject resourceObject = object1.findResourceObject();
                if (projectWriter != null && projectWriter.isWritable((ProjectObject)resourceObject)) {
                    try {
                        projectWriter.write(new ProjectObject[]{resourceObject});
                    }
                    catch (ProjectException e) {
                        Log.logTrace(e);
                    }
                }
                ProjectObjectNode.this.markDirty(false);
                return true;
            }
            return false;
        }
    }

    private static class UnknownProjectObjectTreeNode
    extends TreeNode {
        private UnknownProjectObjectTreeNode() {
        }

        public static UnknownProjectObjectTreeNode create() {
            return new UnknownProjectObjectTreeNode();
        }

        public String getText() {
            return "Unknown Project Object";
        }

        public Image getIcon() {
            return Image.create((Msg)UIMsg.ERROR);
        }
    }
}

