/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core;

import java.util.Comparator;
import oracle.bpm.fusion.core.model.AbstractContainerNode;
import oracle.bpm.fusion.core.model.ExplorerNodeComparator;
import oracle.bpm.fusion.core.model.StudioFolder;
import oracle.bpm.project.model.ProjectObject;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public abstract class BaseNavigatorManager
extends DefaultNavigatorManager {
    private Comparator<ExplorerNode> comparator = new ExplorerNodeComparator();
    private StudioFolder<ProjectObject> rootNode = this.createRootNode();

    public StudioFolder<ProjectObject> getRootNode() {
        return this.rootNode;
    }

    public void setComparator(Comparator<ExplorerNode> comparator) {
        this.comparator = comparator;
    }

    public Comparator<ExplorerNode> getComparator() {
        return this.comparator;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(this.getDefaultViewId().getId());
    }

    public void refresh() {
        this.reloadTree();
    }

    protected abstract StudioFolder<ProjectObject> createRootNode();

    protected abstract Iterable<? extends Element> getChildren();

    protected void initNavigatorWindowComparator(DefaultNavigatorWindow navigator) {
        navigator.setComparator(this.getComparator());
    }

    protected void reloadTree() {
        if (this.rootNode instanceof AbstractContainerNode) {
            AbstractContainerNode containerNode = (AbstractContainerNode)this.rootNode;
            containerNode.reloadChildren(this.getChildren());
            TreeExplorer treeExplorer = this.getNavigatorWindow().getTreeExplorer();
            if (treeExplorer != null) {
                TNode root = treeExplorer.getRoot();
                treeExplorer.refresh(root);
            }
        }
    }
}

