/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca.validator;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.fusion.sca.validator.CompilationListener;
import oracle.bpm.project.compiler.CompilationOptions;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.testfwk.xbean.ComponentTestModel;
import oracle.soa.scac.ComponentValidator;
import oracle.soa.scac.FaultObject;
import oracle.soa.scac.TestFwkAssertionValidator;
import oracle.soa.scac.ValidationFault;
import org.jetbrains.annotations.NotNull;

public class BPMNComponentValidator
implements ComponentValidator {
    private boolean wasAlreadyValidated;

    public static boolean isValidBpmProject(@NotNull ValidationFault validationFault, @NotNull Project project) {
        if (validationFault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.isValidBpmProject must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.isValidBpmProject must not be null");
        }
        ProjectCompiler compiler = ProjectCompiler.createDefault((Project)project);
        FuegoCompiler fuegoCompiler = new FuegoCompiler();
        compiler.setCatalogCompiler((CilCompiler)fuegoCompiler);
        CompilationListener listener = new CompilationListener(validationFault);
        compiler.addCompilationListener((ProjectCompilationListener)listener);
        CompilationOptions options = new CompilationOptions();
        options.setEmitCode(false);
        options.setDeploying(false);
        compiler.compile(null, options);
        return listener.getCompilationResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(@NotNull ComponentModel componentModel, @NotNull ValidationFault validationFault) throws ProjectException, JAXBException, IOException {
        if (componentModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.validate must not be null");
        }
        if (validationFault == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.validate must not be null");
        }
        boolean result = false;
        CompositeModel composite = componentModel.getComposite();
        MetadataManager metadataManager = composite.getMetadataManager();
        String token = null;
        try {
            token = metadataManager.initializeURLResolvers();
            File projectDir = new File(composite.getHome());
            result = this.validate(validationFault, projectDir);
        }
        finally {
            if (token != null) {
                metadataManager.uninitializeURLResolvers(token);
            }
        }
        return result;
    }

    public boolean validate(@NotNull ValidationFault validationFault, @NotNull File projectDir) throws ProjectException, JAXBException, IOException {
        if (validationFault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.validate must not be null");
        }
        if (projectDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.validate must not be null");
        }
        boolean result = false;
        if (!this.wasAlreadyValidated) {
            this.wasAlreadyValidated = true;
            try {
                Project project = this.loadProjectInstance(projectDir);
                result = BPMNComponentValidator.isValidBpmProject(validationFault, project);
            }
            catch (Throwable e) {
                validationFault.addError(new FaultObject(e.getMessage()));
                e.printStackTrace();
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean validateTest(File file, ComponentModel componentModel, ComponentTestModel componentTestModel, TestFwkAssertionValidator testFwkAssertionValidator, ValidationFault validationFault) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Project loadProjectInstance(@NotNull File projectDir) throws ProjectException {
        if (projectDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/BPMNComponentValidator.loadProjectInstance must not be null");
        }
        System.setProperty("use.jaxb.composite.accesor", Boolean.TRUE.toString());
        FileProjectRepository repository = FileProjectRepository.create((File)projectDir.getParentFile());
        RepositoryService.getInstance().setActiveRepository((ProjectRepository)repository);
        String projectName = projectDir.getName();
        Project project = repository.getProject(projectName);
        if (project == null) {
            project = repository.create(projectName);
        }
        Project project2 = project;
        if (project2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/validator/BPMNComponentValidator.loadProjectInstance must not return null");
        }
        return project2;
    }
}

