/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.bpmobject.importexport.ImportExportException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BusinessObjectExporter {
    private Set<VFile> filesToExport = new HashSet<VFile>();
    private Set<TypeDescription> typeDescriptionsAdded = new HashSet<TypeDescription>();

    public void export(@NotNull Set<XObjectTypeDescription> xotds, @NotNull File targetFile) throws ImportExportException {
        if (xotds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.export must not be null");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.export must not be null");
        }
        assert (targetFile.getParentFile().exists()) : "ERROR: " + targetFile + " : No such file.";
        assert (targetFile.getParentFile().canWrite()) : "File " + targetFile + " hasn't write perms.";
        this.addDependencies(xotds);
        File file = this.createTmpDirectory(targetFile.getName());
        try {
            this.zipDirectory(file.getPath(), targetFile.getPath());
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        FileUtils.deleteDirectory(file);
    }

    private static void addDirectory(@NotNull ZipOutputStream zout, @NotNull File fileSource, @NotNull String sourceDir) throws IOException {
        if (zout == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addDirectory must not be null");
        }
        if (fileSource == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addDirectory must not be null");
        }
        if (sourceDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addDirectory must not be null");
        }
        File[] files = fileSource.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int length;
            if (files[i].isDirectory()) {
                BusinessObjectExporter.addDirectory(zout, files[i], sourceDir);
                continue;
            }
            byte[] buffer = new byte[1024];
            FileInputStream fin = new FileInputStream(files[i]);
            String absolutePath = files[i].getPath();
            String route = absolutePath.replace(sourceDir + File.separator, "");
            zout.putNextEntry(new ZipEntry(BusinessObjectExporter.convertToValidZipEntryPath(route)));
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
            fin.close();
        }
    }

    private static String convertToValidZipEntryPath(String route) {
        if (File.separatorChar != '/') {
            route = route.replace('\\', '/');
        }
        return route;
    }

    private File createTmpDirectory(@NotNull String directoryName) throws ImportExportException {
        if (directoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.createTmpDirectory must not be null");
        }
        File tmpDirectory = null;
        try {
            tmpDirectory = File.createTempFile(directoryName, "");
        }
        catch (IOException e) {
            throw new ImportExportException(e);
        }
        tmpDirectory.delete();
        boolean b = tmpDirectory.mkdir();
        assert (b) : "Error creating tmp directory";
        for (VFile vFile : this.filesToExport) {
            this.copyFileToDirectory(vFile, tmpDirectory);
        }
        tmpDirectory.deleteOnExit();
        return tmpDirectory;
    }

    private void copyFileToDirectory(@NotNull VFile vFile, @NotNull File tmpDirectory) throws ImportExportException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.copyFileToDirectory must not be null");
        }
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.copyFileToDirectory must not be null");
        }
        String path = vFile.getCanonicalPath();
        String[] directories = path.split("/");
        int BUFFER = 2048;
        byte[] data = new byte[BUFFER];
        String pathForZip = "";
        for (int i = 1; i < directories.length - 1; ++i) {
            pathForZip = pathForZip + File.separator + directories[i];
        }
        if (!pathForZip.equals("")) {
            File newFile = new File(tmpDirectory.getPath() + pathForZip);
            newFile.mkdirs();
        }
        InputStream inputStream = null;
        try {
            int count;
            inputStream = vFile.openInputStream();
            BufferedInputStream origin = new BufferedInputStream(inputStream, BUFFER);
            File destFile = new File(tmpDirectory + pathForZip + File.separator + vFile.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(destFile);
            while ((count = origin.read(data, 0, BUFFER)) != -1) {
                fileOutputStream.write(data, 0, count);
            }
            origin.close();
        }
        catch (IOException e) {
            try {
                throw new ImportExportException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(inputStream);
    }

    private void addDependencies(Set<XObjectTypeDescription> typeDescriptions) {
        this.typeDescriptionsAdded.addAll(typeDescriptions);
        for (XObjectTypeDescription xotd : typeDescriptions) {
            this.addBusinessObject(xotd);
        }
    }

    private void addBusinessObject(@NotNull XObjectTypeDescription xotd) {
        Object o;
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addBusinessObject must not be null");
        }
        VFile xsdFile = xotd.asSchemaObject().getResourceLocation();
        if (xsdFile != null) {
            this.filesToExport.add(xsdFile);
        }
        if ((o = xotd.getTransientProperty("files")) != null) {
            VFile[] files = (VFile[])o;
            assert (files.length == 1) : "More than 1 file found for: " + xotd.getText();
            this.filesToExport.add(files[0]);
        }
        List<MethodTypeDescription> attributes = BpmObjectTypeDescriptionHelper.getAttributes(xotd);
        HashSet<MethodTypeDescription> attributesSet = new HashSet<MethodTypeDescription>();
        attributesSet.addAll(attributes);
        this.addAttributeDependencies(attributesSet);
        List<MethodTypeDescription> methods = xotd.getMethods();
        this.addMethodDependencies(methods);
        this.addSuperTypeDependencies(xotd.getSuperTypes());
    }

    private void addSuperTypeDependencies(@NotNull List<SuperType> superTypes) {
        if (superTypes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addSuperTypeDependencies must not be null");
        }
        for (SuperType superType : superTypes) {
            TypeDescription td = superType.getType();
            if (!td.isBpmObject()) continue;
            this.addTypeDependency(td);
        }
    }

    private void addMethodDependencies(@NotNull List<MethodTypeDescription> methods) {
        if (methods == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addMethodDependencies must not be null");
        }
        for (MethodTypeDescription mtd : methods) {
            for (Argument argument : mtd.getArguments()) {
                this.addTypeDependency(argument.getType());
            }
            this.addTypeDependency(mtd.getResultArgument().getType());
        }
    }

    private void addAttributeDependencies(@NotNull Set<MethodTypeDescription> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addAttributeDependencies must not be null");
        }
        for (MethodTypeDescription mtd : attributes) {
            AttributeTypeDescription atd = mtd.asAttribute();
            TypeDescription td = atd.getType();
            this.addTypeDependency(td);
        }
    }

    private void addTypeDependency(@NotNull TypeDescription td) {
        if (td == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addTypeDependency must not be null");
        }
        if (!this.typeDescriptionsAdded.contains(td)) {
            this.typeDescriptionsAdded.add(td);
            if (td.isBpmObject()) {
                this.addBusinessObject(td.asBpmObject());
            } else if (td instanceof XmlTypeDescription) {
                this.addXmlDependency((XmlTypeDescription)td);
            }
        }
    }

    private void addXmlDependency(@NotNull XmlTypeDescription xmltd) {
        if (xmltd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.addXmlDependency must not be null");
        }
        VFile vFile = xmltd.asSchemaObject().getResourceLocation();
        if (vFile != null) {
            this.filesToExport.add(vFile);
        }
    }

    private void zipDirectory(@NotNull String sourceDir, @NotNull String zipFile) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.zipDirectory must not be null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/importexport/BusinessObjectExporter.zipDirectory must not be null");
        }
        FileOutputStream fout = new FileOutputStream(zipFile);
        ZipOutputStream zout = new ZipOutputStream(fout);
        File fileSource = new File(sourceDir);
        BusinessObjectExporter.addDirectory(zout, fileSource, sourceDir);
        zout.close();
    }
}

