/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.design;

import java.util.HashSet;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;

public abstract class AbstractGoOverFuegoObject {
    private boolean includesInnerTypes = false;
    private boolean includesSuperTypes = false;
    private ObjectTypeDescription parent;

    public AbstractGoOverFuegoObject(ObjectTypeDescription parent) {
        this(parent, false, false);
    }

    public AbstractGoOverFuegoObject(ObjectTypeDescription parent, boolean includesSuperTypes, boolean includesInnerTypes) {
        this.parent = parent;
        this.includesSuperTypes = includesSuperTypes;
        this.includesInnerTypes = includesInnerTypes;
    }

    public abstract void lookInto(ObjectTypeDescription var1);

    public final void startToGoOver() {
        this.init();
        this.searchObjects(this.parent, new HashSet<ObjectTypeDescription>());
    }

    protected abstract void init();

    private void searchObjects(ObjectTypeDescription parent, HashSet<ObjectTypeDescription> looked) {
        if (looked.contains(parent)) {
            return;
        }
        looked.add(parent);
        this.lookInto(parent);
        if (this.includesInnerTypes) {
            for (int i = 0; i < parent.getInnerTypeCount(); ++i) {
                ObjectTypeDescription inner = parent.getInnerType(i);
                this.searchObjects(inner, looked);
            }
        }
        if (this.includesSuperTypes) {
            for (SuperType superType : parent.getSuperTypes()) {
                if (superType.isHidden()) continue;
                ObjectTypeDescription superotd = superType.getObjectType();
                this.searchObjects(superotd, looked);
            }
        }
    }
}

