/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject;

import java.nio.charset.Charset;
import oracle.bpm.lang.Str;
import org.jetbrains.annotations.NotNull;

public class XmlUtils {
    public static String localname(String qname) {
        return oracle.bpm.type.utils.XmlUtils.localname(qname);
    }

    public static String prefix(String qname) {
        return oracle.bpm.type.utils.XmlUtils.prefix(qname);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String clearCData(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/XmlUtils.clearCData must not be null");
        }
        if (text.startsWith("<![CDATA[")) {
            text = text.substring("<![CDATA[".length());
            text = text.substring(0, text.length() - "]]>".length());
            text = XmlUtils.unEscapeCData(text);
        }
        String string = text;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/XmlUtils.clearCData must not return null");
        }
        return string;
    }

    public static String unEscapeCData(String text) {
        String escaped = Str.toXMLString("]]>", Charset.forName("UTF-8").newEncoder());
        int i = text.indexOf(escaped);
        if (i != -1) {
            text = text.replaceAll(escaped, "]]>");
        }
        return text;
    }

    public static String getPackageFromNamespace(String uri, boolean useJaxRpcRules) {
        return oracle.bpm.type.utils.XmlUtils.getPackageFromNamespace(uri, useJaxRpcRules);
    }
}

