/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import oracle.tutor.docx.Abstract_Packager;
import oracle.tutor.docx.DocxApp;
import oracle.tutor.docx.DocxContentTypes;
import oracle.tutor.docx.DocxCore;
import oracle.tutor.docx.DocxDocRels;
import oracle.tutor.docx.DocxDocument;
import oracle.tutor.docx.DocxEndnotes;
import oracle.tutor.docx.DocxFontTable;
import oracle.tutor.docx.DocxFooter1;
import oracle.tutor.docx.DocxFootnotes;
import oracle.tutor.docx.DocxGUID;
import oracle.tutor.docx.DocxNumbering;
import oracle.tutor.docx.DocxSettings;
import oracle.tutor.docx.DocxSrels;
import oracle.tutor.docx.DocxStyles;
import oracle.tutor.docx.DocxTheme1;
import oracle.tutor.docx.DocxWebSettings;
import oracle.tutor.docx.Docxrels;
import oracle.tutor.docx.TutorDoc;
import org.xml.sax.SAXException;

public final class Word_Packager
extends Abstract_Packager {
    private String _targetDirectory;
    private String _tmpDir;
    private File _rootOutputDirectory;
    private HashMap _filesMap = new HashMap();
    private HashMap _dataObject = new HashMap();
    private TutorDoc _tutorDoc;
    private Logger _logger;
    private static final String PMAKERLOCATION = "C:\\Windows\\PMaker.ini";

    public Word_Packager(Logger logger) {
        this._logger = logger;
        this.setMTmpDir();
    }

    @Override
    protected void populateFilesMap() {
        this._filesMap.put("Content_Types", new File("[Content_Types].xml"));
        this._filesMap.put("_rels", new File("_rels" + File.separator + ".rels"));
        this._filesMap.put("doc", new File("word" + File.separator + "document.xml"));
        this._filesMap.put("endnotes", new File("word" + File.separator + "endnotes.xml"));
        this._filesMap.put("fonttable", new File("word" + File.separator + "fontTable.xml"));
        this._filesMap.put("footer1", new File("word" + File.separator + "footer1.xml"));
        this._filesMap.put("footnotes", new File("word" + File.separator + "footnotes.xml"));
        this._filesMap.put("numbering", new File("word" + File.separator + "numbering.xml"));
        this._filesMap.put("settings", new File("word" + File.separator + "settings.xml"));
        this._filesMap.put("styles", new File("word" + File.separator + "styles.xml"));
        this._filesMap.put("websettings", new File("word" + File.separator + "webSettings.xml"));
        this._filesMap.put("relsdoc", new File("word" + File.separator + "_rels" + File.separator + "document.xml.rels"));
        this._filesMap.put("relssettings", new File("word" + File.separator + "_rels" + File.separator + "settings.xml.rels"));
        this._filesMap.put("_rels", new File("word" + File.separator + "theme" + File.separator + "theme1.xml"));
        this._filesMap.put("core", new File("docProps" + File.separator + "core.xml"));
        this._filesMap.put("app", new File("docProps" + File.separator + "app.xml"));
    }

    public void setPaths(String outputPath, TutorDoc doc) throws ParserConfigurationException, IOException, SAXException {
        DocxGUID guid = new DocxGUID();
        this._dataObject.put("guid", guid);
        this._tutorDoc = doc;
        this._tutorDoc.setMTutorFile(doc.getName());
        this._dataObject.put("tutorDoc", this._tutorDoc);
        this._targetDirectory = outputPath;
        this._rootOutputDirectory = new File(this._targetDirectory);
        if (!this._rootOutputDirectory.exists()) {
            this._rootOutputDirectory.mkdir();
        }
        this.populateFilesMap();
    }

    public void setPaths(String outputPath, TutorDoc doc, String outputFileName) throws ParserConfigurationException, IOException, SAXException {
        DocxGUID guid = new DocxGUID();
        this._dataObject.put("guid", guid);
        this._tutorDoc = doc;
        this._tutorDoc.setMTutorFile(outputFileName);
        this._dataObject.put("tutorDoc", this._tutorDoc);
        this._dataObject.put("dotFileLocation", "//Author.dot");
        this._targetDirectory = outputPath;
        this._rootOutputDirectory = new File(this._targetDirectory);
        if (!this._rootOutputDirectory.exists()) {
            this._rootOutputDirectory.mkdir();
        }
        this.populateFilesMap();
    }

    @Override
    public void marshall() {
        this._logger.fine("marshall file to this output location: " + this._targetDirectory + "\n");
        try {
            this.generateFiles();
            this.zipAll(this.getMTmpDir(), this._targetDirectory + File.separator + this._tutorDoc.getDocFileName() + ".docx");
            this._logger.fine("All files generated and zipped to docx.\nDONE.");
        }
        catch (IOException e) {
            this._logger.severe("IO ERROR: " + e.getMessage());
        }
    }

    private void generateFiles() throws IOException {
        File tmpDir = new File(this._tmpDir);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        File rels = new File(this.getMTmpDir() + File.separator + "_rels");
        rels.mkdir();
        FileWriter tfw = new FileWriter(new File(this.getMTmpDir() + File.separator + "_rels" + File.separator + ".rels"));
        tfw.write(new Docxrels().toDocx());
        tfw.flush();
        tfw.close();
        File docProps = new File(this.getMTmpDir() + File.separator + "docProps");
        docProps.mkdir();
        File word = new File(this.getMTmpDir() + File.separator + "word");
        word.mkdir();
        File wordRels = new File(this.getMTmpDir() + File.separator + "word" + File.separator + "_rels");
        wordRels.mkdir();
        File theme = new File(this.getMTmpDir() + File.separator + "word" + File.separator + "theme");
        theme.mkdir();
        for (Object file : this._filesMap.values()) {
            FileOutputStream fs = new FileOutputStream(new File(this._tmpDir) + File.separator + file, false);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fs, Charset.forName("UTF-8"));
            String fn = ((File)file).getName();
            if (fn.equals("[Content_Types].xml")) {
                fw.write(new DocxContentTypes().toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("document.xml")) {
                fw.write(new DocxDocument(this._dataObject, this._logger).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("settings.xml")) {
                fw.write(new DocxSettings(this._dataObject, this._logger).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("footer1.xml")) {
                fw.write(new DocxFooter1(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("footnotes.xml")) {
                fw.write(new DocxFootnotes(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("fontTable.xml")) {
                fw.write(new DocxFontTable().toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("endnotes.xml")) {
                fw.write(new DocxEndnotes(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("styles.xml")) {
                fw.write(new DocxStyles(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("webSettings.xml")) {
                fw.write(new DocxWebSettings().toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("theme1.xml")) {
                fw.write(new DocxTheme1().toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("document.xml.rels")) {
                fw.write(new DocxDocRels(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("settings.xml.rels")) {
                DocxSrels sxr = new DocxSrels();
                fw.write(sxr.toDocx("Author.dot"));
                fw.flush();
                fw.close();
            } else if (fn.equals("app.xml")) {
                DocxApp app = new DocxApp(this._dataObject);
                fw.write(app.toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("core.xml")) {
                fw.write(new DocxCore(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            } else if (fn.equals("numbering.xml")) {
                fw.write(new DocxNumbering(this._dataObject).toDocx());
                fw.flush();
                fw.close();
            }
            fs.close();
            fw.close();
            fw = null;
            fs = null;
        }
    }

    private void zip(File x, String Dir, ZipOutputStream zos, String zipFileName, String initialDir) {
        try {
            if (!x.exists()) {
                this._logger.severe(x.getName() + " file not found");
            }
            if (!x.isDirectory()) {
                if ((Dir + x.getName()).equalsIgnoreCase(zipFileName)) {
                    return;
                }
                String file2Add = Dir + x.getName();
                file2Add = file2Add.replace(initialDir + File.separator, "");
                zos.putNextEntry(new ZipEntry(file2Add));
                FileInputStream y = new FileInputStream(x);
                byte[] a = new byte[(int)x.length()];
                int did = y.read(a);
                if ((long)did != x.length()) {
                    this._logger.severe("DID NOT GET WHOLE FILE " + Dir + x.getName() + " ; only " + did + " of " + x.length());
                }
                zos.write(a, 0, a.length);
                zos.closeEntry();
                y.close();
                x = null;
                String finishedFileName = this._targetDirectory + File.separator + zipFileName;
                File finishedFile = new File(zipFileName);
                finishedFile.renameTo(new File(finishedFileName));
            } else if (!x.getName().equals("")) {
                String nnn = Dir + x.getName() + File.separator;
                x = null;
                String[] dirlist = new File(nnn).list();
                for (int i = 0; i < dirlist.length; ++i) {
                    this.zip(new File(nnn + dirlist[i]), nnn, zos, zipFileName, initialDir);
                }
            }
        }
        catch (Exception e) {
            this._logger.severe("Error in zip-Method!!" + e);
        }
    }

    private void zipAll(String dirsStartingWith, String name) {
        try {
            File here = new File(dirsStartingWith);
            String[] dirlist = here.list();
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(name));
            for (int i = 0; i < dirlist.length; ++i) {
                this.zip(new File(dirsStartingWith + File.separator + dirlist[i]), dirsStartingWith + File.separator, zos, name, dirsStartingWith);
            }
            zos.close();
            zos = null;
        }
        catch (ZipException ze) {
            this._logger.severe("ZipException Message: " + ze.getMessage());
        }
        catch (IOException ioe) {
            this._logger.severe("IOException Message: " + ioe.getMessage());
        }
        catch (Exception e) {
            this._logger.severe("Error in zipAll-Method.\nVerify that the requested file [" + name + "] is not open or in use.");
        }
    }

    public String findTemplatesFolder(String path) throws FileNotFoundException {
        if (path == null) {
            path = PMAKERLOCATION;
        }
        String dfl = "";
        File fr = new File(path);
        if (fr.exists()) {
            try {
                Scanner s = new Scanner(fr);
                s.useDelimiter("\r\n|\r|\n");
                while (s.hasNext()) {
                    String line = s.next();
                    if (line.startsWith("AuthTmplLoc")) {
                        line = line.replaceFirst("AuthTmplLoc=", "");
                        line = line.replaceAll(" ", "%20");
                        dfl = "file:///" + line;
                        return dfl;
                    }
                    if (!line.startsWith("ALTLOC")) continue;
                    dfl = dfl + this.findTemplatesFolder(line.replaceFirst("ALTLOC=", ""));
                }
                s.close();
            }
            catch (Exception e) {
                this._logger.severe("Can't find dot file.");
            }
        }
        return dfl;
    }

    private void setMTmpDir() {
        this._tmpDir = System.getProperty("java.io.tmpdir");
        if (!this._tmpDir.endsWith(File.separator)) {
            this._logger.fine("This version DOESN'T end w/ " + File.separator);
            this._tmpDir = this._tmpDir + File.separator + "OracleTmp";
        } else {
            this._logger.fine("This version ends w/ " + File.separator);
            this._tmpDir = this._tmpDir + "OracleTmp";
        }
        this._logger.fine("tmpDir is " + this._tmpDir + ".");
    }

    private String getMTmpDir() {
        return this._tmpDir;
    }
}

