/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.Link;
import oracle.tutor.docx.SubStepData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    private static final String ATTR_O_NS = "xmlns:o";
    private static final String ATTR_R_NS = "xmlns:r";
    private static final String ATTR_V_NS = "xmlns:v";
    private static final String ATTR_W_NS = "xmlns:w";
    private static Logger _logger;

    public Utils(Logger logger) {
        _logger = logger;
    }

    public static String getTutorXMLFolderPath() throws FileNotFoundException, IOException {
        String tutorDir = null;
        try {
            tutorDir = Utils.getAuthorDirLocation(null, "ALTLOC");
        }
        catch (FileNotFoundException e) {
            _logger.severe("Tutor configuration file not found.");
            throw e;
        }
        catch (IOException e) {
            _logger.severe("Problem reading Tutor configuration files.");
            throw e;
        }
        if (tutorDir == null) {
            return null;
        }
        if (tutorDir.lastIndexOf(File.separator) == tutorDir.length() - 1) {
            tutorDir = tutorDir.substring(0, tutorDir.length() - 1);
        }
        tutorDir = tutorDir.substring(0, tutorDir.lastIndexOf(File.separator) + 1);
        String xsltMapDir = tutorDir.concat("xml");
        return xsltMapDir;
    }

    public static String getAuthorDirLocation(String path, String dirVariable) throws IOException {
        File PMaker;
        String rulPath = "";
        if (path == null && !new File(path = System.getenv("windir") + File.separator + "PMaker.ini").exists()) {
            _logger.info("No PMaker.ini");
            rulPath = null;
        }
        if ((PMaker = new File(path)).exists()) {
            try {
                File fr = new File(path);
                Scanner s = new Scanner(fr);
                s.useDelimiter("\r\n|\r|\n");
                while (s.hasNext()) {
                    String line = s.next();
                    _logger.info("Looking for " + dirVariable.toLowerCase() + " in " + line.toLowerCase());
                    if (!line.toLowerCase().startsWith(dirVariable.toLowerCase() + "=")) continue;
                    _logger.fine("*************  FOUND " + dirVariable + " in " + line);
                    rulPath = Utils.getMDirLocation(line.replaceFirst(dirVariable + "=", ""), "MDir");
                    break;
                }
                s.close();
            }
            catch (FileNotFoundException e) {
                _logger.severe("Can't find Language.rul file.");
                throw new RuntimeException("Can't find Language.rul file. " + e.getMessage());
            }
            catch (IOException ioe) {
                _logger.severe("Can't find Language.rul file.");
                throw new RuntimeException("Can't find Language.rul file." + ioe.getMessage());
            }
        } else {
            _logger.info("Cannot locate " + dirVariable);
            rulPath = null;
        }
        return rulPath;
    }

    private static String getMDirLocation(String path, String dirPrefix) throws FileNotFoundException, IOException {
        _logger.fine("getMdirLocation called!");
        String mdir = "";
        try {
            File fr = new File(path);
            Scanner s = new Scanner(fr);
            s.useDelimiter("\r\n|\r|\n");
            while (s.hasNext()) {
                String line = s.next();
                if (line == null || !line.startsWith(dirPrefix + "=")) continue;
                mdir = line = line.replaceFirst(dirPrefix + "=", "");
                break;
            }
            s.close();
        }
        catch (RuntimeException e) {
            _logger.fine("Unable to get MDirLocation from " + path);
        }
        if (mdir.equals("") && !dirPrefix.matches("WDir")) {
            _logger.fine("Can't find MDir. So now I look for WDir");
            mdir = Utils.getMDirLocation(path, "WDir");
        }
        _logger.fine("I return " + mdir + " to the getAuthorDir method");
        mdir = Utils.checkForEnvVars(mdir);
        return mdir;
    }

    private static String checkForEnvVars(String mdir) {
        block1: {
            String regEx = "%\\w+%";
            Pattern targStr = Pattern.compile(regEx, 2);
            Matcher tm = targStr.matcher(mdir);
            if (!tm.find()) break block1;
            String var_val = System.getenv(mdir.substring(tm.start() + 1, tm.end() - 1)).toString();
            if (var_val != null) {
                mdir = mdir.substring(0, tm.start()) + var_val + mdir.substring(tm.end(), mdir.length());
            }
            tm.reset();
            mdir = Utils.checkForEnvVars(mdir);
        }
        return mdir;
    }

    public String stripFNDpath(String path) {
        String fr = "";
        String regEx = "\\@(.|/)*.";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(path);
        Boolean matched = false;
        while (tm.find()) {
            String tmp;
            matched = true;
            fr = tmp = path.substring(tm.start() + 1, tm.end());
        }
        if (!matched.booleanValue()) {
            fr = path;
        }
        return fr;
    }

    public ArrayList getTaskDataObjectListFromDocumentationString(String s) {
        ArrayList<SubStepData> al = new ArrayList<SubStepData>();
        String regEx1 = "}";
        Pattern targStr = Pattern.compile(regEx1);
        Matcher tm = targStr.matcher(s);
        Boolean matched = false;
        if (tm.find()) {
            matched = true;
        }
        String[] lines = s.split("\\n");
        if (matched.booleanValue()) {
            for (int i = 0; i < lines.length; ++i) {
                String[] line = lines[i].split("}");
                String style = line[0];
                style = style.substring(1, style.length());
                String ds = "";
                if (line.length > 1) {
                    ds = line[1];
                }
                SubStepData td = new SubStepData(style, ds);
                al.add(td);
            }
        } else {
            for (int i = 0; i < lines.length; ++i) {
                SubStepData td = new SubStepData("Task2", lines[i]);
                al.add(td);
            }
        }
        return al;
    }

    public String reformatConditionString(String cond) {
        String s = cond + "";
        if (!cond.equals("") && !cond.equals("????")) {
            s = cond.substring(0, 1);
            String s2 = cond.substring(1, cond.length()).replace("?", "");
            s = s + s2;
        }
        return s;
    }

    public String removeLeadingNumbers(String task) {
        String taskString = "";
        Pattern typeStr = Pattern.compile("^[0-9]+.");
        Matcher m = typeStr.matcher(task);
        int End2 = 0;
        while (m.find()) {
            End2 = m.end();
        }
        taskString = task.substring(End2, task.length());
        return taskString.trim();
    }

    public String xmlToString(Node node) {
        try {
            Element p = (Element)node;
            p.setAttribute(ATTR_R_NS, "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            p.setAttribute(ATTR_V_NS, "urn:schemas-microsoft-com:vml");
            p.setAttribute(ATTR_W_NS, "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
            p.setAttribute(ATTR_O_NS, "urn:schemas-microsoft-com:office:office");
            DOMSource domSource = new DOMSource(p);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            String xml = sw.toString();
            return xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        }
        catch (TransformerConfigurationException e) {
            e.getMessageAndLocation();
        }
        catch (TransformerException e) {
            e.getMessageAndLocation();
        }
        return null;
    }

    static String capInitial(String test) {
        String t = null;
        if (test != null && !test.equals("")) {
            String il = test.substring(0, 1).toUpperCase();
            t = test;
            t = il + t.substring(1, t.length());
        }
        return t;
    }

    static String stripFinalQuestionMark(String string) {
        String s = "";
        if (string != null && !string.equals("")) {
            String lastChar = string.substring(string.length() - 1);
            s = lastChar.equals("?") ? string.substring(0, string.length() - 1) : string;
        }
        return s;
    }

    public Boolean check4Match(String pattern, String data) {
        Boolean matched = false;
        Pattern owp = Pattern.compile(pattern);
        Matcher m = owp.matcher(data);
        while (m.find()) {
            matched = true;
        }
        return matched;
    }

    static Boolean compareStrings(String descriptionValue, String attributeValue) {
        Boolean same = false;
        if (descriptionValue.equals(attributeValue)) {
            same = true;
        }
        return same;
    }

    public static String formatEntityNotation(String s) {
        String formatted = s.replaceAll("&", "&amp;");
        formatted = formatted.replaceAll("<", "&lt;");
        formatted = formatted.replaceAll(">", "&gt;");
        formatted = formatted.replaceAll("'", "&#039;");
        formatted = formatted.replaceAll("\"", "&quot;");
        return formatted;
    }

    static String formatLocalizedDirectiveString(LanguageMap lm, String test, String type, String target) {
        String ds = "";
        String localizedIf = (String)lm.getFirstValue("If");
        String localizedTask = (String)lm.getFirstValue("Task #");
        String typeString = (String)lm.getFirstValue(type);
        if (type.matches("Stop and complete") || type.matches("End of activity")) {
            localizedTask = "";
        }
        if (lm.getGrammarType() == 0) {
            if (test != null && !test.equals("")) {
                String first = test.substring(0, 1);
                String rest = test.substring(1, test.length());
                String lastChar = "";
                if (rest.length() > 0) {
                    rest.substring(rest.length() - 1);
                }
                if (lastChar.equals("?")) {
                    rest = rest.substring(0, rest.length() - 1);
                }
                ds = ds + localizedIf + " " + first + rest + ", " + typeString;
                if (!target.equals("")) {
                    ds = ds + " " + localizedTask + "" + target;
                }
            } else {
                ds = ds + typeString + " " + localizedTask + "" + target;
            }
        }
        return ds;
    }

    protected boolean stringHasExternalLink(String s) {
        String regEx = "\\[(.|/)*.+\\]";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(s);
        boolean matched = false;
        while (tm.find()) {
            matched = true;
        }
        return matched;
    }

    static boolean nodeHasExternalLink(Node n) throws XPathExpressionException {
        boolean hasLink = false;
        String regEx = "\\[(.|/)*.+\\]";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(n.getTextContent());
        boolean matched = false;
        while (tm.find()) {
            matched = true;
        }
        if (matched) {
            String axis2;
            NodeList nodes2;
            String axis1;
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(axis1 = "descendant::r/child::rPr/child::i", n, XPathConstants.NODESET);
            if (nodes.getLength() > 0 && (nodes2 = (NodeList)xpath.evaluate(axis2 = "descendant::r/child::rPr/child::u", n, XPathConstants.NODESET)).getLength() > 0) {
                hasLink = true;
            }
        } else {
            hasLink = false;
        }
        return hasLink;
    }

    protected static String getFileRefUrl(String s) {
        String url = "";
        Link lo = new Link(s);
        if (lo.getLinkString() != null) {
            url = lo.getLinkUrl();
        }
        return url;
    }

    protected static String getFileRefID(String s) {
        String id = "";
        Link lo = new Link(s);
        if (lo.getLinkId() != null) {
            id = lo.getLinkId();
        }
        return id;
    }

    protected static String getFileRefName(String s) {
        String name = "";
        String regEx = "\\[(.|/)*.+\\]";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(s);
        int patternStart = 0;
        String startString = "";
        boolean matched = false;
        while (tm.find()) {
            matched = true;
            patternStart = tm.start();
        }
        if (matched) {
            startString = s.substring(0, patternStart);
            String[] tmp = startString.split("<i><u>");
            name = tmp.length > 1 ? tmp[1].trim() : tmp[0].trim();
        }
        return name;
    }
}

