/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.docx.Action;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.BPModeler;
import oracle.tutor.docx.Bpd2TutorTaskUtil;
import oracle.tutor.docx.Bpd2TutorUtil;
import oracle.tutor.docx.Condition;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.IntroSection;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.Person;
import oracle.tutor.docx.PriorActivity;
import oracle.tutor.docx.Procedure;
import oracle.tutor.docx.Role;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.SubStepData;
import oracle.tutor.docx.Task;
import oracle.tutor.docx.UnZipper;
import oracle.tutor.docx.Utils;
import oracle.tutor.docx.Word_Packager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TutorDoc
extends Procedure {
    private ArrayList _actorList;
    private Actor _currentActor;
    private int _directiveNumber;
    private ArrayList _distributionList;
    private Document _document;
    private String _documentLanguage;
    private IntroSection _introSection;
    private int _introSectionNum = 0;
    private PriorActivity _priorActivity;
    private int _taskNumber;
    private String _tutorFile;
    protected Utils utils = new Utils(_logger);
    private boolean _isReFile = false;
    private boolean _actorFound = false;
    private static Logger _logger = Logger.getLogger("oracle.tutor.docx");
    private LinkedList<ConversionMessage> _msgList;

    public TutorDoc() {
        this._actorList = new ArrayList();
        Actor newActor = new Actor();
        newActor.setTitle("");
        newActor.setId("");
        this.addActor(newActor);
    }

    private void bpd2tutor(BusinessProcessDiagram bpd, String lang, Pool mainPool, Boolean followMessageFlows, Boolean hideSystemTasks) {
        try {
            Bpd2TutorUtil bpd2tutorUtil = new Bpd2TutorUtil(_logger);
            this.setTitle(bpd.getName());
            if (this._actorList == null) {
                this._actorList = new ArrayList();
            }
            this._currentActor = new Actor();
            this._distributionList = new ArrayList();
            this._directiveNumber = 0;
            this._taskNumber = 0;
            boolean bpdContainsStartObject = false;
            Person owner = new Person();
            owner.setRole("", "owner_1");
            this.setOwner(owner);
            this.addDistributionListItem(owner.getRole());
            this._documentLanguage = lang;
            String rulFile = Utils.getAuthorDirLocation(System.getenv("windir") + "\\PMaker.ini", "ALTLOC");
            LanguageMap lm = new LanguageMap(rulFile, this._documentLanguage);
            this.setPriorActivity(new PriorActivity(lm));
            this._introSection = new IntroSection(lm, _logger);
            this._introSection.setFromPlainText(bpd.getDocumentation());
            for (FlowObject node : bpd.getAllNodes().values()) {
                _logger.fine("Node name is " + node.getName());
                if (node.getLane() == null) continue;
                _logger.fine("Lane is: " + node.getLane().getName() + ", id:" + node.getLane().getID());
            }
            if (mainPool != null && mainPool.getLanes() != null) {
                this._msgList = bpd.simplify();
                bpd.serialize(true, mainPool, false);
            } else {
                BusinessProcessDiagram.SimplifyFlags simp = BusinessProcessDiagram.SimplifyFlags.MERGE_POOLS;
                BusinessProcessDiagram.SimplifyFlags[] Flags = new BusinessProcessDiagram.SimplifyFlags[]{simp};
                try {
                    this._msgList = bpd.simplify(Flags);
                    this._msgList.addAll(bpd.simplify());
                    bpd.serialize(true, null, true);
                }
                catch (Exception ex) {
                    _logger.info(ex.getMessage() + " " + ex.getCause());
                    ex.printStackTrace();
                }
            }
            LinkedList tmpFlows = new LinkedList(bpd.getAllFlows().values());
            for (ConnectingObject flow : tmpFlows) {
                if (flow.getFrom() != null && flow.getTo() != null && !(flow instanceof Association)) continue;
                flow.remove();
            }
            LinkedList tmpFlows2 = new LinkedList(bpd.getAllFlows().values());
            for (ConnectingObject flow : tmpFlows2) {
                Pool toPool;
                Pool fromPool;
                boolean isKeeper;
                if (!(flow instanceof MessageFlow)) continue;
                boolean fromHasNoSFoutflows = flow.getFrom().getOutflows(SequenceFlow.class).size() == 0;
                boolean fromIsCollapsedSp = flow.getFrom() instanceof Subprocess && ((Subprocess)flow.getFrom()).isExpanded() == false;
                boolean toHasNoSFoutflows = flow.getTo().getOutflows(SequenceFlow.class).size() == 0;
                boolean toIsCollapsedSp = flow.getTo() instanceof Subprocess && ((Subprocess)flow.getTo()).isExpanded() == false;
                boolean bl = isKeeper = fromHasNoSFoutflows && fromIsCollapsedSp || flow.getFrom() instanceof Event && ((Event)flow.getFrom()).getEventType() == Event.EventType.END && toHasNoSFoutflows && toIsCollapsedSp;
                if (isKeeper) {
                    if (flow.getFrom() instanceof Subprocess && !((Subprocess)flow.getFrom()).isExpanded().booleanValue()) {
                        flow.getFrom().setAttribute("isPrior", (Object)true);
                    } else if (flow.getTo() instanceof Subprocess && !((Subprocess)flow.getTo()).isExpanded().booleanValue()) {
                        flow.getTo().setAttribute("isFollowup", (Object)true);
                    }
                }
                if (((FlowObject)flow.getFrom()).getLane() == null || ((FlowObject)flow.getTo()).getLane() == null || !(fromPool = ((FlowObject)flow.getFrom()).getLane().getPool()).equals(toPool = ((FlowObject)flow.getTo()).getLane().getPool())) continue;
                flow.remove();
                this._msgList.add(new ConversionMessage(flow.getID(), "Messageflow linking objects in one pool is illegal. Flow removed."));
            }
            ArrayList sn = new ArrayList(bpd.getSequencedNodes());
            _logger.fine("sn has this many elements: " + sn.size());
            int tasks = 0;
            String localizedIf = (String)lm.getFirstValue("If");
            String localizedNo = (String)lm.getFirstValue("*No");
            String localizedYes = (String)lm.getFirstValue("*Yes");
            String localizedIs = "is";
            for (Object o : sn) {
                if (o instanceof oracle.tutor.bpmn.Task) {
                    ((oracle.tutor.bpmn.Task)o).setAttribute("taskNumber", (Object)(++tasks));
                    if (((oracle.tutor.bpmn.Task)o).getName() != null && !((oracle.tutor.bpmn.Task)o).getName().equals("")) continue;
                    ((oracle.tutor.bpmn.Task)o).setName("???");
                    continue;
                }
                if (o instanceof Gateway) {
                    Gateway gw = (Gateway)o;
                    if ((gw.getGatewayType().equals((Object)Gateway.GatewayType.AND) || gw.getGatewayType().equals((Object)Gateway.GatewayType.OR)) && (gw.getOutflows().size() == 1 || gw.getInflows().size() > 1)) {
                        gw.setAttribute("landingTask", (Object)(++tasks));
                    }
                    int markedDefaultFlow = Bpd2TutorUtil.getMarkedDefaultFlow(gw);
                    int labeledNoFlow = Bpd2TutorUtil.getLabeledNoFlow(gw, localizedNo);
                    int labeledYesFlow = Bpd2TutorUtil.getLabeledYesFlow(gw, localizedYes);
                    int soleUnlabeledFlow = Bpd2TutorUtil.getSoleUnlabeledFlow(gw);
                    boolean noFlowsLabeled = Bpd2TutorUtil.allFlowsUnlabeled(gw);
                    if (!gw.getGatewayType().equals((Object)Gateway.GatewayType.XOR_DATA) && !gw.getGatewayType().equals((Object)Gateway.GatewayType.OR) && !gw.getGatewayType().equals((Object)Gateway.GatewayType.COMPLEX) || (gw.getGatewayType().equals((Object)Gateway.GatewayType.AND) || gw.getGatewayType().equals((Object)Gateway.GatewayType.OR)) && gw.getOutflows(SequenceFlow.class).size() == 1 && gw.getInflows(SequenceFlow.class).size() > 1) continue;
                    if (gw.getOutflows(SequenceFlow.class).size() == 2) {
                        if (noFlowsLabeled && markedDefaultFlow == -1) {
                            for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                                ((SequenceFlow)f).setName("????");
                            }
                            continue;
                        }
                        if (noFlowsLabeled && markedDefaultFlow > -1) {
                            int flowCounter = 0;
                            for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                                if (markedDefaultFlow == flowCounter) {
                                    ((SequenceFlow)f).setName(localizedNo);
                                } else {
                                    ((SequenceFlow)f).setName(localizedYes);
                                }
                                ++flowCounter;
                            }
                            continue;
                        }
                        if (labeledNoFlow > -1) {
                            int flowCounter = 0;
                            for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                                if (labeledNoFlow == flowCounter) {
                                    ((SequenceFlow)f).setDefault(Boolean.valueOf(true));
                                } else {
                                    if (((SequenceFlow)f).getName() == null || ((SequenceFlow)f).getName().equals("")) {
                                        ((SequenceFlow)f).setName(localizedYes);
                                    }
                                    ((SequenceFlow)f).setDefault(Boolean.valueOf(false));
                                }
                                ++flowCounter;
                            }
                            continue;
                        }
                        if (labeledYesFlow > -1) {
                            int flowCounter = 0;
                            for (ConnectingObject f : ((Gateway)o).getOutflows(SequenceFlow.class)) {
                                if (labeledYesFlow == flowCounter) {
                                    ((SequenceFlow)f).setDefault(Boolean.valueOf(false));
                                } else if (((SequenceFlow)f).getName() == null || ((SequenceFlow)f).getName().equals("")) {
                                    ((SequenceFlow)f).setName(localizedNo);
                                    ((SequenceFlow)f).setDefault(Boolean.valueOf(true));
                                }
                                ++flowCounter;
                            }
                            continue;
                        }
                        if (soleUnlabeledFlow <= -1) continue;
                        int flowCounter = 0;
                        for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                            if (flowCounter == soleUnlabeledFlow) {
                                ((SequenceFlow)f).setDefault(Boolean.valueOf(true));
                            }
                            ++flowCounter;
                        }
                        continue;
                    }
                    if (gw.getOutflows(SequenceFlow.class).size() <= 2) continue;
                    if (soleUnlabeledFlow > -1 && gw.getGatewayType().equals((Object)Gateway.GatewayType.XOR_DATA)) {
                        int flowCounter = 0;
                        for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                            if (soleUnlabeledFlow == flowCounter) {
                                ((SequenceFlow)f).setDefault(Boolean.valueOf(true));
                            }
                            ++flowCounter;
                        }
                        continue;
                    }
                    for (ConnectingObject f : gw.getOutflows(SequenceFlow.class)) {
                        if (!((SequenceFlow)f).getName().equals("")) continue;
                        ((SequenceFlow)f).setName("????");
                    }
                    continue;
                }
                if (!(o instanceof Event)) continue;
                if (((Event)o).getEventType() == Event.EventType.START) {
                    bpdContainsStartObject = true;
                    continue;
                }
                if (((Event)o).getEventType() != Event.EventType.END) continue;
                ((Event)o).setVisited(Boolean.valueOf(false));
            }
            int taskNum = 0;
            int directiveNum = 0;
            int seqNodeNum = 0;
            _logger.fine("I have this many nodes: " + sn.size());
            for (Object o : sn) {
                block92: {
                    FlowObject bpdNode;
                    Actor a;
                    if (o instanceof oracle.tutor.bpmn.Task) {
                        Directive d;
                        String taskString = ((oracle.tutor.bpmn.Task)o).getName();
                        Bpd2TutorTaskUtil t = new Bpd2TutorTaskUtil(this, (oracle.tutor.bpmn.Task)o, ++taskNum, _logger, lm);
                        _logger.fine(((oracle.tutor.bpmn.Task)o).getName() + " is the Task.");
                        Actor a2 = bpd2tutorUtil.getActorFromLane(this, t, (FlowObject)o);
                        _logger.fine("OK. Got an actor from the lane.");
                        FlowObject bpdNode2 = (FlowObject)o;
                        t.setBpdNode(bpdNode2);
                        t.setSourceId(bpdNode2.getID());
                        this.addStep(t);
                        if (bpdNode2.getOutflows().size() == 0) {
                            d = new Directive(lm, (String)lm.getFirstValue("End of activity"));
                            d.addActor(this.getCurrentActor());
                            this.addStep(d);
                        } else if (bpdNode2.getOutflows().size() == 1) {
                            if (seqNodeNum < sn.size() - 1) {
                                GraphicalElement followingNode = (GraphicalElement)sn.get(seqNodeNum + 1);
                                boolean nextIsEnd = false;
                                if (followingNode instanceof Event && ((Event)followingNode).getEventType() == Event.EventType.END) {
                                    nextIsEnd = true;
                                }
                                for (ConnectingObject f : bpdNode2.getOutflows()) {
                                    GraphicalElement ge;
                                    if (!(f instanceof SequenceFlow) || !((ge = ((SequenceFlow)f).getTo()) instanceof Event) || ((Event)ge).getEventType() != Event.EventType.END || (nextIsEnd || ((Event)ge).isVisited().booleanValue()) && ((Event)ge).getInflows().size() <= 1) continue;
                                    Directive d2 = new Directive(lm, (String)lm.getFirstValue("End of activity"));
                                    d2.setId("D_" + ++directiveNum);
                                    d2.addActor(this.getCurrentActor());
                                    this.addStep(d2);
                                    ((Event)ge).setVisited(Boolean.valueOf(true));
                                }
                            } else if (seqNodeNum == sn.size() - 1 && ((oracle.tutor.bpmn.Task)o).getOutflows(SequenceFlow.class).size() > 0) {
                                LinkedList fl = ((oracle.tutor.bpmn.Task)o).getOutflows(SequenceFlow.class);
                                for (Object of : fl) {
                                    GraphicalElement ge = ((SequenceFlow)of).getTo();
                                    if (!(ge instanceof oracle.tutor.bpmn.Task) || ((oracle.tutor.bpmn.Task)ge).getAttribute("taskNumber") == null) continue;
                                    oracle.tutor.bpmn.Task bpt = (oracle.tutor.bpmn.Task)ge;
                                    int tn = (Integer)bpt.getAttribute("taskNumber");
                                    String localizedGoto = (String)lm.getFirstValue("Goto");
                                    String localizedTask = (String)lm.getFirstValue("Task #");
                                    Directive d3 = new Directive(lm, localizedGoto + " " + localizedTask + tn);
                                    d3.setId("D_" + ++directiveNum);
                                    d3.addFollowingStep(this.getStepById("T_" + tn), true);
                                    this.addStep(d3);
                                }
                            }
                        } else {
                            d = bpd2tutorUtil.handleParallelSplit((GraphicalElement)o, lm, sn, seqNodeNum);
                            if (d.getConditions().size() > 0) {
                                d.setId("D_" + ++directiveNum);
                                d.addActor(this.getCurrentActor());
                                this.addStep(d);
                            }
                        }
                    } else if (o instanceof Gateway) {
                        if (((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.OR) && ((Gateway)o).getOutflows().size() == 1) {
                            Task t = bpd2tutorUtil.handleORGateway(this, (Gateway)o, lm, sn);
                            _logger.fine("I just made a task [" + t.getTaskString() + "] with sourceID: " + ((Gateway)o).getID());
                            t.setSourceId(((Gateway)o).getID());
                            t.setTaskNumber(++taskNum);
                            this._msgList.add(new ConversionMessage("", "Gateway of type OR converted to task " + t.getName()));
                            this.addStep(t);
                        } else if (((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.AND) && ((Gateway)o).getOutflows().size() == 1) {
                            Task t = bpd2tutorUtil.handleANDGateway(this, (Gateway)o, lm, sn);
                            t.setSourceId(((Gateway)o).getID());
                            t.setTaskNumber(++taskNum);
                            this._msgList.add(new ConversionMessage("", "Gateway of type AND converted to task " + t.getName()));
                            this.addStep(t);
                        } else {
                            if (((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.XOR_DATA) || ((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.COMPLEX) || ((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.OR)) {
                                try {
                                    Directive d = bpd2tutorUtil.handleGateway(this, (Gateway)o, lm, sn);
                                    if (d != null) {
                                        d.setId("D_" + ++directiveNum);
                                        a = bpd2tutorUtil.getActorFromLane(this, d, (FlowObject)o);
                                        d.addActor(a);
                                        bpdNode = (FlowObject)o;
                                        d.setBpdNode(bpdNode, true);
                                        d.setSourceId(bpdNode.getID());
                                        this.addStep(d);
                                    }
                                    break block92;
                                }
                                catch (NullPointerException npe) {
                                    _logger.severe("NullPointerException while trying to make Directive. Gateway skipped.");
                                    break;
                                }
                            }
                            if (((Gateway)o).getGatewayType().equals((Object)Gateway.GatewayType.AND)) {
                                Directive d = bpd2tutorUtil.handleParallelSplit((GraphicalElement)o, lm, sn, seqNodeNum);
                                d.setId("D_" + ++directiveNum);
                                d.setSourceId(((Gateway)o).getID());
                                this.addStep(d);
                            }
                        }
                    } else if (o instanceof Subprocess) {
                        Subprocess sp;
                        if (((Subprocess)o).getAttribute("isPrior") == null) {
                            if (((Subprocess)o).getAttribute("processed") == null || ((Subprocess)o).getAttribute("processed").equals(false)) {
                                if (((Subprocess)o).getOutflows(SequenceFlow.class).size() == 1) {
                                    Directive d = bpd2tutorUtil.handleSubprocess((Subprocess)o, lm);
                                    d.setId("D_" + ++directiveNum);
                                    d.setSourceId(((Subprocess)o).getID());
                                    a = bpd2tutorUtil.getActorFromLane(this, d, (FlowObject)o);
                                    d.addActor(a);
                                    this.addStep(d);
                                } else if (((Subprocess)o).getOutflows(SequenceFlow.class).size() > 1) {
                                    Directive d = bpd2tutorUtil.handleSubprocess((Subprocess)o, lm);
                                    d.setId("D_" + ++directiveNum);
                                    d.setSourceId(((Subprocess)o).getID());
                                    a = bpd2tutorUtil.getActorFromLane(this, d, (FlowObject)o);
                                    d.addActor(a);
                                    this.addStep(d);
                                    Directive d2 = bpd2tutorUtil.handleParallelSplit((GraphicalElement)o, lm, sn, seqNodeNum);
                                    d2.setId("D_" + ++directiveNum);
                                    this.addStep(d2);
                                } else if (((Subprocess)o).getOutflows(SequenceFlow.class).size() == 0 && seqNodeNum == sn.size() - 1) {
                                    Directive d = bpd2tutorUtil.handleSubprocess((Subprocess)o, lm);
                                    d.setId("D_" + ++directiveNum);
                                    d.setSourceId(((Subprocess)o).getID());
                                    a = bpd2tutorUtil.getActorFromLane(this, d, (FlowObject)o);
                                    d.addActor(a);
                                    this.addStep(d);
                                    this.addStep(new Directive(lm, (String)lm.getFirstValue("End of activity")));
                                } else if (((Subprocess)o).getOutflows(SequenceFlow.class).size() == 0 && seqNodeNum != sn.size() - 1) {
                                    Directive d = bpd2tutorUtil.handleSubprocess((Subprocess)o, lm);
                                    d.setId("D_" + ++directiveNum);
                                    d.setSourceId(((Subprocess)o).getID());
                                    a = bpd2tutorUtil.getActorFromLane(this, d, (FlowObject)o);
                                    d.addActor(a);
                                    this.addStep(d);
                                    this.addStep(new Directive(lm, (String)lm.getFirstValue("End of activity")));
                                }
                                ((GraphicalElement)o).setAttribute("processed", (Object)"true");
                            }
                        } else if (((Subprocess)o).getAttribute("isPrior") != null && ((Subprocess)o).getAttribute("isPrior").equals(true) && ((sp = (Subprocess)o).getAttribute("processed") == null || sp.getAttribute("processed").equals(false))) {
                            this.setPriorActivityItem(sp.getName() + " [" + sp.getID() + "]");
                            ((Subprocess)o).setAttribute("processed", (Object)true);
                        }
                    } else if (o instanceof Event) {
                        _logger.fine("I found an EVENT");
                        if (((Event)o).getEventType() == Event.EventType.START) {
                            if (((GraphicalElement)o).getOutflows(SequenceFlow.class).size() > 1) {
                                Directive d = bpd2tutorUtil.handleParallelSplit((GraphicalElement)o, lm, sn, seqNodeNum);
                                d.setId("D_" + ++directiveNum);
                                this.addStep(d);
                            }
                        } else if (((Event)o).getEventType() == Event.EventType.END && seqNodeNum < sn.size() - 1 && !((Event)o).isVisited().booleanValue()) {
                            boolean previousStepHasEnd;
                            if (this.getSteps().size() > 0 && !(previousStepHasEnd = bpd2tutorUtil.hasEndCondition(this.getLastStep()))) {
                                Directive d = bpd2tutorUtil.handleEvent(this, (Event)o, lm);
                                d.setId("D_" + ++directiveNum);
                                bpdNode = (FlowObject)o;
                                d.setBpdNode(bpdNode, true);
                                this.addStep(d);
                            }
                        } else if (((Event)o).getEventType() == Event.EventType.END && seqNodeNum == sn.size() - 1 && ((Event)o).getOutflows(MessageFlow.class).size() > 0) {
                            _logger.fine("THIS IS AN END W/ FOLLOW-UPs");
                            Directive d = bpd2tutorUtil.handleEvent(this, (Event)o, lm);
                            d.setId("D_" + ++directiveNum);
                            FlowObject bpdNode3 = (FlowObject)o;
                            d.setBpdNode(bpdNode3, true);
                            this.addStep(d);
                        }
                    }
                }
                ++seqNodeNum;
            }
            _logger.fine("done stepping through the sequenced nodes.");
            if (sn.size() > 0 && this.getSteps().size() > 0) {
                this.setAllNextSteps();
                _logger.fine("NEXT I INSERT ADDL STEPS");
                this.insertAdditionalSteps(bpd, lm);
                this.reNumberAllSteps();
                this.setAllNextSteps();
            } else {
                _logger.severe("The diagram passed to bdp2tutor has no nodes after serialization. No tasks were created!");
                this._msgList.add(new ConversionMessage("", "The diagram passed to bdp2tutor has no nodes after serialization. No tasks were created!"));
            }
            _logger.fine("Finished building Tutor objects from bpd in bpd2Tutor().\n\n");
        }
        catch (FileNotFoundException fnf) {
            throw new RuntimeException("FileNotFoundException in bpd2tutor method. " + fnf.getMessage() + fnf.getCause());
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException in bpd2tutor method. " + ioe.getMessage() + ioe.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception in bpd2tutor method. " + e.getMessage() + e.getCause());
        }
    }

    public void loadBPD(BusinessProcessDiagram bpd, Pool mainPool, String lang) throws FileNotFoundException, IOException {
        this.bpd2tutor(bpd, lang, mainPool, true, false);
    }

    public int getTaskNumberFromName(Collection sn, String nodeID) {
        int taskNumber = 0;
        int matchNumber = 0;
        String targetString = nodeID.trim();
        for (Object o : sn) {
            String oID;
            if (o instanceof oracle.tutor.bpmn.Task) {
                ++taskNumber;
                oID = ((oracle.tutor.bpmn.Task)o).getID().trim();
                if (!oID.matches(targetString)) continue;
                matchNumber = taskNumber;
                break;
            }
            if (!(o instanceof Subprocess)) continue;
            ++taskNumber;
            oID = ((Subprocess)o).getID().trim();
            if (!oID.matches(targetString)) continue;
            matchNumber = taskNumber;
            break;
        }
        return matchNumber;
    }

    public void loadDocx(String docxFile) {
        _logger.fine("loadDocx() called.\n");
        if (docxFile != null) {
            try {
                this.setMTutorFile(docxFile);
                File fn = new File(docxFile);
                this.setIsRE_file(this.check4RE_file(fn.getName()));
                String rulFile = Utils.getAuthorDirLocation(System.getenv("windir") + "\\PMaker.ini", "ALTLOC");
                int actorCounter = 1;
                this._actorList = new ArrayList();
                this._currentActor = new Actor();
                this._distributionList = new ArrayList();
                this._directiveNumber = 0;
                this._taskNumber = 0;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
                factory.setIgnoringComments(true);
                factory.setCoalescing(true);
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                DocumentBuilder parser = factory.newDocumentBuilder();
                if (this._tutorFile == null) {
                    _logger.severe("No Tutor Document found in loadDocx() method.");
                    throw new RuntimeException("No Tutor Document found in loadDocx() method line 467.");
                }
                UnZipper uz = new UnZipper(this._tutorFile, _logger);
                InputStream settingsStream = uz.unZipSettingsFile();
                Document settings = parser.parse(settingsStream);
                settingsStream.close();
                XPath settingsxpath = XPathFactory.newInstance().newXPath();
                String settingsExpression = "descendant::docVar[@name='Paradigm_language']";
                NodeList lang = (NodeList)settingsxpath.evaluate(settingsExpression, settings, XPathConstants.NODESET);
                if (lang.getLength() != 0 || rulFile.equals(null)) {
                    this._documentLanguage = lang.item(0).getAttributes().item(1).getNodeValue();
                    _logger.fine("Found value in settings file: " + this._documentLanguage);
                    if (this._documentLanguage.indexOf("(") == -1) {
                        this._documentLanguage = "English (US)";
                        _logger.warning("Found value invalid. Set default language value to: " + this._documentLanguage);
                    }
                } else {
                    this._documentLanguage = "English (US)";
                    _logger.warning("Set default language value to: " + this._documentLanguage);
                }
                _logger.fine("mDocumentLanguage = " + this._documentLanguage + "\n");
                LanguageMap lm = new LanguageMap(rulFile, this._documentLanguage);
                this.setIntroSection(new IntroSection(lm, _logger));
                this.setPriorActivity(new PriorActivity(lm));
                InputStream is = uz.unZipFile();
                this._document = parser.parse(is);
                is.close();
                NodeList pList = this.getXpathNodeList("descendant::p", this._document);
                int numPs = pList.getLength();
                XPath xpathStyle = XPathFactory.newInstance().newXPath();
                String xpExpressionStyle = "descendant::pStyle/@val";
                _logger.fine("reading " + numPs + " paragraphs...\n");
                for (int i = 0; i < numPs; ++i) {
                    NodeList scopeNodes;
                    NodeList paNodes;
                    String styleAttributeValue = xpathStyle.evaluate(xpExpressionStyle, pList.item(i));
                    _logger.fine("Reading #" + i + " with style name " + styleAttributeValue);
                    if (styleAttributeValue.matches("PageTitle")) {
                        this.setTitle(TutorDoc.p(pList.item(i)));
                        continue;
                    }
                    if (styleAttributeValue.matches("Subheading")) {
                        String subheadingData = TutorDoc.p(pList.item(i));
                        if (this._actorFound) continue;
                        if (this.isPriorActivity(subheadingData, lm).booleanValue()) {
                            paNodes = this.getXpathNodeList("following-sibling::*", pList.item(i));
                            this.handlePriorActivityNodes(xpathStyle, paNodes);
                            continue;
                        }
                        this.addIntroSectionFromDocx(subheadingData.trim());
                        scopeNodes = this.getXpathNodeList("following-sibling::*", pList.item(i));
                        this.handleIntroNodesFromDocx(scopeNodes, subheadingData.trim());
                        continue;
                    }
                    if (styleAttributeValue.matches("SectionTitle")) {
                        String sectionTitleData = TutorDoc.p(pList.item(i));
                        if (sectionTitleData.trim().matches("Ownership")) {
                            Person owner = this.getOwnerFromData(TutorDoc.p(pList.item(i + 1)));
                            this.setOwner(owner);
                            this.addDistributionListItem(owner.getRole());
                            continue;
                        }
                        if (this._actorFound) continue;
                        if (this.isPriorActivity(sectionTitleData, lm).booleanValue()) {
                            paNodes = this.getXpathNodeList("following-sibling::*", pList.item(i));
                            this.handlePriorActivityNodes(xpathStyle, paNodes);
                            continue;
                        }
                        this.addIntroSectionFromDocx(sectionTitleData.trim());
                        scopeNodes = this.getXpathNodeList("following-sibling::*", pList.item(i));
                        this.handleIntroNodesFromDocx(scopeNodes, sectionTitleData.trim());
                        continue;
                    }
                    if (styleAttributeValue.matches("Task1")) {
                        String subTaskName;
                        Task newTask = new Task();
                        newTask.setTaskString(this.utils.removeLeadingNumbers(TutorDoc.p(pList.item(i))));
                        newTask.setId("T_" + ++this._taskNumber);
                        NodeList taskData = this.getXpathNodeList("following-sibling::*", pList.item(i));
                        String xpExpressionSubTask = "descendant::pStyle/@val";
                        for (int j = 0; j < taskData.getLength() && !(subTaskName = xpathStyle.evaluate(xpExpressionSubTask, taskData.item(j))).matches("Task1") && !subTaskName.matches("Directive"); ++j) {
                            if (subTaskName.matches("Actor")) continue;
                            newTask.addTaskData(taskData.item(j));
                        }
                        newTask.addActor(this._currentActor);
                        this.addStep(newTask);
                        continue;
                    }
                    if (styleAttributeValue.matches("Directive")) {
                        String clearedOfNumbersDir = this.utils.removeLeadingNumbers(TutorDoc.p(pList.item(i)));
                        Directive directive = new Directive(lm, clearedOfNumbersDir);
                        directive.setId("D_" + ++this._directiveNumber);
                        Condition co = (Condition)directive.getConditions().get(0);
                        Boolean isEnd = co.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY;
                        Boolean isStop = co.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE;
                        if (!isStop.booleanValue()) {
                            NodeList StackedDirectiveData = this.getXpathNodeList("following-sibling::*", pList.item(i));
                            String xpathStyle2 = "descendant::pStyle/@val";
                            for (int j = 0; j < StackedDirectiveData.getLength(); ++j) {
                                String name = xpathStyle.evaluate(xpathStyle2, StackedDirectiveData.item(j));
                                if (name.matches("Directive")) {
                                    String clearedOfNumsDir = this.utils.removeLeadingNumbers(TutorDoc.p(StackedDirectiveData.item(j)));
                                    Directive tmpDir = new Directive(lm, clearedOfNumsDir);
                                    Condition tmpC = (Condition)tmpDir.getConditions().get(0);
                                    if (isEnd.booleanValue() && (tmpC.getTest() == null || tmpC.getTest().equals(""))) {
                                        directive.addStackedCondition(clearedOfNumsDir);
                                        ++i;
                                        continue;
                                    }
                                    if (isEnd.booleanValue()) break;
                                    boolean parentDirIsConditional = directive.isConditional(TutorDoc.p(pList.item(i)));
                                    boolean currentTestDirectiveIsConditional = tmpDir.isConditional(TutorDoc.p(StackedDirectiveData.item(j)));
                                    directive.addStackedCondition(clearedOfNumsDir);
                                    ++i;
                                    continue;
                                }
                                if (name.matches("Task1") || name.matches("Actor") || name.matches("") || name.matches("Flowchart")) break;
                                directive.addSubStepData(StackedDirectiveData.item(j));
                                ++i;
                            }
                        }
                        directive.addActor(this._currentActor);
                        this.addStep(directive);
                        continue;
                    }
                    if (styleAttributeValue.matches("Actor")) {
                        this.setActorFound(true);
                        Actor newActor = new Actor();
                        if (!this.isRE_file()) {
                            newActor.setTitle(TutorDoc.p(pList.item(i)));
                            newActor.setId("L" + actorCounter++);
                        } else {
                            newActor.setRE_actorName(TutorDoc.p(pList.item(i)));
                        }
                        if (this.getActorByTitle(newActor.getTitle()) == null) {
                            this.addDistributionListItem(newActor);
                            this._actorList.add(newActor);
                            this._currentActor = newActor;
                            continue;
                        }
                        this._currentActor = this.getActorByTitle(newActor.getTitle());
                        continue;
                    }
                    if (this.isActorFound()) continue;
                }
                _logger.fine("done reading paragraphs.\n there are this many steps: " + this.getSteps().size());
                if (this.getSteps().size() <= 1) {
                    throw new RuntimeException("This document contains no tasks to process. Import will stop.");
                }
                this.setAllNextSteps();
            }
            catch (IOException ioe) {
                _logger.severe("IO Exception in loadDocx() method. " + ioe.getMessage());
                throw new RuntimeException("IO Exception in loadDocx() method. Verify that the file path is correct.");
            }
            catch (XPathExpressionException xpe) {
                _logger.severe("XPathExpressionException in loadDocx() method. " + xpe.getMessage());
                throw new RuntimeException("XPathExpressionException in loadDocx() method. Verify that the xml data is well formed.");
            }
            catch (SAXException se) {
                _logger.severe("SAXException in loadDocx() method. " + se.getMessage());
                throw new RuntimeException("SAXException in loadDocx() method. Verify that the xml data is well formed.");
            }
            catch (ParserConfigurationException pce) {
                _logger.severe("ParserConfigurationException in loadDocx() method. " + pce.getMessage());
                throw new RuntimeException("ParserConfigurationException in loadDocx() method.");
            }
        } else {
            _logger.severe("No Tutor Document passed to loadDocx() method. Program will exit.");
            throw new RuntimeException("No Tutor Document passed to loadDocx() method.");
        }
    }

    public BusinessProcessDiagram getBpdDiagram(String poolOneName) {
        _logger.fine("getBpdDiagram(String) called.\n");
        BPModeler bpm = new BPModeler(this, poolOneName, _logger);
        return bpm.getDiagram();
    }

    public BusinessProcessDiagram getBpdDiagram() {
        _logger.fine("getBpdDiagram() called.\n\n");
        BPModeler bpm = new BPModeler(this, "My Company", _logger);
        return bpm.getDiagram();
    }

    public String getDocFileName() {
        _logger.fine("getDocFileName() called.\n");
        File tutorFile = new File(this._tutorFile);
        String tmp = tutorFile.getName();
        Pattern typeStr = Pattern.compile(".docx");
        Matcher m = typeStr.matcher(tmp);
        Boolean matched = false;
        while (m.find()) {
            matched = true;
        }
        String docFileName = "";
        docFileName = matched != false ? tmp.substring(0, tmp.length() - 5) : tmp;
        String[] specChars = new String[]{"<", ">", "|", "[\\?]+\\s*", "'", ":", "\"", "[\\*]+\\s*"};
        for (int i = 0; i < specChars.length; ++i) {
            docFileName = docFileName.replaceAll(specChars[i], "");
        }
        return docFileName;
    }

    private static String p(Node pNode) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String xpExpression = "descendant::t";
        NodeList tList = (NodeList)xpath.evaluate(xpExpression, pNode, XPathConstants.NODESET);
        String pData = "";
        for (int i = 0; i < tList.getLength(); ++i) {
            pData = pData + tList.item(i).getTextContent();
        }
        return pData;
    }

    private Person getOwnerFromData(String data) {
        Person p = new Person();
        String email = "";
        String[] split1 = data.split("\\[");
        String title = split1[0];
        if (split1.length > 1) {
            String[] split2 = split1[1].split("\\?");
            email = split2[0];
        }
        p.setEmail(email);
        p.setRole(title, "");
        return p;
    }

    public void addDistributionListItem(Role role) {
        if (!this._distributionList.contains(role.getTitle())) {
            this._distributionList.add(role.getTitle());
        }
    }

    public ArrayList getMDistributionList() {
        return this._distributionList;
    }

    public ArrayList getMActorList() {
        return this._actorList;
    }

    private NodeList getXpathNodeList(String axis, Node dataSet) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = axis;
        NodeList nodes = (NodeList)xpath.evaluate(expression, dataSet, XPathConstants.NODESET);
        return nodes;
    }

    private String getAttributeValueFromNode(String attribute, Node node) {
        String v = "";
        XPath xpath = XPathFactory.newInstance().newXPath();
        String xpExpressionStyle = "descendant::" + attribute + "/@val";
        try {
            v = xpath.evaluate(xpExpressionStyle, node);
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        return v;
    }

    public Actor getActorByTitle(String title) {
        Actor ac = null;
        for (Object o : this._actorList) {
            Actor a = (Actor)o;
            if (!a.getTitle().matches(title)) continue;
            ac = a;
            return ac;
        }
        return ac;
    }

    public void addActor(Actor a) {
        boolean found = false;
        if (this._actorList != null) {
            for (Object ac : this.getMActorList()) {
                if (((Actor)ac).getTitle().equals(a.getTitle())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this._actorList.add(a);
        }
    }

    private void setAllNextSteps() {
        _logger.fine("Setting next steps.\n");
        ArrayList steps = this.getSteps();
        _logger.fine("This document contains " + steps.size() + " steps.\n");
        ArrayList tasks = new ArrayList();
        for (Object t : steps) {
            if (!(t instanceof Task)) continue;
            tasks.add(t);
        }
        _logger.fine("This document contains " + tasks.size() + " tasks.\n");
        if (steps.size() > 0) {
            this.setStartStep((Step)steps.get(0));
        }
        int stepCounter = 0;
        int taskCounter = 1;
        for (Object o : steps) {
            Step step;
            if (steps.size() > stepCounter + 1) {
                step = (Step)o;
                Step nextStep = (Step)steps.get(stepCounter + 1);
                step.setNextStep(nextStep);
                if (step instanceof Directive) {
                    Condition c;
                    _logger.fine("processing step " + (stepCounter + 1));
                    Directive d = (Directive)o;
                    ArrayList conds = d.getConditions();
                    for (Object cd : conds) {
                        Condition c2 = (Condition)cd;
                        Action a = c2.getAction();
                        ActionEnum.Type at = a.getType();
                        if (at == ActionEnum.Type.GOTO || at == ActionEnum.Type.RETURN_TO) {
                            if (a.getTaskNumber() > 0 && tasks.size() > a.getTaskNumber() - 1) {
                                Step s = (Step)tasks.get(a.getTaskNumber() - 1);
                                a.setTargetStep(s);
                                continue;
                            }
                            if (a.getLinkObject() == null) continue;
                            a.setTargetStep(a.getLinkObject());
                            continue;
                        }
                        a.setTargetStep(null);
                    }
                    if (conds.size() == 1 && (c = (Condition)conds.get(0)).getTest() != null && !c.getTest().equals("")) {
                        Condition nc = new Condition(null, true, ActionEnum.Type.GOTO, "task #" + taskCounter);
                        nc.getAction().setTargetStep(step.getNextStep());
                        d.addCondition(nc);
                    }
                } else {
                    ++taskCounter;
                }
                ++stepCounter;
                continue;
            }
            if (steps.size() != stepCounter + 1) continue;
            _logger.fine("Handling last step #" + stepCounter + ".\n");
            step = (Step)o;
            if (step instanceof Directive) {
                Directive d = (Directive)o;
                ArrayList conds = d.getConditions();
                _logger.fine("Handling last step #" + stepCounter + ". Directive [\"" + d.getDirectiveString() + "\"] has " + conds.size() + " conditions.\n");
                for (Object cd : conds) {
                    Condition c = (Condition)cd;
                    Action a = c.getAction();
                    ActionEnum.Type at = a.getType();
                    if (at == ActionEnum.Type.GOTO || at == ActionEnum.Type.RETURN_TO) {
                        _logger.fine("Handling Goto in directive: " + d.getDirectiveString() + "\n");
                        if (a.getTaskNumber() > 0 && a.getTaskNumber() < tasks.size()) {
                            _logger.fine("a.getTaskNumber() returns " + a.getTaskNumber());
                            Step s = (Step)tasks.get(a.getTaskNumber() - 1);
                            a.setTargetStep(s);
                        } else {
                            _logger.fine("Handling last step #" + stepCounter + " where actionType is " + at.toString() + "\n");
                            a.setTaskNumber(0);
                            a.setTargetStep(a.getLinkObject());
                        }
                    } else {
                        a.setTargetStep(null);
                    }
                    _logger.fine("Handled condition");
                }
                continue;
            }
            _logger.fine("Handling last step #" + stepCounter + " where last step is not a Directive");
        }
        _logger.fine("done setting all next Steps.\n");
    }

    private void reNumberAllSteps() {
        int taskCounter = 0;
        int directiveCounter = 0;
        for (Object s : this.getSteps()) {
            if ((Step)s instanceof Task) {
                ((Step)s).setId("T_" + ++taskCounter);
                ((Task)s).setTaskNumber(taskCounter);
                continue;
            }
            if (!((Step)s instanceof Directive)) continue;
            ((Step)s).setId("D_" + ++directiveCounter);
        }
    }

    protected Step getStepByIndex(int stepIndex) {
        Step s = null;
        ArrayList steps = this.getSteps();
        int stepNum = 1;
        for (Object t : steps) {
            if (stepNum == stepIndex) {
                s = (Step)t;
                break;
            }
            ++stepNum;
        }
        return s;
    }

    protected int getStepIndex(Step step) {
        int s = 0;
        ArrayList steps = this.getSteps();
        int stepNum = 1;
        for (Object t : steps) {
            if (((Step)t).getId() == step.getId()) {
                s = stepNum;
                break;
            }
            ++stepNum;
        }
        return s;
    }

    private void insertAdditionalSteps(BusinessProcessDiagram bpd, LanguageMap lm) {
        Step last;
        int stepNum = 1;
        for (FlowObject t : bpd.getSequencedNodes()) {
            if (t instanceof oracle.tutor.bpmn.Task) {
                oracle.tutor.bpmn.Task currentTask = (oracle.tutor.bpmn.Task)t;
                if (currentTask.getOutflows().size() == 1) {
                    ConnectingObject flow = (ConnectingObject)currentTask.getOutflows().getFirst();
                    GraphicalElement toNode = flow.getTo();
                    String handledGotoFlag = "handledGoto_" + stepNum;
                    Step targetTask = this.getStepBySourceId(toNode.getID());
                    Task currentDocxTask = (Task)this.getStepBySourceId(currentTask.getID());
                    Step nextStep = null;
                    if (this.getStepBySourceId(currentTask.getID()).getNextStep() == null) break;
                    nextStep = this.getStepBySourceId(currentTask.getID()).getNextStep();
                    if (targetTask != null && targetTask instanceof Task && !targetTask.equals(nextStep)) {
                        String dString = (String)lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + ((Task)targetTask).getTaskNumber();
                        Directive d = new Directive(lm, dString);
                        if (nextStep != null && nextStep instanceof Directive) {
                            if (!Bpd2TutorUtil.directiveContainsIdenticalCondition(nextStep, (Condition)d.getConditions().get(0)) && !d.equals(nextStep)) {
                                if (nextStep instanceof Task) {
                                    this.insertStepAfter(this.getStepIndex(currentDocxTask), d);
                                } else if (nextStep instanceof Directive) {
                                    ((Directive)nextStep).addCondition(new Condition(null, false, ActionEnum.Type.GOTO, lm.getFirstValue("Task #") + " " + ((Task)targetTask).getTaskNumber()));
                                }
                                toNode.setAttribute(handledGotoFlag, (Object)true);
                            }
                        } else if (nextStep != null && nextStep instanceof Task) {
                            this.insertStepAfter(this.getStepIndex(currentDocxTask), d);
                            toNode.setAttribute(handledGotoFlag, (Object)true);
                        }
                    }
                } else if (currentTask.getOutflows().size() > 1) {
                    int flowCounter = 0;
                    Directive d = new Directive(lm);
                    d.setParallel(true);
                    Iterator i$ = currentTask.getOutflows().iterator();
                    while (i$.hasNext()) {
                        ConnectingObject f;
                        ConnectingObject flow = f = (ConnectingObject)i$.next();
                        GraphicalElement toNode = flow.getTo();
                        String handledGotoFlag = "handledGoto_" + stepNum;
                        if ((toNode instanceof oracle.tutor.bpmn.Task || toNode instanceof Gateway) && toNode.getAttribute(handledGotoFlag) == null) {
                            Task currentDocxTask = (Task)this.getStepBySourceId(currentTask.getID());
                            Step targetTask = this.getStepBySourceId(toNode.getID());
                            Step nextStep = currentDocxTask.getNextStep();
                            if (nextStep != null && targetTask != null && currentDocxTask != null && targetTask instanceof Task) {
                                Condition c = new Condition("", false, ActionEnum.Type.GOTO, (String)lm.getFirstValue("Task #") + ((Task)targetTask).getTaskNumber());
                                d.addCondition(c);
                                if (nextStep != null && nextStep instanceof Directive) {
                                    if (!Bpd2TutorUtil.directiveContainsIdenticalCondition(nextStep, c)) {
                                        if (nextStep instanceof Task) {
                                            this.insertStepAfter(this.getStepIndex(currentDocxTask), d);
                                        } else if (nextStep instanceof Directive) {
                                            ((Directive)nextStep).addCondition(new Condition(null, false, ActionEnum.Type.GOTO, lm.getFirstValue("Task #") + " " + ((Task)targetTask).getTaskNumber()));
                                        }
                                        toNode.setAttribute(handledGotoFlag, (Object)true);
                                    }
                                } else if (nextStep != null && nextStep instanceof Task) {
                                    if (flowCounter == 0) {
                                        this.insertStepAfter(this.getStepIndex(currentDocxTask), d);
                                    }
                                    toNode.setAttribute(handledGotoFlag, (Object)true);
                                }
                            }
                        }
                        ++flowCounter;
                    }
                }
            } else if (!(t instanceof Gateway) && t instanceof Subprocess && ((Subprocess)t).getOutflows().size() > 0) {
                Iterator i$ = ((Subprocess)t).getOutflows().iterator();
                while (i$.hasNext()) {
                    ConnectingObject f;
                    ConnectingObject flow = f = (ConnectingObject)i$.next();
                    GraphicalElement toNode = flow.getTo();
                    String handledGotoFlag = "handledGoto_" + stepNum;
                    if (!(toNode instanceof oracle.tutor.bpmn.Task) && !(toNode instanceof Gateway) || toNode.getAttribute(handledGotoFlag) != null) continue;
                    Step currentStep = this.getStepBySourceId(((Subprocess)t).getID());
                    Step targetTask = this.getStepBySourceId(toNode.getID());
                    Step nextStep = currentStep.getNextStep();
                    if (nextStep == null || targetTask == null || targetTask.equals(nextStep) || !(targetTask instanceof Task)) continue;
                    _logger.fine("I should make a goto from " + ((Subprocess)t).getName() + " to " + ((Task)targetTask).getTaskNumber());
                    String dString = (String)lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + ((Task)targetTask).getTaskNumber();
                    Directive d = new Directive(lm, dString);
                    if (nextStep != null && nextStep instanceof Directive) {
                        if (Bpd2TutorUtil.directiveContainsIdenticalCondition(nextStep, (Condition)d.getConditions().get(0)) || d.equals(nextStep)) continue;
                        this.insertStepAfter(this.getStepIndex(currentStep), d);
                        toNode.setAttribute(handledGotoFlag, (Object)true);
                        continue;
                    }
                    if (nextStep == null || !(nextStep instanceof Task)) continue;
                    this.insertStepAfter(this.getStepIndex(currentStep), d);
                    toNode.setAttribute(handledGotoFlag, (Object)true);
                }
            }
            ++stepNum;
        }
        if ((last = this.getLastStep()) instanceof Task) {
            Directive newLast = new Directive(lm, "End of activity");
            this.addStep(newLast);
        } else if (last instanceof Directive) {
            Condition c;
            Boolean hasEndofActivity = false;
            Boolean lastIsFollowup = false;
            for (Object o : ((Directive)last).getConditions()) {
                c = (Condition)o;
                if (c.getAction().getType() != ActionEnum.Type.END_OF_ACTIVITY) continue;
                hasEndofActivity = true;
            }
            for (Object o : ((Directive)last).getConditions()) {
                c = (Condition)o;
                if (!hasEndofActivity.booleanValue() || c.getAction().getType() != ActionEnum.Type.GOTO && c.getAction().getType() != ActionEnum.Type.STOP_AND_COMPLETE || c.getTest() != null) continue;
                lastIsFollowup = true;
            }
            if (!(hasEndofActivity.booleanValue() || lastIsFollowup.booleanValue() || ((Directive)last).followingSteps != null && ((Directive)last).followingSteps.size() != 0)) {
                Directive newLast = new Directive(lm, "End of activity");
                this.addStep(newLast);
            }
        }
    }

    private Boolean isPriorActivity(String pData, LanguageMap lm) {
        Boolean isPrior = false;
        ArrayList tn = lm.getLocalizedValues("Prior Activity");
        if (tn != null) {
            for (Object value : tn) {
                if (!pData.trim().matches(((String)value).trim())) continue;
                isPrior = true;
            }
        }
        return isPrior;
    }

    private void handlePriorActivityNodes(XPath xpathStyle, NodeList nl) throws IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        String paName;
        String xpExpressionSubTask = "descendant::pStyle/@val";
        for (int i = 0; i < nl.getLength() && !(paName = xpathStyle.evaluate(xpExpressionSubTask, nl.item(i))).matches("Actor") && !paName.matches("Task1"); ++i) {
            this.setPriorActivityItem(TutorDoc.p(nl.item(i)));
        }
    }

    public int getCharCount() {
        String s = this.getAllTextContent();
        char[] c = s.toCharArray();
        return c.length;
    }

    public int getWordCount() {
        String s = this.getAllTextContent();
        String[] spaceSplit = s.split(" ");
        int ct = spaceSplit.length;
        return ct;
    }

    private String getAllTextContent() {
        String content = "";
        try {
            NodeList nl = this.getXpathNodeList("descendant::t", this._document);
            for (int j = 0; j < nl.getLength(); ++j) {
                content = content + nl.item(j).getTextContent() + " ";
            }
        }
        catch (Exception e) {
            content = "";
        }
        return content;
    }

    public void setPriorActivityItem(String priorActivityItem) {
        this._priorActivity.addActivity(priorActivityItem);
    }

    public PriorActivity getPriorActivity() {
        _logger.fine("getPriorActivity() called.\n");
        return this._priorActivity;
    }

    public void setMTutorFile(String mTutorFile) {
        this._tutorFile = mTutorFile;
    }

    public String getMTutorFile() {
        return this._tutorFile;
    }

    public void setCurrentActor(Actor mCurrentActor) {
        this._currentActor = mCurrentActor;
    }

    public Actor getCurrentActor() {
        return this._currentActor;
    }

    public void toDocx(String outputFilePath, String outputFileName) throws ParserConfigurationException, IOException, SAXException {
        Word_Packager wp = new Word_Packager(_logger);
        wp.setPaths(outputFilePath, this, outputFileName);
        wp.marshall();
    }

    public void toDocx(String outputFilePath, String outputFileName, TutorDoc td) throws ParserConfigurationException, IOException, SAXException {
        Word_Packager wp = new Word_Packager(_logger);
        TutorDoc doc = null;
        doc = td == null ? this : td;
        wp.setPaths(outputFilePath, doc, outputFileName);
        wp.marshall();
    }

    public void setPriorActivity(PriorActivity pa) {
        if (this._priorActivity == null) {
            this._priorActivity = pa;
        }
    }

    private void addIntroSection(String sectionName) {
        this._introSectionNum = this._introSection.addSection(sectionName, this._introSectionNum);
    }

    private void addIntroSectionListItem(String sectionName, String itemStyleName, String itemData) {
        ArrayList section = this._introSection.getSection(sectionName);
        SubStepData sd = new SubStepData(itemStyleName, itemData);
        section.add(sd);
    }

    private void handleIntroNodesFromDocx(NodeList nodes, String sectionTitle) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String xpExpression = "descendant::pStyle/@val";
        for (int i = 0; i < nodes.getLength(); ++i) {
            String subTaskName = "";
            try {
                subTaskName = xpath.evaluate(xpExpression, nodes.item(i));
            }
            catch (XPathExpressionException e) {
                _logger.info("Error parsing XPath expression: " + xpExpression + ". message: " + e.getMessage());
            }
            if (subTaskName.matches("SectionTitle") || subTaskName.matches("Task1") || subTaskName.matches("Directive") || subTaskName.matches("Actor") || subTaskName.matches("Subheading")) break;
            this.addIntroSectionListItemFromDocx(sectionTitle, nodes.item(i));
        }
    }

    private void addIntroSectionFromDocx(String introSectionTitle) {
        this.addIntroSection(introSectionTitle);
    }

    private void addIntroSectionListItemFromDocx(String introSectionTitle, Node n) throws XPathExpressionException {
        String styleName = this.getAttributeValueFromNode("pStyle", n);
        String data = "";
        try {
            data = TutorDoc.p(n);
        }
        catch (XPathExpressionException e) {
            _logger.fine("Problem converting IntroSection node to string at line 1376. message is " + e.getMessage());
        }
        ArrayList section = this._introSection.getSection(introSectionTitle);
        SubStepData sd = new SubStepData(n);
        section.add(sd);
    }

    private Step getStepBySourceId(String nodeId) {
        Step s = null;
        for (Object step : this.getSteps()) {
            String sid;
            if (((Step)step).getSourceId() == null || !(sid = ((Step)step).getSourceId()).equals(nodeId)) continue;
            s = (Step)step;
            break;
        }
        if (s == null) {
            block1: for (Object step : this.getSteps()) {
                if (s != null) break;
                if (!(step instanceof Directive)) continue;
                for (Object c : ((Directive)step).getConditions()) {
                    String targ = ((Condition)c).getAction().getTarget();
                    String lookingFor = "";
                    String[] nid = nodeId.split("_");
                    lookingFor = nid[0];
                    if (!targ.contains(lookingFor)) continue;
                    s = (Step)step;
                    continue block1;
                }
            }
        }
        return s;
    }

    private Step getStepById(String Id) {
        Step s = null;
        for (Object step : this.getSteps()) {
            if (!((Step)step).getId().equals(Id)) continue;
            s = (Step)step;
            break;
        }
        return s;
    }

    public IntroSection getIntroSection() {
        _logger.fine("getIntroSection() called.\n");
        return this._introSection;
    }

    public void setIntroSection(IntroSection mIntroSection) {
        if (this._introSection == null) {
            this._introSection = mIntroSection;
        }
    }

    private boolean check4RE_file(String filename) {
        boolean isRE = false;
        if (filename.startsWith("RE_")) {
            isRE = true;
        }
        _logger.fine("Checking for RE_file. Return " + isRE);
        return isRE;
    }

    private void setIsRE_file(boolean isRE_file) {
        this._isReFile = isRE_file;
    }

    public boolean isRE_file() {
        return this._isReFile;
    }

    private void setActorFound(boolean actorFound) {
        this._actorFound = actorFound;
    }

    private boolean isActorFound() {
        return this._actorFound;
    }

    public LinkedList<ConversionMessage> getMsgList() {
        return this._msgList;
    }
}

