/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.SubStepData;
import oracle.tutor.docx.Utils;
import org.w3c.dom.Node;

public class Task
extends Step {
    private String mName;
    private String mtaskString;
    private ArrayList mTaskData;
    private int taskNumber;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void addTaskDataFromString(String tutorStyleString, String taskDataString) {
        if (this.mTaskData == null) {
            this.mTaskData = new ArrayList();
            this.mTaskData.add(new SubStepData(tutorStyleString, taskDataString));
        } else {
            this.mTaskData.add(new SubStepData(tutorStyleString, taskDataString));
        }
    }

    public void addTaskData(Node node) throws XPathExpressionException {
        if (this.mTaskData == null) {
            this.mTaskData = new ArrayList();
            this.mTaskData.add(new SubStepData(node));
        } else {
            this.mTaskData.add(new SubStepData(node));
        }
    }

    public void addTaskData(SubStepData s) {
        if (this.mTaskData == null) {
            this.mTaskData = new ArrayList();
            this.mTaskData.add(s);
        } else {
            this.mTaskData.add(s);
        }
    }

    public ArrayList getTaskData() {
        if (this.mTaskData == null) {
            this.mTaskData = new ArrayList();
        }
        return this.mTaskData;
    }

    public String getTaskDataAsDocumentationString() {
        String s = "";
        for (Object o : this.getTaskData()) {
            s = s + "{" + ((SubStepData)o).getStyleName().trim() + "}" + ((SubStepData)o).getDataString() + "\n";
        }
        return s;
    }

    public void setTaskString(String taskString) {
        this.mtaskString = taskString;
    }

    public String getTaskString() {
        return this.mtaskString;
    }

    public String actorsToDocx(String currentActor, String guid) {
        String d = "";
        String names = "";
        int count = 0;
        for (Object o : this.getActors()) {
            if (++count > 1 && count < this.getActors().size()) {
                names = names + ", ";
            }
            names = names + ((Actor)o).getTitle().trim();
        }
        if (!names.equals(currentActor.trim())) {
            d = "   <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "                 <w:pPr>\n" + "                         <w:pStyle w:val=\"Actor\"/>\n" + "                 </w:pPr>\n" + "                 <w:r>\n" + "                         <w:t>" + Utils.formatEntityNotation(names) + "</w:t>\n" + "                 </w:r>\n" + "     </w:p>\n";
        }
        return d;
    }

    public String toDocx(int taskNumber, String guid) {
        String taskString = "";
        taskString = taskString + "\t<w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "\t\t<w:pPr>\n" + "\t\t\t<w:pStyle w:val=\"Task1\"/>\n" + "\t\t</w:pPr>\n" + "           <w:r>\n" + "                   <w:t>" + taskNumber + ".</w:t>\n" + "           </w:r>\n" + "\t\t<w:r>\n" + "           <w:tab/>\n" + "\t\t\t<w:t>" + Utils.formatEntityNotation(this.mtaskString) + "</w:t>\n" + "\t\t</w:r>\n" + "\t</w:p>\n" + this.taskDatatoDocx(guid);
        return taskString;
    }

    private String taskDatatoDocx(String guid) {
        String td = "";
        if (this.getTaskData() != null) {
            for (Object o : this.getTaskData()) {
                td = td + ((SubStepData)o).toDocx(guid);
            }
        }
        return td;
    }

    protected void setTaskNumber(int taskNumber) {
        this.taskNumber = taskNumber;
    }

    public int getTaskNumber() {
        return this.taskNumber;
    }
}

