/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.docx.Utils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubStepData {
    private String styleName;
    private String dataString;
    private boolean containsUPKlink = false;
    private boolean hasLink = false;
    private String upk_topic_id = "";
    private String upk_topic_url = "";
    private String upk_topic_name = "";
    private Utils utils;
    private String formattedLinkString;
    private static Logger _logger = Logger.getLogger("oracle.tutor.docx");

    public SubStepData(Node n) throws XPathExpressionException {
        XPath xpathStyle = XPathFactory.newInstance().newXPath();
        String xpExpressionSubTask = "descendant::pStyle/@val";
        this.setStyleName(xpathStyle.evaluate(xpExpressionSubTask, n));
        this.setDataString(n.getTextContent());
        if (Utils.nodeHasExternalLink(n)) {
            this.setHasLink(true);
            this.formattedLinkString = this.makeStringMap(n);
            this.setUpkLink(this.check4UPKlink(n.getTextContent()));
        }
    }

    public SubStepData(String styleName, String dataString) {
        this.setStyleName(styleName);
        this.setDataString(dataString);
        this.setHasLink(this.check4FileLink(dataString));
        this.setUpkLink(this.check4UPKlink(dataString));
        if (this.hasLink()) {
            this.formattedLinkString = this.getDataString();
        }
    }

    private String makeStringMap(Node n) throws XPathExpressionException {
        String linkString = "";
        XPath xpath = XPathFactory.newInstance().newXPath();
        String axis1 = "descendant::r";
        NodeList nodes = (NodeList)xpath.evaluate(axis1, n, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String test = nodes.item(i).getTextContent();
            String axis2 = "child::rPr/child::i";
            String axis3 = "child::rPr/child::u";
            NodeList nodesItal = (NodeList)xpath.evaluate(axis2, nodes.item(i), XPathConstants.NODESET);
            NodeList nodesUl = (NodeList)xpath.evaluate(axis3, nodes.item(i), XPathConstants.NODESET);
            linkString = nodesItal.getLength() > 0 && nodesUl.getLength() > 0 ? linkString + "<i><u>" + nodes.item(i).getTextContent() + "</u></i>" : linkString + nodes.item(i).getTextContent();
        }
        return linkString;
    }

    public String getStyleName() {
        return this.styleName.trim();
    }

    public String getDataString() {
        String data = this.dataString;
        if (this.formattedLinkString != null) {
            data = this.formattedLinkString;
        }
        return data;
    }

    public String getPlainDataString() {
        return this.dataString;
    }

    public String getDocumentationFormat() {
        String s = "{" + this.getStyleName() + "}";
        s = s + this.getDataString().trim() + "\n";
        return s;
    }

    public String toDocx(String guid) {
        String g = "";
        g = guid == null ? "D1A2B3C6" : guid;
        String sn = this.getStyleName();
        String td = "    <w:p w:rsidR=\"" + g + "\" w:rsidRDefault=\"" + g + "\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"" + sn + "\"/>\n";
        td = td + "\t\t\t</w:pPr>\n";
        if (this.formattedLinkString != null) {
            String[] linkStrings = this.getDataString().split("<i><u>");
            for (int i = 0; i < linkStrings.length; ++i) {
                boolean matches = false;
                String regEx = "(</u></i>)";
                Pattern pattern = Pattern.compile(regEx, 2);
                Matcher m = pattern.matcher(linkStrings[i]);
                ArrayList<MatchResult> stringParts = new ArrayList<MatchResult>();
                while (m.find()) {
                    stringParts.add(m.toMatchResult());
                }
                if (stringParts.size() > 0) {
                    for (MatchResult r : stringParts) {
                        if (r.start() > 0) {
                            td = td + "     <w:r>\n";
                            td = td + "       <w:rPr>\n        <w:i/>\n        <w:u w:val=\"single\"/>\n      </w:rPr>\n       <w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(linkStrings[i].substring(0, r.start())) + "</w:t>\n" + "    </w:r>\n";
                        }
                        if (r.end() == linkStrings[i].length()) continue;
                        td = td + "        <w:r>\n              <w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(linkStrings[i].substring(r.end(), linkStrings[i].length())) + "</w:t>\n" + "        </w:r>\n";
                    }
                    continue;
                }
                td = td + "\t<w:r>\n         <w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(linkStrings[i]) + "</w:t>\n" + "      </w:r>\n";
            }
        } else {
            td = td + "\t<w:r>\n\t\t<w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(this.getDataString()) + "</w:t>\n" + "\t</w:r>\n";
        }
        td = td + " </w:p>\n";
        return td;
    }

    private void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public void setDataString(String dataString) {
        this.dataString = dataString;
    }

    private boolean check4UPKlink(String data) {
        boolean matched = false;
        Pattern owp = Pattern.compile("dhtml_kp.html?");
        Matcher m = owp.matcher(data);
        while (m.find()) {
            matched = true;
        }
        if (matched) {
            String id = Utils.getFileRefID(data);
            this.setUpk_topic_id(id);
            String url = Utils.getFileRefUrl(data);
            this.setUpk_topic_url(url);
            String name = "";
            if (this.formattedLinkString != null) {
                name = Utils.getFileRefName(this.formattedLinkString);
                this.setUpk_topic_name(name);
            } else {
                name = Utils.getFileRefName(data);
                this.setUpk_topic_name(name);
            }
        }
        return matched;
    }

    private boolean check4FileLink(String data) {
        String regEx = "\\[(.|/)*.+\\]";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(data);
        boolean matched = false;
        while (tm.find()) {
            matched = true;
            this.formattedLinkString = data;
        }
        return matched;
    }

    private void setUpkLink(boolean containsUPKlink) {
        this.containsUPKlink = containsUPKlink;
    }

    public boolean isContainsUPKlink() {
        return this.containsUPKlink;
    }

    private void setHasLink(boolean hasLink) {
        this.hasLink = hasLink;
    }

    protected boolean hasLink() {
        return this.hasLink;
    }

    private void setUpk_topic_id(String upk_topic_id) {
        this.upk_topic_id = upk_topic_id;
    }

    public String getUpk_topic_id() {
        return this.upk_topic_id;
    }

    private void setUpk_topic_url(String upk_topic_url) {
        String[] tmp = upk_topic_url.split("\\?");
        this.upk_topic_url = tmp[0] + "?";
    }

    public String getUpk_topic_url() {
        return this.upk_topic_url;
    }

    private void setUpk_topic_name(String upk_topic_name) {
        this.upk_topic_name = upk_topic_name;
    }

    public String getUpk_topic_name() {
        return this.upk_topic_name;
    }
}

