/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Link {
    private String linkUrl;
    private String linkString;
    private String linkId;
    private boolean isUPK;
    private static Logger _logger = Logger.getLogger("oracle.tutor.docx");

    public Link(String s) {
        _logger.fine("Checking " + s + " for link pattern, including '[' and ']'.\n");
        this.isUPK = false;
        this.linkUrl = "";
        this.linkString = "";
        String regEx = "\\[(.|/)*.+\\]";
        Pattern targStr = Pattern.compile(regEx, 2);
        Matcher tm = targStr.matcher(s.trim());
        boolean matched = false;
        while (tm.find()) {
            matched = true;
            String tmp = s.substring(tm.start() + 1, tm.end() - 1);
            String[] UrlData = tmp.split("_");
            this.linkUrl = UrlData[0].endsWith("RE") ? UrlData[0] + "_" + UrlData[1] : tmp;
            try {
                this.linkString = s.substring(0, tm.start()).trim();
            }
            catch (StringIndexOutOfBoundsException ex) {
                try {
                    this.linkString = "* " + s.substring(tm.start() + 1, tm.end() - 1);
                }
                catch (StringIndexOutOfBoundsException ex2) {
                    this.linkString = "";
                }
            }
        }
        Pattern owp = Pattern.compile("Guid=", 2);
        Matcher m = owp.matcher(s);
        while (m.find()) {
            this.isUPK = true;
            String tmpOb = s.substring(m.end(), s.trim().length());
            String[] tmpAr = tmpOb.split("]");
            this.linkId = tmpAr[0];
            String[] tmpUrl = this.getLinkUrl().split("\\?");
            if (tmpUrl.length <= 1) continue;
            this.linkUrl = tmpUrl[0] + "?";
        }
    }

    protected String getLinkUrl() {
        return this.linkUrl;
    }

    protected String getLinkString() {
        return this.linkString;
    }

    private boolean isIsUPK() {
        return this.isUPK;
    }

    public String getLinkId() {
        if (this.isIsUPK()) {
            return "Guid=" + this.linkId;
        }
        return this.linkId;
    }
}

