/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.SubStepData;
import org.w3c.dom.Node;

public class IntroSection {
    private Boolean _isPlainText = false;
    private String _plainText;
    private LanguageMap _lm;
    private HashMap _sections;
    private Logger _logger;

    public IntroSection(LanguageMap lm, Logger logger) {
        this._lm = lm;
        this._logger = logger;
        this._sections = new HashMap();
    }

    protected int addSection(String sectionName, int index) {
        int returnedSectionNumber = index;
        if (this._sections.get(sectionName) == null) {
            ArrayList<Integer> al = new ArrayList<Integer>();
            al.add(index);
            this._sections.put(sectionName, al);
            returnedSectionNumber = index + 1;
        }
        return returnedSectionNumber;
    }

    protected ArrayList getSection(String sectionName) {
        ArrayList list = new ArrayList();
        if (this._sections.get(sectionName) != null) {
            list = (ArrayList)this._sections.get(sectionName);
        }
        return list;
    }

    protected void addIntroSectionListItem(String sectionName, String itemStyleName, String itemData) {
        this._logger.fine("Adding " + itemData + " to  intro section w/o '{' markup to this section: " + sectionName);
        ArrayList list = (ArrayList)this._sections.get(sectionName);
        try {
            list.add(new SubStepData(itemStyleName, itemData));
        }
        catch (Exception e) {
            this._logger.info("ERROR. Can't add " + itemData + ". Message is " + e.getMessage());
        }
    }

    protected void addIntroSectionListItem(String sectionName, Node n) throws XPathExpressionException {
        ArrayList list = (ArrayList)this._sections.get(sectionName);
        list.add(new SubStepData(n));
    }

    public String getSectionsAsPlainText() {
        ArrayList section;
        String localizedDistribution = (String)this._lm.getFirstValue("Distribution");
        String localizedScope = (String)this._lm.getFirstValue("Scope");
        String localizedPolicy = (String)this._lm.getFirstValue("Policy");
        String localizedPreface = (String)this._lm.getFirstValue("Preface");
        String localizedPrior_Activity = (String)this._lm.getFirstValue("Prior Activity");
        String localizedResponsibility = (String)this._lm.getFirstValue("Responsibility");
        String[] sectionNames = new String[]{localizedScope, localizedPolicy};
        String s = "";
        for (int i = 0; i < sectionNames.length; ++i) {
            section = this.getSection(sectionNames[i]);
            if (section.size() <= 0) continue;
            s = s + "{SectionTitle}" + sectionNames[i] + "\n";
            for (Object o : section) {
                if (!(o instanceof SubStepData)) continue;
                s = s + ((SubStepData)o).getDocumentationFormat();
            }
        }
        ArrayList sortedByIndex = this.sortByIndex();
        for (Object sectionObj : sortedByIndex) {
            ArrayList section2 = (ArrayList)sectionObj;
            String name = (String)section2.get(0);
            if (name.equals(localizedDistribution) || name.equals(localizedScope) || name.equals(localizedPolicy) || name.equals(localizedPreface) || name.equals(localizedPrior_Activity)) continue;
            s = s + "{SectionTitle}" + name + "\n";
            if (((ArrayList)section2.get(1)).size() <= 0) continue;
            ArrayList sl = (ArrayList)section2.get(1);
            for (Object o : sl) {
                if (!(o instanceof SubStepData)) continue;
                s = s + ((SubStepData)o).getDocumentationFormat();
            }
        }
        section = this.getSection(localizedPreface);
        if (section.size() > 0) {
            s = s + "{SectionTitle}" + localizedPreface + "\n";
            for (Object o : section) {
                if (!(o instanceof SubStepData)) continue;
                s = s + ((SubStepData)o).getDocumentationFormat();
            }
        }
        return s;
    }

    public String toDocx(String guid) {
        String d;
        block6: {
            String g;
            block5: {
                d = "";
                g = guid;
                if (!this.getIsPlainText().booleanValue()) break block5;
                ArrayList section = this.getSection("std");
                if (section.size() <= 0) break block6;
                for (Object o : section) {
                    if (!(o instanceof SubStepData)) continue;
                    d = d + ((SubStepData)o).toDocx(g);
                }
                break block6;
            }
            ArrayList sortedIntroSections = this.sortByIndex();
            String localizedDistribution = (String)this._lm.getFirstValue("Distribution");
            String localizedScope = (String)this._lm.getFirstValue("Scope");
            String localizedPolicy = (String)this._lm.getFirstValue("Policy");
            String localizedPreface = (String)this._lm.getFirstValue("Preface");
            String localizedPrior_Activity = (String)this._lm.getFirstValue("Prior Activity");
            String localizedResponsibility = (String)this._lm.getFirstValue("Responsibility");
            String[] sectionNames = new String[]{localizedScope, localizedPolicy};
            for (int i = 0; i < sectionNames.length; ++i) {
                ArrayList section = this.getSection(sectionNames[i]);
                d = d + "\t<w:p w:rsidR=\"" + g + "\" w:rsidRDefault=\"" + g + "\">\n" + "\t\t<w:pPr>\n" + "\t\t    <w:pStyle w:val=\"SectionTitle\"/>\n" + "\t\t</w:pPr>\n" + "\t        <w:r>\n" + "\t\t   <w:t>" + sectionNames[i] + "              </w:t>\n" + "\t        </w:r>\n" + "\t </w:p>\n";
                for (Object o : section) {
                    if (!(o instanceof SubStepData)) continue;
                    d = d + ((SubStepData)o).toDocx(g);
                }
            }
            ArrayList sortedSections = this.sortByIndex();
            for (Object sectionObj : sortedSections) {
                ArrayList section = (ArrayList)sectionObj;
                String name = (String)section.get(0);
                if (name.equals(localizedDistribution) || name.equals(localizedScope) || name.equals(localizedPolicy) || name.equals(localizedPreface) || name.equals(localizedPrior_Activity)) continue;
                d = d + "   <w:p w:rsidR=\"" + g + "\" w:rsidRDefault=\"" + g + "\">\n" + "        <w:pPr>\n" + "            <w:pStyle w:val=\"SectionTitle\"/>\n" + "        </w:pPr>\n" + "        <w:r>\n" + "            <w:t>" + name + "</w:t>\n" + "        </w:r>\n" + "    </w:p>\n";
                if (((ArrayList)section.get(1)).size() <= 0) continue;
                ArrayList sl = (ArrayList)section.get(1);
                for (Object o : sl) {
                    if (!(o instanceof SubStepData)) continue;
                    d = d + ((SubStepData)o).toDocx(g);
                }
            }
        }
        return d;
    }

    private ArrayList sortByIndex() {
        ArrayList al = new ArrayList();
        int i = 0;
        while (i < this._sections.size()) {
            for (Object key : this._sections.keySet()) {
                String name = (String)key;
                ArrayList l = this.getSection((String)key);
                if (!l.get(0).equals(i)) continue;
                ArrayList<Object> section = new ArrayList<Object>();
                section.add(key);
                section.add(l);
                al.add(section);
                ++i;
            }
        }
        return al;
    }

    public String ActivityPrefacetoDocx(String guid) {
        String g = guid;
        String d = "";
        String localizedPreface = (String)this._lm.getFirstValue("Preface");
        ArrayList section = this.getSection(localizedPreface);
        if (section.size() > 0) {
            d = d + "   <w:p w:rsidR=\"" + g + "\" w:rsidRDefault=\"" + g + "\">\n" + "          <w:pPr>\n" + "                <w:pStyle w:val=\"SectionTitle\"/>\n" + "          </w:pPr>\n" + "          <w:r>\n" + "                <w:t>" + localizedPreface + "                </w:t>\n" + "          </w:r>\n" + "    </w:p>\n";
            for (Object o : section) {
                if (!(o instanceof SubStepData)) continue;
                d = d + ((SubStepData)o).toDocx(g);
            }
        }
        return d;
    }

    public void setIsPlainText(Boolean isPlainText) {
        this._isPlainText = isPlainText;
    }

    public Boolean getIsPlainText() {
        return this._isPlainText;
    }

    public void setFromPlainText(String plainText) {
        this._plainText = plainText;
        String[] lines = plainText.split("\n");
        int sectionNumber = 0;
        if (plainText.startsWith("{", 0)) {
            String currentSection = "";
            for (int i = 0; i < lines.length; ++i) {
                String styleName = "BodyText";
                String dataString = "";
                String[] ss = lines[i].split("}");
                if (ss.length > 1) {
                    styleName = ss[0].replaceFirst("\\{", "");
                    dataString = ss[1];
                }
                if (styleName.matches("SectionTitle")) {
                    sectionNumber = this.addSection(dataString, sectionNumber);
                    currentSection = dataString;
                    continue;
                }
                this.addIntroSectionListItem(currentSection, styleName, dataString);
            }
        } else {
            this.setIsPlainText(true);
            sectionNumber = this.addSection("std", sectionNumber);
            String currentSection = "std";
            for (int i = 0; i < lines.length; ++i) {
                String styleName = "BodyText";
                String dataString = lines[i];
                this.addIntroSectionListItem(currentSection, styleName, dataString);
            }
        }
    }

    public String getPlainText() {
        return this._plainText;
    }
}

