/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.DocxGUID;
import oracle.tutor.docx.IntroSection;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.Task;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.docx.Utils;
import oracle.tutor.docx.Word_File;

public class DocxDocument
extends Word_File {
    private HashMap _dataObject;
    private String _guid;
    private TutorDoc _doc;
    private Logger _logger;

    public DocxDocument(HashMap hm, Logger logger) {
        this._dataObject = hm;
        Object go = hm.get("guid");
        this._guid = ((DocxGUID)go).getGuid();
        Object doc = hm.get("tutorDoc");
        this._doc = (TutorDoc)doc;
        this._logger = logger;
    }

    public void setData() {
    }

    @Override
    public String toDocx() {
        String d = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><w:document xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\">\n <w:body>\n";
        d = d + this.makeDoc();
        d = d + "</w:body></w:document>";
        return d;
    }

    private String makeDoc() {
        String content = this.makeConversionNotes();
        content = content + "\n" + this.makeTitleSection();
        content = content + "\n" + this.makeIntroSection();
        content = content + "\n" + this.makeDistributionSection();
        content = content + "\n" + this.makeOwnershipSegment();
        content = content + "\n" + this.makeActivityPreface();
        content = content + "\n" + this.makePriorActivitiesSegment();
        content = content + "\n" + this.makeTaskSegment();
        return content;
    }

    private String makeConversionNotes() {
        String p = "<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\" ><w:pPr><w:pStyle w:val=\"BoxText\"/>\n" + "\t\t\t\t<w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"FFFF00\"/>\n" + "\t\t\t\t<w:jc w:val=\"center\"/></w:pPr><w:r><w:t>This document is formatted for Tutor Author, an Oracle product designed for editing and deploying end-user procedure documentation.  Contact your Oracle Account Manager for more information about Tutor, or download and install a trial of Oracle Tutor at http://edelivery.oracle.com. </w:t></w:r></w:p>";
        p = p + "<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\" ><w:pPr><w:pStyle w:val=\"BoxText\"/>\n" + "\t\t\t\t<w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"FFFF00\"/>\n" + "\t\t\t\t<w:jc w:val=\"center\"/></w:pPr></w:p>";
        if (this._doc.getMsgList().size() > 0) {
            p = p + "<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\" ><w:pPr><w:pStyle w:val=\"BoxText\"/>\n" + "\t\t\t\t<w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"FFFF00\"/>\n" + "\t\t\t\t<w:jc w:val=\"center\"/></w:pPr><w:r><w:t>Conversion Notes</w:t></w:r></w:p>";
            for (ConversionMessage msg : this._doc.getMsgList()) {
                p = p + "<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "\t<w:pPr><w:pStyle w:val=\"BoxText\"/>\n" + "                         <w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"FFFF00\"/>\n" + "\t</w:pPr>\n" + "\t<w:r>\n" + "\t\t<w:t>" + Utils.formatEntityNotation(msg.getMessage());
                String mID = msg.getObjectID();
                if (!this.getTaskNumberFromSrcID(mID).equals("")) {
                    p = p + " (task #" + this.getTaskNumberFromSrcID(msg.getObjectID()) + ")";
                }
                p = p + "</w:t></w:r></w:p>";
            }
            p = p + "<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "    <w:pPr><w:pStyle w:val=\"BoxText\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"FFFF00\"/><w:jc w:val=\"center\"/></w:pPr>" + "         <w:r><w:rPr>\n" + "\t\t\t<w:i/><w:iCs/>\n" + "\t  </w:rPr><w:t>Delete this block after verifying conversion.</w:t></w:r></w:p>";
        }
        return p;
    }

    private String getTaskNumberFromSrcID(String srcID) {
        String taskID = "";
        for (Object step : this._doc.getSteps()) {
            Task t;
            if (!(step instanceof Task) || (t = (Task)step).getSourceId() == null || !t.getSourceId().equals(srcID)) continue;
            taskID = Integer.toString(t.getTaskNumber());
            break;
        }
        return taskID;
    }

    private String makeIntroSection() {
        this._logger.fine("Publishing IntroSection");
        String p = "";
        IntroSection is = this._doc.getIntroSection();
        p = is.toDocx(this._guid);
        return p;
    }

    private String makeActivityPreface() {
        String p = "";
        IntroSection is = this._doc.getIntroSection();
        p = is.ActivityPrefacetoDocx(this._guid);
        return p;
    }

    private String makeDistributionSection() {
        this._logger.fine("Publishing Distribution Section");
        String p = "\t<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"SectionTitle\"/>\n" + "\t\t\t</w:pPr>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:t>Distribution</w:t>\n" + "\t\t\t</w:r>\n" + "\t</w:p>";
        for (Object o : this._doc.getMDistributionList()) {
            if ((String)o == null || (String)o == "") continue;
            p = p + "\t<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"BodyText\"/>\n" + "\t\t\t</w:pPr>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:t>" + Utils.formatEntityNotation(((String)o).trim()) + "</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:vertAlign w:val=\"superscript\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t>*</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t</w:p>";
        }
        return p;
    }

    private String makeTitleSection() {
        this._logger.fine("Publishing Title Section");
        String p = " <w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"PageTitle\"/>\n" + "\t\t\t</w:pPr>\n" + "\t\t\t<w:fldSimple w:instr=\" TITLE  \\* MERGEFORMAT \">\n" + "\t\t\t\t<w:r>\n" + "\t\t\t\t\t<w:t>" + Utils.formatEntityNotation(this._doc.getName()) + "</w:t>\n" + "\t\t\t\t</w:r>\n" + "\t\t\t</w:fldSimple>\n" + "\t\t</w:p>\n";
        return p;
    }

    private String makeOwnershipSegment() {
        this._logger.fine("Publishing Ownership Section");
        String p = "\t\t<w:p w:rsidR=\"" + this._guid + "\" w:rsidRDefault=\"" + this._guid + "\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"SectionTitle\"/>\n" + "\t\t\t</w:pPr>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:t>Ownership</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t</w:p>\n" + "\t\t<w:p w:rsidR=\"00F9256B\" w:rsidRDefault=\"00F9256B\">\n" + "\t\t\t<w:pPr>\n" + "\t\t\t\t<w:pStyle w:val=\"BodyText\"/>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t</w:pPr>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(this._doc.getOwner().getRole().getTitle()) + "</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t\t<w:u w:val=\"single\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t>[list@YourCompany.com?Subject=</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t\t<w:fldSimple w:instr=\" TITLE  \\* MERGEFORMAT \">\n" + "\t\t\t\t<w:r>\n" + "\t\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t\t\t<w:u w:val=\"single\"/>\n" + "\t\t\t\t\t</w:rPr>\n" + "\t\t\t\t\t<w:t>" + Utils.formatEntityNotation(this._doc.getName()) + "</w:t>\n" + "\t\t\t\t</w:r>\n" + "\t\t\t</w:fldSimple>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t\t<w:u w:val=\"single\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t xml:space=\"preserve\">: </w:t>\n" + "\t\t\t</w:r>\n" + "\t\t\t<w:fldSimple w:instr=\" FILENAME  \\* MERGEFORMAT \">\n" + "\t\t\t\t<w:r>\n" + "\t\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t\t\t<w:noProof/>\n" + "\t\t\t\t\t\t<w:u w:val=\"single\"/>\n" + "\t\t\t\t\t</w:rPr>\n" + "\t\t\t\t\t<w:t>" + Utils.formatEntityNotation(this._doc.getDocFileName()) + ".docx</w:t>\n" + "\t\t\t\t</w:r>\n" + "\t\t\t</w:fldSimple>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t\t<w:u w:val=\"single\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t>]</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t\t<w:r>\n" + "\t\t\t\t<w:rPr>\n" + "\t\t\t\t\t<w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t\t\t\t</w:rPr>\n" + "\t\t\t\t<w:t xml:space=\"preserve\"> is responsible for ensuring that this document is necessary, reflects actual practice, and supports corporate policy.</w:t>\n" + "\t\t\t</w:r>\n" + "\t\t</w:p>";
        return p;
    }

    private String makePriorActivitiesSegment() {
        this._logger.fine("Publishing Prior Activities Section");
        String pa = "";
        pa = pa + this._doc.getPriorActivity().toDocx(this._guid);
        return pa;
    }

    private String makeTaskSegment() {
        if (this._doc.getSteps().size() > 0) {
            this._logger.fine("Publishing Task Section");
            int taskNumber = 1;
            ArrayList mActorList = this._doc.getMActorList();
            String taskSegment = ((Actor)mActorList.get(0)).toDocx(this._guid);
            String currentActorTitle = ((Actor)mActorList.get(0)).getTitle();
            int stepNum = 0;
            int stepSize = this._doc.getSteps().size();
            for (Object o : this._doc.getSteps()) {
                ++stepNum;
                if ((Step)o instanceof Task) {
                    if (stepNum < stepSize) {
                        taskSegment = taskSegment + ((Task)o).actorsToDocx(currentActorTitle, this._guid);
                        currentActorTitle = ((Actor)((Task)o).getActors().get(0)).getTitle();
                    }
                    taskSegment = taskSegment + ((Task)o).toDocx(taskNumber++, this._guid);
                    this._logger.fine("Creating Task:\n" + ((Task)o).toDocx(taskNumber, this._guid) + "\n");
                    continue;
                }
                if (!((Step)o instanceof Directive)) continue;
                if (stepNum < stepSize) {
                    taskSegment = taskSegment + ((Directive)o).actorsToDocx(currentActorTitle, this._guid);
                    if (((Directive)o).getActors().size() > 0) {
                        currentActorTitle = ((Actor)((Directive)o).getActors().get(0)).getTitle();
                    }
                }
                taskSegment = taskSegment + ((Directive)o).toDocx(this._guid);
                this._logger.fine("Creating Directive:\n" + ((Directive)o).getDirectiveString() + "\n");
            }
            return taskSegment;
        }
        return "";
    }
}

