/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Condition;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.Utils;
import org.w3c.dom.Node;

public class Directive
extends Step {
    private String _directiveString;
    private LanguageMap _languageMap;
    private ArrayList _conditions;
    private String _otherwiseClause = "";
    private int _otherwisePosition = -1;
    private String _leadAndFollowup = "";
    private int _hasFollowupPosition = -1;
    private boolean _parallel = false;
    private boolean _flowsHandled = false;
    private static final String STARTPARALLELDIRECTIVE = "In parallel: ";
    private static Logger _logger = Logger.getLogger("oracle.tutor.docx");

    public Directive(LanguageMap map, String directiveString) {
        this._languageMap = map;
        this._conditions = new ArrayList();
        this.prevSteps = new LinkedList();
        this.followingSteps = new LinkedList();
        this._directiveString = directiveString;
        this.parse4Conditions(this._directiveString);
    }

    public Directive(LanguageMap map) {
        this._languageMap = map;
        this._conditions = new ArrayList();
        this.prevSteps = new LinkedList();
        this.followingSteps = new LinkedList();
    }

    public void setBpdNode(FlowObject node, boolean handleSubStepData) {
        block14: {
            block15: {
                super.setBpdNode(node);
                if (!handleSubStepData) break block14;
                if (!(node instanceof Gateway)) break block15;
                Gateway g = (Gateway)node;
                int numFlows = 0;
                if (g.getOutflows() != null) {
                    numFlows = g.getOutflows().size();
                }
                if (numFlows <= 0) break block14;
                int flowCounter = 0;
                for (ConnectingObject q : g.getOutflows()) {
                    if (q.getDocumentation() != "" && q.getDocumentation() != null) {
                        int i;
                        String ssData = q.getDocumentation();
                        String[] lines = ssData.split("\\n");
                        String regEx1 = "}";
                        Pattern targStr = Pattern.compile(regEx1);
                        Matcher tm = targStr.matcher(ssData);
                        Boolean matched = false;
                        while (tm.find()) {
                            matched = true;
                        }
                        if (matched.booleanValue()) {
                            for (i = 0; i < lines.length; ++i) {
                                String[] line = lines[i].split("}");
                                String style = line[0];
                                style = style.substring(1, style.length());
                                String ds = line[1];
                                ((Condition)this._conditions.get(flowCounter)).addSubStepDataFromString(style, ds);
                            }
                        } else {
                            for (i = 0; i < lines.length; ++i) {
                                if (lines[i].equals("")) continue;
                                ((Condition)this._conditions.get(flowCounter)).addSubStepDataFromString("Note1", lines[i]);
                            }
                        }
                    }
                    ++flowCounter;
                }
                break block14;
            }
            if (node instanceof Subprocess && node.getDocumentation() != "" && node.getDocumentation() != null) {
                String ssData = node.getDocumentation();
                String[] lines = ssData.split("\\n");
                String regEx1 = "}";
                Pattern targStr = Pattern.compile(regEx1);
                Matcher tm = targStr.matcher(ssData);
                Boolean matched = false;
                while (tm.find()) {
                    matched = true;
                }
                if (matched.booleanValue()) {
                    for (int i = 0; i < lines.length; ++i) {
                        String[] line = lines[i].split("}");
                        String style = line[0];
                        style = style.substring(1, style.length());
                        String ds = line[1];
                        ((Condition)this._conditions.get(1)).addSubStepDataFromString(style, ds);
                    }
                } else {
                    for (int i = 0; i < lines.length; ++i) {
                        ((Condition)this._conditions.get(1)).addSubStepDataFromString("Note1", lines[i]);
                    }
                }
            }
        }
    }

    public void setDirectiveString(String directiveString) {
        this._directiveString = directiveString;
    }

    public String getDirectiveString() {
        return this._directiveString;
    }

    private Boolean test4ActionString(String directive) {
        Boolean hasCondition = false;
        if (this.isSimpleEndOfActivity(directive).booleanValue()) {
            hasCondition = true;
        } else if (this.isConditional(directive).booleanValue()) {
            if (this.isOtherwise(directive).booleanValue()) {
                this.handleOtherwiseDirective(directive);
            } else if (this.isActionType("Goto", directive).booleanValue()) {
                hasCondition = true;
            } else if (this.isActionType("Return to", directive).booleanValue()) {
                hasCondition = true;
            } else if (this.isActionType("Stop and complete", directive).booleanValue()) {
                hasCondition = true;
            } else if (this.isActionType("End of activity", directive).booleanValue()) {
                hasCondition = true;
            }
        } else if (this.isGoto(directive).booleanValue()) {
            hasCondition = true;
        } else if (this.isStopAndComplete(directive).booleanValue()) {
            hasCondition = true;
        }
        return hasCondition;
    }

    private void parse4Conditions(String directive) {
        if (this.isSimpleEndOfActivity(directive).booleanValue()) {
            this._conditions.add(new Condition(null, false, ActionEnum.Type.END_OF_ACTIVITY, null));
        } else if (this.isParallelDirective(directive).booleanValue()) {
            this.handleParallelDirective(directive);
        } else if (this.isConditional(directive).booleanValue()) {
            if (this.isOtherwise(directive).booleanValue()) {
                this.handleOtherwiseDirective(directive);
            } else if (this.isActionType("End of activity", directive).booleanValue()) {
                for (Condition o : this.handleEndDirective(directive)) {
                    this._conditions.add(o);
                }
            } else if (this.isActionType("Goto", directive).booleanValue()) {
                this._conditions.add(this.handleGoToDirective(directive));
            } else if (this.isActionType("Return to", directive).booleanValue()) {
                this._conditions.add(this.handleReturnToDirective(directive));
            } else if (this.isActionType("Stop and complete", directive).booleanValue()) {
                this._conditions.add(this.handleStopDirective(directive));
            }
        } else if (this.isGoto(directive).booleanValue()) {
            String[] gtTest = this.getGotoSections(directive);
            this._conditions.add(new Condition(null, false, ActionEnum.Type.GOTO, gtTest[1]));
        } else if (this.isStopAndComplete(directive).booleanValue()) {
            String[] stTest = this.getStopSections(directive);
            this._conditions.add(new Condition(null, false, ActionEnum.Type.STOP_AND_COMPLETE, stTest[1]));
        } else {
            _logger.severe("Unknown Directive!!! " + directive);
        }
    }

    private String[] getOtherwiseSections(String directive) {
        Boolean matched = false;
        String[] segments = new String[]{"", ""};
        ArrayList tn2 = this._languageMap.getLocalizedValues("Otherwise");
        for (Object value : tn2.subList(0, tn2.size())) {
            Pattern owp = Pattern.compile((String)value);
            Matcher m = owp.matcher(directive);
            while (m.find()) {
                matched = true;
                segments[0] = directive.substring(0, m.start());
                String part2 = directive.substring(m.end(), directive.length());
                segments[1] = part2 = part2.replaceFirst(",", "").trim();
            }
        }
        if (!matched.booleanValue()) {
            segments[0] = directive;
        }
        return segments;
    }

    private String[] getGotoSections(String directiveSegment) {
        String[] segments = new String[]{"", ""};
        ArrayList gtList = this._languageMap.getLocalizedValues("Goto");
        for (Object value : gtList.subList(0, gtList.size())) {
            String[] sections;
            Pattern targStr = Pattern.compile((String)value, 2);
            Matcher tm = targStr.matcher(directiveSegment);
            String target = "";
            int targStart = 0;
            int targEnd = 0;
            Boolean tmatched = false;
            while (tm.find()) {
                tmatched = true;
                targStart = tm.start();
                targEnd = tm.end();
            }
            if (tmatched.booleanValue() && (target = directiveSegment.substring(targEnd, directiveSegment.length())).length() == 0) {
                target = directiveSegment.substring(0, targEnd);
            }
            if ((sections = new String[]{(String)value, target}).length <= 1) continue;
            if (this._languageMap.getGrammarType() == 0) {
                segments[0] = sections[0];
                segments[1] = sections[1].trim();
                break;
            }
            segments[0] = sections[1].trim();
            segments[1] = sections[0].trim();
            break;
        }
        return segments;
    }

    private String[] getStopSections(String directive) {
        String[] segments = new String[]{"", ""};
        ArrayList stopList = this._languageMap.getLocalizedValues("Stop and complete");
        for (Object value : stopList) {
            if (this._languageMap.getGrammarType() != 0) continue;
            Boolean matched = false;
            int start = 0;
            int end = 0;
            Pattern stopP = Pattern.compile((String)value, 2);
            Matcher m = stopP.matcher(directive);
            while (m.find()) {
                start = m.start();
                end = m.end();
                matched = true;
            }
            if (!matched.booleanValue()) continue;
            segments[0] = directive.substring(0, end);
            segments[1] = directive.substring(end + 1, directive.length());
            break;
        }
        return segments;
    }

    private Boolean isEndOfActivity(String directive) {
        return this.checkForMatch("End of activity", directive);
    }

    private Boolean isSimpleEndOfActivity(String directive) {
        Boolean end = false;
        ArrayList list = this._languageMap.getLocalizedValues("End of activity");
        for (Object value : list.subList(0, list.size())) {
            String val = ((String)value).trim();
            String tmp = directive.replaceAll("\\.", "").trim();
            end = tmp.equalsIgnoreCase(val);
            if (!end.booleanValue()) continue;
            break;
        }
        return end;
    }

    private Boolean isParallelDirective(String directive) {
        boolean par = false;
        ArrayList list = this._languageMap.getLocalizedValues("In parallel:");
        for (Object value : list.subList(0, list.size())) {
            if (!directive.contains((String)value)) continue;
            par = true;
            break;
        }
        return par;
    }

    private Boolean isActionType(String actionType, String directive) {
        return this.checkForMatch(actionType, directive);
    }

    public Boolean isConditional(String directive) {
        return this.checkForMatch("If", directive);
    }

    private Boolean isGoto(String directive) {
        return this.checkForMatch("Goto", directive);
    }

    private Boolean isOtherwise(String directive) {
        return this.checkForMatch("Otherwise", directive);
    }

    private Boolean isCompoundEndDirective(String directive) {
        Boolean isEnd = this.isActionType("End of activity", directive);
        Boolean hasFollowup = this.isGoto(directive) != false || this.isStopAndComplete(directive) != false;
        Boolean compound = isEnd != false && hasFollowup != false;
        return compound;
    }

    private Boolean isReturnTo(String directive) {
        return this.checkForMatch("Return to", directive);
    }

    private Boolean isStopAndComplete(String directive) {
        return this.checkForMatch("Stop and complete", directive);
    }

    private Boolean isTaskDirective(String directive) {
        return this.checkForMatch("Task #", directive);
    }

    private ActionEnum.Type getActionType(String clause) {
        ActionEnum.Type myType = ActionEnum.Type.GOTO;
        String[] types = new String[]{"Goto", "Stop and complete", "End of activity", "Return to"};
        for (int i = 0; i < types.length; ++i) {
            ArrayList aList = this._languageMap.getLocalizedValues(types[i]);
            for (Object value : aList.subList(0, aList.size())) {
                Pattern owp = Pattern.compile((String)value, 2);
                Matcher m = owp.matcher(clause);
                if (!m.find()) continue;
                myType = ActionEnum.getType(types[i]);
            }
        }
        return myType;
    }

    private String getTestString(String type, String directive) {
        String c = "";
        boolean matched = false;
        Pattern p = Pattern.compile((String)this._languageMap.getFirstValue("If"));
        Matcher m = p.matcher(directive);
        int start = 0;
        int end = 0;
        while (m.find()) {
            matched = true;
            start = m.start();
            end = m.end();
        }
        if (matched) {
            String ats = this.getActionTypeString(type, directive);
            Boolean actionMatched = false;
            Pattern ap = Pattern.compile(ats, 2);
            Matcher am = ap.matcher(directive);
            while (am.find()) {
                actionMatched = true;
                if (this._languageMap.getGrammarType() == 0) {
                    c = directive.substring(end, am.start()).trim();
                    if (!c.endsWith(",")) continue;
                    c = c.substring(0, c.length() - 1);
                    continue;
                }
                c = directive.substring(0, end);
            }
        } else {
            c = null;
        }
        return c;
    }

    private String getTargetString(String type, String directive) {
        String t = "";
        boolean matched = false;
        Pattern typeStr = Pattern.compile(type, 2);
        Matcher m = typeStr.matcher(directive);
        int typeStart = 0;
        int typeEnd = 0;
        ArrayList<MatchResult> matchList = new ArrayList<MatchResult>();
        while (m.find()) {
            matched = true;
            matchList.add(m.toMatchResult());
            typeStart = m.start();
            typeEnd = m.end();
            if (directive.length() <= typeEnd + 1) continue;
            if (this._languageMap.getGrammarType() == 0) {
                t = directive.substring(typeEnd + 1, directive.length());
                continue;
            }
            if (!matched) continue;
            MatchResult mr = (MatchResult)matchList.get(matchList.size() - 1);
            typeStart = mr.start();
            typeEnd = mr.end();
            String testAndTarget = directive.substring(0, typeStart);
            boolean tmatched = false;
            if (!this.checkForMatch("Task #", testAndTarget)) continue;
            ArrayList taskVals = this._languageMap.getLocalizedValues("Task #");
            for (Object value : taskVals.subList(0, taskVals.size())) {
                String regEx = (String)value + "[0-9]*";
                Pattern targStr = Pattern.compile(regEx, 2);
                Matcher tm = targStr.matcher(testAndTarget);
                int targStart = 0;
                int targEnd = 0;
                while (tm.find()) {
                    tmatched = true;
                    targStart = tm.start();
                    targEnd = tm.end();
                }
                if (tmatched) {
                    String target = testAndTarget.substring(targStart, targEnd);
                    if (target.length() == 0) {
                        target = testAndTarget.substring(0, targEnd);
                    }
                    t = target;
                    continue;
                }
                t = testAndTarget.substring(0, typeStart);
            }
        }
        if (!matched) {
            // empty if block
        }
        return t.trim();
    }

    private boolean checkForMatch(String langItem, String directiveText) {
        boolean matched = false;
        ArrayList list = this._languageMap.getLocalizedValues(langItem);
        for (Object value : list.subList(0, list.size())) {
            Pattern owp = Pattern.compile("\\b" + (String)value + "\\b", 2);
            Matcher m = owp.matcher(directiveText);
            if (!m.find()) continue;
            matched = true;
        }
        return matched;
    }

    private String getActionTypeString(String actionTypeString, String directive) {
        String actionString = "";
        ArrayList ats = this._languageMap.getLocalizedValues(actionTypeString);
        boolean matched = false;
        for (Object value : ats.subList(0, ats.size())) {
            Pattern owp = Pattern.compile((String)value, 2);
            Matcher m = owp.matcher(directive);
            while (m.find()) {
                matched = true;
            }
            if (!matched) continue;
            actionString = (String)value;
        }
        return actionString;
    }

    private void handleParallelDirective(String directive) {
        this.setParallel(true);
        this.setDirectiveString(directive);
        ArrayList list = this._languageMap.getLocalizedValues("In parallel:");
        String gotosString = "";
        for (Object value : list.subList(0, list.size())) {
            Pattern owp = Pattern.compile("\\b" + (String)value, 2);
            Matcher m = owp.matcher(directive);
            if (!m.find()) continue;
            gotosString = directive.substring(m.end(), directive.length()).trim();
        }
        String[] gotos = gotosString.split(",");
        for (int i = 0; i < gotos.length; ++i) {
            String[] ampSplit;
            String[] andSplit = gotos[i].trim().split(" and ");
            if (andSplit.length > 1) {
                for (int j = 0; j < andSplit.length; ++j) {
                    this.addCondition(this.handleGoToDirective(andSplit[j].trim()));
                }
            }
            if ((ampSplit = gotos[i].trim().split("&")).length > 1) {
                for (int j = 0; j < ampSplit.length; ++j) {
                    this.addCondition(this.handleGoToDirective(ampSplit[j].trim()));
                }
                continue;
            }
            this.addCondition(this.handleGoToDirective(gotos[i].trim()));
        }
    }

    private void handleOtherwiseDirective(String directive) {
        String[] otherwiseTest = this.getOtherwiseSections(directive);
        String clause = otherwiseTest[0].trim();
        if (this.isActionType("End of activity", clause).booleanValue()) {
            for (Condition o : this.handleEndDirective(clause)) {
                this._conditions.add(o);
            }
        } else if (this.isActionType("Goto", clause).booleanValue()) {
            this._conditions.add(this.handleGoToDirective(clause));
        } else if (this.isActionType("Return to", clause).booleanValue()) {
            this._conditions.add(this.handleReturnToDirective(clause));
        } else if (this.isActionType("Stop and complete", clause).booleanValue()) {
            this._conditions.add(this.handleStopDirective(clause));
        }
        String owClause = otherwiseTest[1].trim();
        ActionEnum.Type type = this.getActionType(owClause);
        String typeString = ActionEnum.getTypeString(type);
        String ts = this.getTargetString(typeString, owClause);
        Boolean hasSubCondition = this.test4ActionString(ts);
        if (hasSubCondition.booleanValue()) {
            this._conditions.add(new Condition(null, true, type, null));
            this.parse4Conditions(ts);
        } else {
            this._conditions.add(new Condition(null, true, type, ts));
        }
    }

    private ArrayList<Condition> handleEndDirective(String directive) {
        boolean hasFollowupStop;
        ArrayList<Condition> cList = new ArrayList<Condition>();
        String test = this.getTestString("End of activity", directive);
        Condition c = new Condition(test, false, ActionEnum.Type.END_OF_ACTIVITY, null);
        cList.add(c);
        boolean hasFollowupGoto = this.checkForMatch("Goto", directive);
        if (hasFollowupGoto) {
            c.setHasFollowup(true);
            String match = "";
            String gotoDirective = "";
            int gotoStartPosition = 0;
            ArrayList list = this._languageMap.getLocalizedValues("Goto");
            for (Object value : list.subList(0, list.size())) {
                Pattern owp = Pattern.compile("\\b" + (String)value + "\\b", 2);
                Matcher m = owp.matcher(directive);
                if (!m.find()) continue;
                match = ((String)value).toLowerCase();
                gotoStartPosition = m.end();
            }
            gotoDirective = directive.substring(gotoStartPosition, directive.length());
            Condition anotherC = new Condition("", false, ActionEnum.Type.GOTO, gotoDirective);
            anotherC.setIsFollowup(true);
            cList.add(anotherC);
        }
        if (hasFollowupStop = this.checkForMatch("Stop and complete", directive)) {
            c.setHasFollowup(true);
            String match = "";
            String gotoDirective = "";
            int gotoStartPosition = 0;
            ArrayList list = this._languageMap.getLocalizedValues("Stop and complete");
            for (Object value : list.subList(0, list.size())) {
                Pattern owp = Pattern.compile("\\b" + (String)value + "\\b", 2);
                Matcher m = owp.matcher(directive);
                if (!m.find()) continue;
                match = ((String)value).toLowerCase();
                gotoStartPosition = m.start();
            }
            gotoDirective = directive.substring(gotoStartPosition, directive.length() - 1);
            Condition anotherC = new Condition("", false, ActionEnum.Type.STOP_AND_COMPLETE, gotoDirective.replaceFirst(match, ""));
            anotherC.setIsFollowup(true);
            cList.add(anotherC);
        }
        return cList;
    }

    private Condition handleGoToDirective(String directive) {
        ActionEnum.Type type = this.getActionType(directive);
        String typeString = ActionEnum.getTypeString(type);
        Condition c = new Condition(this.getTestString("Goto", directive), false, ActionEnum.Type.GOTO, this.getTargetString(typeString, directive));
        return c;
    }

    private Condition handleReturnToDirective(String directive) {
        ActionEnum.Type type = this.getActionType(directive);
        String typeString = ActionEnum.getTypeString(type);
        Condition c = new Condition(this.getTestString("Return To", directive), false, ActionEnum.Type.RETURN_TO, this.getTargetString(typeString, directive));
        return c;
    }

    private Condition handleStopDirective(String directive) {
        ActionEnum.Type type = this.getActionType(directive);
        String typeString = ActionEnum.getTypeString(type);
        Condition c = new Condition(this.getTestString("Stop and complete", directive), false, ActionEnum.Type.STOP_AND_COMPLETE, this.getTargetString(typeString, directive));
        return c;
    }

    public ArrayList getConditions() {
        return this._conditions;
    }

    public void addStackedCondition(String directive) {
        this.parse4Conditions(directive);
    }

    public void addCondition(int index, Condition c) {
        this._conditions.add(index, c);
    }

    public void addCondition(Condition c) {
        this._conditions.add(c);
    }

    public String actorsToDocx(String currentActor, String guid) {
        String d = "";
        String names = "";
        if (this.getActors().size() == 0) {
            return d;
        }
        int count = 0;
        for (Object o : this.getActors()) {
            if (++count > 1 && count < this.getActors().size()) {
                names = names + ", ";
            }
            names = names + ((Actor)o).getTitle();
        }
        if (!names.matches(currentActor)) {
            d = "   <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "                 <w:pPr>\n" + "                         <w:pStyle w:val=\"Actor\"/>\n" + "                         <w:rPr>\n" + "                                 <w:rFonts w:cs=\"Times New Roman\"/>\n" + "                         </w:rPr>\n" + "                 </w:pPr>\n" + "                 <w:bookmarkStart w:id=\"1\" w:name=\"A0002\"/>\n" + "                 <w:bookmarkEnd w:id=\"1\"/>\n" + "                 <w:r>\n" + "                         <w:rPr>\n" + "                                 <w:rFonts w:cs=\"Times New Roman\"/>\n" + "                         </w:rPr>\n" + "                         <w:t>" + Utils.formatEntityNotation(names) + "</w:t>\n" + "                 </w:r>\n" + "     </w:p>";
        }
        return d;
    }

    protected void addSubStepData(Node node) throws XPathExpressionException {
        if (this._conditions.size() != 0) {
            Condition c = (Condition)this._conditions.get(this._conditions.size() - 1);
            c.addSubStepData(node);
        }
    }

    protected void addSubStepDataFromString(String styleName, String data) {
        if (this._conditions.size() != 0) {
            Condition c = (Condition)this._conditions.get(this._conditions.size() - 1);
            c.addSubStepDataFromString(styleName, data);
        }
    }

    public String toDocx(String guid) {
        String d = "";
        Boolean containsOtherwise = false;
        for (int i = 0; i < this._conditions.toArray().length; ++i) {
            Condition c = (Condition)this._conditions.toArray()[i];
            if (!c.getIsOtherwise()) continue;
            containsOtherwise = true;
            this._otherwisePosition = i;
            this._otherwiseClause = c.toDocx(this._languageMap, guid);
            break;
        }
        Boolean containsFollowup = false;
        for (int i = 0; i < this._conditions.toArray().length; ++i) {
            Condition c = (Condition)this._conditions.toArray()[i];
            if (!c.getHasFollowup()) continue;
            containsFollowup = true;
            this._hasFollowupPosition = i;
            this._leadAndFollowup = c.toDocx(this._languageMap, guid);
            if (i + 1 >= this.getConditions().size()) continue;
            String followupStr = "";
            this._leadAndFollowup = this._leadAndFollowup + " " + ((Condition)this._conditions.toArray()[i + 1]).toDocx(this._languageMap, guid);
        }
        if (this._conditions.size() == 1 || this._conditions.size() == 2 && containsOtherwise.booleanValue() && !containsFollowup.booleanValue() && !this._parallel) {
            d = d + "\t<w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "\t\t<w:pPr>\n" + "\t\t\t<w:pStyle w:val=\"Directive\"/>\n" + "\t\t</w:pPr>\n";
            for (Object o : this._conditions) {
                Condition c = (Condition)o;
                d = d + c.toDocx(this._languageMap, guid);
            }
            d = d + "\n\t</w:p>\n";
            for (Condition c : this._conditions) {
                d = d + c.subSteps_toDocx();
            }
        } else if (this._conditions.size() >= 2 && !this.isParallel() && this._hasFollowupPosition > -1) {
            d = d + this.formatFollowupDirective(guid, containsOtherwise);
            d = d + "\n";
        } else if (this._conditions.size() >= 2 && !this.isParallel()) {
            d = d + this.formatMultipleDirective(guid, containsOtherwise);
            d = d + "\n";
        } else if (this._conditions.size() >= 2 && this.isParallel()) {
            d = d + "     <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "             <w:pPr>\n" + "                     <w:pStyle w:val=\"Directive\"/>\n" + "             </w:pPr>\n";
            d = this.formatParallelDirective(guid);
            d = d + "\n \n";
        }
        return d;
    }

    protected String formatFollowupDirective(String guid, boolean containsOtherwise) {
        String d = "";
        Object[] cList = this._conditions.toArray();
        if (containsOtherwise) {
            if (this._otherwisePosition == this._hasFollowupPosition) {
                for (int i = 0; i < cList.length; ++i) {
                    d = i == this._otherwisePosition ? d + this.wrapAsParagraph(this._leadAndFollowup, guid) : d + this.wrapAsParagraph(((Condition)cList[i]).toDocx(this._languageMap, guid), guid);
                    d = d + ((Condition)cList[i]).subSteps_toDocx();
                }
            } else {
                for (int i = 0; i < cList.length; ++i) {
                    if (i == this._hasFollowupPosition) {
                        d = d + this.wrapAsParagraph(this._leadAndFollowup, guid);
                        ++i;
                    } else {
                        d = d + this.wrapAsParagraph(((Condition)cList[i]).toDocx(this._languageMap, guid), guid);
                    }
                    if (i >= cList.length) continue;
                    d = d + ((Condition)cList[i]).subSteps_toDocx();
                }
            }
        } else {
            for (int i = 0; i < cList.length; ++i) {
                if (i == this._hasFollowupPosition) {
                    d = d + this.wrapAsParagraph(this._leadAndFollowup, guid);
                    ++i;
                } else {
                    d = d + this.wrapAsParagraph(((Condition)cList[i]).toDocx(this._languageMap, guid), guid);
                }
                if (i >= cList.length) continue;
                d = d + ((Condition)cList[i]).subSteps_toDocx();
            }
        }
        return d;
    }

    protected String formatMultipleDirective(String guid, boolean containsOtherwise) {
        String d = "";
        int conditionCounter = 0;
        for (Object o : this._conditions) {
            String conditionString = "";
            Condition c = (Condition)o;
            if (!containsOtherwise || ++conditionCounter < this._conditions.size() - 1) {
                conditionString = c.toDocx(this._languageMap, guid);
            } else if (conditionCounter == this._conditions.size() - 1) {
                conditionString = c.toDocx(this._languageMap, guid) + this._otherwiseClause;
            }
            if (!c.getIsOtherwise() && conditionCounter <= this._conditions.size()) {
                d = d + "      <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "           <w:pPr>\n" + "                   <w:pStyle w:val=\"Directive\"/>\n" + "           </w:pPr>\n";
                d = d + conditionString + "   </w:p>\n";
                d = d + c.subSteps_toDocx();
                continue;
            }
            if (!c.getIsOtherwise() || conditionCounter != this._conditions.size()) continue;
            d = d + c.subSteps_toDocx();
        }
        return d;
    }

    protected String formatParallelDirective(String guid) {
        String d = "";
        String conditionString = STARTPARALLELDIRECTIVE;
        int conditionCounter = 0;
        for (Object o : this._conditions) {
            ++conditionCounter;
            Condition c = (Condition)o;
            if (c.getAction().getType().equals((Object)ActionEnum.Type.END_OF_ACTIVITY)) continue;
            String taskToken = (String)this._languageMap.getFirstValue("Task #");
            String actype = c.getAction().getActionTypeString();
            int taskNumber = c.getAction().getTaskNumber();
            if (c.getAction().getType() != ActionEnum.Type.GOTO || taskNumber <= 0) continue;
            conditionString = conditionString + actype + " " + taskToken + "" + taskNumber;
            if (conditionCounter < this._conditions.size()) {
                conditionString = conditionString + ", ";
                continue;
            }
            if (conditionCounter != this._conditions.size()) continue;
            conditionString = conditionString + ". ";
        }
        d = d + "      <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "           <w:pPr>\n" + "                   <w:pStyle w:val=\"Directive\"/>\n" + "           </w:pPr>\n";
        d = d + "<w:r><w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(conditionString) + "</w:t></w:r>   \n</w:p>\n";
        return d;
    }

    protected String wrapAsParagraph(String content, String guid) {
        String s = "      <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "           <w:pPr>\n" + "                   <w:pStyle w:val=\"Directive\"/>\n" + "           </w:pPr>\n";
        s = s + content;
        s = s + "\n</w:p>\n";
        return s;
    }

    protected void setConditionAsOtherwise(int conditionIndex) {
        Condition c = (Condition)this._conditions.get(conditionIndex);
        c.setIsOtherwise(true);
    }

    protected void setParallel(boolean parallel) {
        this._parallel = parallel;
    }

    protected boolean isParallel() {
        return this._parallel;
    }

    public void setFlowsHandled(boolean _flowsHandled) {
        this._flowsHandled = _flowsHandled;
    }

    public boolean getFlowsHandled() {
        return this._flowsHandled;
    }
}

