/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import oracle.tutor.docx.Action;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.SubStepData;
import oracle.tutor.docx.Utils;
import org.w3c.dom.Node;

public class Condition {
    private Action _action;
    private boolean _isOtherwise;
    private boolean _hasFollowup = false;
    private boolean _isFollowup = false;
    private boolean _flowProcessed = false;
    private String _test;
    private ArrayList _subStepData;
    private String _guid;
    private static Logger _logger = Logger.getLogger("oracle.tutor.docx");

    public Condition(String test, boolean isOtherwise, ActionEnum.Type type, String target) {
        this._test = test != null ? test : null;
        this._isOtherwise = isOtherwise;
        this._action = new Action(type, target);
    }

    public String getTest() {
        return this._test;
    }

    public boolean getIsOtherwise() {
        return this._isOtherwise;
    }

    public void setAction(Action action) {
        this._action = action;
    }

    public Action getAction() {
        return this._action;
    }

    protected void addSubStepData(Node node) throws XPathExpressionException {
        if (this._subStepData == null) {
            this._subStepData = new ArrayList();
            this._subStepData.add(new SubStepData(node));
        } else {
            this._subStepData.add(new SubStepData(node));
        }
    }

    protected void addSubStepDataFromString(String tutorStyleString, String dataString) {
        if (this._subStepData == null) {
            this._subStepData = new ArrayList();
            this._subStepData.add(new SubStepData(tutorStyleString, dataString));
        } else {
            this._subStepData.add(new SubStepData(tutorStyleString, dataString));
        }
    }

    protected String toDocx(LanguageMap languageMap, String guid) {
        String s = "";
        String atString = "";
        String testSegment = "";
        String fileRefSegment = "";
        String taskNumSegment = "";
        this._guid = guid;
        String leadString = "";
        leadString = this.getTest() == null || this.getTest().equals("") ? "" : (String)languageMap.getFirstValue("If");
        String commaTestSeperator = "";
        if (this.getAction().getActionTypeString() != null) {
            atString = atString + "<w:r>\n";
            if (this.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY) {
                atString = atString + "<w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(this.getAction().getActionTypeString());
                atString = this._hasFollowup ? atString + "; </w:t>" : atString + ". </w:t>";
            } else {
                atString = atString + "<w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(this.getAction().getActionTypeString()) + "</w:t>";
            }
            atString = atString + "</w:r>\n";
        }
        if (this._isOtherwise) {
            testSegment = testSegment + "<w:r>\n";
            testSegment = testSegment + "<w:t xml:space=\"preserve\">" + (String)languageMap.getFirstValue("Otherwise") + ", </w:t>\n" + "</w:r>\n";
        } else if (this.getTest() != null) {
            if (!this.getTest().equals("")) {
                commaTestSeperator = ", ";
            }
            testSegment = testSegment + "<w:r>\n";
            testSegment = testSegment + "<w:t xml:space=\"preserve\">" + Utils.formatEntityNotation(leadString) + " " + Utils.formatEntityNotation(this.getTest().trim()) + "" + commaTestSeperator + "</w:t>\n" + "</w:r>\n";
        }
        if (this.getAction().getFileReference() != null) {
            fileRefSegment = fileRefSegment + "<w:r>\n<w:rPr>\n<w:rFonts w:cs=\"Times New Roman\"/>\n<w:i/>\n   <w:iCs/>\n   <w:u w:val=\"single\"/>\n   <w:t xml:space=\"preserve\"> " + Utils.formatEntityNotation(this.getAction().getFileReferenceName()) + " [" + Utils.formatEntityNotation(this.getAction().getFileReference()) + "]. </w:t></w:rPr></w:r>";
        } else if (this.getAction().getTaskNumber() > 0) {
            taskNumSegment = taskNumSegment + "<w:r>\n";
            taskNumSegment = taskNumSegment + "<w:t xml:space=\"preserve\"> " + ((String)languageMap.getFirstValue("Task #")).toLowerCase() + this.getAction().getTaskNumber() + ". </w:t>";
            taskNumSegment = taskNumSegment + "</w:r>";
        }
        if (languageMap.getGrammarType() == 0) {
            s = testSegment != "" ? testSegment + " " + atString : atString;
            s = this.getAction().getTaskNumber() == 0 || this.getAction().getFileReference() != null ? s + " " + fileRefSegment : s + " " + taskNumSegment;
        }
        return s;
    }

    protected ArrayList getSubStepData() {
        if (this._subStepData == null) {
            this._subStepData = new ArrayList();
        }
        return this._subStepData;
    }

    protected String getSubStepDataAsDocumentationString() {
        String s = "";
        for (Object o : this.getSubStepData()) {
            s = s + "{" + ((SubStepData)o).getStyleName() + "}" + ((SubStepData)o).getDataString() + "\n";
        }
        return s;
    }

    protected String subSteps_toDocx() {
        String s = "";
        for (Object o : this.getSubStepData()) {
            s = s + ((SubStepData)o).toDocx(null);
        }
        return s;
    }

    protected void setIsOtherwise(boolean isOtherwise) {
        this._isOtherwise = isOtherwise;
    }

    public void setHasFollowup(boolean hasFollowup) {
        this._hasFollowup = hasFollowup;
    }

    public boolean getHasFollowup() {
        return this._hasFollowup;
    }

    public void setIsFollowup(boolean isFollowup) {
        this._isFollowup = isFollowup;
    }

    public boolean getIsFollowup() {
        return this._isFollowup;
    }

    public void setFlowProcessed(boolean flowProcessed) {
        this._flowProcessed = flowProcessed;
    }

    public boolean isFlowProcessed() {
        return this._flowProcessed;
    }
}

