/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Condition;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.Task;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.docx.Utils;

public class Bpd2TutorUtil {
    private Utils _util;
    private Logger _logger;

    public Bpd2TutorUtil(Logger logger) {
        this._logger = logger;
        this._util = new Utils(this._logger);
        this._logger.fine("Initialized conversion from BPD 2 Tutor objects.");
    }

    protected Directive handleParallelSplit(GraphicalElement o, LanguageMap lm, ArrayList sn, int snNumber) {
        Directive d = new Directive(lm);
        GraphicalElement g = o;
        boolean containsEnd = false;
        for (ConnectingObject r : g.getOutflows(SequenceFlow.class)) {
            GraphicalElement el = r.getTo();
            if (!(el instanceof Event) || !((Event)el).getEventType().equals((Object)Event.EventType.END)) continue;
            containsEnd = true;
            break;
        }
        if (g.getOutflows(SequenceFlow.class).size() >= 2) {
            d.setParallel(true);
        }
        String localizedTask = (String)lm.getFirstValue("Task #");
        LinkedList flows = g.getOutflows();
        for (Object f : flows) {
            Condition c;
            String target;
            Subprocess sp;
            if (f instanceof SequenceFlow) {
                Condition c2;
                SequenceFlow sf = (SequenceFlow)f;
                GraphicalElement ge = sf.getTo();
                GraphicalElement nextNode = null;
                if (snNumber + 1 < sn.size()) {
                    nextNode = (GraphicalElement)sn.get(snNumber + 1);
                }
                if (ge instanceof oracle.tutor.bpmn.Task) {
                    if (!d.isParallel() && !(g instanceof Gateway)) continue;
                    String target2 = localizedTask + "" + ((oracle.tutor.bpmn.Task)ge).getAttribute("taskNumber").toString();
                    c2 = new Condition("", false, ActionEnum.Type.GOTO, target2);
                    this._logger.fine("Adding Goto " + target2);
                    d.addCondition(c2);
                    continue;
                }
                if (ge instanceof Subprocess) {
                    sp = (Subprocess)ge;
                    target = sp.getName() + " [../" + sp.getID() + "]";
                    c = new Condition("", false, ActionEnum.Type.STOP_AND_COMPLETE, target);
                    d.addCondition(c);
                    continue;
                }
                if (ge instanceof Event) {
                    Event ev = (Event)ge;
                    if (!ev.getEventType().equals((Object)Event.EventType.END) || ev.getOutflows(MessageFlow.class).size() <= 0) continue;
                    c2 = new Condition("", false, ActionEnum.Type.END_OF_ACTIVITY, null);
                    ev.setVisited(Boolean.valueOf(true));
                    d.addCondition(c2);
                    continue;
                }
                if (!(ge instanceof Gateway)) continue;
            }
            if (!(f instanceof MessageFlow)) continue;
            MessageFlow mf = (MessageFlow)f;
            GraphicalElement to = mf.getTo();
            GraphicalElement fro = mf.getFrom();
            if (to instanceof Subprocess && !((Subprocess)to).isExpanded().booleanValue() && to.getInflows(SequenceFlow.class).isEmpty() && to.getOutflows(SequenceFlow.class).isEmpty()) {
                this._logger.fine("Check for from = EVENT in Bpd2TutorUtil line 211");
                if (!(mf.getFrom() instanceof Event) || ((Event)mf.getFrom()).getEventType() != Event.EventType.END) continue;
                sp = (Subprocess)to;
                target = sp.getName() + " [../" + sp.getID() + "]";
                c = new Condition("", false, ActionEnum.Type.GOTO, target);
                c.setIsFollowup(true);
                d.addCondition(c);
                continue;
            }
            if (fro instanceof Subprocess && !((Subprocess)fro).isExpanded().booleanValue() && fro.getInflows(SequenceFlow.class).isEmpty() && !fro.getOutflows(SequenceFlow.class).isEmpty()) continue;
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Directive handleStackedDirective(TutorDoc td, Gateway g, LanguageMap lm, Collection sn) {
        int yesFlow;
        Directive d;
        block11: {
            String test;
            String directiveString;
            ConnectingObject o;
            int i;
            LinkedList flows;
            block12: {
                block13: {
                    GraphicalElement ge;
                    SequenceFlow sf;
                    String target;
                    String sfName;
                    String gatewayName;
                    String localizedIs;
                    String localizedTask;
                    String localizedNo;
                    block16: {
                        block15: {
                            block14: {
                                d = null;
                                localizedNo = (String)lm.getFirstValue("*No");
                                localizedTask = (String)lm.getFirstValue("Task #");
                                localizedIs = "is";
                                gatewayName = g.getName();
                                flows = g.getOutflows();
                                yesFlow = 0;
                                boolean hasDefault = false;
                                for (i = 0; i < flows.toArray().length; ++i) {
                                    o = (ConnectingObject)flows.get(i);
                                    if (!(o instanceof SequenceFlow) || !((SequenceFlow)o).isDefault().booleanValue()) continue;
                                    hasDefault = true;
                                }
                                i = 0;
                                if (i >= flows.toArray().length) break block11;
                                o = (ConnectingObject)flows.get(i);
                                if (i == 0) {
                                    yesFlow = i;
                                }
                                directiveString = "";
                                sfName = "";
                                test = "";
                                target = "";
                                if (!(o instanceof SequenceFlow)) break block12;
                                sf = (SequenceFlow)o;
                                ge = sf.getTo();
                                if (sf == null || ge == null) break block13;
                                sfName = sf.getName().trim();
                                if (!(ge instanceof oracle.tutor.bpmn.Task)) break block14;
                                test = !gatewayName.equals("") ? Utils.stripFinalQuestionMark(gatewayName) + " " + localizedIs + " " + sfName : sfName;
                                target = ge.getAttribute("taskNumber").toString();
                                directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target);
                                d = new Directive(lm, directiveString);
                                if (d == null) {
                                    // empty if block
                                }
                                break block11;
                            }
                            if (!(ge instanceof Event)) break block15;
                            this._logger.fine("FOUND AN EVENT");
                            if (((Event)ge).getEventType() == Event.EventType.END && !((Event)ge).isVisited().booleanValue()) {
                                test = !gatewayName.equals("") ? Utils.stripFinalQuestionMark(gatewayName) + " " + localizedIs + " " + sfName : sfName;
                                this._logger.fine("format string");
                                String conditionString = Utils.formatLocalizedDirectiveString(lm, test, "End of activity", "");
                                this._logger.fine("It formatted OK");
                                d = new Directive(lm, conditionString);
                                ((Event)ge).setVisited(Boolean.valueOf(true));
                                if (ge.getOutflows().size() > 0) {
                                    for (ConnectingObject ob : ge.getOutflows()) {
                                        GraphicalElement el = ob.getTo();
                                        if (!(el instanceof Subprocess)) continue;
                                        this._logger.fine(el.getID() + " subp name is: " + el.getName());
                                    }
                                }
                            }
                            break block11;
                        }
                        if (!(ge instanceof Subprocess)) break block16;
                        test = !gatewayName.equals("") ? Utils.stripFinalQuestionMark(gatewayName) + " " + localizedIs + " " + sfName : sfName;
                        Subprocess targetProcess = (Subprocess)ge;
                        directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target);
                        this._logger.fine("Done");
                        d = new Directive(lm, directiveString);
                        break block11;
                    }
                    if (!(ge instanceof Gateway)) break block11;
                    test = !gatewayName.equals("") ? Utils.stripFinalQuestionMark(gatewayName) + " " + localizedIs + " " + sfName : sfName;
                    if (ge.getAttribute("taskNumber") != null) {
                        target = ge.getAttribute("landingTask").toString();
                        if (sf.isDefault().booleanValue() || sfName.equals(localizedNo)) {
                            Condition c = new Condition("", true, ActionEnum.Type.GOTO, localizedTask + " " + target);
                            d = new Directive(lm);
                            d.addCondition(c);
                            break block11;
                        } else {
                            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target);
                            d = new Directive(lm, directiveString);
                        }
                        break block11;
                    } else if (ge instanceof Gateway && ge.getInflows().size() > 1) {
                        this._logger.fine("found a Join");
                    }
                    break block11;
                }
                this._logger.severe("The sequence flow is either null or has no toNode, and cannot be processed");
                throw new RuntimeException("The sequence flow is either null or has no toNode, and cannot be processed");
            }
            if (!(o instanceof MessageFlow)) return null;
            test = ((MessageFlow)flows.get(i)).getName();
            Subprocess targetProcess = (Subprocess)((MessageFlow)flows.get(i)).getTo();
            String targetPSstring = targetProcess.getName() + " [../" + targetProcess.getID() + "]";
            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Stop and complete", targetPSstring);
            d = new Directive(lm, directiveString);
        }
        if (d == null) return d;
        return this.completeStackedDirective(d, yesFlow, td, g, lm);
    }

    private Directive completeStackedDirective(Directive d, int yesFlow, TutorDoc td, Gateway g, LanguageMap lm) {
        String otherwiseClause = "";
        String localizedIf = (String)lm.getFirstValue("If");
        String localizedNo = (String)lm.getFirstValue("*No");
        String localizedIs = "is";
        int testedFlows = 0;
        String gatewayName = "";
        if (g.getName() != null && !g.getName().equals("")) {
            gatewayName = g.getName();
        }
        LinkedList flows = g.getOutflows();
        for (int i = 0; i < flows.toArray().length; ++i) {
            boolean isOtherwise = false;
            if (i != yesFlow) {
                ConnectingObject o = (ConnectingObject)flows.get(i);
                String target = "";
                String test = "";
                String conditionString = "";
                if (o instanceof SequenceFlow) {
                    SequenceFlow sf = (SequenceFlow)o;
                    String sfName = "";
                    if (sf.getName() != null) {
                        sfName = sf.getName();
                    } else if (sfName.equals("") && !sf.isDefault().booleanValue()) {
                        sfName = "???";
                    }
                    String gwVarString = "";
                    if (!gatewayName.trim().equals("") && !sf.isDefault().booleanValue()) {
                        gwVarString = Utils.stripFinalQuestionMark(gatewayName) + " " + localizedIs;
                        test = gwVarString + " " + sfName;
                    } else {
                        test = sfName;
                    }
                    GraphicalElement ge = sf.getTo();
                    String toID = ge.getID();
                    if (ge instanceof oracle.tutor.bpmn.Task) {
                        target = ge.getAttribute("taskNumber") != null ? ge.getAttribute("taskNumber").toString() : toID;
                        if (!target.matches("0")) {
                            conditionString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target);
                        } else if (target.matches("0")) {
                            conditionString = Utils.formatLocalizedDirectiveString(lm, test, "End of activity", "");
                        }
                    } else if (ge instanceof Subprocess) {
                        Subprocess targetProcess = (Subprocess)ge;
                        String targetPSstring = targetProcess.getName() + " [../" + targetProcess.getID() + "]";
                        conditionString = Utils.formatLocalizedDirectiveString(lm, test, "Stop and complete", targetPSstring);
                    } else if (ge instanceof Event && ((Event)ge).getEventType().equals((Object)Event.EventType.END) && !((Event)ge).isVisited().booleanValue()) {
                        conditionString = Utils.formatLocalizedDirectiveString(lm, test, "End of activity", "");
                        ((Event)ge).setVisited(Boolean.valueOf(true));
                        if (ge.getOutflows().size() > 0) {
                            boolean flowCount = true;
                            for (ConnectingObject ob : ge.getOutflows()) {
                                GraphicalElement el = ob.getTo();
                                if (!(el instanceof Subprocess) || !flowCount) continue;
                                conditionString = conditionString + "; " + ((String)lm.getFirstValue("Goto")).toLowerCase() + " " + el.getName() + " [" + el.getID() + "]";
                            }
                        }
                    } else if (ge instanceof Gateway) {
                        if (ge.getAttribute("landingTask") != null) {
                            target = ge.getAttribute("landingTask").toString();
                        }
                        if (isOtherwise) {
                            test = "";
                        }
                        conditionString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target);
                    }
                } else if (o instanceof MessageFlow) {
                    test = o.getName() != null ? o.getName() : "";
                    Subprocess targetProcess = (Subprocess)o.getTo();
                    String targetPSstring = targetProcess.getName() + " [../" + targetProcess.getID() + "]";
                    conditionString = Utils.formatLocalizedDirectiveString(lm, test, "Stop and complete", targetPSstring);
                }
                if (isOtherwise) {
                    otherwiseClause = conditionString;
                } else {
                    d.addStackedCondition(conditionString);
                }
            }
            ++testedFlows;
        }
        if (otherwiseClause != "") {
            d.addStackedCondition(otherwiseClause);
            d.setConditionAsOtherwise(flows.toArray().length - 1);
        }
        this._logger.fine("Completed making stacked directive. String is " + d.getDirectiveString());
        return d;
    }

    protected Directive handleBinaryDirective(TutorDoc td, Gateway g, LanguageMap lm, Collection sn) {
        int numCurrentflow = 0;
        String localizedIf = (String)lm.getFirstValue("If");
        String localizedOtherwise = (String)lm.getFirstValue("Otherwise");
        String localizedStopClause = (String)lm.getFirstValue("Stop and complete");
        String localizedYes = (String)lm.getFirstValue("*Yes");
        String localizedNo = (String)lm.getFirstValue("*No");
        String localizedIs = "is";
        String localizedEnd = (String)lm.getFirstValue("End of activity");
        this._logger.fine("Building a binary directive");
        String directiveString = "";
        String defaultSegmentString = "";
        boolean isStop = false;
        for (ConnectingObject q : g.getOutflows()) {
            ConnectingObject branch = q;
            if (branch instanceof SequenceFlow) {
                try {
                    String test;
                    SequenceFlow sf = (SequenceFlow)branch;
                    GraphicalElement ge = sf.getTo();
                    String target = "";
                    if (ge instanceof oracle.tutor.bpmn.Task) {
                        target = ge.getAttribute("taskNumber").toString();
                    } else if (ge instanceof Subprocess) {
                        isStop = true;
                        target = ge.getName() + " [" + ((Subprocess)ge).getModelReference() + "]";
                    } else if (ge instanceof Event) {
                        target = localizedEnd;
                    } else if (ge instanceof Gateway && ge.getAttribute("landingTask") != null) {
                        int lt = (Integer)ge.getAttribute("landingTask");
                        target = Integer.toString(lt);
                    }
                    ++numCurrentflow;
                    if (sf.getName() == null || target == "") continue;
                    if (sf.getName().matches(localizedNo) || sf.getName().matches(localizedOtherwise) || sf.isDefault().booleanValue()) {
                        test = localizedOtherwise;
                        if (ge instanceof Event) {
                            if (lm.getGrammarType() == 0) {
                                defaultSegmentString = localizedOtherwise + ", " + (String)lm.getFirstValue("End of activity");
                                if (!ge.getID().equals("E2")) {
                                    for (ConnectingObject tar : ge.getOutflows(MessageFlow.class)) {
                                        if (!(((MessageFlow)tar).getTo() instanceof Subprocess)) continue;
                                        Subprocess follower = (Subprocess)((MessageFlow)tar).getTo();
                                        String gotoString = "; " + lm.getFirstValue("Goto") + " " + follower.getName() + " [" + follower.getModelReference() + "]. ";
                                        defaultSegmentString = defaultSegmentString + gotoString;
                                    }
                                } else {
                                    defaultSegmentString = defaultSegmentString + ".";
                                }
                            } else {
                                defaultSegmentString = localizedOtherwise + ", " + (String)lm.getFirstValue("End of activity") + ".";
                            }
                        } else if (ge instanceof Subprocess) {
                            defaultSegmentString = lm.getGrammarType() == 0 ? localizedOtherwise + "," + (String)lm.getFirstValue("Stop and complete") + " " + target + "." : localizedOtherwise + ", " + (String)lm.getFirstValue("Goto") + " " + (String)lm.getFirstValue("Task #") + target + ".";
                            ge.setAttribute("processed", (Object)true);
                        } else {
                            defaultSegmentString = lm.getGrammarType() == 0 ? test + " " + (String)lm.getFirstValue("Goto") + " " + (String)lm.getFirstValue("Task #") + target + "." : test + " " + (String)lm.getFirstValue("Goto") + " " + (String)lm.getFirstValue("Task #") + target + ".";
                        }
                    } else if (sf.getName().matches(localizedYes)) {
                        test = "";
                        String directiveStart = "";
                        if (lm.getGrammarType() == 0) {
                            directiveStart = g.getName().equals("") ? "???" : g.getName();
                            if (sf.getName().trim().toLowerCase().equals(localizedYes.toLowerCase())) {
                                test = localizedIf + " " + td.utils.reformatConditionString(directiveStart);
                                directiveString = directiveString + test + ", ";
                            } else {
                                test = localizedIf + " " + td.utils.reformatConditionString(directiveStart) + " " + localizedIs + " " + sf.getName();
                                directiveString = directiveString + test + ", ";
                            }
                        } else {
                            test = localizedIf + " " + td.utils.reformatConditionString(directiveStart) + " " + localizedIs + " ???";
                            directiveString = directiveString + test + ", ";
                        }
                        if (ge instanceof Event) {
                            directiveString = directiveString + (String)lm.getFirstValue("End of activity") + ". ";
                            if (!ge.getID().equals("E2")) {
                                for (ConnectingObject tar : ge.getOutflows(MessageFlow.class)) {
                                    if (!(((MessageFlow)tar).getTo() instanceof Subprocess)) continue;
                                    Subprocess follower = (Subprocess)((MessageFlow)tar).getTo();
                                    String gotoString = "; " + lm.getFirstValue("Goto") + " " + follower.getName() + " [" + follower.getModelReference() + "]. ";
                                    directiveString = directiveString + gotoString;
                                }
                            } else {
                                directiveString = directiveString + ".";
                            }
                        } else if (ge instanceof oracle.tutor.bpmn.Task || ge instanceof Gateway) {
                            directiveString = directiveString + (String)lm.getFirstValue("Goto") + " " + (String)lm.getFirstValue("Task #") + target + ". ";
                        } else if (ge instanceof Subprocess) {
                            directiveString = directiveString + localizedStopClause + " " + ge.getName() + " [" + target + "]. ";
                        }
                    } else {
                        test = "";
                        if (branch.getName().trim().equals("")) {
                            test = g.getName().trim().equals("") ? localizedIf + " ??? " : " ";
                        } else {
                            String gName = g.getName();
                            if (gName.equals("") && (gName = sf.getName()).equals("")) {
                                gName = "????";
                            }
                            test = localizedIf + " " + td.utils.reformatConditionString(gName) + " " + localizedIs + " " + sf.getName();
                        }
                        directiveString = ge instanceof Event && ((Event)ge).getEventType() == Event.EventType.END ? directiveString + test + ", " + target + ". " : directiveString + test + ", " + (String)lm.getFirstValue("Goto") + " " + (String)lm.getFirstValue("Task #") + target + ". ";
                    }
                    ge.setAttribute("processed", (Object)true);
                }
                catch (RuntimeException re) {
                    this._logger.severe("Runtime Exception parsing SequenceFlows in a binary Gateway.");
                }
                continue;
            }
            if (!(branch instanceof MessageFlow)) continue;
            this._logger.fine("MESSAGEFLOW!!!! " + branch.getTo().getName() + "\n");
        }
        directiveString = directiveString + defaultSegmentString;
        Directive d = new Directive(lm, directiveString);
        return d;
    }

    protected Task handleORGateway(TutorDoc td, Gateway g, LanguageMap lm, Collection sn) {
        Task t = new Task();
        t.setBpdNode((FlowObject)g);
        String actorName = "";
        actorName = g.getLane() != null ? g.getLane().getName() : td.getCurrentActor().getTitle();
        Actor a = new Actor();
        a.setTitle(actorName);
        t.addActor(a);
        t.setName("Verify active parallel tasks are complete and continue.");
        t.setTaskString(t.getName());
        return t;
    }

    protected Task handleANDGateway(TutorDoc td, Gateway g, LanguageMap lm, Collection sn) {
        Task t = new Task();
        t.setBpdNode((FlowObject)g);
        String actorName = g.getLane().getName();
        Actor a = new Actor();
        a.setTitle(actorName);
        t.addActor(a);
        t.setName("Verify all parallel tasks are complete and continue.");
        t.setTaskString(t.getName());
        return t;
    }

    protected Directive handleGateway(TutorDoc td, Gateway g, LanguageMap lm, Collection sn) {
        String gatewayName = g.getName();
        int numFlows = g.getOutflows().size();
        Directive d = null;
        String localizedIf = (String)lm.getFirstValue("If");
        String localizedYes = (String)lm.getFirstValue("*Yes");
        String localizedNo = (String)lm.getFirstValue("*No");
        String directiveString = "";
        if (numFlows == 1) {
            ConnectingObject branch = (ConnectingObject)g.getOutflows().toArray()[0];
            if (branch instanceof SequenceFlow) {
                SequenceFlow sf = (SequenceFlow)branch;
                GraphicalElement ge = sf.getTo();
                String target = "";
                if (ge instanceof oracle.tutor.bpmn.Task) {
                    target = ge.getAttribute("taskNumber").toString();
                }
                if (branch.getName() != null) {
                    if (branch.getName().matches(localizedNo)) {
                        String test = "";
                        if ((FlowObject)branch.getTo() instanceof Event) {
                            directiveString = lm.getFirstValue("End of activity") + ".";
                            ((FlowObject)branch.getTo()).setVisited(Boolean.valueOf(true));
                        } else if ((FlowObject)branch.getTo() instanceof Subprocess) {
                            this._logger.fine("Subprocess!!!!\n");
                        } else {
                            directiveString = test + " " + lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + target + ".";
                        }
                    } else if (branch.getName().matches(localizedYes)) {
                        String test = localizedIf + " " + td.utils.reformatConditionString(g.getName());
                        directiveString = directiveString + test + ", " + lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + target + ". ";
                    } else if (branch.getName() == "") {
                        this._logger.fine("branchName is EMPTY STRING");
                        String test = " ";
                        directiveString = directiveString + test + ", " + lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + target + ". ";
                    } else {
                        String test = localizedIf + " " + td.utils.reformatConditionString(g.getName());
                        directiveString = directiveString + test + ", " + lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + target + ". ";
                    }
                } else {
                    String test = localizedIf + " " + gatewayName;
                    directiveString = test + ", " + lm.getFirstValue("Goto") + " " + lm.getFirstValue("Task #") + target + ". ";
                }
            }
            this._logger.fine("So I build my directive with this: " + directiveString);
            d = new Directive(lm, directiveString);
        } else if (numFlows == 2) {
            boolean isOtherwise = false;
            boolean GWlabeled = !gatewayName.equals("");
            boolean allFlowsLabeled = Bpd2TutorUtil.getSoleUnlabeledFlow(g) == -1;
            boolean allMembersLabeled = GWlabeled && allFlowsLabeled;
            boolean labeledNo = false;
            boolean labeledYes = false;
            ArrayList owList = lm.getLocalizedValues("Otherwise");
            int flowCount = 0;
            for (ConnectingObject q : g.getOutflows()) {
                ++flowCount;
                ConnectingObject branch = q;
                for (Object ow : owList) {
                    if (branch.getName().trim().matches((String)ow) || branch.getName().trim().matches(localizedNo)) {
                        isOtherwise = true;
                    }
                    if (branch.getName().trim().matches(localizedNo)) {
                        labeledNo = true;
                        continue;
                    }
                    if (!branch.getName().trim().matches(localizedYes)) continue;
                    labeledYes = true;
                }
                if (!(branch instanceof SequenceFlow) || !((SequenceFlow)branch).isDefault().booleanValue()) continue;
                isOtherwise = true;
            }
            d = isOtherwise && !allMembersLabeled || labeledYes && labeledNo ? this.handleBinaryDirective(td, g, lm, sn) : this.handleStackedDirective(td, g, lm, sn);
        } else {
            d = numFlows >= 2 ? this.handleStackedDirective(td, g, lm, sn) : null;
        }
        return d;
    }

    protected boolean hasEndCondition(Step s) {
        boolean hasEnd = false;
        if (s instanceof Directive) {
            for (Object o : ((Directive)s).getConditions()) {
                if (!((Condition)o).getAction().getType().equals((Object)ActionEnum.Type.END_OF_ACTIVITY)) continue;
                hasEnd = true;
            }
        }
        return hasEnd;
    }

    protected Directive handleEvent(TutorDoc td, Event e, LanguageMap lm) {
        Directive d = new Directive(lm);
        if (e.getEventType() == Event.EventType.END) {
            Actor a = new Actor();
            if (e.getLane() != null) {
                a.setTitle(e.getLane().getName());
            } else {
                a.setTitle("");
            }
            d.addActor(a);
            Condition c = new Condition(null, false, ActionEnum.Type.END_OF_ACTIVITY, null);
            d.addCondition(c);
            d.setDirectiveString((String)lm.getFirstValue("End of activity"));
            e.setVisited(Boolean.valueOf(true));
            for (ConnectingObject o : e.getOutflows()) {
                if (!(o instanceof MessageFlow)) continue;
                this._logger.fine("Found a MessageFlow");
                d.addStackedCondition(this.getLocalizedConditionFromMessageFlow(lm, (MessageFlow)o));
                GraphicalElement targetSubproc = ((MessageFlow)o).getTo();
                targetSubproc.setAttribute("processed", (Object)"true");
            }
        }
        return d;
    }

    protected String getLocalizedConditionFromMessageFlow(LanguageMap lm, MessageFlow o) {
        String c = "";
        String fileRef = o.getTo().getID();
        String fileRefName = o.getTo().getName();
        this._logger.fine("Parsing MessageFlow to find stacked directive condition. fileRef = " + fileRef + " fileRefName is " + fileRefName);
        String locGoto = (String)lm.getFirstValue("Goto");
        c = lm.getGrammarType() == 0 ? locGoto + " " + fileRefName + " [" + fileRef + "]" : fileRefName + " [" + fileRef + "]" + locGoto;
        return c;
    }

    protected Directive handleSubprocess(Subprocess s, LanguageMap lm) {
        this._logger.fine("Handling conversion of Subprocess to Tutor objects for " + s.getName());
        String stopComplStr = (String)lm.getFirstValue("Stop and complete");
        String modelRef = "";
        if (s.getModelReference() != null) {
            String[] tmp = s.getModelReference().split("_pa");
            modelRef = tmp[0];
        } else {
            String[] refArray = s.getID().split("_");
            modelRef = refArray[0];
        }
        Directive d = new Directive(lm, stopComplStr + " " + s.getName() + " [" + modelRef + "]");
        if (s.getDocumentation() != null && s.getDocumentation() != "") {
            String ssData = s.getDocumentation();
            String[] lines = ssData.split("\\n");
            String regEx1 = "}";
            Pattern targStr = Pattern.compile(regEx1);
            Matcher tm = targStr.matcher(ssData);
            Boolean matched = false;
            if (tm.find()) {
                matched = true;
            }
            if (matched.booleanValue()) {
                for (int i = 0; i < lines.length; ++i) {
                    String[] line = lines[i].split("}");
                    String style = line[0];
                    style = style.substring(1, style.length());
                    String ds = line[1];
                    ArrayList conditions = d.getConditions();
                    ((Condition)conditions.get(0)).addSubStepDataFromString(style, ds);
                }
            }
        }
        return d;
    }

    protected Boolean actorIsInDocActorList(TutorDoc td, Step s) {
        Boolean found;
        block2: {
            Object z;
            Actor act;
            found = false;
            ArrayList al = td.getMActorList();
            if (al.size() == 0) {
                return found;
            }
            ArrayList l = s.getActors();
            if (l == null || l.size() == 0) {
                return found;
            }
            Actor actor = (Actor)l.get(0);
            Iterator i$ = al.iterator();
            if (!i$.hasNext() || !(act = (Actor)(z = i$.next())).getTitle().matches(actor.getTitle())) break block2;
            found = true;
        }
        return found;
    }

    static Directive getTaskOutflowsAsDirective(LanguageMap lm, LinkedList outflows, Logger logger) {
        Directive d = null;
        int flowCounter = 0;
        Collections.reverse(outflows);
        for (Object o : outflows) {
            ConnectingObject co = (ConnectingObject)o;
            GraphicalElement ge = co.getTo();
            String actionTypeString = "";
            String targetName = "";
            String flowName = co.getName();
            targetName = ge != null && !ge.getName().equals("") ? ge.getName() : "???";
            if (flowName.equals("")) {
                flowName = "???";
            }
            if (flowCounter == 0) {
                if (ge instanceof Subprocess) {
                    actionTypeString = (String)lm.getFirstValue("Stop and complete");
                    String fileRef = ((Subprocess)ge).getModelReference();
                    targetName = targetName + " [" + fileRef + "]";
                    ge.setAttribute("processed", (Object)true);
                } else {
                    actionTypeString = (String)lm.getFirstValue("Goto");
                }
                String ds = lm.getFirstValue("If") + " " + flowName + " " + actionTypeString + " " + targetName;
                d = new Directive(lm, ds);
                logger.fine("the value of ds is " + ds);
            } else {
                Boolean isDefault = false;
                if (ge instanceof Subprocess) {
                    String fileRef = ((Subprocess)ge).getModelReference();
                    targetName = targetName + " [" + fileRef + "]";
                    ge.setAttribute("processed", (Object)true);
                    if (co instanceof SequenceFlow) {
                        isDefault = ((SequenceFlow)co).isDefault();
                        d.addCondition(new Condition(flowName, isDefault, ActionEnum.Type.GOTO, targetName));
                    } else {
                        d.addCondition(new Condition(flowName, isDefault, ActionEnum.Type.STOP_AND_COMPLETE, targetName));
                    }
                } else {
                    d.addCondition(new Condition(flowName, isDefault, ActionEnum.Type.GOTO, targetName));
                }
            }
            ++flowCounter;
        }
        return d;
    }

    static int getMarkedDefaultFlow(Gateway g) {
        int defaultFlowNum;
        block1: {
            defaultFlowNum = -1;
            int flowNum = 0;
            Iterator i$ = g.getOutflows(SequenceFlow.class).iterator();
            if (!i$.hasNext()) break block1;
            ConnectingObject o = (ConnectingObject)i$.next();
            if (((SequenceFlow)o).isDefault().booleanValue()) {
                defaultFlowNum = flowNum;
            }
            ++flowNum;
        }
        return defaultFlowNum;
    }

    static int getLabeledNoFlow(Gateway g, String localNo) {
        int noFlowNum = -1;
        int flowNum = 0;
        for (ConnectingObject o : g.getOutflows(SequenceFlow.class)) {
            if (((SequenceFlow)o).getName().trim().equalsIgnoreCase(localNo)) {
                noFlowNum = flowNum;
                break;
            }
            ++flowNum;
        }
        return noFlowNum;
    }

    static int getLabeledYesFlow(Gateway g, String localYes) {
        int yesFlowNum = -1;
        int flowNum = 0;
        for (ConnectingObject o : g.getOutflows(SequenceFlow.class)) {
            if (((SequenceFlow)o).getName().trim().equalsIgnoreCase(localYes)) {
                yesFlowNum = flowNum;
                break;
            }
            ++flowNum;
        }
        return yesFlowNum;
    }

    static int getSoleUnlabeledFlow(Gateway g) {
        int noFlowNum = -1;
        int flowNum = 0;
        int blanksFound = 0;
        for (ConnectingObject o : g.getOutflows(SequenceFlow.class)) {
            if (((SequenceFlow)o).getName().trim().equals("")) {
                noFlowNum = flowNum;
                ++blanksFound;
            }
            ++flowNum;
        }
        if (blanksFound != 1) {
            noFlowNum = -1;
        }
        return noFlowNum;
    }

    static boolean allFlowsUnlabeled(Gateway g) {
        boolean flowsAreBlank = true;
        for (ConnectingObject o : g.getOutflows(SequenceFlow.class)) {
            if (((SequenceFlow)o).getName().equals("")) continue;
            flowsAreBlank = false;
            break;
        }
        return flowsAreBlank;
    }

    static boolean directiveContainsIdenticalCondition(Step s, Condition condition) {
        boolean containsCondition = false;
        for (Object c : ((Directive)s).getConditions()) {
            Condition con = (Condition)c;
            int conTnum = con.getAction().getTaskNumber();
            if (!con.getAction().getType().equals((Object)condition.getAction().getType()) || conTnum != condition.getAction().getTaskNumber()) continue;
            containsCondition = true;
            break;
        }
        return containsCondition;
    }

    protected Actor getActorFromLane(TutorDoc td, Step s, FlowObject o) {
        Boolean matched = this.actorIsInDocActorList(td, s);
        ArrayList actors = s.getActors();
        Actor a = null;
        a = actors != null && actors.size() > 0 ? (Actor)actors.get(0) : new Actor();
        if (!matched.booleanValue()) {
            if (o.getLane() != null && !o.getLane().getName().equals("")) {
                a.setTitle(o.getLane().getName());
                a.setId(o.getLane().getName());
            } else {
                a.setId("Unknown");
                a.setTitle("Unknown");
            }
            td.addDistributionListItem(a);
            td.addActor(a);
            td.setCurrentActor(a);
        } else {
            td.setCurrentActor(td.getActorByTitle(a.getTitle()));
        }
        return a;
    }
}

