/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Task;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Condition;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.ExternalLinkObject;
import oracle.tutor.docx.Flow_Util;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.SubStepData;
import oracle.tutor.docx.Task;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.docx.Utils;

public class BPModeler {
    private BusinessProcessDiagram _bpd;
    private Actor _currentActor;
    private Task _currentTask;
    private TutorDoc _document;
    private Lane _l;
    private Pool _p0;
    private Lane _usl;
    private Pool _p1;
    private Pool _p2;
    private Utils _utils;
    private HashMap _poolsUsed;
    private int _processedStep;
    private int _flowNumber;
    private int _stopSubProcessNum;
    private String _poolOneName;
    private Logger _logger;
    private boolean _isRE;
    private Flow_Util _flow_util;

    public BPModeler(TutorDoc doc, String poolOneName, Logger logger) {
        this._poolOneName = poolOneName == null ? "My Company" : poolOneName;
        this._document = doc;
        this._isRE = this._document.isRE_file();
        this._logger = logger;
        this._utils = new Utils(logger);
        this._bpd = new BusinessProcessDiagram(this._document.getDocFileName(), this._document.getName());
        this._bpd.setToolID("Oracle Tutor");
        String documentation = "";
        if (!doc.getIntroSection().getIsPlainText().booleanValue() && doc.getIntroSection().getSectionsAsPlainText() != "") {
            documentation = documentation + doc.getIntroSection().getSectionsAsPlainText() + "\n";
        } else if (doc.getIntroSection().getIsPlainText().booleanValue() && doc.getIntroSection().getPlainText() != "") {
            documentation = documentation + doc.getIntroSection().getPlainText() + "\n";
        }
        this._bpd.setDocumentation(documentation);
        this._currentActor = new Actor();
        this._p0 = new Pool("P0", "UpStream Processes", this._bpd);
        this._usl = new Lane("usl", "Prior Activities", this._bpd.getPool("P0"));
        this._p1 = new Pool("P1", this._poolOneName, this._bpd);
        this._p2 = new Pool("P2", "Downstream Processes", this._bpd);
        this._stopSubProcessNum = 0;
        String dsLaneName = "dsl";
        String dslLabel = "Post Process Activities";
        this._l = new Lane(dsLaneName, dslLabel, this._bpd.getPool("P2"));
        this._poolsUsed = new HashMap();
        this.populateBPD();
        this.removeLingeringEnd();
    }

    private void removeLingeringEnd() {
        Event end = (Event)this._bpd.getNode("E2");
        if (end.getInflows().isEmpty() && end.getOutflows().isEmpty()) {
            end.remove();
        }
    }

    private void populateBPD() {
        Step step;
        this._logger.fine("Starting to populate BPD\n");
        ArrayList actL = this._document.getMActorList();
        this._processedStep = 1;
        if (!this._isRE) {
            for (Object o : actL) {
                Actor a = (Actor)o;
                String lane = a.getId();
                String label = a.getTitle();
                this._l = new Lane(lane, label, this._bpd.getPool("P1"));
            }
        } else {
            Actor a = (Actor)actL.get(0);
            String lane = a.getId();
            String label = a.getREActorName();
            this._l = new Lane(lane, label, this._bpd.getPool("P1"));
        }
        Event e = new Event("E1", "Start", this._p1.getLane((Object)"L1"));
        e.setEventType(Event.EventType.START);
        if (this._p1.getLane((Object)"L1") == null) {
            this._bpd.addNode((FlowObject)e);
        }
        for (Object p : this._document.getPriorActivity().getMActivities()) {
            Subprocess sub = new Subprocess(((ExternalLinkObject)p).getFileReference() + "_pa", ((ExternalLinkObject)p).getFileReferenceName(), this._p0.getLane((Object)"usl"));
            sub.setSourceID(this._document.getDocFileName());
            sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
            sub.setModelReference(((ExternalLinkObject)p).getFileReference());
        }
        this._currentActor.setId("L1");
        for (Object o : this._document.getSteps()) {
            step = (Step)o;
            if (!(step instanceof Directive)) continue;
            int cCounter = 0;
            int eoaLocation = -1;
            for (Object c : ((Directive)step).getConditions()) {
                if (((Condition)c).getAction().getType().equals((Object)ActionEnum.Type.END_OF_ACTIVITY)) {
                    eoaLocation = cCounter;
                } else if (eoaLocation > -1 && !((Condition)c).getIsOtherwise()) {
                    ((Condition)c).setIsFollowup(true);
                }
                ++cCounter;
            }
        }
        for (Object o : this._document.getSteps()) {
            step = (Step)o;
            if (!this._isRE) {
                ArrayList actors = step.getActors();
                this._currentActor = (Actor)actors.get(0);
            }
            if (step instanceof Task) {
                Task task = (Task)step;
                if (!this._isRE) {
                    Gateway g;
                    if (task.getTaskString().equals("Verify all parallel tasks are complete and continue.")) {
                        g = new Gateway(task.getId(), "", this._p1.getLane((Object)this._currentActor.getId()));
                        g.setGatewayType(Gateway.GatewayType.AND);
                        g.setMarkerVisible(Boolean.valueOf(false));
                        if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                        this._bpd.addNode((FlowObject)g);
                        continue;
                    }
                    if (task.getTaskString().equals("Verify active parallel tasks are complete and continue.")) {
                        g = new Gateway(task.getId(), "", this._p1.getLane((Object)this._currentActor.getId()));
                        g.setGatewayType(Gateway.GatewayType.OR);
                        g.setMarkerVisible(Boolean.valueOf(false));
                        if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                        this._bpd.addNode((FlowObject)g);
                        continue;
                    }
                    oracle.tutor.bpmn.Task t = new oracle.tutor.bpmn.Task(task.getId(), task.getTaskString(), this._p1.getLane((Object)this._currentActor.getId()));
                    String tdString = this.getTaskString((GraphicalElement)t, task.getTaskData());
                    t.setDocumentation(tdString);
                    Boolean isSystemType = t.getTaskType() == Task.TaskType.USER;
                    if (!isSystemType.booleanValue()) {
                        t.setTaskType(Task.TaskType.MANUAL);
                    }
                    if (this._p1.getLane((Object)this._currentActor.getId()) != null) continue;
                    this._bpd.addNode((FlowObject)t);
                    continue;
                }
                Subprocess sub = new Subprocess(task.getId(), task.getTaskString(), this._p1.getLane((Object)"L1"));
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                Actor a = (Actor)task.getActors().get(0);
                sub.setModelReference(a.getProcUrl());
                sub.setSourceID(this._document.getDocFileName());
                sub.setDocumentation(this.getTaskString((GraphicalElement)sub, task.getTaskData()));
                continue;
            }
            Directive d = (Directive)o;
            ArrayList clist = d.getConditions();
            if (clist.size() == 2) {
                Condition second = (Condition)clist.get(1);
                if (second.getIsOtherwise()) {
                    this.makeBPD4Binary(d);
                    continue;
                }
                this.makeBPDDirective(d);
                continue;
            }
            this.makeBPDDirective(d);
        }
        Event endEvent = new Event("E2", "End", this._p1.getLane((Object)this._currentActor.getId()));
        endEvent.setEventType(Event.EventType.END);
        if (this._p1.getLane((Object)this._currentActor.getId()) == null) {
            this._bpd.addNode((FlowObject)endEvent);
        }
        this._flow_util = new Flow_Util(this._bpd, this._logger);
        this.setPreviousSteps();
        this.makeFlows();
        this.removeExtraPools();
        this._logger.fine("Finished building BPMN model.\n");
    }

    private void setPreviousSteps() {
        for (Object o : this._document.getSteps()) {
            for (Object x : this._document.getSteps()) {
                if (o.equals(x)) continue;
                Step step = (Step)x;
                if (step instanceof Task) {
                    if (step.getNextStep() == null || !step.getNextStep().equals((Step)o)) continue;
                    ((Step)o).addPrevStep(step);
                    continue;
                }
                if (!(step instanceof Directive)) continue;
                Directive d = (Directive)step;
                for (Object c : d.getConditions()) {
                    if (((Condition)c).getAction().getTargetStep() == null || !((Condition)c).getAction().getTargetStep().equals((Step)o)) continue;
                    ((Step)o).addPrevStep(d);
                }
            }
        }
    }

    private void makeBPD4Binary(Directive d) {
        int numConditions = d.getConditions().size();
        int gCounter = 0;
        for (Object c : d.getConditions()) {
            String target;
            Subprocess sub;
            Condition cond = (Condition)c;
            Boolean isStopAndComplete = cond.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE;
            Boolean isEnd = cond.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY;
            Boolean isGoto = cond.getAction().getType() == ActionEnum.Type.GOTO || cond.getAction().getType() == ActionEnum.Type.RETURN_TO;
            Boolean isLast = this._document.getSteps().get(this._document.getSteps().size() - 1).equals(d);
            if (gCounter == 0) {
                Gateway g;
                if (cond.getTest() == null) continue;
                if (isEnd.booleanValue() && !isLast.booleanValue()) {
                    g = new Gateway(d.getId(), Utils.capInitial(this._utils.removeLeadingNumbers(cond.getTest())) + "?", this._p1.getLane((Object)this._currentActor.getId()));
                    g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    g.setMarkerVisible(Boolean.valueOf(false));
                    if (this._p1.getLane((Object)this._currentActor.getId()) == null) {
                        this._bpd.addNode((FlowObject)g);
                    }
                    ++gCounter;
                } else if (isGoto.booleanValue() || isStopAndComplete.booleanValue()) {
                    g = new Gateway(d.getId(), Utils.capInitial(this._utils.removeLeadingNumbers(cond.getTest())) + "?", this._p1.getLane((Object)this._currentActor.getId()));
                    g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    g.setMarkerVisible(Boolean.valueOf(false));
                    if (this._p1.getLane((Object)this._currentActor.getId()) == null) {
                        this._bpd.addNode((FlowObject)g);
                    }
                    ++gCounter;
                }
                if (!isStopAndComplete.booleanValue()) continue;
                sub = new Subprocess(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum, cond.getAction().getLinkObject().getFileReferenceName(), this._p1.getLane((Object)this._currentActor.getId()));
                cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum++);
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                target = cond.getAction().getLinkObject().getId();
                sub.setAttribute("taskNumber", (Object)target);
                this._logger.fine("I just set the taskNumber attribute for Subprocess " + sub.getID() + " to " + target);
                sub.setSourceID(this._document.getDocFileName());
                if (this._p1.getLane((Object)this._currentActor.getId()) != null) continue;
                this._bpd.addNode((FlowObject)sub);
                continue;
            }
            if (isGoto.booleanValue()) {
                if (cond.getAction().getLinkObject() == null || cond.getAction().getLinkObject().getId() == null) continue;
                sub = new Subprocess(cond.getAction().getLinkObject().getId(), cond.getAction().getLinkObject().getFileReferenceName(), this._p2.getLane((Object)"dsl"));
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                target = cond.getAction().getLinkObject().getId();
                sub.setAttribute("taskNumber", (Object)target);
                sub.setSourceID(this._document.getDocFileName());
                this.add2PoolsUsed("P2", "");
                if (this._p1.getLane((Object)"dsl") != null) continue;
                this._bpd.addNode((FlowObject)sub);
                continue;
            }
            if (isStopAndComplete.booleanValue()) {
                sub = new Subprocess(cond.getAction().getLinkObject().getFileReference() + "_" + this._stopSubProcessNum, cond.getAction().getLinkObject().getFileReferenceName(), this._p1.getLane((Object)this._currentActor.getId()));
                cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum++);
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                sub.setSourceID(this._document.getDocFileName());
                target = cond.getAction().getLinkObject().getId();
                sub.setAttribute("taskNumber", (Object)target);
                if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                this._bpd.addNode((FlowObject)sub);
                continue;
            }
            if (!isEnd.booleanValue() || numConditions <= 1 || gCounter >= numConditions - 1) continue;
            Event endEvent = new Event("E_" + d.getId(), "End", this._p1.getLane((Object)this._currentActor.getId()));
            endEvent.setEventType(Event.EventType.END);
            if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                this._bpd.addNode((FlowObject)endEvent);
            }
            ++gCounter;
        }
    }

    private void makeBPDDirective(Directive d) {
        int numConditions = d.getConditions().size();
        int gCounter = 0;
        boolean reversedDirective = false;
        boolean eoaIsOtherwise = false;
        boolean hasEndwFollowup = false;
        for (Object c : d.getConditions()) {
            if (((Condition)c).getAction().getType().equals((Object)ActionEnum.Type.END_OF_ACTIVITY) && ((Condition)c).getHasFollowup()) {
                hasEndwFollowup = true;
                eoaIsOtherwise = ((Condition)c).getIsOtherwise();
                continue;
            }
            if (!((Condition)c).getAction().getType().equals((Object)ActionEnum.Type.GOTO) && !((Condition)c).getAction().getType().equals((Object)ActionEnum.Type.STOP_AND_COMPLETE) || !((Condition)c).getIsOtherwise() || ((Condition)c).getIsFollowup() || !hasEndwFollowup || eoaIsOtherwise) continue;
            reversedDirective = true;
            break;
        }
        for (Object c : d.getConditions()) {
            Subprocess sub;
            Event endEvent;
            Condition cond = (Condition)c;
            Boolean isStopAndComplete = cond.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE;
            Boolean isEnd = cond.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY;
            Boolean isGoto = cond.getAction().getType() == ActionEnum.Type.GOTO || cond.getAction().getType() == ActionEnum.Type.RETURN_TO;
            Boolean isLast = this._document.getSteps().get(this._document.getSteps().size() - 1).equals(d);
            if (gCounter == 0) {
                Gateway g;
                if (cond.getTest() != null) {
                    if (isEnd.booleanValue() && !isLast.booleanValue()) {
                        if (numConditions > 1) {
                            endEvent = new Event("E_" + d.getId(), "End", this._p1.getLane((Object)this._currentActor.getId()));
                            endEvent.setEventType(Event.EventType.END);
                            if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                                this._bpd.addNode((FlowObject)endEvent);
                            }
                            ++gCounter;
                        }
                    } else if (isGoto.booleanValue() || isStopAndComplete.booleanValue()) {
                        g = new Gateway(d.getId(), Utils.capInitial(this._utils.removeLeadingNumbers(cond.getTest())) + "?", this._p1.getLane((Object)this._currentActor.getId()));
                        g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                        g.setMarkerVisible(Boolean.valueOf(false));
                        if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                            this._bpd.addNode((FlowObject)g);
                        }
                        ++gCounter;
                    }
                    if (reversedDirective) {
                        g = new Gateway(d.getId(), Utils.capInitial(this._utils.removeLeadingNumbers(cond.getTest())) + "?", this._p1.getLane((Object)this._currentActor.getId()));
                        g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                        g.setMarkerVisible(Boolean.valueOf(false));
                        if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                            this._bpd.addNode((FlowObject)g);
                        }
                        ++gCounter;
                    }
                    if (!isStopAndComplete.booleanValue()) continue;
                    sub = new Subprocess(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum, cond.getAction().getLinkObject().getFileReferenceName(), this._p1.getLane((Object)this._currentActor.getId()));
                    cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum++);
                    sub.setExpanded(Boolean.valueOf(false));
                    sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                    sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                    sub.setSourceID(this._document.getDocFileName());
                    if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                    this._bpd.addNode((FlowObject)sub);
                    continue;
                }
                if (isEnd.booleanValue()) {
                    if (numConditions <= 1) continue;
                    if (!isLast.booleanValue()) {
                        endEvent = new Event("E_" + d.getId(), "End", this._p1.getLane((Object)this._currentActor.getId()));
                        endEvent.setEventType(Event.EventType.END);
                        if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                            this._bpd.addNode((FlowObject)endEvent);
                        }
                    }
                    ++gCounter;
                    continue;
                }
                if (isGoto.booleanValue()) {
                    if (cond.getAction().getLinkObject() == null && cond.getAction().getTaskNumber() == 0) {
                        sub = new Subprocess(cond.getAction().getTarget() + "_sp", cond.getAction().getTarget(), this._p2.getLane((Object)"dsl"));
                        sub.setExpanded(Boolean.valueOf(false));
                        sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                        sub.setSourceID(this._document.getDocFileName());
                        sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                        this.add2PoolsUsed("P2", "");
                        if (this._p1.getLane((Object)"dsl") != null) continue;
                        this._bpd.addNode((FlowObject)sub);
                        continue;
                    }
                    if (cond.getAction().getLinkObject() != null && cond.getAction().getTaskNumber() == 0) {
                        sub = new Subprocess(cond.getAction().getLinkObject().getId(), cond.getAction().getLinkObject().getFileReferenceName(), this._p2.getLane((Object)"dsl"));
                        cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_sp");
                        sub.setExpanded(Boolean.valueOf(false));
                        sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                        sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                        sub.setSourceID(this._document.getDocFileName());
                        sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                        this.add2PoolsUsed("P2", "");
                        if (this._p1.getLane((Object)this._p1.getLane((Object)"dsl")) != null) continue;
                        this._bpd.addNode((FlowObject)sub);
                        continue;
                    }
                    if (!d.isParallel()) continue;
                    g = new Gateway(d.getId(), "", this._p1.getLane((Object)this._currentActor.getId()));
                    g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    g.setMarkerVisible(Boolean.valueOf(false));
                    if (this._p1.getLane((Object)this._currentActor.getId()) == null) {
                        this._bpd.addNode((FlowObject)g);
                    }
                    ++gCounter;
                    continue;
                }
                if (!isStopAndComplete.booleanValue() || cond.getAction().getLinkObject() == null || cond.getAction().getLinkObject().getId() == null) continue;
                sub = new Subprocess(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum, cond.getAction().getLinkObject().getFileReferenceName(), this._p1.getLane((Object)this._currentActor.getId()));
                cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum++);
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                sub.setSourceID(this._document.getDocFileName());
                sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                this._bpd.addNode((FlowObject)sub);
                continue;
            }
            if (isGoto.booleanValue()) {
                try {
                    if (cond.getAction().getLinkObject() != null && cond.getAction().getLinkObject().getId() != null) {
                        sub = new Subprocess(cond.getAction().getLinkObject().getId(), cond.getAction().getLinkObject().getFileReferenceName(), this._p2.getLane((Object)"dsl"));
                        sub.setExpanded(Boolean.valueOf(false));
                        sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                        sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                        sub.setSourceID(this._document.getDocFileName());
                        sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                        this.add2PoolsUsed("P2", "");
                        if (this._p1.getLane((Object)this._p1.getLane((Object)"dsl")) != null) continue;
                        this._bpd.addNode((FlowObject)sub);
                        continue;
                    }
                    if (cond.getAction().getLinkObject() != null || cond.getAction().getTaskNumber() != 0) continue;
                    this._logger.fine("SUB-P! Need to make " + cond.getAction().getTarget() + " into a label.");
                    sub = new Subprocess(cond.getAction().getTarget() + "_sp", "* " + cond.getAction().getTarget(), this._p2.getLane((Object)"dsl"));
                    sub.setExpanded(Boolean.valueOf(false));
                    sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                    sub.setSourceID(this._document.getDocFileName());
                    sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                    this.add2PoolsUsed("P2", "");
                    if (this._p1.getLane((Object)this._p1.getLane((Object)"dsl")) != null) continue;
                    this._bpd.addNode((FlowObject)sub);
                }
                catch (NullPointerException npe) {
                    this._logger.fine("NullPointerException thrown in block making BPMN Objects for GOTO");
                }
                continue;
            }
            if (isStopAndComplete.booleanValue()) {
                sub = new Subprocess(cond.getAction().getLinkObject().getFileReference() + "_" + this._stopSubProcessNum, cond.getAction().getLinkObject().getFileReferenceName(), this._p1.getLane((Object)this._currentActor.getId()));
                cond.getAction().setConnectorId(cond.getAction().getLinkObject().getId() + "_" + this._stopSubProcessNum++);
                sub.setExpanded(Boolean.valueOf(false));
                sub.setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                sub.setModelReference(cond.getAction().getLinkObject().getFileReference());
                sub.setSourceID(this._document.getDocFileName());
                sub.setDocumentation(cond.getSubStepDataAsDocumentationString());
                if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) != null) continue;
                this._bpd.addNode((FlowObject)sub);
                continue;
            }
            if (isEnd.booleanValue()) {
                if (numConditions <= 1 || gCounter >= numConditions - 1) continue;
                endEvent = new Event("E_" + d.getId(), "End", this._p1.getLane((Object)this._currentActor.getId()));
                endEvent.setEventType(Event.EventType.END);
                if (this._p1.getLane((Object)this._p1.getLane((Object)this._currentActor.getId())) == null) {
                    this._bpd.addNode((FlowObject)endEvent);
                }
                ++gCounter;
                continue;
            }
            this._logger.severe("I should not happen. BPModler line 652. I am at condition # " + gCounter + " with this condition: " + ((Condition)c).getTest() + " for this type: " + ((Condition)c).getAction().getActionTypeString() + ". Otherwise is " + ((Condition)c).getIsOtherwise() + " points to this target: " + ((Condition)c).getAction().getTarget() + " file ref " + cond.getAction().getFileReference() + "\n");
        }
    }

    private void makeFlows() {
        this._logger.fine("Making flows");
        this._flowNumber = 0;
        int totalSteps = this._document.getSteps().size();
        int numStep = 1;
        for (Object p : this._document.getPriorActivity().getMActivities()) {
            MessageFlow m = new MessageFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(((ExternalLinkObject)p).getFileReference() + "_pa"), (GraphicalElement)this._bpd.getNode("E1"));
            this.add2PoolsUsed("P0", m.getID());
        }
        SequenceFlow s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode("E1"), (GraphicalElement)this._bpd.getNode(this._document.getStartStep().getId()));
        for (Object o : this._document.getSteps()) {
            block28: {
                boolean isLastStep = numStep == totalSteps;
                Step step = (Step)o;
                int stepIndex = this._document.getStepIndex(step);
                Step prevStep = this._document.getStepByIndex(stepIndex - 1);
                boolean nextIsLast = numStep == totalSteps - 1;
                try {
                    if (step instanceof Task) {
                        this._currentTask = (Task)step;
                        this._logger.fine("writing flow for " + this._currentTask.getTaskString() + " " + step.getId());
                        if (step.getNextStep() instanceof Task) {
                            s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(step.getId()), (GraphicalElement)this._bpd.getNode(step.getNextStep().getId()));
                        } else if (step.getNextStep() instanceof Directive) {
                            try {
                                Directive nd = (Directive)step.getNextStep();
                                this._logger.fine("writing flow for directive as NextStep " + nd.getDirectiveString() + " " + step.getId());
                                int numConditions = nd.getConditions().size();
                                ActionEnum.Type aType = ((Condition)nd.getConditions().get(0)).getAction().getType();
                                if (nextIsLast && numConditions == 1 && aType == ActionEnum.Type.END_OF_ACTIVITY) {
                                    s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(step.getId()), (GraphicalElement)this._bpd.getNode("E2"));
                                } else if (this._bpd.getNode(step.getNextStep().getId()) == null) {
                                    int conditions = 0;
                                    if (numConditions == 1) {
                                        for (Object c : nd.getConditions()) {
                                            Condition cond = (Condition)c;
                                            ++conditions;
                                            if (cond.getTest() != null) continue;
                                            if (cond.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE) {
                                                s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(step.getId()), (GraphicalElement)this._bpd.getNode(cond.getAction().getConnectorId()));
                                            }
                                            s = this._flow_util.getSFfromDirectiveAsNextStep_single(step, cond, conditions, this._flowNumber++);
                                        }
                                    } else if (numConditions >= 2) {
                                        ArrayList condits = nd.getConditions();
                                        Condition second = (Condition)condits.get(1);
                                        if (condits.size() == 2 && second.getIsOtherwise()) {
                                            this.handleFlows4Binary(nd.getConditions(), second.getIsOtherwise(), step, false);
                                        } else {
                                            this.handleFlows4MultipleConditions(second.getIsOtherwise(), step, prevStep, isLastStep, true, nd);
                                        }
                                    }
                                } else {
                                    s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(step.getId()), (GraphicalElement)this._bpd.getNode(step.getNextStep().getId()));
                                }
                            }
                            catch (Exception e) {
                                this._logger.severe("Error while trying to create sequenceFlow from Node " + step.getId() + " to this node: " + step.getNextStep().getId());
                            }
                        }
                        ++this._processedStep;
                        break block28;
                    }
                    Directive D = (Directive)step;
                    this._logger.fine("writing flow for " + D.getDirectiveString() + " " + step.getId());
                    int conditions = 0;
                    int numConditions = D.getConditions().size();
                    if (numConditions == 1) {
                        for (Object c : D.getConditions()) {
                            Condition cond = (Condition)c;
                            ++conditions;
                            if (cond.getTest() != null || prevStep instanceof Task) {
                                if (isLastStep || cond.isFlowProcessed()) continue;
                                s = this._flow_util.getSFfromDirectiveStep_single(this._currentTask, step, cond, conditions, this._flowNumber++);
                                continue;
                            }
                            if (cond.getTest() != null && !(prevStep instanceof Directive) || cond.isFlowProcessed()) continue;
                            s = this._flow_util.getSFfromDirectiveStep_single(this._currentTask, step, cond, conditions, this._flowNumber++);
                        }
                    } else if (numConditions >= 2) {
                        ArrayList condits = D.getConditions();
                        Condition second = (Condition)condits.get(1);
                        if (condits.size() == 2 && second.getIsOtherwise()) {
                            this.handleFlows4Binary(D.getConditions(), second.getIsOtherwise(), step, true);
                        } else {
                            this.handleFlows4MultipleConditions(second.getIsOtherwise(), step, prevStep, isLastStep, false, D);
                        }
                    }
                    ++this._processedStep;
                }
                catch (NullPointerException excep) {
                    throw new NullPointerException("A Null Pointer Exception occured while making SequenceFlows for " + step.getId() + ". Message is " + excep.getMessage());
                }
            }
            ++numStep;
        }
        this._logger.fine("Finished building Flows.");
    }

    private void handleFlows4Binary(ArrayList conditions, Boolean yesNo, Step stepProcessing, boolean fromTask) {
        int conditionCounter = 0;
        Boolean isLastStep = this._document.getSteps().get(this._document.getSteps().size() - 1).equals(stepProcessing);
        for (Object o : conditions) {
            SequenceFlow s;
            ++conditionCounter;
            String label = "";
            Condition c = (Condition)o;
            if (yesNo.booleanValue()) {
                if (conditionCounter == 1) {
                    label = "Yes";
                } else if (conditionCounter == 2) {
                    label = "No";
                }
            } else {
                label = Utils.capInitial(c.getTest());
                if (label == null) {
                    label = "";
                } else if (conditionCounter == 1 && c.getAction().getType() != ActionEnum.Type.STOP_AND_COMPLETE) {
                    label = "Yes";
                }
            }
            if (c.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE) {
                s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode(c.getAction().getConnectorId()));
                if (fromTask) {
                    this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                }
                s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(c.getAction().getConnectorId()), (GraphicalElement)this._bpd.getNode(stepProcessing.getNextStep().getId()));
                continue;
            }
            if (c.getAction().getType() == ActionEnum.Type.GOTO || c.getAction().getType() == ActionEnum.Type.RETURN_TO) {
                s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode(c.getAction().getTargetStep().getId()));
                if (!fromTask) continue;
                this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                continue;
            }
            if (c.getAction().getType() != ActionEnum.Type.END_OF_ACTIVITY) continue;
            s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode("E2"));
            if (!fromTask) continue;
            this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
        }
    }

    private void handleFlows4MultipleConditions(Boolean yesNo, Step stepProcessing, Step prevStep, boolean isLast, boolean originIsTaskObject, Step directive) {
        Directive D = (Directive)directive;
        if (!D.getFlowsHandled()) {
            ArrayList conditions = D.getConditions();
            int conditionCounter = 0;
            int numConditions = conditions.size();
            int endConditionNumber = -1;
            boolean hasFollowup = false;
            boolean containsEnd = false;
            boolean isLastStep = isLast;
            boolean isParallel = D.isParallel();
            String nextStepID = null;
            boolean fromTask = originIsTaskObject;
            if (numConditions > 1) {
                if (!isLastStep) {
                    nextStepID = stepProcessing.getNextStep().getId();
                }
                for (int i = 0; i < conditions.size(); ++i) {
                    Condition c = (Condition)conditions.get(i);
                    if (c.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY) {
                        containsEnd = true;
                        endConditionNumber = i;
                    }
                    if (!containsEnd || endConditionNumber >= i || !c.getIsFollowup()) continue;
                    hasFollowup = true;
                }
            }
            for (Object o : conditions) {
                SequenceFlow s;
                String ds;
                String fromId;
                if (fromTask && ++conditionCounter > 1 && !D.isParallel()) break;
                String label = "";
                Condition c = (Condition)o;
                boolean isOtherwise = c.getIsOtherwise();
                if (yesNo.booleanValue()) {
                    if (conditionCounter == 1) {
                        label = "Yes";
                    } else if (conditionCounter == 2) {
                        label = "No";
                    }
                } else {
                    label = Utils.capInitial(c.getTest());
                    if (label == null) {
                        label = "";
                    } else if (conditionCounter == 1 && c.getAction().getType() != ActionEnum.Type.STOP_AND_COMPLETE) {
                        label = "Yes";
                    }
                }
                if (c.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE) {
                    fromId = null;
                    fromId = stepProcessing instanceof Directive ? (((Directive)stepProcessing).isConditional(ds = ((Directive)stepProcessing).getDirectiveString()).booleanValue() ? stepProcessing.getId() : ((Condition)conditions.get(conditionCounter - 1)).getAction().getConnectorId()) : stepProcessing.getId();
                    if (this._bpd.getNode(fromId) != null && this._bpd.getNode(((Condition)conditions.get(conditionCounter - 1)).getAction().getConnectorId()) != null) {
                        s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(fromId), (GraphicalElement)this._bpd.getNode(((Condition)conditions.get(conditionCounter - 1)).getAction().getConnectorId()));
                        this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                    }
                    if (fromTask) continue;
                    if (conditionCounter == 1 && this._bpd.getNode(((Condition)conditions.get(conditionCounter)).getAction().getConnectorId()) != null) {
                        this._logger.fine("Number 1 from Directive. Current SP id is " + c.getAction().getConnectorId() + ". next Subprocess ID is " + ((Condition)conditions.get(conditionCounter)).getAction().getConnectorId());
                        s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(c.getAction().getConnectorId()), (GraphicalElement)this._bpd.getNode(((Condition)conditions.get(conditionCounter)).getAction().getConnectorId()));
                        continue;
                    }
                    if (conditionCounter > 1 && numConditions > conditionCounter && this._bpd.getNode(((Condition)conditions.get(conditionCounter)).getAction().getConnectorId()) != null) {
                        this._logger.fine("Current SP id is " + c.getAction().getConnectorId() + ". next Subprocess ID is " + ((Condition)conditions.get(conditionCounter)).getAction().getConnectorId());
                        s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(c.getAction().getConnectorId()), (GraphicalElement)this._bpd.getNode(((Condition)conditions.get(conditionCounter)).getAction().getConnectorId()));
                        continue;
                    }
                    if ((numConditions != conditionCounter || this._bpd.getNode(nextStepID) == null) && (conditionCounter <= 1 || numConditions <= conditionCounter || this._bpd.getNode(((Condition)conditions.get(conditionCounter)).getAction().getConnectorId()) != null)) continue;
                    this._logger.fine("nextStepID is " + nextStepID);
                    s = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(c.getAction().getConnectorId()), (GraphicalElement)this._bpd.getNode(nextStepID));
                    if (!isOtherwise) continue;
                    s.setAttribute("Otherwise", (Object)"true");
                    s.setDefault(Boolean.valueOf(true));
                    continue;
                }
                if (c.getAction().getType() == ActionEnum.Type.GOTO || c.getAction().getType() == ActionEnum.Type.RETURN_TO) {
                    SequenceFlow lastFlow;
                    if (hasFollowup && c.getIsFollowup()) {
                        if (c.getAction().getLinkObject() != null) {
                            MessageFlow m = isLastStep ? new MessageFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode("E2"), (GraphicalElement)this._bpd.getNode(c.getAction().getLinkObject().getId())) : new MessageFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode("E_" + stepProcessing.getId()), (GraphicalElement)this._bpd.getNode(c.getAction().getLinkObject().getId()));
                            if (isOtherwise) {
                                m.setAttribute("Otherwise", (Object)"true");
                            }
                            this._flow_util.setDocumentationFromCondition((ConnectingObject)m, c);
                            this.add2PoolsUsed("P2", m.getID());
                            continue;
                        }
                        String toNodeName = "";
                        String fromNodeName = "";
                        toNodeName = c.getAction().getTargetStep() == null ? c.getAction().getTarget() + "_sp" : c.getAction().getTargetStep().getId();
                        fromNodeName = isLastStep ? "E2" : stepProcessing.getId();
                        MessageFlow m = new MessageFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(fromNodeName), (GraphicalElement)this._bpd.getNode(toNodeName));
                        if (isOtherwise) {
                            m.setAttribute("Otherwise", (Object)"true");
                        }
                        this._flow_util.setDocumentationFromCondition((ConnectingObject)m, c);
                        continue;
                    }
                    fromId = null;
                    fromId = stepProcessing instanceof Directive ? (((Directive)stepProcessing).isConditional(ds = ((Directive)stepProcessing).getDirectiveString()).booleanValue() || ((Directive)stepProcessing).isParallel() ? stepProcessing.getId() : ((lastFlow = (SequenceFlow)this._bpd.getFlow("S" + (this._flowNumber - 1))) != null && lastFlow.getTo() != null ? lastFlow.getTo().getID() : "E2")) : stepProcessing.getId();
                    s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(fromId), (GraphicalElement)this._bpd.getNode(c.getAction().getTargetStep().getId()));
                    this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                    if (!isOtherwise) continue;
                    s.setAttribute("Otherwise", (Object)"true");
                    s.setDefault(Boolean.valueOf(true));
                    continue;
                }
                if (c.getAction().getType() != ActionEnum.Type.END_OF_ACTIVITY) continue;
                if (!isLastStep) {
                    SequenceFlow s2;
                    if (conditionCounter < numConditions) {
                        try {
                            String toID = null;
                            toID = this._bpd.getNode(stepProcessing.getNextStep().getId()) == null ? "E2" : "E_" + stepProcessing.getId();
                            if (originIsTaskObject) continue;
                            if (this._bpd.getNode(stepProcessing.getId()) != null) {
                                s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode(toID));
                                this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                                if (!isOtherwise) continue;
                                s.setAttribute("Otherwise", (Object)"true");
                                continue;
                            }
                            if (this._bpd.getNode(prevStep.getId()) == null) continue;
                            s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(prevStep.getId()), (GraphicalElement)this._bpd.getNode(toID));
                            if (isOtherwise) {
                                s.setAttribute("Otherwise", (Object)"true");
                            }
                            this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
                        }
                        catch (NullPointerException np) {
                            Step testStep = (Step)this._document.getSteps().get(this._processedStep - 2);
                            if (!(testStep instanceof Task)) continue;
                            SequenceFlow s3 = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(((Step)this._document.getSteps().get(this._processedStep - 2)).getId()), (GraphicalElement)this._bpd.getNode("E_" + stepProcessing.getId()));
                            this._flow_util.setDocumentationFromCondition((ConnectingObject)s3, c);
                        }
                        continue;
                    }
                    if (conditionCounter == numConditions) {
                        if (this._bpd.getNode(stepProcessing.getId()) == null || this._bpd.getNode("E_" + stepProcessing.getId()) == null) continue;
                        s2 = new SequenceFlow("S" + this._flowNumber++, "", (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode("E_" + stepProcessing.getId()));
                        this._flow_util.setDocumentationFromCondition((ConnectingObject)s2, c);
                        s2.setDefault(Boolean.valueOf(true));
                        continue;
                    }
                    s2 = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(stepProcessing.getId()), (GraphicalElement)this._bpd.getNode("E2"));
                    this._flow_util.setDocumentationFromCondition((ConnectingObject)s2, c);
                    continue;
                }
                Step nextToLastStep = (Step)this._document.getSteps().get(this._document.getSteps().size() - 2);
                s = new SequenceFlow("S" + this._flowNumber++, label, (GraphicalElement)this._bpd.getNode(nextToLastStep.getId()), (GraphicalElement)this._bpd.getNode("E2"));
                this._flow_util.setDocumentationFromCondition((ConnectingObject)s, c);
            }
            if (D.isParallel()) {
                D.setFlowsHandled(true);
            }
        }
    }

    public BusinessProcessDiagram getDiagram() {
        return this._bpd;
    }

    public void runTest() {
        this._logger.fine("Diagram Name: " + this._bpd.getName());
        this._logger.fine("All objects: " + this._bpd.getGraphicalElements());
        this._logger.fine("");
        this._logger.fine("***************** NOW JUST THE FLOW INFO ***********************************");
        for (ConnectingObject o : this._bpd.getAllFlows().values()) {
            if (o instanceof MessageFlow) {
                MessageFlow mfn = (MessageFlow)o;
                this._logger.fine("MessageFlow: " + mfn.getID() + " = " + mfn.getName() + " from = " + mfn.getFrom().getID() + " to = " + mfn.getTo().getID());
                continue;
            }
            SequenceFlow node = (SequenceFlow)o;
            this._logger.fine(node.getID() + " = " + node.getName() + " (from " + node.getFrom().getID() + " to " + node.getTo().getID() + ")");
        }
    }

    private void add2PoolsUsed(String key, String value) {
        if (!this._poolsUsed.containsKey(key)) {
            this._poolsUsed.put(key, value);
        }
    }

    private void removeExtraPools() {
        String[] pools = new String[]{"P2", "P0"};
        for (int i = 0; i < pools.length; ++i) {
            if (this._poolsUsed.containsKey(pools[i])) continue;
            this._bpd.getPools().remove(pools[i]);
        }
    }

    private String getTaskString(GraphicalElement t, ArrayList td) {
        String tdString = "";
        if (td != null && td.size() >= 1) {
            int btCounter = 1;
            for (int i = 0; i < td.size(); ++i) {
                try {
                    String ssd;
                    if (((SubStepData)td.get(i)).getStyleName().matches("BoxText") && btCounter < 4) {
                        if (btCounter == 1) {
                            t.setAttribute("SYSTEM_APPLICATION", (Object)((SubStepData)td.get(i)).getDataString());
                        } else if (btCounter == 2) {
                            t.setAttribute("SYSTEM_NAVIGATION", (Object)((SubStepData)td.get(i)).getDataString());
                        } else if (btCounter == 3) {
                            t.setAttribute("SYSTEM_SCREEN_NAME", (Object)((SubStepData)td.get(i)).getDataString());
                            if (t instanceof oracle.tutor.bpmn.Task) {
                                ((oracle.tutor.bpmn.Task)t).setTaskType(Task.TaskType.USER);
                            }
                        }
                        tdString = tdString + ((SubStepData)td.get(i)).getDocumentationFormat();
                        ++btCounter;
                        continue;
                    }
                    if (((SubStepData)td.get(i)).getStyleName().matches("BoxText") && btCounter >= 4) {
                        ++btCounter;
                        tdString = tdString + ((SubStepData)td.get(i)).getDocumentationFormat();
                        if (!((SubStepData)td.get(i)).isContainsUPKlink()) continue;
                        ssd = ((SubStepData)td.get(i)).getPlainDataString();
                        t.setAttribute("UPK_TOPIC_ID", (Object)Utils.getFileRefID(ssd));
                        t.setAttribute("UPK_TOPIC_URL", (Object)Utils.getFileRefUrl(ssd));
                        t.setAttribute("UPK_TOPIC_NAME", (Object)Utils.getFileRefName(((SubStepData)td.get(i)).getDataString()));
                        continue;
                    }
                    tdString = tdString + ((SubStepData)td.get(i)).getDocumentationFormat();
                    if (!((SubStepData)td.get(i)).isContainsUPKlink()) continue;
                    ssd = ((SubStepData)td.get(i)).getPlainDataString();
                    t.setAttribute("UPK_TOPIC_ID", (Object)Utils.getFileRefID(ssd));
                    t.setAttribute("UPK_TOPIC_URL", (Object)Utils.getFileRefUrl(ssd));
                    t.setAttribute("UPK_TOPIC_NAME", (Object)Utils.getFileRefName(((SubStepData)td.get(i)).getDataString()));
                    continue;
                }
                catch (Exception XPathExpressionException) {
                    this._logger.fine("Something went wrong");
                }
            }
        }
        return tdString;
    }
}

