/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.ExternalLinkObject;
import oracle.tutor.docx.Link;
import oracle.tutor.docx.Step;

public class Action {
    private ActionEnum.Type type;
    private String target;
    private Step targetStep;
    private int taskNumber;
    private String fileReference = null;
    private String fileReferenceName;
    private ExternalLinkObject linkObject;
    private String connectorId;

    public Action(ActionEnum.Type type, String target) {
        this.type = type;
        this.target = this.removeTrailingPeriod(target);
        this.targetStep = null;
        this.linkObject = null;
        this.connectorId = null;
        this.setTaskNumber();
        if (this.target != null && this.isReference(this.target).booleanValue() || type == ActionEnum.Type.STOP_AND_COMPLETE) {
            this.setFileReference(this.target);
            this.linkObject = new ExternalLinkObject(this.fileReference, this.fileReferenceName);
        }
    }

    private String removeTrailingPeriod(String t) {
        String s = "";
        if (t != null) {
            s = t.length() > 1 && t.lastIndexOf(".") == t.length() - 1 ? t.substring(0, t.length() - 1) : t;
        }
        return s;
    }

    private Boolean isReference(String targetString) {
        Boolean ref = false;
        if (targetString.length() > 0) {
            String regEx = "\\[.+\\]";
            Pattern targStr = Pattern.compile(regEx, 2);
            Matcher tm = targStr.matcher(targetString);
            while (tm.find()) {
                ref = true;
            }
        }
        return ref;
    }

    private void setFileReference(String targetString) {
        this.fileReference = "";
        this.fileReferenceName = "";
        Link lo = new Link(targetString);
        if (lo.getLinkString() != null) {
            this.fileReference = lo.getLinkUrl();
            this.fileReferenceName = lo.getLinkString();
        }
    }

    private void setTaskNumber() {
        if (this.type == ActionEnum.Type.GOTO) {
            String t = "";
            this.taskNumber = 0;
            String regEx = "#[\\s]*[0-9]+";
            Pattern targStr = Pattern.compile(regEx, 2);
            Matcher tm = targStr.matcher(this.target);
            while (tm.find()) {
                t = this.target.substring(tm.start() + 1, tm.end()).trim();
                this.taskNumber = Integer.parseInt(t);
            }
        }
    }

    public void setTaskNumber(int n) {
        this.taskNumber = n;
    }

    public ActionEnum.Type getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public String getActionTypeString() {
        return ActionEnum.getTypeString(this.type);
    }

    public void setTargetStep(Step targetStep) {
        this.targetStep = targetStep;
    }

    public Step getTargetStep() {
        return this.targetStep;
    }

    public int getTaskNumber() {
        return this.taskNumber;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public String getFileReferenceName() {
        return this.fileReferenceName;
    }

    public ExternalLinkObject getLinkObject() {
        return this.linkObject;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }
}

