/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.DataObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Group;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;
import oracle.tutor.bpmn.Task;
import oracle.tutor.xpdl.Constants;
import oracle.tutor.xpdl.ConversionContext;
import oracle.tutor.xpdl.Util;
import oracle.tutor.xpdl.XPDLMarshallingException;
import oracle.tutor.xpdl.XPDLNamespaceFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wfmc.xpdl21.Activity;
import org.wfmc.xpdl21.ActivitySet;
import org.wfmc.xpdl21.Artifact;
import org.wfmc.xpdl21.Association;
import org.wfmc.xpdl21.BlockActivity;
import org.wfmc.xpdl21.ConnectorGraphicsInfo;
import org.wfmc.xpdl21.Coordinates;
import org.wfmc.xpdl21.ExpressionType;
import org.wfmc.xpdl21.ExtendedAttribute;
import org.wfmc.xpdl21.IntermediateEvent;
import org.wfmc.xpdl21.Lane;
import org.wfmc.xpdl21.MessageFlow;
import org.wfmc.xpdl21.NodeGraphicsInfo;
import org.wfmc.xpdl21.PackageHeader;
import org.wfmc.xpdl21.PackageType;
import org.wfmc.xpdl21.Page;
import org.wfmc.xpdl21.Pages;
import org.wfmc.xpdl21.Pools;
import org.wfmc.xpdl21.ProcessType;
import org.wfmc.xpdl21.Reference;
import org.wfmc.xpdl21.Route;
import org.wfmc.xpdl21.SubFlow;
import org.wfmc.xpdl21.Task;
import org.wfmc.xpdl21.Transition;
import org.wfmc.xpdl21.VendorExtension;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XPDLUnmarshaller
implements Constants {
    protected Unmarshaller _jaxbUnmarshaller;
    protected XMLFilter _nsFilter;
    protected Validator _validator;
    protected Transformer _patcher;
    private static XPDLUnmarshaller _instance;
    private static final double OFFSET = 10.0;
    private static final String PATCH_XSL_NAME = "patch.xsl";
    private static final Logger LOG;
    private static boolean isReprocessableLanes;
    private static File inputFile;
    private PackageType pkg = null;

    public static XPDLUnmarshaller getInstance() throws XPDLMarshallingException {
        if (_instance == null) {
            _instance = new XPDLUnmarshaller();
        }
        return _instance;
    }

    private XPDLUnmarshaller() throws XPDLMarshallingException {
        try {
            this._jaxbUnmarshaller = this.createUnmarshaller();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            this._nsFilter = new XPDLNamespaceFilter(parser.getXMLReader());
            try {
                if (XPDLUnmarshaller.isXPDLValidationOn()) {
                    SchemaFactory xsdFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    URL xsdFile = this.getClass().getClassLoader().getResource("bpmnxpdl_31.xsd");
                    Schema xsd = xsdFactory.newSchema(xsdFile);
                    this._validator = xsd.newValidator();
                }
            }
            catch (SAXException e) {
                LOG.warning("Schema validator is not created: " + e.getMessage());
            }
        }
        catch (JAXBException e) {
            throw new XPDLMarshallingException(e);
        }
        catch (SAXException e) {
            throw new XPDLMarshallingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XPDLMarshallingException(e);
        }
    }

    public BusinessProcessDiagram[] unmarshal(String fileName, String tutorDirectoryPath) throws XPDLMarshallingException, FileNotFoundException {
        LOG.info("XPDL file name:" + fileName);
        return this.unmarshal(new File(fileName), tutorDirectoryPath);
    }

    public BusinessProcessDiagram[] unmarshal(File file, String tutorDirectoryPath) throws XPDLMarshallingException, FileNotFoundException {
        inputFile = file;
        BusinessProcessDiagram[] bpd = this.unmarshal(new FileInputStream(file), tutorDirectoryPath);
        if (bpd.length == 1) {
            bpd[0].setID(file.getName().substring(0, file.getName().lastIndexOf(46)));
        }
        return bpd;
    }

    public BusinessProcessDiagram[] unmarshal(InputStream istream, String tutorDirectoryPath) throws XPDLMarshallingException {
        this.load(istream, tutorDirectoryPath);
        BusinessProcessDiagram[] bpd = XPDLUnmarshaller.convertToBPMN(this.pkg);
        return bpd;
    }

    public void load(String filePath, String tutorDirectoryPath) throws XPDLMarshallingException {
        this.load(new File(filePath), tutorDirectoryPath);
    }

    public void load(File file, String tutorDirectoryPath) throws XPDLMarshallingException {
        try {
            inputFile = file;
            this.load(new FileInputStream(file), tutorDirectoryPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\"" + file.getAbsolutePath() + "\" file not found");
        }
    }

    public void load(InputStream istream, String tutorDirectoryPath) throws XPDLMarshallingException {
        SAXSource ss = this.getSAXSource(istream, tutorDirectoryPath);
        this.pkg = this.readXPDLPackage(ss);
    }

    private SAXSource getSAXSource(InputStream istream, String tutorDirectoryPath) throws XPDLMarshallingException {
        InputSource is = new InputSource(this.applyPatch(istream, tutorDirectoryPath));
        SAXSource ss = new SAXSource(this._nsFilter, is);
        if (XPDLUnmarshaller.isXPDLValidationOn() && this._validator != null) {
            try {
                this._validator.validate(ss);
            }
            catch (SAXException e) {
                throw new XPDLMarshallingException("Input document is not valid XPDL 2.1 document: " + e.getMessage());
            }
            catch (IOException e) {
                throw new XPDLMarshallingException(e);
            }
        }
        return ss;
    }

    public String[] getPages() {
        String[] pageNames = null;
        if (this.pkg != null) {
            Pages pages = this.pkg.getPages();
            if (pages != null) {
                if (pages.getPage() != null && pages.getPage().size() != 0) {
                    List<Page> pageList = pages.getPage();
                    pageNames = new String[pageList.size()];
                    for (Page page : pageList) {
                        pageNames[pageList.indexOf((Object)page)] = page.getName();
                    }
                } else {
                    LOG.info("pages element is empty");
                }
            } else {
                LOG.warning("pages element does not exist in xpdl");
            }
        } else {
            LOG.severe("Package object not created yet. call this method after calling load method.");
            throw new RuntimeException("Package object not created yet. call getPages() method after calling load() method.");
        }
        return pageNames;
    }

    private String[] getPools(String pnameOrPid, boolean pnameOrPidIsPname) {
        LinkedList<String> poolNamesList = new LinkedList<String>();
        if (this.pkg != null) {
            Pools pools = this.pkg.getPools();
            if (pools != null && pools.getPool() != null && pools.getPool().size() != 0) {
                for (org.wfmc.xpdl21.Pool pool : pools.getPool()) {
                    if (pool.getNodeGraphicsInfos() != null && pool.getNodeGraphicsInfos().getNodeGraphicsInfo() != null && pool.getNodeGraphicsInfos().getNodeGraphicsInfo().size() != 0) {
                        NodeGraphicsInfo pgrfxInfo = pool.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                        if (pnameOrPidIsPname) {
                            if (pgrfxInfo.getPage() != null) {
                                if (!pgrfxInfo.getPage().equals(pnameOrPid)) continue;
                                poolNamesList.add(pool.getName());
                                continue;
                            }
                            LOG.info("\"" + pool.getName() + "\" pool does not contain page Name info");
                            continue;
                        }
                        if (pgrfxInfo.getPageId() != null) {
                            if (!pgrfxInfo.getPageId().equals(pnameOrPid)) continue;
                            poolNamesList.add(pool.getName());
                            continue;
                        }
                        LOG.info("\"" + pool.getName() + "\" pool does not contain page Id info");
                        continue;
                    }
                    LOG.info("NodeGraphicsInfo is not found for pool : " + pool.getName());
                }
            } else {
                LOG.warning("Pools element is empty");
            }
        } else {
            LOG.severe("Package object not created yet.");
            throw new RuntimeException("Package object not created yet.");
        }
        String[] poolNames = null;
        if (poolNamesList.size() != 0) {
            poolNames = new String[poolNamesList.size()];
            Iterator<org.wfmc.xpdl21.Pool> i$ = poolNamesList.iterator();
            while (i$.hasNext()) {
                String poolName;
                poolNames[poolNamesList.indexOf((Object)poolName)] = poolName = (String)((Object)i$.next());
            }
        }
        return poolNames;
    }

    public String[] getAllPools() {
        String[] poolNames = new String[]{};
        if (this.pkg != null) {
            Pools pools = this.pkg.getPools();
            if (pools != null && pools.getPool() != null && pools.getPool().size() != 0) {
                List<org.wfmc.xpdl21.Pool> poolList = pools.getPool();
                poolNames = new String[poolList.size()];
                for (org.wfmc.xpdl21.Pool pool : poolList) {
                    poolNames[poolList.indexOf((Object)pool)] = pool.getName();
                }
            } else {
                LOG.info("Pools element is empty");
            }
        } else {
            LOG.severe("Package object not created yet.");
        }
        return poolNames;
    }

    public String[] getPoolsByPageId(String pageId) {
        String[] poolNames = this.getPools(pageId, false);
        return poolNames;
    }

    public String[] getPoolsByPageName(String pageName) {
        String[] poolNames = this.getPools(pageName, true);
        return poolNames;
    }

    public InputStream applyPatch(InputStream istream, String tutorDirectoryPath) throws XPDLMarshallingException {
        ByteArrayOutputStream transformedBytes = new ByteArrayOutputStream();
        Document domObject = this.getDocument(istream);
        InputStream streamSource = this.addMissingNamespaces(domObject);
        Transformer patcher = this.getTransformer(domObject, tutorDirectoryPath);
        if (patcher != null) {
            try {
                StreamResult outputTarget = new StreamResult(transformedBytes);
                LOG.info("Applying patch");
                patcher.transform(new StreamSource(streamSource), outputTarget);
            }
            catch (TransformerException e) {
                LOG.severe(e.getMessage());
                throw new XPDLMarshallingException("Error applying patch.", e);
            }
            return new ByteArrayInputStream(transformedBytes.toByteArray());
        }
        LOG.warning("Patch file not found or invalid. Processing input file as is.");
        return streamSource;
    }

    protected static boolean isXPDLValidationOn() {
        return Boolean.parseBoolean(System.getProperty("bpmnxpdl.xpdl_validation_on", "false"));
    }

    protected Transformer getTransformer(Document doc, String tutorDirectoryPath) {
        String filePath = null;
        LOG.info("looking for patch file");
        filePath = this.getPatchFilePath(doc, tutorDirectoryPath);
        TransformerFactory xformFactory = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        InputStream patchInputStream = null;
        try {
            if (filePath != null && !filePath.equals("")) {
                filePath = filePath.trim();
                if (tutorDirectoryPath != null) {
                    if (':' != filePath.charAt(1) && !filePath.startsWith("\\")) {
                        filePath = tutorDirectoryPath + File.separator + filePath;
                    }
                    patchInputStream = new FileInputStream(filePath);
                } else {
                    patchInputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
                }
            } else {
                patchInputStream = this.getClass().getClassLoader().getResourceAsStream(PATCH_XSL_NAME);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warning(e.getMessage());
            throw new RuntimeException("File not found:" + e.getMessage());
        }
        if (patchInputStream != null) {
            try {
                this._patcher = xformFactory.newTransformer(new StreamSource(patchInputStream));
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Unable to initialize transformer. " + e.getMessage());
            }
        } else {
            this._patcher = null;
        }
        return this._patcher;
    }

    private Document getDocument(File f) throws FileNotFoundException {
        return this.getDocument(new FileInputStream(f));
    }

    private Document getDocument(InputStream istream) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        domFactory.setNamespaceAware(false);
        Document doc = null;
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            doc = builder.parse(istream);
        }
        catch (Exception e) {
            LOG.severe(XPDLUnmarshaller.getStackTrace(e));
            throw new RuntimeException(e.getMessage());
        }
        return doc;
    }

    private InputStream addMissingNamespaces(InputStream istream) {
        return this.addMissingNamespaces(this.getDocument(istream));
    }

    private InputStream addMissingNamespaces(Document doc) {
        boolean xsiNamespaceFoundFlag = false;
        boolean xsdNamespaceFoundFlag = false;
        boolean defNamespaceChanged = false;
        InputStream istream = null;
        Element docElement = doc.getDocumentElement();
        NamedNodeMap nnm = docElement.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            Attr attr = (Attr)n;
            if (attr.getName().equals("xmlns") && !attr.getValue().equals("http://www.wfmc.org/2008/XPDL2.1")) {
                defNamespaceChanged = true;
                attr.setValue("http://www.wfmc.org/2008/XPDL2.1");
                continue;
            }
            if (attr.getValue().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                xsiNamespaceFoundFlag = true;
            }
            if (!attr.getValue().equals("http://www.w3.org/2001/XMLSchema")) continue;
            xsdNamespaceFoundFlag = true;
        }
        if (xsiNamespaceFoundFlag && xsdNamespaceFoundFlag && !defNamespaceChanged) {
            try {
                istream = new FileInputStream(inputFile);
            }
            catch (FileNotFoundException e) {
                LOG.severe("input File not found:" + e.getMessage());
            }
        } else {
            if (!xsiNamespaceFoundFlag) {
                docElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            if (!xsdNamespaceFoundFlag) {
                docElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            }
            Transformer transformer = null;
            try {
                transformer = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null).newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(resultStream);
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                istream = new ByteArrayInputStream(resultStream.toByteArray());
            }
            catch (TransformerConfigurationException e) {
                LOG.warning("Transformer object to 'recreate xpdl with new namespaces' can not be created");
            }
            catch (TransformerException e) {
                LOG.warning("recreation of xpdl with new namespaces can not be done");
            }
        }
        return istream;
    }

    private boolean getXPathResultBooleanValue(Document doc, String xpathExpression) {
        boolean result;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            XPathExpression xpathExpr = xpath.compile(xpathExpression);
            result = (Boolean)xpathExpr.evaluate(doc, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            LOG.severe(xpathExpression + "-xpath expression can not be evaluated" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    private NodeList getXPathResultNodeList(Document doc, String xpathExpression) {
        NodeList list;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            XPathExpression xpathExpr = xpath.compile(xpathExpression);
            list = (NodeList)xpathExpr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOG.severe(xpathExpression + "-xpath expression can not be evaluated" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return list;
    }

    private String getXPathResultString(Document doc, String xpathExpression) {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        String result = null;
        try {
            XPathExpression xpathExpr = xpath.compile(xpathExpression);
            result = (String)xpathExpr.evaluate(doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            LOG.severe(xpathExpression + "-xpath expression can not be evaluated" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    private String iterateDocNodesAndGetPatchFilePath(Document docXslMappingFile, Document docXPDL, String vendorFromXPDLFile) {
        String patchFilePath = null;
        NodeList filePathNodes = this.getXPathResultNodeList(docXslMappingFile, "XSLFilePaths/XSLFilePath");
        for (int j = 0; j < filePathNodes.getLength(); ++j) {
            String vendorValue;
            Node filePathNode = filePathNodes.item(j);
            NamedNodeMap attrmap = filePathNode.getAttributes();
            Node vendorAttr = attrmap.getNamedItem("Vendor");
            Node conditionAttr = attrmap.getNamedItem("Condition");
            String conditionXPath = conditionAttr != null ? conditionAttr.getNodeValue() : null;
            String string = vendorValue = vendorAttr != null ? vendorAttr.getNodeValue() : null;
            if (conditionXPath != null && vendorValue != null) {
                if (!vendorValue.equals(vendorFromXPDLFile) || !this.getXPathResultBooleanValue(docXPDL, conditionXPath)) continue;
                patchFilePath = filePathNode.getTextContent();
                break;
            }
            if (conditionXPath != null && this.getXPathResultBooleanValue(docXPDL, conditionXPath)) {
                patchFilePath = filePathNode.getTextContent();
                break;
            }
            if (vendorValue == null || !vendorValue.equals(vendorFromXPDLFile)) continue;
            patchFilePath = filePathNode.getTextContent();
            break;
        }
        return patchFilePath;
    }

    private String getPatchFilePath(Document docXPDL, String tutorDirectoryPath) {
        String patchFilePath;
        block8: {
            LOG.info("finding vendor extensions");
            String vendorFromXPDLFile = this.getXPathResultString(docXPDL, "//Vendor/text()");
            vendorFromXPDLFile = vendorFromXPDLFile.trim();
            patchFilePath = null;
            try {
                if (tutorDirectoryPath != null) {
                    File tutorFolder = new File(tutorDirectoryPath);
                    if (tutorFolder.exists()) {
                        File xslMapFile = null;
                        boolean xslMapFileFound = false;
                        if (tutorFolder.isDirectory()) {
                            File[] tutorFolderFiles = tutorFolder.listFiles();
                            for (int i = 0; i < tutorFolderFiles.length; ++i) {
                                if (!"XSLFilePaths.xml".equals(tutorFolderFiles[i].getName())) continue;
                                xslMapFile = tutorFolderFiles[i];
                                Document docXslFilePath = this.getDocument(xslMapFile);
                                xslMapFileFound = true;
                                patchFilePath = this.iterateDocNodesAndGetPatchFilePath(docXslFilePath, docXPDL, vendorFromXPDLFile);
                                LOG.info("patch file path:" + patchFilePath);
                                break;
                            }
                            if (!xslMapFileFound) {
                                throw new FileNotFoundException("XSLFilePaths.xml File not found in directory:" + tutorFolder.getName());
                            }
                            break block8;
                        }
                        throw new FileNotFoundException(tutorDirectoryPath + " is not a directory. Patch file not found.");
                    }
                    throw new FileNotFoundException(tutorDirectoryPath + " does not exist");
                }
                InputStream xslFilePathsStream = this.getClass().getClassLoader().getResourceAsStream("XSLFilePaths.xml");
                if (xslFilePathsStream != null) {
                    Document docXslFilePath = this.getDocument(xslFilePathsStream);
                    patchFilePath = this.iterateDocNodesAndGetPatchFilePath(docXslFilePath, docXPDL, vendorFromXPDLFile);
                    break block8;
                }
                throw new RuntimeException("Unable to read XSLFilePaths.xml as resource.");
            }
            catch (FileNotFoundException e) {
                LOG.severe(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        return patchFilePath;
    }

    private PackageType readXPDLPackage(SAXSource ss) throws XPDLMarshallingException {
        PackageType pkg = null;
        try {
            JAXBElement jaxbEl = (JAXBElement)this._jaxbUnmarshaller.unmarshal((Source)ss);
            pkg = (PackageType)jaxbEl.getValue();
        }
        catch (JAXBException e) {
            throw new XPDLMarshallingException(e);
        }
        return pkg;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException, SAXException, ParserConfigurationException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.wfmc.xpdl21");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return unmarshaller;
    }

    private static void setPackageHeader(PackageType pkg, BusinessProcessDiagram bpd) {
        PackageHeader hdr = pkg.getPackageHeader();
        if (hdr != null) {
            List<VendorExtension> venext;
            if (hdr.getCreated() != null) {
                bpd.setCreationDate(hdr.getCreated().getValue());
            }
            if (hdr.getModificationDate() != null) {
                bpd.setModificationDate(hdr.getModificationDate().getValue());
            }
            if (hdr.getDescription() != null) {
                bpd.setDescription(hdr.getDescription().getValue());
            }
            if (hdr.getVendorExtensions() != null && (venext = hdr.getVendorExtensions().getVendorExtension()).size() > 0) {
                bpd.setToolID(venext.get(0).getToolId());
            }
            if ((bpd.getToolID() == null || "".equals(bpd.getToolID())) && hdr.getVendor() != null) {
                bpd.setToolID(hdr.getVendor().getValue());
            }
        } else {
            LOG.info("package header information not available");
        }
        if (pkg.getRedefinableHeader() != null) {
            if (pkg.getRedefinableHeader().getVersion() != null) {
                bpd.setVersion(pkg.getRedefinableHeader().getVersion().getValue());
            }
            if (pkg.getRedefinableHeader().getAuthor() != null) {
                bpd.setAuthor(pkg.getRedefinableHeader().getAuthor().getValue());
            }
        } else {
            LOG.info("RedefinableHeader info not available");
        }
        bpd.setCoordinateOrigin(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT);
        bpd.setMeasurementUnit("MM");
    }

    private static BusinessProcessDiagram[] convertToBPMN(PackageType pkg) {
        BusinessProcessDiagram[] bpdArray = null;
        BusinessProcessDiagram bpd = null;
        ConversionContext ctx = null;
        isReprocessableLanes = false;
        HashMap<String, ConversionContext> conversionContextMap = null;
        HashMap<String, BusinessProcessDiagram> bpdMap = null;
        if (pkg != null) {
            if (pkg.getPages() != null && pkg.getPages().getPage() != null && pkg.getPages().getPage().size() != 0) {
                bpdMap = new HashMap<String, BusinessProcessDiagram>();
            }
            List<ExtendedAttribute> extndAttributes = null;
            boolean isRelativeObjectCoordinates = true;
            if (pkg.getExtendedAttributes() != null && pkg.getExtendedAttributes().getExtendedAttribute() != null) {
                extndAttributes = pkg.getExtendedAttributes().getExtendedAttribute();
                for (ExtendedAttribute e : extndAttributes) {
                    if (!e.getName().equals("isRelativeObjectCoordinates")) continue;
                    isRelativeObjectCoordinates = e.getValue().toLowerCase().trim().equals("true");
                    break;
                }
            }
            if (bpdMap == null) {
                bpdArray = new BusinessProcessDiagram[]{new BusinessProcessDiagram(pkg.getId(), pkg.getName())};
                bpd = bpdArray[0];
                bpd.setRelativeObjectCoordinates(isRelativeObjectCoordinates);
                XPDLUnmarshaller.setPackageHeader(pkg, bpd);
                ctx = new ConversionContext(bpd, pkg);
            } else {
                int noOfPages = 0;
                if (pkg.getPages().getPage() != null) {
                    noOfPages = pkg.getPages().getPage().size();
                    conversionContextMap = new HashMap<String, ConversionContext>();
                    for (int i = 0; i < noOfPages; ++i) {
                        Page page = pkg.getPages().getPage().get(i);
                        BusinessProcessDiagram tempBPD = new BusinessProcessDiagram(inputFile.getName().substring(0, inputFile.getName().lastIndexOf(46)) + "-" + page.getId(), page.getName());
                        tempBPD.setRelativeObjectCoordinates(isRelativeObjectCoordinates);
                        bpdMap.put(page.getId(), tempBPD);
                        XPDLUnmarshaller.setPackageHeader(pkg, (BusinessProcessDiagram)bpdMap.get(page.getId()));
                        conversionContextMap.put(page.getId(), new ConversionContext((BusinessProcessDiagram)bpdMap.get(page.getId()), pkg));
                    }
                }
            }
            String page = null;
            if (pkg.getPools() != null) {
                List<org.wfmc.xpdl21.Pool> pools = pkg.getPools().getPool();
                LOG.info("creating bpmn pool,lane objects");
                for (org.wfmc.xpdl21.Pool pool : pools) {
                    if (pool.getNodeGraphicsInfos() != null && pool.getNodeGraphicsInfos().getNodeGraphicsInfo() != null) {
                        page = pool.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPageId();
                        if (page == null) {
                            page = pool.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPage();
                        }
                    } else if (pool.getLanes() != null && pool.getLanes().getLane() != null && pool.getLanes().getLane().size() != 0 && pool.getLanes().getLane().get(0).getNodeGraphicsInfos() != null && pool.getLanes().getLane().get(0).getNodeGraphicsInfos().getNodeGraphicsInfo() != null && (page = pool.getLanes().getLane().get(0).getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPageId()) == null) {
                        page = pool.getLanes().getLane().get(0).getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPage();
                    }
                    if (pkg.getPages() != null && page != null) {
                        ctx = (ConversionContext)conversionContextMap.get(page);
                        bpd = (BusinessProcessDiagram)bpdMap.get(page);
                    }
                    bpd.getPools().put(pool.getId(), XPDLUnmarshaller.createBPMNPool(pool, ctx));
                }
            }
            if (pkg.getWorkflowProcesses() != null) {
                List<ProcessType> wfprocesses = pkg.getWorkflowProcesses().getWorkflowProcess();
                for (ProcessType wfprocess : wfprocesses) {
                    if (wfprocess.getActivities() != null) {
                        LOG.info("creating bpmn flowObjects for '" + wfprocess.getName() + "' WorkFlowProcess");
                        for (Activity activity : wfprocess.getActivities().getActivity()) {
                            if (pkg.getPages() != null) {
                                page = activity.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPageId();
                                if (page == null) {
                                    page = activity.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPage();
                                }
                                ctx = (ConversionContext)conversionContextMap.get(page);
                            }
                            BusinessProcessDiagram tempBPD = ctx.getBPMNDiagram();
                            ctx.setXPDLProcess(wfprocess);
                            XPDLUnmarshaller.createBPMNActivity(activity, ctx);
                        }
                    }
                    if (wfprocess.getTransitions() == null) continue;
                    LOG.info("creating sequence flow objects for '" + wfprocess.getName() + "' WorkFlowProcess");
                    for (Transition trans : wfprocess.getTransitions().getTransition()) {
                        SequenceFlow bpmnFlow = null;
                        if (pkg.getPages() != null) {
                            page = trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPageId();
                            if (page == null) {
                                page = trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPage();
                            }
                            bpd = (BusinessProcessDiagram)bpdMap.get(page);
                            ctx = (ConversionContext)conversionContextMap.get(page);
                        }
                        XPDLUnmarshaller.modifyFlowCoordinates(ctx, trans);
                        bpmnFlow = XPDLUnmarshaller.createBPMNSequenceFlow(trans, ctx);
                        if (bpmnFlow == null) continue;
                        bpd.addFlow((ConnectingObject)bpmnFlow);
                    }
                }
            }
            if (pkg.getArtifacts() != null && pkg.getArtifacts().getArtifactAndAny().size() != 0) {
                LOG.info("creating bpmn artifact objects");
                for (Object artifact : pkg.getArtifacts().getArtifactAndAny()) {
                    if (!(artifact instanceof Artifact)) continue;
                    Artifact tempArtifact = (Artifact)artifact;
                    if (tempArtifact.getNodeGraphicsInfos() != null && pkg.getPages() != null) {
                        page = tempArtifact.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPageId();
                        if (page == null) {
                            page = tempArtifact.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0).getPage();
                        }
                        bpd = (BusinessProcessDiagram)bpdMap.get(page);
                        ctx = (ConversionContext)conversionContextMap.get(page);
                        bpd.addNode((FlowObject)XPDLUnmarshaller.createBPMNArtifact(tempArtifact, ctx));
                        continue;
                    }
                    bpd.addNode((FlowObject)XPDLUnmarshaller.createBPMNArtifact((Artifact)artifact, ctx));
                }
            }
            if (ctx.getBPMNDiagram().isRelativeObjectCoordinates()) {
                XPDLUnmarshaller.reassignLanesToActivities(ctx);
            }
            if (pkg.getMessageFlows() != null && pkg.getMessageFlows().getMessageFlowAndAny().size() != 0) {
                LOG.info("creating bpmn message flow objects");
                for (Object messageFLow : pkg.getMessageFlows().getMessageFlowAndAny()) {
                    if (!(messageFLow instanceof MessageFlow)) continue;
                    if (((MessageFlow)messageFLow).getConnectorGraphicsInfos() != null && pkg.getPages() != null) {
                        page = ((MessageFlow)messageFLow).getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPageId();
                        if (page == null) {
                            page = ((MessageFlow)messageFLow).getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPage();
                        }
                        bpd = (BusinessProcessDiagram)bpdMap.get(page);
                        ctx = (ConversionContext)conversionContextMap.get(page);
                    }
                    bpd.addFlow((ConnectingObject)XPDLUnmarshaller.createBPMNMessageFlow((MessageFlow)messageFLow, ctx));
                }
            }
            if (pkg.getAssociations() != null) {
                for (Object assoc : pkg.getAssociations().getAssociationAndAny()) {
                    if (!(assoc instanceof Association)) continue;
                    if (((Association)assoc).getConnectorGraphicsInfos() != null && pkg.getPages() != null) {
                        page = ((Association)assoc).getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPageId();
                        if (page == null) {
                            page = ((Association)assoc).getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getPage();
                        }
                        bpd = (BusinessProcessDiagram)bpdMap.get(page);
                        ctx = (ConversionContext)conversionContextMap.get(page);
                    }
                    bpd.addFlow((ConnectingObject)XPDLUnmarshaller.createBPMNAssociation((Association)assoc, ctx));
                }
            }
            if (isReprocessableLanes) {
                XPDLUnmarshaller.reprocessPoolsAndLanes(ctx);
            }
            XPDLUnmarshaller.setCompensation(bpd);
            XPDLUnmarshaller.removeUselessPools(bpd);
        }
        boolean redrawConnections = false;
        boolean layoutActivities = false;
        if (pkg.getExtendedAttributes() != null && pkg.getExtendedAttributes().getExtendedAttribute().size() != 0) {
            for (ExtendedAttribute temp : pkg.getExtendedAttributes().getExtendedAttribute()) {
                if ("redrawConnections".equalsIgnoreCase(temp.getName())) {
                    redrawConnections = temp.getValue().toLowerCase().trim().equalsIgnoreCase("true");
                    break;
                }
                if (!"LayoutActivities".equalsIgnoreCase(temp.getName())) continue;
                layoutActivities = temp.getValue().toLowerCase().trim().equals("true");
            }
        }
        if (bpdMap != null) {
            Set pageIdSet = bpdMap.keySet();
            Iterator pageIdSetIterator = pageIdSet.iterator();
            bpdArray = new BusinessProcessDiagram[pkg.getPages().getPage().size()];
            int i = 0;
            while (pageIdSetIterator.hasNext()) {
                bpdArray[i] = (BusinessProcessDiagram)bpdMap.get(pageIdSetIterator.next());
                ++i;
            }
        }
        if (layoutActivities) {
            for (BusinessProcessDiagram tempbpd : bpdArray) {
                tempbpd.layout(75.0, 50.0);
            }
        }
        if (redrawConnections) {
            for (BusinessProcessDiagram tempbpd : bpdArray) {
                for (ConnectingObject tempFlow : tempbpd.getAllFlows().values()) {
                    tempFlow.getPath().clear();
                }
            }
        }
        return bpdArray;
    }

    private static void reassignLanesToActivities(ConversionContext ctx) {
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            if (bpmnNode.getParentSubProcess() == null) continue;
            FlowObject parent = XPDLUnmarshaller.getToplevelSubprocess(bpmnNode);
            bpmnNode.setLane(parent.getLane());
        }
    }

    private static FlowObject getToplevelSubprocess(FlowObject bpmnNode) {
        if (bpmnNode.getParentSubProcess() == null) {
            return bpmnNode;
        }
        return XPDLUnmarshaller.getToplevelSubprocess((FlowObject)bpmnNode.getParentSubProcess());
    }

    private static void modifyFlowCoordinates(ConversionContext ctx, Transition trans) {
        PackageType pkg = ctx.getXPDLPackage();
        if (pkg.getExtendedAttributes() != null && pkg.getExtendedAttributes().getExtendedAttribute().size() != 0) {
            for (ExtendedAttribute ext : pkg.getExtendedAttributes().getExtendedAttribute()) {
                if (!ext.getName().equals("handleFlows") || !ext.getValue().equals("true")) continue;
                String directionPath = "";
                if (trans.getConnectorGraphicsInfos() != null && trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo() != null && trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getCoordinates() != null) {
                    for (ConnectorGraphicsInfo tempcgi : trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo()) {
                        Coordinates temp = tempcgi.getCoordinates().get(0);
                        for (Coordinates tempcoord : tempcgi.getCoordinates()) {
                            if (temp.getXCoordinate() - tempcoord.getXCoordinate() == 0.0 && temp.getYCoordinate() - tempcoord.getYCoordinate() == 0.0) continue;
                            if (temp.getXCoordinate() - tempcoord.getXCoordinate() == 0.0 && temp.getYCoordinate() - tempcoord.getYCoordinate() > 0.0) {
                                directionPath = directionPath.concat("up.");
                            } else if (temp.getXCoordinate() - tempcoord.getXCoordinate() == 0.0 && temp.getYCoordinate() - tempcoord.getYCoordinate() < 0.0) {
                                directionPath = directionPath.concat("down.");
                            } else if (temp.getXCoordinate() - tempcoord.getXCoordinate() > 0.0 && temp.getYCoordinate() - tempcoord.getYCoordinate() == 0.0) {
                                directionPath = directionPath.concat("left.");
                            } else if (temp.getXCoordinate() - tempcoord.getXCoordinate() < 0.0 && temp.getYCoordinate() - tempcoord.getYCoordinate() == 0.0) {
                                directionPath = directionPath.concat("right.");
                            }
                            temp = tempcoord;
                        }
                    }
                    XPDLUnmarshaller.setFlowPoints(trans, directionPath, ctx);
                    break;
                }
                LOG.warning("No sufficient info on ConnectorGraphicsInfo for transition id:" + trans.getId());
            }
        }
    }

    private static void setFlowPoints(Transition trans, String direction, ConversionContext ctx) {
        StringTokenizer st = new StringTokenizer(direction, ".");
        try {
            Activity source = Util.getActivityById(ctx.getXPDLProcess(), trans.getFrom());
            Activity target = Util.getActivityById(ctx.getXPDLProcess(), trans.getTo());
            if (source == null) {
                LOG.warning("Activity with Id:" + trans.getFrom() + " can not be found");
            } else if (target == null) {
                LOG.warning("Activity with Id:" + trans.getTo() + " can not be found");
            }
            if (source != null && target != null) {
                XPDLUnmarshaller.setFlowFirstPoint(trans, direction, source);
                List<Coordinates> coordinates = trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getCoordinates();
                Coordinates prevPoint = coordinates.get(0);
                int currPointCtr = 1;
                while (st.hasMoreTokens()) {
                    String currDir = st.nextToken();
                    Coordinates currPoint = coordinates.get(currPointCtr);
                    if (currDir.equalsIgnoreCase("up")) {
                        currPoint.setXCoordinate(prevPoint.getXCoordinate());
                        currPoint.setYCoordinate(prevPoint.getYCoordinate() - currPoint.getYCoordinate());
                    } else if (currDir.equalsIgnoreCase("down")) {
                        currPoint.setXCoordinate(prevPoint.getXCoordinate());
                        currPoint.setYCoordinate(prevPoint.getYCoordinate() + currPoint.getYCoordinate());
                    } else if (currDir.equalsIgnoreCase("left")) {
                        currPoint.setXCoordinate(prevPoint.getXCoordinate() - currPoint.getXCoordinate());
                        currPoint.setYCoordinate(prevPoint.getYCoordinate());
                    } else if (currDir.equalsIgnoreCase("right")) {
                        currPoint.setXCoordinate(prevPoint.getXCoordinate() + currPoint.getXCoordinate());
                        currPoint.setYCoordinate(prevPoint.getYCoordinate());
                    }
                    prevPoint = currPoint;
                    ++currPointCtr;
                }
                XPDLUnmarshaller.setFlowLastPoint(trans, direction, target);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    private static void setFlowLastPoint(Transition trans, String direction, Activity target) {
        Coordinates point = trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getCoordinates().get(trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getCoordinates().size() - 1);
        NodeGraphicsInfo tgt = target.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
        if (direction.endsWith("right.")) {
            point.setXCoordinate(tgt.getCoordinates().getXCoordinate());
        } else if (direction.endsWith("left.")) {
            point.setXCoordinate(tgt.getCoordinates().getXCoordinate() + tgt.getWidth());
        } else if (direction.endsWith("up.")) {
            point.setYCoordinate(tgt.getCoordinates().getYCoordinate() + tgt.getHeight());
        } else if (direction.endsWith("down.")) {
            point.setYCoordinate(tgt.getCoordinates().getYCoordinate());
        }
    }

    private static void setFlowFirstPoint(Transition trans, String direction, Activity source) {
        Coordinates point = trans.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0).getCoordinates().get(0);
        NodeGraphicsInfo src = source.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
        if (direction.startsWith("right")) {
            point.setXCoordinate(src.getCoordinates().getXCoordinate() + src.getWidth());
            point.setYCoordinate(src.getCoordinates().getYCoordinate() + src.getHeight() / 2.0);
        } else if (direction.startsWith("left")) {
            point.setXCoordinate(src.getCoordinates().getXCoordinate());
            point.setYCoordinate(src.getCoordinates().getYCoordinate() + src.getHeight() / 2.0);
        } else if (direction.startsWith("up")) {
            point.setXCoordinate(src.getCoordinates().getXCoordinate() + src.getWidth() / 2.0);
            point.setYCoordinate(src.getCoordinates().getYCoordinate());
        } else if (direction.startsWith("down")) {
            point.setXCoordinate(src.getCoordinates().getXCoordinate() + src.getWidth() / 2.0);
            point.setYCoordinate(src.getCoordinates().getYCoordinate() + src.getHeight());
        }
    }

    private static void reprocessPoolsAndLanes(ConversionContext ctx) {
        block6: {
            String orientation;
            double maxYHeightSum;
            double padding;
            BusinessProcessDiagram bpd;
            block5: {
                bpd = ctx.getBPMNDiagram();
                padding = -1.0;
                double maxXWidthSum = 0.0;
                maxYHeightSum = 0.0;
                orientation = (String)((Pool)bpd.getPools().values().toArray()[0]).getAttribute("orientation");
                orientation = orientation != null ? orientation : "horizontal";
                for (FlowObject tempFlowObject : bpd.getAllNodes().values()) {
                    String flowObjectType = (String)tempFlowObject.getAttribute("type");
                    if (flowObjectType == null || !flowObjectType.equalsIgnoreCase("event") || padding != -1.0) continue;
                    padding = tempFlowObject.getWidthd();
                    break;
                }
                if (!orientation.equalsIgnoreCase("horizontal")) break block5;
                for (Pool tempPool : bpd.getPools().values()) {
                    maxXWidthSum = XPDLUnmarshaller.maxXWidthSumOfPool(ctx, tempPool.getID());
                    for (oracle.tutor.bpmn.Lane tempLane : tempPool.getLanes().values()) {
                        if (!(maxXWidthSum >= tempLane.getWidthd() + tempLane.getXd())) continue;
                        XPDLUnmarshaller.setAllLanesWidth(tempPool.getLanes().values(), maxXWidthSum, padding);
                        break;
                    }
                    tempPool.setWidth(maxXWidthSum + padding);
                }
                break block6;
            }
            if (!orientation.equalsIgnoreCase("vertical")) break block6;
            for (Pool tempPool : bpd.getPools().values()) {
                maxYHeightSum = XPDLUnmarshaller.maxYHeightSumOfPool(ctx, tempPool.getID());
                for (oracle.tutor.bpmn.Lane tempLane : tempPool.getLanes().values()) {
                    if (!(maxYHeightSum >= tempLane.getHeightd() + tempLane.getYd())) continue;
                    XPDLUnmarshaller.setAllLanesHeight(tempPool.getLanes().values(), maxYHeightSum, padding);
                    break;
                }
                tempPool.setHeight(maxYHeightSum + padding);
            }
        }
    }

    private static double maxXWidthSumOfPool(ConversionContext ctx, String poolId) {
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        double maxXWidthSum = 0.0;
        for (FlowObject bpmnFlowObject : bpd.getAllNodes().values()) {
            String tempPoolId = bpmnFlowObject.getLane() instanceof oracle.tutor.bpmn.Lane ? bpmnFlowObject.getLane().getPool().getID() : bpmnFlowObject.getLane().getID();
            if (!tempPoolId.equals(poolId)) continue;
            maxXWidthSum = Math.max(maxXWidthSum, bpmnFlowObject.getXd() + bpmnFlowObject.getWidthd());
        }
        return maxXWidthSum;
    }

    private static double maxYHeightSumOfPool(ConversionContext ctx, String poolId) {
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        double maxYHeightSum = 0.0;
        for (FlowObject bpmnFlowObject : bpd.getAllNodes().values()) {
            String tempPoolId;
            if (bpmnFlowObject.getLane() == null || bpmnFlowObject.getLane().getPool() == null || !(tempPoolId = bpmnFlowObject.getLane() instanceof oracle.tutor.bpmn.Lane ? bpmnFlowObject.getLane().getPool().getID() : bpmnFlowObject.getLane().getID()).equals(poolId)) continue;
            maxYHeightSum = Math.max(maxYHeightSum, bpmnFlowObject.getYd() + bpmnFlowObject.getHeightd());
        }
        return maxYHeightSum;
    }

    private static void setAllLanesWidth(Collection<oracle.tutor.bpmn.Lane> bpmnLanes, double maxXWidthSum, double padding) {
        for (oracle.tutor.bpmn.Lane tempLane : bpmnLanes) {
            double difference = maxXWidthSum - tempLane.getWidthd() - tempLane.getXd();
            tempLane.setWidth(tempLane.getWidthd() + difference + padding);
        }
    }

    private static void setAllPoolsWidth(Collection<Pool> bpmnPools, double maxXWidthSum, double padding) {
        for (Pool tempPool : bpmnPools) {
            double difference = maxXWidthSum - tempPool.getWidthd() - tempPool.getXd();
            tempPool.setWidth(tempPool.getWidthd() + difference + padding);
        }
    }

    private static void setAllLanesHeight(Collection<oracle.tutor.bpmn.Lane> bpmnLanes, double maxYHeightSum, double padding) {
        for (oracle.tutor.bpmn.Lane tempLane : bpmnLanes) {
            double difference = maxYHeightSum - tempLane.getHeightd() - tempLane.getYd();
            tempLane.setHeight(tempLane.getHeightd() + difference + padding);
        }
    }

    private static void setAllPoolsHeight(Collection<Pool> bpmnPools, double maxYHeightSum, double padding) {
        for (Pool tempPool : bpmnPools) {
            double difference = maxYHeightSum - tempPool.getHeightd() - tempPool.getYd();
            tempPool.setHeight(tempPool.getHeightd() + difference + padding);
        }
    }

    private static void setCompensation(BusinessProcessDiagram bpd) {
        for (FlowObject node : bpd.getAllNodes().values()) {
            Event event;
            if (!(node instanceof Event) || (event = (Event)node).getTrigger() != Event.Trigger.COMPENSATION) continue;
            for (ConnectingObject connector : event.getOutflows()) {
                GraphicalElement toNode = connector.getTo();
                if (!(toNode instanceof oracle.tutor.bpmn.Task) && !(toNode instanceof Subprocess)) continue;
                ((oracle.tutor.bpmn.Activity)toNode).setCompensation(Boolean.valueOf(true));
            }
        }
    }

    private static void removeUselessPools(BusinessProcessDiagram bpd) {
        Iterator iter = bpd.getPools().entrySet().iterator();
        while (iter.hasNext()) {
            Pool pool = (Pool)iter.next().getValue();
            if (!XPDLUnmarshaller.isPoolUseless(pool)) continue;
            iter.remove();
        }
    }

    private static boolean isPoolUseless(Pool pool) {
        if (!Util.getSwimlaneNodes((Swimlane)pool).isEmpty()) {
            return false;
        }
        for (oracle.tutor.bpmn.Lane lane : pool.getLanes().values()) {
            if (Util.getSwimlaneNodes((Swimlane)lane).isEmpty()) continue;
            return false;
        }
        return pool.getWidth() == 0.0f && pool.getHeight() == 0.0f;
    }

    private static Map<String, FlowObject> convertToBPMNNodeSet(String activitySetId, ConversionContext ctx) {
        HashMap<String, FlowObject> nodes = new HashMap<String, FlowObject>();
        ActivitySet actSet = Util.getActivitySetById(ctx.getXPDLProcess(), activitySetId);
        if (actSet == null) {
            LOG.warning("XPDL activity set not found: id=" + activitySetId);
        } else if (actSet.getActivities() != null) {
            for (Activity act : actSet.getActivities().getActivity()) {
                FlowObject bpmnNode = XPDLUnmarshaller.createBPMNActivity(act, ctx);
                nodes.put(bpmnNode.getID(), bpmnNode);
            }
        }
        return nodes;
    }

    private static Pool createBPMNPool(org.wfmc.xpdl21.Pool pool, ConversionContext ctx) {
        Pool bpmnPool = new Pool(pool.getId(), pool.getName(), ctx.getBPMNDiagram());
        bpmnPool.setVisible(Boolean.valueOf(pool.isBoundaryVisible()));
        if (pool.getLanes() != null) {
            for (Lane lane : pool.getLanes().getLane()) {
                bpmnPool.getLanes().put(lane.getId(), XPDLUnmarshaller.createBPMNLane(lane, bpmnPool, ctx));
            }
        }
        if (pool.getNodeGraphicsInfos() != null && pool.getNodeGraphicsInfos().getNodeGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(pool.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0), (GraphicalElement)bpmnPool, ctx);
        }
        if (pool.getLanes() != null) {
            for (Lane lane : pool.getLanes().getLane()) {
                oracle.tutor.bpmn.Lane bpmnParentLane = bpmnPool.getLane((Object)lane.getParentLane());
                if (bpmnParentLane == null) continue;
                bpmnPool.getLane((Object)lane.getId()).setParentLane(bpmnParentLane);
            }
        }
        bpmnPool.setAttribute("orientation", (Object)pool.getOrientation());
        return bpmnPool;
    }

    private static oracle.tutor.bpmn.Lane createBPMNLane(Lane lane, Pool bpmnPool, ConversionContext ctx) {
        oracle.tutor.bpmn.Lane bpmnLane = new oracle.tutor.bpmn.Lane(lane.getId(), lane.getName());
        bpmnLane.setPool(bpmnPool);
        List<Lane.NestedLane> nestedLanes = lane.getNestedLane();
        HashMap<String, oracle.tutor.bpmn.Lane> bpmnNestedLanes = new HashMap<String, oracle.tutor.bpmn.Lane>();
        for (Lane.NestedLane nestedLane : nestedLanes) {
            String laneId = nestedLane.getLaneId();
            bpmnNestedLanes.put(laneId, bpmnPool.getLane((Object)laneId));
        }
        bpmnLane.setLanes(bpmnNestedLanes);
        if (lane.getNodeGraphicsInfos() != null && lane.getNodeGraphicsInfos().getNodeGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(lane.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0), (GraphicalElement)bpmnLane, ctx);
        }
        return bpmnLane;
    }

    private static FlowObject createBPMNActivity(Activity activity, ConversionContext ctx) {
        FlowObject bpmnActivity = null;
        if (activity.getImplementation() != null) {
            if (activity.getImplementation().getTask() != null || activity.getImplementation().getNo() != null) {
                bpmnActivity = XPDLUnmarshaller.createBPMNTask(activity, ctx);
            } else if (activity.getImplementation().getReference() != null) {
                bpmnActivity = XPDLUnmarshaller.createBPMNReference(activity, ctx);
            } else if (activity.getImplementation().getSubFlow() != null) {
                bpmnActivity = XPDLUnmarshaller.createBPMNSubprocess(activity, ctx);
            }
        } else if (activity.getBlockActivity() != null) {
            bpmnActivity = XPDLUnmarshaller.createBPMNSubprocess(activity, ctx);
        } else if (activity.getEvent() != null) {
            bpmnActivity = XPDLUnmarshaller.createBPMNEvent(activity, ctx);
        } else if (activity.getRoute() != null) {
            bpmnActivity = XPDLUnmarshaller.createBPMNGateway(activity, ctx);
        } else {
            LOG.info(activity.getId() + " != event,subprocess,route,task");
        }
        if (bpmnActivity == null) {
            bpmnActivity = new oracle.tutor.bpmn.Task(activity.getId(), activity.getName());
            ((oracle.tutor.bpmn.Task)bpmnActivity).setTaskType(Task.TaskType.NONE);
        }
        bpmnActivity.setModel(ctx.getBPMNDiagram());
        if (bpmnActivity instanceof oracle.tutor.bpmn.Activity) {
            oracle.tutor.bpmn.Activity act = (oracle.tutor.bpmn.Activity)bpmnActivity;
            act.setLoopType(XPDLUnmarshaller.getBPMNActivityLoopType(activity));
            if (activity.getDescription() != null) {
                bpmnActivity.setDocumentation(activity.getDescription().getValue());
            }
        }
        if (bpmnActivity instanceof Subprocess && ((Subprocess)bpmnActivity).isExpanded().booleanValue()) {
            NodeGraphicsInfo subprocessNGI = activity.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
            Double tempspWidth = subprocessNGI.getWidth();
            Double tempspHeight = subprocessNGI.getHeight();
            if (tempspWidth == null || tempspWidth != null && tempspWidth == 0.0 || tempspHeight == null || tempspHeight != null && tempspHeight == 0.0) {
                XPDLUnmarshaller.setSubprocessWidthAndHeight((Subprocess)bpmnActivity, activity, ctx);
            }
        }
        if (activity.getNodeGraphicsInfos() != null && activity.getNodeGraphicsInfos().getNodeGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(activity.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0), (GraphicalElement)bpmnActivity, ctx);
        } else {
            ctx.getBPMNDiagram().addNode(bpmnActivity);
        }
        return bpmnActivity;
    }

    private static FlowObject createBPMNGateway(Activity activity, ConversionContext ctx) {
        Gateway bpmnGateway = new Gateway(activity.getId(), activity.getName());
        bpmnGateway.setGatewayType(XPDLUnmarshaller.getBPMNGatewayType(activity.getRoute()));
        bpmnGateway.setMarkerVisible(Boolean.valueOf(activity.getRoute().isMarkerVisible()));
        return bpmnGateway;
    }

    private static FlowObject createBPMNEvent(Activity activity, ConversionContext ctx) {
        Event bpmnEvent = new Event(activity.getId(), activity.getName());
        bpmnEvent.setEventType(XPDLUnmarshaller.getBPMNEventType(activity.getEvent()));
        bpmnEvent.setTrigger(XPDLUnmarshaller.getBPMNTrigger(activity.getEvent()));
        bpmnEvent.setDirection(XPDLUnmarshaller.getBPMNEventDirection(activity.getEvent()));
        if (bpmnEvent.getEventType() == Event.EventType.INTERMEDIATE) {
            String targetId = activity.getEvent().getIntermediateEvent().getTarget();
            FlowObject node = (FlowObject)ctx.getBPMNDiagram().getAllNodes().get(targetId);
            if (node instanceof oracle.tutor.bpmn.Activity) {
                bpmnEvent.setTarget((oracle.tutor.bpmn.Activity)node);
            } else if (targetId != null) {
                LOG.warning("Missing attached event's target activity: id=" + targetId);
            }
        }
        bpmnEvent.setAttribute("type", (Object)"event");
        return bpmnEvent;
    }

    private static FlowObject createBPMNSubprocess(Activity activity, ConversionContext ctx) {
        BlockActivity blockActivity;
        Subprocess bpmnSubprocess = new Subprocess(activity.getId(), activity.getName());
        bpmnSubprocess.setSubprocessType(XPDLUnmarshaller.getBPMNSubprocesType(activity));
        bpmnSubprocess.setTransaction(Boolean.valueOf(activity.isIsATransaction()));
        if (activity.getImplementation() != null && activity.getImplementation().getSubFlow() != null) {
            SubFlow xpdlSubFlow = activity.getImplementation().getSubFlow();
            bpmnSubprocess.setModelReference(xpdlSubFlow.getId());
            boolean expanded = "EXPANDED".equals(xpdlSubFlow.getView());
            bpmnSubprocess.setExpanded(Boolean.valueOf(expanded));
        }
        if ((blockActivity = activity.getBlockActivity()) != null) {
            String actSetId = blockActivity.getActivitySetId();
            ctx.setBPMNSubprocess(bpmnSubprocess);
            bpmnSubprocess.setAllNodes(XPDLUnmarshaller.convertToBPMNNodeSet(actSetId, ctx));
            for (FlowObject subnode : bpmnSubprocess.getAllNodes().values()) {
                subnode.setParentSubProcess(bpmnSubprocess);
            }
            boolean expanded = "EXPANDED".equals(blockActivity.getView());
            bpmnSubprocess.setExpanded(Boolean.valueOf(expanded));
            bpmnSubprocess.setID(actSetId);
            ActivitySet xpdlActSet = Util.getActivitySetById(ctx.getXPDLProcess(), actSetId);
            bpmnSubprocess.setAdHoc(Boolean.valueOf(xpdlActSet.isAdHoc()));
            if (xpdlActSet.getTransitions() != null) {
                for (Transition trans : xpdlActSet.getTransitions().getTransition()) {
                    ctx.getBPMNDiagram().addFlow((ConnectingObject)XPDLUnmarshaller.createBPMNSequenceFlow(trans, ctx));
                }
            }
            ctx.setBPMNSubprocess(null);
        }
        return bpmnSubprocess;
    }

    private static void setSubprocessWidthAndHeight(Subprocess subprocess, Activity rawActivity, ConversionContext ctx) {
        ProcessType process = ctx.getXPDLProcess();
        List<ActivitySet> activitySets = process.getActivitySets().getActivitySet();
        if (activitySets != null) {
            for (ActivitySet tempActSet : activitySets) {
                if (!tempActSet.getId().equals(subprocess.getID())) continue;
                List<Activity> activities = tempActSet.getActivities().getActivity();
                double padding = 0.0;
                double minY = Double.MAX_VALUE;
                double minX = Double.MAX_VALUE;
                double maxYAndHeightSum = 0.0;
                double maxXAndWidthSum = 0.0;
                FlowObject tempMaxHeightActivity = null;
                FlowObject tempMaxWidthActivity = null;
                for (Activity child : activities) {
                    FlowObject tempbpmnActivity = null;
                    tempbpmnActivity = child.getBlockActivity() != null ? ctx.getBPMNDiagram().getNode(child.getBlockActivity().getActivitySetId()) : ctx.getBPMNDiagram().getNode(child.getId());
                    double actX = tempbpmnActivity.getXd();
                    double actY = tempbpmnActivity.getYd();
                    minX = Math.min(minX, actX);
                    minY = Math.min(minY, actY);
                    if (maxXAndWidthSum < tempbpmnActivity.getXd() + tempbpmnActivity.getWidthd()) {
                        maxXAndWidthSum = Math.max(maxXAndWidthSum, actX + tempbpmnActivity.getWidthd());
                        tempMaxWidthActivity = tempbpmnActivity;
                    }
                    if (maxYAndHeightSum < tempbpmnActivity.getYd() + tempbpmnActivity.getHeightd()) {
                        maxYAndHeightSum = Math.max(maxYAndHeightSum, actY + tempbpmnActivity.getHeightd());
                        tempMaxHeightActivity = tempbpmnActivity;
                    }
                    if (padding != 0.0 || (child.getImplementation() == null || child.getImplementation().getTask() == null) && (child.getEvent() == null || padding != 0.0)) continue;
                    padding = tempbpmnActivity.getHeightd() / 2.0;
                }
                subprocess.setWidth(tempMaxWidthActivity.getXd() - minX + tempMaxWidthActivity.getWidthd() + 2.0 * padding);
                subprocess.setHeight(tempMaxHeightActivity.getYd() - minY + tempMaxHeightActivity.getHeightd() + 2.0 * padding);
                subprocess.setX(minX - padding);
                subprocess.setY(minY - padding);
                NodeGraphicsInfo rawActNGI = rawActivity.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                rawActNGI.setWidth(tempMaxWidthActivity.getXd() - minX + tempMaxWidthActivity.getWidthd() + 2.0 * padding);
                rawActNGI.setHeight(tempMaxHeightActivity.getYd() - minY + tempMaxHeightActivity.getHeightd() + 2.0 * padding);
                rawActNGI.getCoordinates().setXCoordinate(minX - padding);
                rawActNGI.getCoordinates().setYCoordinate(minY - padding);
                subprocess.setAttribute("isResized", (Object)"true");
                break;
            }
        }
    }

    private static FlowObject createBPMNReference(Activity activity, ConversionContext ctx) {
        FlowObject bpmnActivity = null;
        Reference reference = activity.getImplementation().getReference();
        String refActivityId = reference.getActivityId();
        if (refActivityId != null) {
            Activity referencedActivity = Util.getActivityById(ctx.getXPDLProcess(), refActivityId);
            FlowObject referencedNode = ctx.getBPMNDiagram().getNode(refActivityId);
            if (referencedNode == null && referencedActivity != null) {
                XPDLUnmarshaller.createBPMNActivity(referencedActivity, ctx);
                referencedNode = ctx.getBPMNDiagram().getNode(refActivityId);
            }
            if (referencedActivity != null) {
                if (referencedNode instanceof oracle.tutor.bpmn.Task) {
                    bpmnActivity = XPDLUnmarshaller.createBPMNTask(referencedActivity, ctx);
                } else if (referencedNode instanceof Subprocess) {
                    bpmnActivity = new Subprocess();
                    ((Subprocess)bpmnActivity).setSubprocessType(Subprocess.SubprocessType.REFERENCE);
                    ((Subprocess)bpmnActivity).setSubprocessReference((Subprocess)referencedNode);
                    ((Subprocess)bpmnActivity).setExpanded(((Subprocess)referencedNode).isExpanded());
                } else {
                    bpmnActivity = XPDLUnmarshaller.createBPMNTask(referencedActivity, ctx);
                    LOG.warning("Reference to null activity: id=" + refActivityId + ". (id is null or referred activity is defined after in input file)");
                }
                bpmnActivity.setID(activity.getId());
                bpmnActivity.setName(activity.getName());
            }
        }
        return bpmnActivity;
    }

    private static FlowObject createBPMNTask(Activity activity, ConversionContext ctx) {
        oracle.tutor.bpmn.Task bpmnActivity = new oracle.tutor.bpmn.Task(activity.getId(), activity.getName());
        if (activity.getImplementation().getTask() != null) {
            bpmnActivity.setTaskType(XPDLUnmarshaller.getBPMNTaskType(activity.getImplementation().getTask()));
        }
        return bpmnActivity;
    }

    private static Activity.LoopType getBPMNActivityLoopType(Activity activity) {
        Activity.LoopType loopType = Activity.LoopType.NONE;
        if (activity.getLoop() != null && activity.getLoop().getLoopType() != null) {
            String xpdlLoopType = activity.getLoop().getLoopType();
            if ("Standard".equals(xpdlLoopType)) {
                loopType = Activity.LoopType.STANDARD;
            } else if ("MultiInstance".equals(xpdlLoopType)) {
                loopType = Activity.LoopType.MULTIINSTANCE;
            }
        }
        return loopType;
    }

    private static SequenceFlow createBPMNSequenceFlow(Transition transition, ConversionContext ctx) {
        SequenceFlow sequenceFlow = null;
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        FlowObject srcNode = bpd.getNode(transition.getFrom());
        FlowObject destNode = bpd.getNode(transition.getTo());
        if (srcNode != null && destNode != null) {
            sequenceFlow = new SequenceFlow(transition.getId(), transition.getName() == null ? "" : transition.getName(), (GraphicalElement)srcNode, (GraphicalElement)destNode);
            if (transition.getDescription() != null) {
                sequenceFlow.setDocumentation(transition.getDescription().getValue());
            }
            if (transition.getCondition() != null) {
                if (sequenceFlow.getName().equals("") && transition.getCondition().getType() != null && transition.getCondition().getType().equals("CONDITION") && transition.getCondition().getContent() != null) {
                    for (int i = 0; i < transition.getCondition().getContent().size(); ++i) {
                        Serializable ele = transition.getCondition().getContent().get(i);
                        if (ele instanceof JAXBElement) {
                            JAXBElement elejaxb = (JAXBElement)ele;
                            if (!elejaxb.getName().getLocalPart().equals("Expression") || ((ExpressionType)elejaxb.getValue()).getContent() == null || ((ExpressionType)elejaxb.getValue()).getContent().size() == 0 || ((ExpressionType)elejaxb.getValue()).getContent() == null) continue;
                            sequenceFlow.setName((String)((ExpressionType)elejaxb.getValue()).getContent().get(0));
                            break;
                        }
                        if (!(ele instanceof String)) continue;
                        String value = (String)((Object)ele);
                        System.out.println(value);
                        sequenceFlow.setName(value);
                    }
                }
                sequenceFlow.setConditional(Boolean.valueOf("CONDITION".equals(transition.getCondition().getType()) || "EXCEPTION".equals(transition.getCondition().getType())));
                sequenceFlow.setDefault(Boolean.valueOf("OTHERWISE".equals(transition.getCondition().getType())));
            } else {
                sequenceFlow.setConditional(Boolean.valueOf(false));
                sequenceFlow.setDefault(Boolean.valueOf(false));
            }
            if (transition.getConnectorGraphicsInfos() != null && transition.getConnectorGraphicsInfos().getConnectorGraphicsInfo().size() > 0) {
                XPDLUnmarshaller.applyGraphicsInfo(transition.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0), (ConnectingObject)sequenceFlow, ctx);
            }
        }
        return sequenceFlow;
    }

    private static oracle.tutor.bpmn.Artifact createBPMNArtifact(Artifact artifact, ConversionContext ctx) {
        DataObject bpmnArtifact = null;
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        if ("DataObject".equals(artifact.getArtifactType())) {
            bpmnArtifact = artifact.getDataObject() != null ? new DataObject(artifact.getId(), artifact.getDataObject().getName(), bpd) : new DataObject(artifact.getId(), artifact.getName(), bpd);
        } else if ("Group".equals(artifact.getArtifactType())) {
            bpmnArtifact = new Group(artifact.getId(), artifact.getName(), bpd);
        } else if ("Annotation".equals(artifact.getArtifactType())) {
            bpmnArtifact = new Annotation(artifact.getId(), artifact.getTextAnnotation(), bpd);
        }
        Map<QName, String> tempMap = artifact.getOtherAttributes();
        if (tempMap != null) {
            Set<QName> keySet = tempMap.keySet();
            Object[] keys = keySet.toArray();
            for (int i = 0; i < keys.length; ++i) {
                if (!((QName)keys[i]).toString().equals("ActivitySetId")) continue;
                bpmnArtifact.setAttribute("ActivitySetId", (Object)tempMap.get(keys[i]));
                FlowObject subprocess = bpd.getNode(tempMap.get(keys[i]));
                bpmnArtifact.setParentSubProcess((Subprocess)subprocess);
            }
        }
        if (artifact.getNodeGraphicsInfos() != null && artifact.getNodeGraphicsInfos().getNodeGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(artifact.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0), (GraphicalElement)bpmnArtifact, ctx);
        }
        return bpmnArtifact;
    }

    private static oracle.tutor.bpmn.Association createBPMNAssociation(Association association, ConversionContext ctx) {
        oracle.tutor.bpmn.Association bpmnAssoc = null;
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        FlowObject srcNode = bpd.getNode(association.getSource());
        FlowObject destNode = bpd.getNode(association.getTarget());
        if (srcNode != null && destNode != null) {
            bpmnAssoc = new oracle.tutor.bpmn.Association(association.getId(), association.getName(), (GraphicalElement)srcNode, (GraphicalElement)destNode);
            bpmnAssoc.setDirection(XPDLUnmarshaller.getBPMNAssociationDirection(association));
        }
        if (association.getConnectorGraphicsInfos() != null && association.getConnectorGraphicsInfos().getConnectorGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(association.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0), (ConnectingObject)bpmnAssoc, ctx);
        }
        return bpmnAssoc;
    }

    private static oracle.tutor.bpmn.MessageFlow createBPMNMessageFlow(MessageFlow messageFlow, ConversionContext ctx) {
        oracle.tutor.bpmn.MessageFlow bpmnMesFlow = null;
        BusinessProcessDiagram bpd = ctx.getBPMNDiagram();
        GraphicalElement srcNode = (GraphicalElement)bpd.getGraphicalElements().get(messageFlow.getSource());
        GraphicalElement destNode = (GraphicalElement)bpd.getGraphicalElements().get(messageFlow.getTarget());
        if (srcNode != null && destNode != null) {
            bpmnMesFlow = new oracle.tutor.bpmn.MessageFlow(messageFlow.getId(), messageFlow.getName(), srcNode, destNode);
            bpmnMesFlow.setDocumentation(messageFlow.getTarget());
        }
        if (messageFlow.getConnectorGraphicsInfos() != null && messageFlow.getConnectorGraphicsInfos().getConnectorGraphicsInfo().size() > 0) {
            XPDLUnmarshaller.applyGraphicsInfo(messageFlow.getConnectorGraphicsInfos().getConnectorGraphicsInfo().get(0), (ConnectingObject)bpmnMesFlow, ctx);
        }
        return bpmnMesFlow;
    }

    private static Task.TaskType getBPMNTaskType(Task task) {
        Task.TaskType tt = Task.TaskType.NONE;
        if (task.getTaskManual() != null) {
            tt = Task.TaskType.MANUAL;
        } else if (task.getTaskReceive() != null) {
            tt = Task.TaskType.RECEIVE;
        } else if (task.getTaskReference() != null) {
            tt = Task.TaskType.REFERENCE;
        } else if (task.getTaskScript() != null) {
            tt = Task.TaskType.SCRIPT;
        } else if (task.getTaskSend() != null) {
            tt = Task.TaskType.SEND;
        } else if (task.getTaskService() != null) {
            tt = Task.TaskType.SERVICE;
        } else if (task.getTaskUser() != null) {
            tt = Task.TaskType.USER;
        }
        return tt;
    }

    private static void applyGraphicsInfo(NodeGraphicsInfo graphicsInfo, GraphicalElement bpmnElement, ConversionContext ctx) {
        Event bpmnEvent;
        oracle.tutor.bpmn.Activity target;
        if (graphicsInfo.getWidth() != null) {
            bpmnElement.setWidth(graphicsInfo.getWidth().doubleValue());
        }
        if (graphicsInfo.getHeight() != null) {
            bpmnElement.setHeight(graphicsInfo.getHeight().doubleValue());
        }
        if (graphicsInfo.getCoordinates() != null) {
            double x = 0.0;
            double y = 0.0;
            if (graphicsInfo.getCoordinates().getXCoordinate() != null) {
                x = graphicsInfo.getCoordinates().getXCoordinate();
            }
            if (graphicsInfo.getCoordinates().getYCoordinate() != null) {
                y = graphicsInfo.getCoordinates().getYCoordinate();
            }
            bpmnElement.setPosition(x, y);
        }
        XPDLUnmarshaller.setParentLane(graphicsInfo, bpmnElement, ctx);
        if (bpmnElement instanceof Event && (target = (bpmnEvent = (Event)bpmnElement).getTarget()) != null) {
            bpmnEvent.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
            if (target instanceof Subprocess && ((Subprocess)target).isExpanded().booleanValue() && target.getAttribute("isResized") != null && target.getAttribute("isResized").equals("true")) {
                int noOfAttachedEvents = target.getAttachedEvents().size();
                bpmnElement.setPosition(target.getX() + (float)(noOfAttachedEvents * 50), target.getY() + target.getHeight());
            }
        }
        XPDLUnmarshaller.stretchBPMNContainer(bpmnElement, ctx);
    }

    private static void setParentLane(NodeGraphicsInfo graphicsInfo, GraphicalElement bpmnElement, ConversionContext ctx) {
        if (bpmnElement instanceof FlowObject) {
            FlowObject flowObject = (FlowObject)bpmnElement;
            if (ctx.getBPMNDiagram().getPools().size() == 0) {
                ctx.getBPMNDiagram().addNode(flowObject);
            } else if (graphicsInfo.getLaneId() != null) {
                oracle.tutor.bpmn.Lane lane = null;
                for (Pool pool : flowObject.getModel().getPools().values()) {
                    lane = pool.getLane((Object)graphicsInfo.getLaneId());
                    if (lane == null) continue;
                    flowObject.setLane(lane);
                    break;
                }
            } else {
                XPDLUnmarshaller.setNodeLaneByCoordinates(flowObject, ctx);
            }
        }
    }

    private static void stretchBPMNContainer(GraphicalElement bpmnElement, ConversionContext ctx) {
        Subprocess container = null;
        boolean isInSubprocess = false;
        if (bpmnElement instanceof oracle.tutor.bpmn.Lane) {
            if (!(bpmnElement.getWidthd() != 0.0 && bpmnElement.getHeightd() != 0.0 || isReprocessableLanes)) {
                isReprocessableLanes = true;
            }
            if ((container = ((oracle.tutor.bpmn.Lane)bpmnElement).getParentLane()) == null) {
                container = ((oracle.tutor.bpmn.Lane)bpmnElement).getPool();
            }
        } else if (bpmnElement instanceof FlowObject) {
            container = ((FlowObject)bpmnElement).getParentSubProcess();
            if (container == null) {
                container = ((FlowObject)bpmnElement).getLane();
            } else {
                isInSubprocess = true;
            }
        }
        if (container != null) {
            org.wfmc.xpdl21.Pool tempPoolContainer;
            NodeGraphicsInfo graphicsInfo = null;
            if (container instanceof Subprocess) {
                Activity tempSubprocessContainer = Util.getActivityById(ctx.getXPDLProcess(), container.getID());
                if (tempSubprocessContainer.getNodeGraphicsInfos() != null) {
                    graphicsInfo = tempSubprocessContainer.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                }
            } else if (container instanceof oracle.tutor.bpmn.Lane) {
                Lane tempLaneContainer = Util.getLaneById(ctx.getXPDLPackage(), container.getID());
                if (tempLaneContainer.getNodeGraphicsInfos() != null) {
                    graphicsInfo = tempLaneContainer.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                }
            } else if (container instanceof Pool && (tempPoolContainer = Util.getPoolById(ctx.getXPDLPackage(), container.getID())).getNodeGraphicsInfos() != null) {
                graphicsInfo = tempPoolContainer.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
            }
            if (graphicsInfo != null && graphicsInfo.getHeight() != null && graphicsInfo.getHeight() != 0.0 && graphicsInfo.getWidth() != null && graphicsInfo.getWidth() != 0.0) {
                container = null;
            }
        }
        if (container != null) {
            Coordinate containerRB = XPDLUnmarshaller.getRightBottom((GraphicalElement)container);
            Coordinate elementRB = XPDLUnmarshaller.getRightBottom(bpmnElement);
            if (container instanceof oracle.tutor.bpmn.Lane && ctx.getBPMNDiagram().isRelativeObjectCoordinates()) {
                Lane tempLaneContainer = Util.getLaneById(ctx.getXPDLPackage(), container.getID());
                NodeGraphicsInfo laneGraphicsInfo = null;
                if (tempLaneContainer != null && tempLaneContainer.getNodeGraphicsInfos() != null && !tempLaneContainer.getNodeGraphicsInfos().getNodeGraphicsInfo().isEmpty()) {
                    laneGraphicsInfo = tempLaneContainer.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                }
                org.wfmc.xpdl21.Pool tempPool = Util.getPoolById(ctx.getXPDLPackage(), ((oracle.tutor.bpmn.Lane)container).getPool().getID());
                NodeGraphicsInfo poolGraphicsInfo = null;
                if (tempPool != null && tempPool.getNodeGraphicsInfos() != null && !tempPool.getNodeGraphicsInfos().getNodeGraphicsInfo().isEmpty()) {
                    poolGraphicsInfo = tempPool.getNodeGraphicsInfos().getNodeGraphicsInfo().get(0);
                }
                if (laneGraphicsInfo != null && laneGraphicsInfo.getCoordinates() != null && poolGraphicsInfo != null && poolGraphicsInfo.getCoordinates() != null) {
                    containerRB.setX(laneGraphicsInfo.getCoordinates().getXCoordinate() + poolGraphicsInfo.getCoordinates().getXCoordinate() + laneGraphicsInfo.getWidth());
                    containerRB.setY(laneGraphicsInfo.getCoordinates().getYCoordinate() + poolGraphicsInfo.getCoordinates().getYCoordinate() + laneGraphicsInfo.getHeight());
                }
            }
            if (elementRB.getXd() >= containerRB.getXd()) {
                container.setWidth(elementRB.getXd() - container.getXd() + (isInSubprocess ? 10.0 : 0.0));
            }
            if (elementRB.getYd() >= containerRB.getYd()) {
                container.setHeight(elementRB.getYd() - container.getYd() + (isInSubprocess ? 10.0 : 0.0));
            }
            XPDLUnmarshaller.stretchBPMNContainer((GraphicalElement)container, ctx);
        }
    }

    private static Coordinate getRightBottom(GraphicalElement element) {
        return new Coordinate(element.getXd() + element.getWidthd(), element.getYd() + element.getHeightd());
    }

    private static void setNodeLaneByCoordinates(FlowObject bpmnNode, ConversionContext ctx) {
        Pool nodeLane = null;
        BusinessProcessDiagram model = bpmnNode.getModel();
        for (Pool pool : model.getPools().values()) {
            for (oracle.tutor.bpmn.Lane lane : pool.getLanes().values()) {
                oracle.tutor.bpmn.Lane tempLane = null;
                if (ctx.getBPMNDiagram().isRelativeObjectCoordinates()) {
                    tempLane = new oracle.tutor.bpmn.Lane();
                    tempLane.setX(pool.getXd() + lane.getXd());
                    tempLane.setY(pool.getYd() + lane.getYd());
                    tempLane.setWidth(lane.getWidthd());
                    tempLane.setHeight(lane.getHeightd());
                }
                if (tempLane == null) {
                    tempLane = lane;
                }
                if (isReprocessableLanes) {
                    if (((String)pool.getAttribute("orientation")).equalsIgnoreCase("horizontal")) {
                        tempLane.setWidth(XPDLUnmarshaller.getRightBottom((GraphicalElement)bpmnNode).getX());
                    } else {
                        tempLane.setHeight(XPDLUnmarshaller.getRightBottom((GraphicalElement)bpmnNode).getY());
                    }
                }
                if (!XPDLUnmarshaller.isNodeInSwimlane(bpmnNode, (Swimlane)tempLane)) continue;
                nodeLane = lane;
                bpmnNode.setLane(lane);
                break;
            }
            if (nodeLane == null) continue;
            break;
        }
        if (nodeLane == null) {
            String poolId = Util.getPoolIdByProcessId(ctx.getXPDLPackage(), ctx.getXPDLProcess().getId());
            if (poolId != null) {
                bpmnNode.setLane(ctx.getBPMNDiagram().getPool(poolId));
                nodeLane = ctx.getBPMNDiagram().getPool(poolId);
            } else {
                for (Pool pool : model.getPools().values()) {
                    if (!XPDLUnmarshaller.isNodeInSwimlane(bpmnNode, (Swimlane)pool)) continue;
                    bpmnNode.setLane(pool);
                    nodeLane = pool;
                    break;
                }
            }
        }
        if (nodeLane == null) {
            LOG.info("no parent lane or pool found for node:" + bpmnNode.getID());
            ctx.getBPMNDiagram().addNode(bpmnNode);
        }
    }

    private static boolean isNodeInSwimlane(FlowObject bpmnNode, Swimlane swimlane) {
        boolean result;
        float nodeX1 = bpmnNode.getPosition().getX();
        float nodeY1 = bpmnNode.getPosition().getY();
        float nodeX2 = bpmnNode.getPosition().getX() + bpmnNode.getWidth();
        float nodeY2 = bpmnNode.getPosition().getY() + bpmnNode.getHeight();
        float laneX1 = swimlane.getPosition().getX();
        float laneY1 = swimlane.getPosition().getY();
        float laneX2 = laneX1 + swimlane.getWidth();
        float laneY2 = laneY1 + swimlane.getHeight();
        boolean bl = result = nodeX1 >= laneX1 && nodeX2 <= laneX2 && nodeY1 >= laneY1 && nodeY2 <= laneY2;
        if (!result && LOG.isLoggable(Level.FINE)) {
            LOG.finest("Matching node[" + nodeX1 + "," + nodeY1 + "," + nodeX2 + "," + nodeY2 + "] to swimlane[" + laneX1 + "," + laneY1 + "," + laneX2 + "," + laneY2 + "]... " + result);
        }
        return result;
    }

    private static void applyGraphicsInfo(ConnectorGraphicsInfo graphicsInfo, ConnectingObject sequenceFlow, ConversionContext ctx) {
        if (graphicsInfo.getCoordinates() != null && sequenceFlow != null) {
            double offsetX = ctx.isInSubprocess() ? ctx.getBPMNSubprocess().getXd() : 0.0;
            double offsetY = ctx.isInSubprocess() ? ctx.getBPMNSubprocess().getYd() : 0.0;
            for (Coordinates coords : graphicsInfo.getCoordinates()) {
                sequenceFlow.getPath().add(new Coordinate(coords.getXCoordinate() + offsetX, coords.getYCoordinate() + offsetY));
            }
        }
    }

    private static Subprocess.SubprocessType getBPMNSubprocesType(Activity activity) {
        Subprocess.SubprocessType st = null;
        if (activity.getBlockActivity() != null) {
            st = Subprocess.SubprocessType.EMBEDDED;
        } else if (activity.getImplementation().getSubFlow() != null) {
            st = Subprocess.SubprocessType.REUSABLE;
        } else if (activity.getImplementation().getReference() != null) {
            st = Subprocess.SubprocessType.REFERENCE;
        }
        return st;
    }

    private static Event.EventType getBPMNEventType(org.wfmc.xpdl21.Event event) {
        Event.EventType et = null;
        if (event.getEndEvent() != null) {
            et = Event.EventType.END;
        } else if (event.getStartEvent() != null) {
            et = Event.EventType.START;
        } else if (event.getIntermediateEvent() != null) {
            et = Event.EventType.INTERMEDIATE;
        }
        return et;
    }

    private static Event.Trigger getBPMNTrigger(org.wfmc.xpdl21.Event event) {
        String trigger = null;
        if (event.getEndEvent() != null) {
            trigger = event.getEndEvent().getResult();
        } else if (event.getStartEvent() != null) {
            trigger = event.getStartEvent().getTrigger();
        } else if (event.getIntermediateEvent() != null) {
            trigger = event.getIntermediateEvent().getTrigger();
        }
        Event.Trigger result = null;
        result = "None".equals(trigger) ? Event.Trigger.NONE : ("Cancel".equals(trigger) ? Event.Trigger.CANCEL : ("Compensation".equals(trigger) ? Event.Trigger.COMPENSATION : ("Conditional".equals(trigger) ? Event.Trigger.CONDITIONAL : ("Error".equals(trigger) ? Event.Trigger.ERROR : ("Link".equals(trigger) ? Event.Trigger.LINK : ("Message".equals(trigger) ? Event.Trigger.MESSAGE : ("Multiple".equals(trigger) ? Event.Trigger.MULTIPLE : ("Signal".equals(trigger) ? Event.Trigger.SIGNAL : ("Terminate".equals(trigger) || event.getEndEvent() != null ? Event.Trigger.TERMINATE : ("Timer".equals(trigger) ? Event.Trigger.TIMER : Event.Trigger.NONE))))))))));
        return result;
    }

    private static Event.Direction getBPMNEventDirection(org.wfmc.xpdl21.Event event) {
        IntermediateEvent intermEvent;
        String eventTrigger;
        Event.Direction dir = null;
        if (event.getEndEvent() != null) {
            dir = Event.Direction.THROW;
        } else if (event.getStartEvent() != null) {
            dir = Event.Direction.CATCH;
        } else if (event.getIntermediateEvent() != null && (eventTrigger = (intermEvent = event.getIntermediateEvent()).getTrigger()) != null) {
            String val = null;
            if ("Message".equals(eventTrigger)) {
                val = intermEvent.getTriggerResultMessage() == null ? null : intermEvent.getTriggerResultMessage().getCatchThrow();
            } else if ("Link".equals(eventTrigger)) {
                val = intermEvent.getTriggerResultLink() == null ? null : intermEvent.getTriggerResultLink().getCatchThrow();
            }
            dir = val == null ? null : Event.Direction.valueOf((String)val);
        }
        return dir;
    }

    private static Gateway.GatewayType getBPMNGatewayType(Route route) {
        Gateway.GatewayType gt = Gateway.GatewayType.XOR_DATA;
        String routeGT = route.getGatewayType();
        if ("AND".equals(routeGT) || "Parallel".equals(routeGT)) {
            gt = Gateway.GatewayType.AND;
        } else if ("Inclusive".equals(routeGT) || "OR".equals(routeGT)) {
            gt = Gateway.GatewayType.OR;
        } else if ("Exclusive".equals(routeGT) || "XOR".equals(routeGT)) {
            String routeET = route.getExclusiveType();
            if (routeET == null) {
                routeET = route.getXORType();
            }
            if ("Data".equals(routeET)) {
                gt = Gateway.GatewayType.XOR_DATA;
            } else if ("Event".equals(routeET)) {
                gt = Gateway.GatewayType.XOR_EVENT;
            }
        } else if ("EventBasedXOR".equals(routeGT)) {
            gt = Gateway.GatewayType.XOR_EVENT;
        } else if ("Complex".equals(routeGT)) {
            gt = Gateway.GatewayType.COMPLEX;
        }
        return gt;
    }

    private static Association.Direction getBPMNAssociationDirection(Association association) {
        Association.Direction dir = Association.Direction.NONE;
        String assocDir = association.getAssociationDirection();
        if ("Both".equals(assocDir)) {
            dir = Association.Direction.BOTH;
        } else if ("To".equals(assocDir) || "From".equals(assocDir)) {
            dir = Association.Direction.ONE;
        }
        return dir;
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    static {
        LOG = Logger.getLogger(XPDLUnmarshaller.class.getName());
        inputFile = null;
    }
}

