/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;
import oracle.tutor.xpdl.XPDLMarshallingException;
import oracle.tutor.xpdl.XPDLUnmarshaller;

public class XPDLTestApp {
    public static void main(String[] args) throws XPDLMarshallingException, FileNotFoundException {
        String fileName = "SolicitudDeEjercicioDeInversion.xpdl";
        System.out.println("> Loading BPMN diagram from XPDL file:" + fileName + "...\n");
        System.out.println('\n');
        BusinessProcessDiagram[] diagram = XPDLUnmarshaller.getInstance().unmarshal(fileName, "C:\\Tutor\\xml");
        for (int i = 0; i < diagram.length; ++i) {
            XPDLTestApp.printBPMNDiagram(diagram[i]);
        }
    }

    private static void transform(String fileName) throws FileNotFoundException, XPDLMarshallingException {
        ByteArrayInputStream ibuf = (ByteArrayInputStream)XPDLUnmarshaller.getInstance().applyPatch(new FileInputStream(fileName), "C:\\Tutor\\xml");
        Scanner sc = new Scanner(ibuf);
        while (sc.hasNextLine()) {
            System.out.println(sc.nextLine());
        }
    }

    static void printBPMNDiagram(BusinessProcessDiagram bpd) {
        Iterator i$;
        System.out.println("BPMN Diagram [id=" + bpd.getID() + ", name=" + bpd.getName() + "] :");
        System.out.println("    Description: " + bpd.getDescription());
        System.out.println("    Creation date: " + bpd.getCreationDate());
        System.out.println("    Tool: " + bpd.getToolID());
        System.out.println("\nPools:");
        if (bpd.getPools() != null) {
            i$ = bpd.getPools().values().iterator();
            while (i$.hasNext()) {
                Pool opool;
                Pool pool = opool = (Pool)i$.next();
                System.out.println(XPDLTestApp.indent(1) + XPDLTestApp.node2str((GraphicalElement)pool, 2));
                XPDLTestApp.printBPMNNodes(XPDLTestApp.getLaneNodes((Swimlane)pool), 2);
                if (pool.getLanes() == null) continue;
                System.out.println(XPDLTestApp.indent(2) + "Lanes:");
                Iterator i$2 = pool.getLanes().values().iterator();
                while (i$2.hasNext()) {
                    Lane olane;
                    Lane lane = olane = (Lane)i$2.next();
                    System.out.println(XPDLTestApp.indent(3) + XPDLTestApp.node2str((GraphicalElement)lane, 4));
                    XPDLTestApp.printBPMNNodes(XPDLTestApp.getLaneNodes((Swimlane)lane), 4);
                }
            }
        }
        System.out.println("\nConnectors: " + bpd.getAllFlows().size());
        i$ = bpd.getAllFlows().values().iterator();
        while (i$.hasNext()) {
            ConnectingObject obj;
            ConnectingObject connector = obj = (ConnectingObject)i$.next();
            System.out.println(XPDLTestApp.obj2str(connector) + ":\t" + XPDLTestApp.obj2str(connector.getFrom()) + " --> " + XPDLTestApp.obj2str(connector.getTo()));
        }
    }

    private static void printBPMNNodes(Collection<FlowObject> nodes, int indent) {
        System.out.println(XPDLTestApp.indent(indent) + "Nodes:");
        for (FlowObject node : nodes) {
            System.out.println(XPDLTestApp.indent(indent + 1) + XPDLTestApp.node2str((GraphicalElement)node, indent + 2));
            if (!(node instanceof Subprocess)) continue;
            Collection<FlowObject> subNodes = ((Subprocess)node).getAllNodes().values();
            XPDLTestApp.printBPMNNodes(subNodes, indent + 2);
        }
    }

    private static Collection<FlowObject> getLaneNodes(Swimlane lane) {
        ArrayList<FlowObject> res = new ArrayList<FlowObject>();
        for (FlowObject obj : lane.getModel().getAllNodes().values()) {
            FlowObject node = obj;
            if (node.getLane() != lane) continue;
            res.add(node);
        }
        return res;
    }

    private static String indent(int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append("  ");
        }
        return s.toString();
    }

    private static String obj2str(Object o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [").append(XPDLTestApp.getProperty(o, "id")).append(", ").append(XPDLTestApp.getProperty(o, "name")).append(']');
        return s.toString();
    }

    private static String obj2str(GraphicalElement o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(XPDLTestApp.getProperty(o, "ID")).append(", name=").append(XPDLTestApp.getProperty(o, "name")).append(']');
        return s.toString();
    }

    private static String obj2str(ConnectingObject o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(o.getID()).append(", name=").append(o.getName()).append(", pathSize=").append(o.getPath().size());
        for (Method m : o.getClass().getMethods()) {
            Class<?> rtype;
            String prefix = null;
            if (m.getName().equals("getID") || m.getName().equals("getName") || m.getName().equals("getPosition") || m.getName().equals("getTextPosition") || m.getName().equals("getWidth") || m.getName().equals("getHeight") || m.getName().equals("getAttribute") || m.getName().equals("getDocumentation")) continue;
            prefix = "get";
            if (!m.getName().startsWith("get")) {
                prefix = "is";
                if (!m.getName().startsWith("is")) continue;
            }
            if (!(rtype = m.getReturnType()).isPrimitive() && !rtype.isEnum() && !String.class.isAssignableFrom(rtype) && !Boolean.class.isAssignableFrom(rtype) && !Number.class.isAssignableFrom(rtype) && !Coordinate.class.isAssignableFrom(rtype)) continue;
            try {
                Object val = m.invoke((Object)o, new Object[0]);
                if (val instanceof Coordinate) {
                    val = "(" + ((Coordinate)val).getX() + "," + ((Coordinate)val).getY() + ")";
                }
                String attrName = m.getName().substring(prefix.length());
                s.append(", ").append(attrName).append('=').append(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        s.append(']');
        return s.toString();
    }

    private static String node2str(GraphicalElement o, int indent) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(XPDLTestApp.getProperty(o, "ID")).append(", name=").append(XPDLTestApp.getProperty(o, "name")).append(']');
        s.append('\n').append(XPDLTestApp.indent(indent)).append("Attributes:");
        ++indent;
        for (Method m : o.getClass().getMethods()) {
            Class<?> rtype;
            String prefix = null;
            if (m.getName().equals("getID") || m.getName().equals("getName") || m.getName().equals("getAttribute")) continue;
            prefix = "get";
            if (!m.getName().startsWith("get")) {
                prefix = "is";
                if (!m.getName().startsWith("is")) continue;
            }
            if (!(rtype = m.getReturnType()).isPrimitive() && !rtype.isEnum() && !String.class.isAssignableFrom(rtype) && !Boolean.class.isAssignableFrom(rtype) && !Number.class.isAssignableFrom(rtype) && !Coordinate.class.isAssignableFrom(rtype) && !FlowObject.class.isAssignableFrom(rtype)) continue;
            try {
                Object val = m.invoke((Object)o, new Object[0]);
                if (val instanceof Coordinate) {
                    val = "(" + ((Coordinate)val).getX() + "," + ((Coordinate)val).getY() + ")";
                } else if (val instanceof FlowObject) {
                    val = ((FlowObject)val).getID();
                }
                s.append("\n").append(XPDLTestApp.indent(indent)).append(m.getName().substring(prefix.length())).append('=').append(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return s.toString();
    }

    private static Object getProperty(Object o, String prop) {
        String methodName = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, new Class[0]);
            result = m.invoke(o, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result == null ? "<empty>" : result;
    }
}

