/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XPDLNamespaceFilter
extends XMLFilterImpl {
    private String _namespace;
    private String _prefix;

    public static String getDefaultXPDLPrefix() {
        return System.getProperty("bpmnxpdl.default_xpdl_prefix", "xpdl");
    }

    public static String getDefaultXPDLNamespace() {
        return System.getProperty("bpmnxpdl.default_namespace", "http://www.wfmc.org/2008/XPDL2.1");
    }

    public XPDLNamespaceFilter(XMLReader reader) {
        super(reader);
        this._namespace = XPDLNamespaceFilter.getDefaultXPDLNamespace();
        this._prefix = XPDLNamespaceFilter.getDefaultXPDLPrefix();
    }

    public XPDLNamespaceFilter(XMLReader reader, String defaltNamespace, String namespacePrefix) {
        super(reader);
        this._namespace = defaltNamespace;
        this._prefix = namespacePrefix + ":";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("".equals(uri) || uri == null || qName.startsWith(this._prefix)) {
            uri = this._namespace;
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("xpdl".equalsIgnoreCase(prefix)) {
            uri = this._namespace;
        }
        super.startPrefixMapping(prefix, uri);
    }
}

