/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.xpdl.InvalidXPDLFormatException;
import oracle.tutor.xpdl.XPDLMarshallingException;
import oracle.tutor.xpdl.XPDLUnmarshaller;

public class Utility {
    private Utility() {
    }

    public static BusinessProcessDiagram[] importFromXPDL(File file, String tutorDirectoryPath) throws InvalidXPDLFormatException, FileNotFoundException {
        try {
            return XPDLUnmarshaller.getInstance().unmarshal(file, tutorDirectoryPath);
        }
        catch (XPDLMarshallingException e) {
            throw new InvalidXPDLFormatException(e);
        }
    }

    public static BusinessProcessDiagram[] importFromXPDL(String fileXPDL, String tutorDirectoryPath) throws InvalidXPDLFormatException, FileNotFoundException {
        try {
            return XPDLUnmarshaller.getInstance().unmarshal(fileXPDL, tutorDirectoryPath);
        }
        catch (XPDLMarshallingException e) {
            throw new InvalidXPDLFormatException(e);
        }
    }

    public static BusinessProcessDiagram[] importFromXPDL(InputStream istream, String tutorDirectoryPath) throws InvalidXPDLFormatException {
        try {
            return XPDLUnmarshaller.getInstance().unmarshal(istream, tutorDirectoryPath);
        }
        catch (XPDLMarshallingException e) {
            throw new InvalidXPDLFormatException(e);
        }
    }
}

