/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.visio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.DataObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Group;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.ProgressDialog;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Task;
import oracle.tutor.visio.MasterMapLoader;
import oracle.tutor.visio.UserCancelException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utility {
    private static Logger _log = Logger.getLogger(Utility.class.getName());
    private XPath _xpath = XPathFactory.newInstance().newXPath();
    private ProgressDialog _progressDlg;
    private ProgressNotifier _notifier;

    public BusinessProcessDiagram[] importVdx(String filename) throws ParserConfigurationException, SAXException, IOException, UserCancelException, TransformerConfigurationException, TransformerException {
        return this.importVdx(filename, (ProgressDialog)null, 100, null);
    }

    public BusinessProcessDiagram[] importVdx(String filename, ProgressDialog progressDlg, int progressDelta, String xmlFolder) throws ParserConfigurationException, SAXException, IOException, UserCancelException, TransformerConfigurationException, TransformerException {
        return this._importVdx(filename, null, progressDlg, progressDelta, xmlFolder);
    }

    public BusinessProcessDiagram[] importVdx(String filename, ProgressNotifier progressNotifier, int progressDelta, String xmlFolder) throws ParserConfigurationException, SAXException, IOException, UserCancelException, TransformerConfigurationException, TransformerException {
        return this._importVdx(filename, progressNotifier, null, progressDelta, xmlFolder);
    }

    private BusinessProcessDiagram[] _importVdx(String filename, ProgressNotifier progressNotifier, ProgressDialog progressDlg, int progressDelta, String xmlFolder) throws ParserConfigurationException, SAXException, IOException, UserCancelException, TransformerConfigurationException, TransformerException {
        this._notifier = progressNotifier;
        this._progressDlg = progressDlg;
        int minProgress = 0;
        int maxProgress = 100;
        if (this._progressDlg == null && this._notifier == null) {
            progressDelta = 100;
        } else if (this._progressDlg != null) {
            minProgress = this._progressDlg.getProgressBar().getValue();
            maxProgress = minProgress + progressDelta;
        }
        int progress = minProgress;
        File vsoFile = new File(filename);
        if (!vsoFile.exists() || !vsoFile.canRead()) {
            throw new RuntimeException("Source file does not exist or cannot be read.");
        }
        String baseFilename = vsoFile.getName().substring(0, vsoFile.getName().lastIndexOf("."));
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        domFactory.setNamespaceAware(false);
        DocumentBuilder docBuilder = domFactory.newDocumentBuilder();
        Document doc = null;
        URL xslReducerFile = this._getFileUrl("VisioReducer.xsl", xmlFolder, false);
        if (xslReducerFile != null) {
            _log.info("Visio reducer path: " + xslReducerFile.getPath());
            this.statusMessage("Preparing input file...", progress);
            StreamSource vsoStream = new StreamSource(vsoFile);
            StreamSource xslStream = new StreamSource(xslReducerFile.openStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer(xslStream);
            transformer.transform(vsoStream, new StreamResult(baos));
            try {
                doc = docBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                _log.severe("Unable to parse reduced input file.\n" + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        _log.info("Visio reducer xslt not found. Processing full input file.");
        try {
            doc = docBuilder.parse(new File(filename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(filename + " file not found");
        }
        catch (Exception e) {
            _log.severe("Unable to parse input file.\n" + e.getMessage());
            throw new RuntimeException(e);
        }
        HashMap<String, String> insideShapeIDMap = new HashMap<String, String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        MasterMapLoader masterMapLoader = new MasterMapLoader();
        HashMap<String, GraphicalElement> masterMap = masterMapLoader.getMasterMap(xmlFolder);
        this.statusMessage("Reading masters", progress);
        double progressChunk = (double)progressDelta * 0.1;
        NodeList mastersIDList = this.getXmlNodeset(doc, "//VisioDocument/Masters/Master/attribute::ID");
        NodeList mastersNameList = this.getXmlNodeset(doc, "//VisioDocument/Masters/Master");
        for (int i = 0; i < mastersNameList.getLength(); ++i) {
            String masterName = this.getXmlString(mastersNameList.item(i), "attribute::Name");
            if ("".equals(masterName)) {
                masterName = this.getXmlString(mastersNameList.item(i), "attribute::NameU");
            }
            nameMap.put(mastersIDList.item(i).getNodeValue(), masterName.toCharArray().length == 0 ? "<none>" : masterName);
        }
        progress = (int)((double)progress + progressChunk);
        this.statusMessage((String)null, progress);
        NodeList pageNodes = this.getXmlNodeset(doc, "//VisioDocument/Pages/Page");
        BusinessProcessDiagram[] bpdArray = new BusinessProcessDiagram[pageNodes.getLength()];
        for (int p = 0; p < pageNodes.getLength(); ++p) {
            Node pageNode = pageNodes.item(p);
            BusinessProcessDiagram bpd = new BusinessProcessDiagram();
            this.setBpdAttributes(bpd, baseFilename, pageNode);
            Pool defaultPool = new Pool("P0", "", bpd);
            defaultPool.setObjectPin(GraphicalElement.ObjectPin.LOWERLEFT);
            defaultPool.setVisible(Boolean.valueOf(false));
            progressChunk = (double)progressDelta * 0.6 / (double)pageNodes.getLength();
            NodeList shapesList = this.getXmlNodeset(pageNode, "child::Shapes/Shape");
            for (int i = 0; i < shapesList.getLength(); ++i) {
                Node shapeNode = shapesList.item(i);
                String masterName = this.getMasterName(shapeNode, nameMap, masterMap);
                this.addShapeToModel(bpd, shapeNode, masterMap, masterName, defaultPool, insideShapeIDMap, (double)progress + progressChunk * ((double)i / (double)shapesList.getLength()));
            }
            NodeList connectNodes = this.getXmlNodeset(pageNode, "child::Connects/Connect");
            progress = (int)((double)progress + progressChunk);
            this.statusMessage("Processing connectors", progress);
            progressChunk = (double)progressDelta * 0.3 / (double)pageNodes.getLength();
            for (int i = 0; i < connectNodes.getLength(); ++i) {
                this.statusMessage(null, (double)progress + progressChunk * ((double)i / (double)connectNodes.getLength()));
                String FromSheet = this.getXmlString(connectNodes.item(i), "attribute::FromSheet");
                String FromCell = this.getXmlString(connectNodes.item(i), "attribute::FromCell");
                String ToSheet = this.getXmlString(connectNodes.item(i), "attribute::ToSheet");
                if (!bpd.getAllFlows().containsKey(FromSheet)) continue;
                ConnectingObject objectFlow = (ConnectingObject)bpd.getAllFlows().get(FromSheet);
                if (!bpd.getGraphicalElements().containsKey(ToSheet) && !insideShapeIDMap.containsKey(ToSheet)) continue;
                if (!bpd.getGraphicalElements().containsKey(ToSheet) && insideShapeIDMap.containsKey(ToSheet)) {
                    ToSheet = insideShapeIDMap.get(ToSheet);
                }
                GraphicalElement node = bpd.getElement((Object)ToSheet);
                if (FromCell.equals("BeginX")) {
                    objectFlow.setFrom(node);
                    continue;
                }
                if (FromCell.equals("EndX")) {
                    objectFlow.setTo(node);
                    continue;
                }
                _log.warning("Flow " + objectFlow.getID() + " has no BeginX or EndX cell.");
            }
            progress = (int)((double)progress + progressChunk);
            this.connectUngluedConnectors(bpd);
            LinkedList tmpFlows = new LinkedList(bpd.getAllFlows().values());
            for (ConnectingObject flow : tmpFlows) {
                if ((flow.getFrom() != null && flow.getFrom() instanceof DataObject || flow.getTo() != null && flow.getTo() instanceof DataObject || flow.getFrom() != null && flow.getFrom() instanceof Annotation || flow.getTo() != null && flow.getTo() instanceof Annotation) && flow instanceof SequenceFlow) {
                    this.convertToAssociation(bpd, flow);
                }
                if (flow.getAttribute("reversed") != null && flow.getAttribute("reversed").equals(true)) {
                    GraphicalElement fromObj = flow.getFrom();
                    flow.setFrom(flow.getTo());
                    flow.setTo(fromObj);
                    _log.info("Reversed direction of flow '" + flow.getName() + "' (" + flow.getID() + ")");
                }
                if (flow.getAttribute("linkedEvent") == null) continue;
                Event event = (Event)flow.getAttribute("linkedEvent");
                Coordinate start = (Coordinate)flow.getPath().getFirst();
                Coordinate end = (Coordinate)flow.getPath().getLast();
                event.setPosition((start.getX() + end.getX()) / 2.0f, (start.getY() + end.getY()) / 2.0f);
                if (flow.getInflows() != null) {
                    LinkedList inFlows = new LinkedList(flow.getInflows());
                    for (ConnectingObject inFlow : inFlows) {
                        inFlow.setTo((GraphicalElement)event);
                        ((Coordinate)inFlow.getPath().getLast()).setX(event.getX() - event.getWidth() / 2.0f);
                    }
                }
                if (flow.getOutflows() != null) {
                    LinkedList outFlows = new LinkedList(flow.getOutflows());
                    for (ConnectingObject outFlow : outFlows) {
                        outFlow.setFrom((GraphicalElement)event);
                        ((Coordinate)outFlow.getPath().getFirst()).setX(event.getX() + event.getWidth() / 2.0f);
                    }
                }
                if (flow.getFrom() != null && flow.getTo() != null) {
                    event.setEventType(Event.EventType.INTERMEDIATE);
                    SequenceFlow flow2 = new SequenceFlow(flow.getID() + "_2", "", (GraphicalElement)event, flow.getTo());
                    flow.setTo((GraphicalElement)event);
                    LinkedList newPath1 = new LinkedList();
                    LinkedList<Object> newPath2 = new LinkedList<Object>();
                    newPath1.add(flow.getPath().getFirst());
                    newPath1.add(new Coordinate(event.getX() - event.getWidth() / 2.0f, event.getY()));
                    newPath2.add(new Coordinate(event.getX() + event.getWidth() / 2.0f, event.getY()));
                    newPath2.add(flow.getPath().getLast());
                    flow.setPath(newPath1);
                    flow2.setPath(newPath2);
                    continue;
                }
                if (flow.getFrom() != null) {
                    flow.setTo((GraphicalElement)event);
                    event.setEventType(Event.EventType.END);
                    ((Coordinate)flow.getPath().getLast()).setX(event.getX() - event.getWidth() / 2.0f);
                    ((Coordinate)flow.getPath().getLast()).setY(event.getY());
                    continue;
                }
                if (flow.getTo() != null) {
                    flow.setFrom((GraphicalElement)event);
                    event.setEventType(Event.EventType.START);
                    ((Coordinate)flow.getPath().getFirst()).setX(event.getX() + event.getWidth() / 2.0f);
                    ((Coordinate)flow.getPath().getFirst()).setY(event.getY());
                    continue;
                }
                flow.remove();
            }
            LinkedList tmpNodes = new LinkedList(bpd.getAllNodes().values());
            for (FlowObject node : tmpNodes) {
                if (!(node instanceof Activity) || !this.containsOtherNodes(bpd, node)) continue;
                if (node.getInflows(SequenceFlow.class).isEmpty() && node.getOutflows(SequenceFlow.class).isEmpty()) {
                    this.convertToGroup(bpd, node);
                    continue;
                }
                this.convertToSubprocess(bpd, node);
            }
            this.setEventTypes(bpd);
            this.setPoolsLanesObjects(bpd, defaultPool);
            this.assignEventTargets(bpd);
            tmpNodes = new LinkedList(bpd.getAllNodes().values());
            for (FlowObject node : tmpNodes) {
                String masterName = (String)node.getAttribute("VISIO_MASTER");
                if (!(node instanceof Task) || !"<none>".equals(masterName) && !"shape-task".equals(masterName) || !"".equals(node.getName()) || !node.getInflows().isEmpty() || !node.getOutflows().isEmpty()) continue;
                node.remove();
            }
            bpdArray[p] = bpd;
        }
        return bpdArray;
    }

    private URL _getFileUrl(String filename, String xmlFolderPath, Boolean errorIfMissing) throws FileNotFoundException {
        URL url = null;
        if (xmlFolderPath != null) {
            String filePath = xmlFolderPath.concat(File.separator).concat(filename);
            File file = new File(filePath);
            if (file.exists()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(file.getAbsolutePath() + " is not a valid path.");
                }
            } else if (errorIfMissing.booleanValue()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
        } else {
            url = this.getClass().getClassLoader().getResource(filename);
            if (url == null && errorIfMissing.booleanValue()) {
                throw new RuntimeException("Unable to load " + filename + " as resource.");
            }
        }
        return url;
    }

    private void setBpdAttributes(BusinessProcessDiagram bpd, String bpdIdPrefix, Node pageNode) {
        bpd.setCoordinateOrigin(BusinessProcessDiagram.CoordinateOrigins.LOWERLEFT);
        String bpdIdSuffix = this.getXmlString(pageNode, "attribute::ID");
        String bpdID = bpdIdPrefix + "-" + bpdIdSuffix;
        bpd.setID(bpdID);
        String bpdName = this.getXmlString(pageNode, "attribute::Name");
        if (bpdName.toCharArray().length == 0) {
            bpdName = this.getXmlString(pageNode, "attribute::NameU");
        }
        bpd.setName(bpdName.toCharArray().length == 0 ? "" : bpdName);
        Node docPropsNode = this.getXmlNode(pageNode, "//VisioDocument/DocumentProperties");
        String bpdAuthor = this.getXmlString(docPropsNode, "Creator/text()");
        bpd.setAuthor(bpdAuthor.toCharArray().length == 0 ? "" : bpdAuthor);
        String bpdDescription = this.getXmlString(docPropsNode, "Company/text()");
        bpd.setDescription(bpdDescription.toCharArray().length == 0 ? "" : bpdDescription);
        bpd.setToolID("Oracle Visio Importer");
        String bpdCreated = this.getXmlString(docPropsNode, "TimeCreated/text()");
        bpd.setCreationDate(bpdCreated.toCharArray().length == 0 ? "" : bpdCreated);
        String bpdModified = this.getXmlString(docPropsNode, "TimeEdited/text()");
        bpd.setModificationDate(bpdModified.toCharArray().length == 0 ? "" : bpdModified);
        _log.info("bpdID:" + bpd.getID());
        _log.info("bpdName:" + bpd.getName());
    }

    private String getMasterName(Node shapeNode, HashMap<String, String> nameMap, HashMap<String, GraphicalElement> masterMap) {
        String masterName;
        String masterId = this.getXmlString(shapeNode, "attribute::Master");
        if (masterId.toCharArray().length > 0) {
            masterName = nameMap.get(masterId);
        } else {
            masterName = this.getXmlString(shapeNode, "attribute::NameU");
            if (masterName.toCharArray().length == 0 && ((masterName = this.getXmlString(shapeNode, "attribute::Type")).equals("Group") || masterName.toCharArray().length == 0)) {
                masterName = "<none>";
            }
        }
        if (masterName.contains(".") || masterName.contains(":")) {
            int index2 = masterName.contains(":") ? masterName.lastIndexOf(":") : masterName.lastIndexOf(".");
            masterName = masterName.substring(0, index2);
        }
        _log.fine("masterId: " + masterId + " mastername: " + masterName);
        _log.fine("In map = " + masterMap.containsKey(masterName.toLowerCase()));
        if (masterName.equals("Flowchart shapes")) {
            String shapeType = this.getXmlString(shapeNode, "Scratch/A/text()");
            if (shapeType.equals("1")) {
                masterName = "Task";
            } else if (shapeType.equals("2")) {
                masterName = "Gateway";
            } else if (shapeType.equals("3")) {
                masterName = "DataObject";
            } else if (shapeType.equals("4")) {
                masterName = "DataObject";
            }
        } else if (masterName.equals("Process Step")) {
            String shapeType = this.getXmlString(shapeNode, "User[@NameU='TypeCode']/Value/text()");
            if (shapeType.equals("0")) {
                masterName = "Process Step Task";
            } else if (shapeType.equals("1")) {
                masterName = "Process Step Manual";
            } else if (shapeType.equals("2")) {
                masterName = "Process Step Service";
            } else if (shapeType.equals("3")) {
                masterName = "Process Step DataObject";
            }
        } else if (masterName.equals("Shape") || !masterMap.containsKey(masterName.toLowerCase())) {
            _log.warning("Master '" + masterName + "' not recognized.");
            String lineStyle = this.getXmlString(shapeNode, "attribute::LineStyle");
            if (lineStyle.equals("1")) {
                masterName = "Annotation";
            } else {
                NodeList oneDimensional = this.getXmlNodeset(shapeNode, "child::XForm1D");
                NodeList polygonShape = this.getXmlNodeset(shapeNode, "child::Geom/LineTo");
                NodeList circleShape = this.getXmlNodeset(shapeNode, "child::Geom/Ellipse");
                NodeList ellipseShape = this.getXmlNodeset(shapeNode, "child::Geom/EllipticalArcTo");
                masterName = oneDimensional.getLength() > 0 ? "flow" : (polygonShape.getLength() >= 4 ? "shape-task" : (circleShape.getLength() > 0 || ellipseShape.getLength() >= 2 ? "shape-event" : "<none>"));
            }
        } else if (masterName.equals("Foreign") || !masterMap.containsKey(masterName.toLowerCase())) {
            _log.warning("Master '" + masterName + "' not recognized.");
            masterName = "<none>";
        }
        return masterName;
    }

    private void addShapeToModel(BusinessProcessDiagram bpd, Node shapeNode, HashMap<String, GraphicalElement> masterMap, String masterName, Pool defaultPool, HashMap<String, String> insideShapeIDMap, double progress) throws UserCancelException {
        NodeList xForm1D;
        String shapeId = this.getXmlString(shapeNode, "attribute::ID");
        Node textNode = null;
        textNode = masterName.equals("Process Step Task") || masterName.equals("Process Step Manual") || masterName.equals("Process Step Service") || masterName.equals("Process Step DataObject") ? this.getXmlNode(shapeNode, "descendant::Shape[@NameU='Text']/Text") : this.getXmlNode(shapeNode, "descendant::Text");
        String shapeText = "";
        if (textNode != null) {
            if (textNode.hasChildNodes()) {
                NodeList txtBlocks = textNode.getChildNodes();
                for (int i = 0; i < txtBlocks.getLength(); ++i) {
                    shapeText = shapeText + txtBlocks.item(i).getTextContent();
                }
            } else {
                shapeText = textNode.getTextContent();
            }
            shapeText = shapeText.trim().replace("\n\n", "\n");
        }
        _log.fine("Adding shape " + shapeId + " " + masterName + " '" + shapeText + "'");
        this.statusMessage("Reading " + masterName + " - " + shapeText, progress);
        GraphicalElement template = masterMap.get(masterName.toLowerCase().trim());
        if (template instanceof Lane) {
            String poolFlag = this.getXmlString(shapeNode, "child::User[@NameU='BPMNPool']/Value/text()");
            if (poolFlag.equals("1")) {
                template = masterMap.get("pool");
            }
        } else if (template instanceof Activity) {
            String activityType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnActivityType']/Value/text()");
            if (activityType.equals("Task") && template instanceof Subprocess) {
                template = masterMap.get("task");
            } else if (activityType.equals("Sub-Process") && template instanceof Task) {
                template = masterMap.get("subprocess");
            }
        } else if (template instanceof ConnectingObject) {
            String flowType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnConnectingObjectType']/Value/text()");
            if (flowType.equals("Sequence Flow") && !(template instanceof SequenceFlow)) {
                template = masterMap.get("sequence flow");
            }
            if (flowType.equals("Message Flow") && !(template instanceof MessageFlow)) {
                template = masterMap.get("Message flow");
            }
            if (flowType.equals("Association") && !(template instanceof Association)) {
                template = masterMap.get("association");
            }
        }
        if (template != null) {
            template.setAttribute("VISIO_MASTER", (Object)masterName);
        }
        if ((xForm1D = this.getXmlNodeset(shapeNode, "child::XForm1D")).getLength() > 0) {
            LinkedList<Object> path = this.getFlowPath(shapeNode);
            MessageFlow newFlow = null;
            Node XFormNode = this.getXmlNode(shapeNode, "child::XForm");
            if (!path.isEmpty()) {
                Lane newObj;
                if (masterName.equals("Message")) {
                    newFlow = new MessageFlow(shapeId, shapeText);
                    newFlow.setAttribute("VISIO_MASTER", (Object)masterName);
                } else if (template instanceof ConnectingObject) {
                    try {
                        newFlow = ((ConnectingObject)template).clone(shapeId);
                        newFlow.setName(shapeText);
                    }
                    catch (CloneNotSupportedException e) {
                        newFlow = new SequenceFlow(shapeId, shapeText);
                    }
                    if (newFlow instanceof SequenceFlow) {
                        double marker = this.getXmlNumber(shapeNode, "child::Prop[@NameU='marker']/Value/text()");
                        if (marker == 1.0) {
                            ((SequenceFlow)newFlow).setConditional(Boolean.valueOf(true));
                        } else if (marker == 2.0) {
                            ((SequenceFlow)newFlow).setDefault(Boolean.valueOf(true));
                        }
                    }
                    this.setAttributesFromProperties((GraphicalElement)newFlow, shapeNode);
                } else if (template instanceof Event) {
                    try {
                        newObj = ((Event)template).clone("e_" + shapeId);
                        newObj.setName(shapeText);
                    }
                    catch (CloneNotSupportedException e) {
                        _log.warning("Unable to clone " + masterName);
                        newObj = new Event(shapeId, shapeText);
                    }
                    newObj.setPosition(0.0f, 0.0f);
                    newObj.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
                    newObj.setWidth(0.5);
                    newObj.setHeight(0.5);
                    double timerFlag = this.getXmlNumber(shapeNode, "child::Prop[@NameU='Temporal']/Value/text()");
                    if (timerFlag == 1.0) {
                        newObj.setTrigger(Event.Trigger.TIMER);
                    }
                    NodeList insideShapes = this.getXmlNodeset(shapeNode, "descendant::Shape[@ID]");
                    for (int s = 0; s < insideShapes.getLength(); ++s) {
                        String insideShapeID = this.getXmlString(insideShapes.item(s), "attribute::ID");
                        insideShapeIDMap.put(insideShapeID, newObj.getID());
                    }
                    bpd.addNode((FlowObject)newObj);
                    newFlow = new SequenceFlow(shapeId, "");
                    newFlow.setAttribute("linkedEvent", (Object)newObj);
                } else if (template instanceof Lane) {
                    try {
                        newObj = ((Lane)template).clone(shapeId);
                        newObj.setName(shapeText);
                        newObj.setPool(defaultPool);
                    }
                    catch (CloneNotSupportedException e) {
                        _log.warning("Unable to clone " + masterName);
                        newObj = new Lane(shapeId, shapeText, defaultPool);
                    }
                    double x = this.getXmlNumber(XFormNode, "PinX/text()");
                    double y = this.getXmlNumber(XFormNode, "PinY/text()");
                    newObj.setPosition(x, y);
                    NodeList insideShapes = this.getXmlNodeset(shapeNode, "descendant::Shape[@ID]");
                    _log.fine("    Inside shapes: " + insideShapes.getLength());
                    if (insideShapes.getLength() > 0) {
                        newObj.setWidth(this.getXmlNumber(shapeNode, "descendant::Shape[1]/XForm/Width/text()").doubleValue());
                        newObj.setHeight(this.getXmlNumber(shapeNode, "descendant::Shape[1]/XForm/Height/text()").doubleValue());
                    } else {
                        newObj.setWidth(this.getXmlNumber(XFormNode, "Width/text()").doubleValue());
                        newObj.setHeight(this.getXmlNumber(XFormNode, "Height/text()").doubleValue());
                    }
                    newObj.setObjectPin(GraphicalElement.ObjectPin.UPPERLEFT);
                } else if (template instanceof Annotation) {
                    double xAnno;
                    NodeList insideShapes = this.getXmlNodeset(shapeNode, "descendant::Shape[@ID]");
                    _log.fine("    Inside shapes:" + insideShapes.getLength());
                    if (insideShapes.getLength() > 0) {
                        Annotation newObj2 = new Annotation(shapeId, shapeText);
                        newObj2.setAttribute("VISIO_MASTER", (Object)masterName);
                        xAnno = this.getXmlNumber(XFormNode, "PinX/text()");
                        double yAnno = this.getXmlNumber(XFormNode, "PinY/text()");
                        newObj2.setPosition(xAnno, yAnno);
                        newObj2.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
                        for (int s = 0; s < insideShapes.getLength(); ++s) {
                            double angle;
                            NodeList checkAssociation = this.getXmlNodeset(insideShapes.item(s), "child::XForm1D");
                            if (checkAssociation.getLength() > 0) {
                                newFlow = new Association();
                                newFlow.setAttribute("VISIO_MASTER", (Object)masterName);
                                newFlow.setID(this.getXmlString(insideShapes.item(s), "attribute::ID"));
                                newFlow.setName(this.getXmlString(insideShapes.item(s), "child::Text/text()"));
                                insideShapeIDMap.put(newObj2.getID(), newFlow.getID());
                                angle = this.getXmlNumber(insideShapes.item(s), "XForm/Angle/text()");
                                path = angle != 0.0 ? new LinkedList() : this.getFlowPath(insideShapes.item(s));
                                bpd.addNode((FlowObject)newObj2);
                                newFlow.setTo((GraphicalElement)newObj2);
                                continue;
                            }
                            angle = this.getXmlNumber(insideShapes.item(s), "XForm/Angle/text()");
                            if (Math.abs(Math.toDegrees(angle) - 90.0) <= 1.0) {
                                newObj2.setHeight(this.getXmlNumber(insideShapes.item(s), "XForm/Width/text()").doubleValue());
                                newObj2.setWidth(this.getXmlNumber(insideShapes.item(s), "XForm/Height/text()").doubleValue());
                                continue;
                            }
                            newObj2.setWidth(this.getXmlNumber(insideShapes.item(s), "XForm/Width/text()").doubleValue());
                            newObj2.setHeight(this.getXmlNumber(insideShapes.item(s), "XForm/Height/text()").doubleValue());
                        }
                    } else {
                        Annotation newObj3 = new Annotation(shapeId + "Anno", shapeText);
                        newObj3.setAttribute("VISIO_MASTER", (Object)masterName);
                        xAnno = this.getXmlNumber(XFormNode, "PinX/text()");
                        double yAnno = this.getXmlNumber(XFormNode, "PinY/text()");
                        newObj3.setPosition(xAnno, yAnno);
                        newObj3.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
                        if (this.getXmlNumber(XFormNode, "Angle/text()") == 1.5707963267949) {
                            newObj3.setHeight(this.getXmlNumber(XFormNode, "Width/text()").doubleValue());
                            newObj3.setWidth(this.getXmlNumber(XFormNode, "Height/text()").doubleValue());
                        } else {
                            newObj3.setWidth(this.getXmlNumber(XFormNode, "Width/text()").doubleValue());
                            newObj3.setHeight(this.getXmlNumber(XFormNode, "Height/text()").doubleValue());
                        }
                        newFlow = new Association(shapeId, "");
                        newFlow.setAttribute("VISIO_MASTER", (Object)masterName);
                        bpd.addNode((FlowObject)newObj3);
                        newFlow.setTo((GraphicalElement)newObj3);
                    }
                } else {
                    newFlow = new SequenceFlow(shapeId, shapeText);
                    newFlow.setAttribute("VISIO_MASTER", (Object)masterName);
                }
                if (newFlow != null) {
                    double beginArrow = this.getXmlNumber(shapeNode, "Line/BeginArrow/text()");
                    double endArrow = this.getXmlNumber(shapeNode, "Line/EndArrow/text()");
                    if (beginArrow != 0.0 && endArrow == 0.0) {
                        Collections.reverse(path);
                        newFlow.setAttribute("reversed", (Object)true);
                    }
                    newFlow.setPath(path);
                    bpd.addFlow((ConnectingObject)newFlow);
                }
            }
        } else if (template instanceof Gateway) {
            Gateway newObj;
            try {
                newObj = ((Gateway)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Gateway(shapeId, shapeText);
            }
            if (!newObj.isMarkerVisible().booleanValue()) {
                this.setPM5GatewayAttributes(newObj, shapeNode);
            }
            this.setAttributesFromProperties((GraphicalElement)newObj, shapeNode);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Event) {
            Event newObj;
            try {
                newObj = ((Event)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Event(shapeId, shapeText);
            }
            this.setPM5EventAttributes(newObj, shapeNode);
            this.setAttributesFromProperties((GraphicalElement)newObj, shapeNode);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Task) {
            Subprocess newObj;
            Double subprocFlag = this.getXmlNumber(shapeNode, "User[@NameU='HasSubprocess']/Value/text()");
            if (subprocFlag == 1.0) {
                newObj = new Subprocess(shapeId, shapeText);
            } else {
                try {
                    newObj = ((Task)template).clone(shapeId);
                    newObj.setName(shapeText);
                }
                catch (CloneNotSupportedException e) {
                    _log.warning("Unable to clone " + masterName);
                    newObj = new Task(shapeId, shapeText);
                }
            }
            this.setPM5TaskAttributes((Task)newObj, shapeNode);
            newObj.setDocumentation(this.getXmlString(shapeNode, "Prop[@NameU='Description']/Value/text()"));
            String systemApp = this.getXmlString(shapeNode, "Prop[@NameU='Application']/Value/text()");
            String systemScreen = this.getXmlString(shapeNode, "Prop[@NameU='Module']/Value/text()");
            String systemNav = this.getXmlString(shapeNode, "Prop[@NameU='Navigation']/Value/text()");
            if (!systemNav.equals("")) {
                if (newObj instanceof Task) {
                    ((Task)newObj).setTaskType(Task.TaskType.USER);
                }
                newObj.setAttribute("SYSTEM_APPLICATION", (Object)systemApp);
                newObj.setAttribute("SYSTEM_SCREEN_NAME", (Object)systemScreen);
                newObj.setAttribute("SYSTEM_NAVIGATION", (Object)systemNav);
            }
            this.setAttributesFromProperties((GraphicalElement)newObj, shapeNode);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Subprocess) {
            Subprocess newObj;
            try {
                newObj = ((Subprocess)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Subprocess(shapeId, shapeText);
            }
            this.setAttributesFromProperties((GraphicalElement)newObj, shapeNode);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Lane) {
            Lane newObj;
            try {
                newObj = ((Lane)template).clone(shapeId);
                newObj.setName(shapeText);
                newObj.setPool(defaultPool);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Lane(shapeId, shapeText, defaultPool);
            }
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            String blength = this.getXmlString(shapeNode, "User[@NameU='Blength']/Value/text()");
            String bheight = this.getXmlString(shapeNode, "User[@NameU='BHeight']/Value/text()");
            if (blength != null && !blength.equals("")) {
                newObj.setWidth(this.getXmlNumber(shapeNode, "User[@NameU='Blength']/Value/text()").doubleValue());
            } else if (bheight != null && !bheight.equals("")) {
                newObj.setHeight(this.getXmlNumber(shapeNode, "User[@NameU='BHeight']/Value/text()").doubleValue());
            }
        } else if (template instanceof Pool) {
            Node shape1XFormNode;
            Pool newObj;
            try {
                newObj = ((Pool)template).clone(shapeId);
                newObj.setName(shapeText);
                newObj.setModel(bpd);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Pool(shapeId, shapeText, bpd);
            }
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            NodeList insideShapes = this.getXmlNodeset(shapeNode, "descendant::Shape[@ID]");
            _log.fine("  Pool inside shapes: " + insideShapes.getLength());
            if (insideShapes.getLength() > 0 && (shape1XFormNode = this.getXmlNode(shapeNode, "Shapes/Shape[1]/XForm")) != null) {
                double x = this.getXmlNumber(shape1XFormNode, "PinX/text()");
                double y = this.getXmlNumber(shapeNode, "XForm/PinY/text()");
                double locX = this.getXmlNumber(shape1XFormNode, "LocPinX/text()");
                double locY = this.getXmlNumber(shape1XFormNode, "LocPinY/text()");
                double h = this.getXmlNumber(shape1XFormNode, "Height/text()");
                double w = this.getXmlNumber(shape1XFormNode, "Width/text()");
                if (w > (double)newObj.getWidth()) {
                    newObj.setPosition(x, y);
                    newObj.setHeight(h);
                    newObj.setWidth(w);
                    this.setCoordinateSystemPool(newObj, locX, locY);
                }
            }
        } else if (template instanceof DataObject) {
            DataObject newObj;
            try {
                newObj = ((DataObject)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new DataObject(shapeId, shapeText);
            }
            newObj.setAttribute("VISIO_MASTER", (Object)masterName);
            this.setAttributesFromProperties((GraphicalElement)newObj, shapeNode);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Annotation) {
            Annotation newObj;
            try {
                newObj = ((Annotation)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Annotation(shapeId, shapeText);
            }
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template instanceof Group) {
            Group newObj;
            try {
                newObj = ((Group)template).clone(shapeId);
                newObj.setName(shapeText);
            }
            catch (CloneNotSupportedException e) {
                _log.warning("Unable to clone " + masterName);
                newObj = new Group(shapeId, shapeText);
            }
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (masterName.equals("<none>")) {
            Task newObj = new Task(shapeId, shapeText);
            newObj.setAttribute("VISIO_MASTER", (Object)masterName);
            this.setNodeGraphics((GraphicalElement)newObj, shapeNode);
            this.setInsideShapes((GraphicalElement)newObj, shapeNode, insideShapeIDMap);
            bpd.addNode((FlowObject)newObj);
        } else if (template != null) {
            _log.warning("Unindentified node found: " + shapeId + " " + masterName);
        }
    }

    private LinkedList<Coordinate> getFlowPath(Node shapeNode) {
        LinkedList<Coordinate> path = new LinkedList<Coordinate>();
        Node XForm1DNode = this.getXmlNode(shapeNode, "child::XForm1D");
        double begX = this.getXmlNumber(XForm1DNode, "BeginX/text()");
        double begY = this.getXmlNumber(XForm1DNode, "BeginY/text()");
        double endX = this.getXmlNumber(XForm1DNode, "EndX/text()");
        double endY = this.getXmlNumber(XForm1DNode, "EndY/text()");
        if (begX != endX || begY != endY) {
            path.add(new Coordinate(begX, begY));
            Node XFormNode = this.getXmlNode(shapeNode, "child::XForm");
            double x = this.getXmlNumber(XFormNode, "PinX/text()");
            double y = this.getXmlNumber(XFormNode, "PinY/text()");
            double locX = this.getXmlNumber(XFormNode, "LocPinX/text()");
            double locY = this.getXmlNumber(XFormNode, "LocPinY/text()");
            NodeList points = this.getXmlNodeset(shapeNode, "child::Geom/LineTo/X");
            for (int j = 0; j < points.getLength() - 1; ++j) {
                double x1 = this.getXmlNumber(points.item(j), "text()");
                double y1 = this.getXmlNumber(points.item(j), "following-sibling::Y/text()");
                x1 = x1 + x - locX;
                y1 = y1 + y - locY;
                Coordinate intermediate = new Coordinate(x1, y1);
                path.add(intermediate);
            }
            path.add(new Coordinate(endX, endY));
        }
        return path;
    }

    private NodeList getXmlNodeset(Document doc, String xpathQuery) {
        if (doc == null) {
            throw new RuntimeException("Argument 'doc' is null. xpathQuery: " + xpathQuery);
        }
        try {
            return (NodeList)this._xpath.evaluate(xpathQuery, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            _log.severe(e.getMessage() + "\nXPATH expression: " + xpathQuery);
            throw new RuntimeException(e);
        }
    }

    private NodeList getXmlNodeset(Node item, String xpathQuery) {
        if (item == null) {
            throw new RuntimeException("Argument 'item' is null. xpathQuery: " + xpathQuery);
        }
        try {
            return (NodeList)this._xpath.evaluate(xpathQuery, item, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            _log.severe(e.getMessage() + "\nXPATH expression: " + xpathQuery);
            return null;
        }
    }

    private Node getXmlNode(Node item, String xpathQuery) {
        if (item == null) {
            throw new RuntimeException("Argument 'item' is null. xpathQuery: " + xpathQuery);
        }
        try {
            return (Node)this._xpath.evaluate(xpathQuery, item, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            _log.severe(e.getMessage() + "\nXPATH expression: " + xpathQuery);
            return null;
        }
    }

    private String getXmlString(Node item, String xpathQuery) {
        if (item == null) {
            _log.severe("Argument 'item' is null. xpathQuery: " + xpathQuery + ". Returning null string.");
            return "";
        }
        try {
            String s = (String)this._xpath.evaluate(xpathQuery, item, XPathConstants.STRING);
            return s.trim().replace("\n\n", "\n");
        }
        catch (XPathExpressionException e) {
            _log.severe(e.getMessage() + "\nXPATH expression: " + xpathQuery);
            return "";
        }
    }

    private Double getXmlNumber(Node item, String xpathQuery) {
        String resultString;
        Double result = 0.0;
        if (item == null) {
            _log.severe("Argument 'item' is null. xpathQuery: " + xpathQuery + ". Returning 0.0.");
            return result;
        }
        try {
            resultString = (String)this._xpath.evaluate(xpathQuery, item, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            _log.severe(e.getMessage() + "\nXPATH expression: " + xpathQuery + "\nItem: ");
            return result;
        }
        if (resultString == null || resultString.equals("")) {
            return result;
        }
        try {
            result = Double.parseDouble(resultString);
        }
        catch (NumberFormatException e) {
            _log.warning("'" + xpathQuery + "' is not a valid number. Returning 0.0.");
            result = 0.0;
        }
        return result;
    }

    private void setNodeGraphics(GraphicalElement node, Node xmlNode) {
        double locY;
        double locX;
        Node XFormNode = this.getXmlNode(xmlNode, "child::XForm");
        double x = this.getXmlNumber(XFormNode, "PinX/text()");
        double y = this.getXmlNumber(XFormNode, "PinY/text()");
        node.setPosition(x, y);
        double angle = Math.abs(Math.toDegrees(this.getXmlNumber(XFormNode, "Angle/text()")));
        if (Math.abs(angle - 90.0) < 5.0 || Math.abs(angle - 270.0) < 5.0) {
            node.setWidth(this.getXmlNumber(XFormNode, "Height/text()").doubleValue());
            node.setHeight(this.getXmlNumber(XFormNode, "Width/text()").doubleValue());
            locX = this.getXmlNumber(XFormNode, "LocPinY/text()");
            locY = this.getXmlNumber(XFormNode, "LocPinX/text()");
        } else {
            node.setWidth(this.getXmlNumber(XFormNode, "Width/text()").doubleValue());
            node.setHeight(this.getXmlNumber(XFormNode, "Height/text()").doubleValue());
            locX = this.getXmlNumber(XFormNode, "LocPinX/text()");
            locY = this.getXmlNumber(XFormNode, "LocPinY/text()");
        }
        this.setCoordinateSystem(node, locX, locY);
    }

    private void setPM5GatewayAttributes(Gateway g, Node shapeNode) {
        String metaData = this.getXmlString(shapeNode, "child::Shapes/Shape/ForeignData/text()");
        if (!metaData.equals("")) {
            String metaData1 = metaData.substring(42, 50);
            if ((metaData = metaData.substring(64, 67)).equals("FAU")) {
                g.setGatewayType(Gateway.GatewayType.XOR_EVENT);
                g.setMarkerVisible(Boolean.valueOf(true));
            } else if (metaData.equals("nAQ")) {
                if (metaData1.equals("DjAgAA4w")) {
                    g.setGatewayType(Gateway.GatewayType.AND);
                    g.setMarkerVisible(Boolean.valueOf(true));
                } else if (metaData1.equals("A6AgAAgg")) {
                    g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    g.setMarkerVisible(Boolean.valueOf(true));
                } else {
                    g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    g.setMarkerVisible(Boolean.valueOf(false));
                }
            } else if (metaData.equals("OAY")) {
                g.setGatewayType(Gateway.GatewayType.OR);
                g.setMarkerVisible(Boolean.valueOf(true));
            } else if (metaData.equals("aAU")) {
                g.setGatewayType(Gateway.GatewayType.COMPLEX);
                g.setMarkerVisible(Boolean.valueOf(true));
            } else {
                g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                g.setMarkerVisible(Boolean.valueOf(false));
            }
        }
    }

    private void setAttributesFromProperties(GraphicalElement obj, Node shapeNode) {
        String doc = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnDocumentation']/Value/text()");
        if (!doc.equals("")) {
            obj.setDocumentation(doc);
        }
        if (obj instanceof Activity) {
            String compensation;
            String loopType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnLoopType']/Value/text()");
            if (!loopType.equals("")) {
                if (loopType.equals("None")) {
                    ((Activity)obj).setLoopType(Activity.LoopType.NONE);
                } else if (loopType.equals("Standard")) {
                    ((Activity)obj).setLoopType(Activity.LoopType.STANDARD);
                } else if (loopType.equals("MultiInstance")) {
                    ((Activity)obj).setLoopType(Activity.LoopType.MULTIINSTANCE);
                }
            }
            if (!(compensation = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnIsForCompensation']/Value/text()")).equals("")) {
                ((Activity)obj).setCompensation(Boolean.valueOf(compensation.equals("1")));
            }
            if (obj instanceof Task) {
                String taskType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnTaskType']/Value/text()");
                if (!taskType.equals("")) {
                    if (taskType.equals("None")) {
                        ((Task)obj).setTaskType(Task.TaskType.NONE);
                    } else if (taskType.equals("Service")) {
                        ((Task)obj).setTaskType(Task.TaskType.SERVICE);
                    } else if (taskType.equals("Receive")) {
                        ((Task)obj).setTaskType(Task.TaskType.RECEIVE);
                    } else if (taskType.equals("Send")) {
                        ((Task)obj).setTaskType(Task.TaskType.SEND);
                    } else if (taskType.equals("User")) {
                        ((Task)obj).setTaskType(Task.TaskType.USER);
                    } else if (taskType.equals("Script")) {
                        ((Task)obj).setTaskType(Task.TaskType.SCRIPT);
                    } else if (taskType.equals("Abstract")) {
                        ((Task)obj).setTaskType(Task.TaskType.NONE);
                    } else if (taskType.equals("Manual")) {
                        ((Task)obj).setTaskType(Task.TaskType.MANUAL);
                    } else if (taskType.equals("Reference")) {
                        ((Task)obj).setTaskType(Task.TaskType.REFERENCE);
                    }
                }
            } else if (obj instanceof Subprocess) {
                String subType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnSubProcessType']/Value/text()");
                if (subType.equals("Embedded")) {
                    ((Subprocess)obj).setSubprocessType(Subprocess.SubprocessType.EMBEDDED);
                } else if (subType.equals("Reusable")) {
                    ((Subprocess)obj).setSubprocessType(Subprocess.SubprocessType.REUSABLE);
                } else if (subType.equals("Reference")) {
                    ((Subprocess)obj).setSubprocessType(Subprocess.SubprocessType.REFERENCE);
                }
                String collapsed = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnIsCollapsed']/Value/text()");
                String transaction = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnIsATransaction']/Value/text()");
                String adhoc = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnAdHoc']/Value/text()");
                if (!collapsed.equals("")) {
                    ((Subprocess)obj).setExpanded(Boolean.valueOf(!collapsed.equals("1")));
                }
                if (!transaction.equals("")) {
                    ((Subprocess)obj).setTransaction(Boolean.valueOf(transaction.equals("1")));
                }
                if (!adhoc.equals("")) {
                    ((Subprocess)obj).setAdHoc(Boolean.valueOf(adhoc.equals("1")));
                }
            }
        } else if (obj instanceof Event) {
            String eventType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnEventType']/Value/text()");
            String trigger = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnTriggerOrResult']/Value/text()");
            if (!eventType.equals("")) {
                if (eventType.equals("Start")) {
                    ((Event)obj).setEventType(Event.EventType.START);
                } else if (eventType.equals("Intermediate")) {
                    ((Event)obj).setEventType(Event.EventType.INTERMEDIATE);
                    ((Event)obj).setDirection(Event.Direction.CATCH);
                } else if (eventType.equals("Intermediate (Throwing)")) {
                    ((Event)obj).setEventType(Event.EventType.INTERMEDIATE);
                    ((Event)obj).setDirection(Event.Direction.THROW);
                } else if (eventType.equals("End")) {
                    ((Event)obj).setEventType(Event.EventType.END);
                }
            }
            if (!trigger.equals("")) {
                if (trigger.equals("None")) {
                    ((Event)obj).setTrigger(Event.Trigger.NONE);
                } else if (trigger.equals("Message")) {
                    ((Event)obj).setTrigger(Event.Trigger.MESSAGE);
                } else if (trigger.equals("Timer")) {
                    ((Event)obj).setTrigger(Event.Trigger.TIMER);
                } else if (trigger.equals("Error")) {
                    ((Event)obj).setTrigger(Event.Trigger.ERROR);
                } else if (trigger.equals("Cancel")) {
                    ((Event)obj).setTrigger(Event.Trigger.CANCEL);
                } else if (trigger.equals("Compensation")) {
                    ((Event)obj).setTrigger(Event.Trigger.COMPENSATION);
                } else if (trigger.equals("Conditional")) {
                    ((Event)obj).setTrigger(Event.Trigger.CONDITIONAL);
                } else if (trigger.equals("Link")) {
                    ((Event)obj).setTrigger(Event.Trigger.LINK);
                } else if (trigger.equals("Signal")) {
                    ((Event)obj).setTrigger(Event.Trigger.SIGNAL);
                } else if (trigger.equals("Terminate")) {
                    ((Event)obj).setTrigger(Event.Trigger.TERMINATE);
                } else if (trigger.equals("Multiple")) {
                    ((Event)obj).setTrigger(Event.Trigger.MULTIPLE);
                }
            }
        } else if (obj instanceof Gateway) {
            String gatewayType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnGatewayType']/Value/text()");
            if (!gatewayType.equals("")) {
                if (gatewayType.equals("Exclusive")) {
                    String xorType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnExclusiveType']/Value/text()");
                    if (xorType.equals("Event")) {
                        ((Gateway)obj).setGatewayType(Gateway.GatewayType.XOR_EVENT);
                    } else {
                        ((Gateway)obj).setGatewayType(Gateway.GatewayType.XOR_DATA);
                        String markerVisible = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnMarkerVisible']/Value/text()");
                        ((Gateway)obj).setMarkerVisible(Boolean.valueOf(markerVisible.equals("1")));
                    }
                }
                if (gatewayType.equals("Inclusive")) {
                    ((Gateway)obj).setGatewayType(Gateway.GatewayType.OR);
                }
                if (gatewayType.equals("Parallel")) {
                    ((Gateway)obj).setGatewayType(Gateway.GatewayType.AND);
                }
                if (gatewayType.equals("Complex")) {
                    ((Gateway)obj).setGatewayType(Gateway.GatewayType.COMPLEX);
                }
            }
        } else if (obj instanceof DataObject) {
            ((DataObject)obj).setState(this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnState']/Value/text()"));
        } else if (obj instanceof ConnectingObject) {
            String direction;
            String condType;
            if (obj instanceof SequenceFlow && !(condType = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnConditionType']/Value/text()")).equals("") && !condType.equals("None")) {
                if (condType.equals("Expression")) {
                    ((SequenceFlow)obj).setConditional(Boolean.valueOf(true));
                } else if (condType.equals("Default")) {
                    ((SequenceFlow)obj).setDefault(Boolean.valueOf(true));
                }
            }
            if (obj instanceof Association && !(direction = this.getXmlString(shapeNode, "child::Prop[@NameU='BpmnDirection']/Value/text()")).equals("")) {
                if (direction.equals("None")) {
                    ((Association)obj).setDirection(Association.Direction.NONE);
                } else if (direction.equals("One")) {
                    ((Association)obj).setDirection(Association.Direction.ONE);
                } else if (direction.equals("Both")) {
                    ((Association)obj).setDirection(Association.Direction.BOTH);
                }
            }
        }
    }

    private void setPM5EventAttributes(Event e, Node shapeNode) {
        String metaData = this.getXmlString(shapeNode, "child::Shapes/Shape/ForeignData/text()");
        if (!metaData.equals("")) {
            String metaData1 = metaData.substring(64, 72);
            if ((metaData = metaData.substring(42, 50)).equals("C2AQAAQw") || metaData.equals("C2AQAARA")) {
                e.setTrigger(Event.Trigger.MESSAGE);
                if (metaData1.equals("6AYAAC8A")) {
                    e.setDirection(Event.Direction.THROW);
                }
            } else if (metaData.equals("DCAQAAwg")) {
                e.setTrigger(Event.Trigger.TIMER);
            } else if (metaData.equals("CCAQAAhA")) {
                e.setTrigger(Event.Trigger.CONDITIONAL);
            } else if (metaData.equals("DHAQAAlw")) {
                e.setTrigger(Event.Trigger.SIGNAL);
                if (metaData1.equals("dAgAADsA")) {
                    e.setDirection(Event.Direction.THROW);
                }
            } else if (metaData.equals("DBAQAAsA")) {
                e.setTrigger(Event.Trigger.MULTIPLE);
                if (metaData1.equals("JAQAAB0A")) {
                    e.setDirection(Event.Direction.THROW);
                }
            } else if (metaData.equals("BcAQAAzw")) {
                e.setTrigger(Event.Trigger.ERROR);
            } else if (metaData.equals("DRAQAA0Q")) {
                e.setTrigger(Event.Trigger.CANCEL);
            } else if (metaData.equals("CTAQAAnw")) {
                e.setTrigger(Event.Trigger.COMPENSATION);
            } else if (metaData.equals("DSAQAAfA")) {
                e.setTrigger(Event.Trigger.LINK);
            } else if (metaData.equals("C+AQAAvg")) {
                e.setTrigger(Event.Trigger.TERMINATE);
            } else {
                e.setTrigger(Event.Trigger.NONE);
            }
        }
    }

    private void setPM5TaskAttributes(Task t, Node shapeNode) {
        String metaData = this.getXmlString(shapeNode, "child::Shapes/Shape/ForeignData/text()");
        if (!metaData.equals("")) {
            if ((metaData = metaData.substring(210, 215)).equals("qAGQ2")) {
                t.setTaskType(Task.TaskType.NONE);
            } else if (metaData.equals("0EEEF")) {
                t.setTaskType(Task.TaskType.USER);
            } else if (metaData.equals("yEo0U")) {
                t.setTaskType(Task.TaskType.MANUAL);
            } else if (metaData.equals("GFlmm")) {
                t.setTaskType(Task.TaskType.SEND);
            } else if (metaData.equals("MUpJq")) {
                t.setTaskType(Task.TaskType.RECEIVE);
            } else if (metaData.equals("aXJld")) {
                t.setTaskType(Task.TaskType.SCRIPT);
            } else if (metaData.equals("UVERP")) {
                t.setTaskType(Task.TaskType.REFERENCE);
            } else if (metaData.equals("G4q06")) {
                t.setTaskType(Task.TaskType.SERVICE);
            } else if (metaData.equals("qAEAA")) {
                t.setTaskType(Task.TaskType.NONE);
                t.setLoopType(Activity.LoopType.STANDARD);
            } else if (metaData.equals("/AAAA")) {
                t.setTaskType(Task.TaskType.NONE);
                t.setLoopType(Activity.LoopType.MULTIINSTANCE);
            } else {
                t.setTaskType(Task.TaskType.NONE);
            }
        }
    }

    private void setInsideShapes(GraphicalElement node, Node xmlNode, HashMap<String, String> insideShapesMap) {
        NodeList insideShapes = this.getXmlNodeset(xmlNode, "descendant::Shape[@ID]");
        _log.fine("    inside shapes: " + insideShapes.getLength());
        for (int s = 0; s < insideShapes.getLength(); ++s) {
            String insideShapeID = this.getXmlString(insideShapes.item(s), "attribute::ID");
            insideShapesMap.put(insideShapeID, node.getID());
        }
    }

    private void setCoordinateSystem(GraphicalElement object, double locX, double locY) {
        if (locX == 0.0 && locY == 0.0) {
            object.setObjectPin(GraphicalElement.ObjectPin.LOWERLEFT);
        } else if (locX == 0.0 && Math.abs(locY - (double)object.getHeight()) <= 0.1) {
            object.setObjectPin(GraphicalElement.ObjectPin.UPPERLEFT);
        } else if (Math.abs(locX - (double)object.getWidth() * 0.5) <= 0.1 && Math.abs(locY - (double)object.getHeight() * 0.5) <= 0.1) {
            object.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
        } else {
            _log.warning("Unable to identify coordinate system of object " + object.getName() + "(" + object.getID() + ").");
            object.setPosition((double)object.getX() - locX, (double)object.getY() - locY);
            object.setObjectPin(GraphicalElement.ObjectPin.LOWERLEFT);
        }
    }

    private void setCoordinateSystemlane(Lane object, double locX, double locY) {
        this.setCoordinateSystem((GraphicalElement)object, locX, locY);
    }

    private void setCoordinateSystemPool(Pool object, double locX, double locY) {
        this.setCoordinateSystem((GraphicalElement)object, locX, locY);
    }

    private void setEventTypes(BusinessProcessDiagram bpd) {
        for (FlowObject o : bpd.getAllNodes().values()) {
            Event e;
            if (!(o instanceof Event) || (e = (Event)o).getEventType() != null) continue;
            if (e.getInflows(SequenceFlow.class).isEmpty()) {
                e.setEventType(Event.EventType.START);
                continue;
            }
            if (e.getOutflows(SequenceFlow.class).isEmpty()) {
                e.setEventType(Event.EventType.END);
                continue;
            }
            e.setEventType(Event.EventType.INTERMEDIATE);
        }
    }

    private void connectUngluedConnectors(BusinessProcessDiagram bpd) {
        double sumHeight = 0.0;
        int count = 0;
        for (FlowObject node : bpd.getAllNodes().values()) {
            if (!(node instanceof Task) && !(node instanceof Event) && !(node instanceof Gateway) && (!(node instanceof Subprocess) || ((Subprocess)node).isExpanded().booleanValue())) continue;
            sumHeight += (double)node.getHeight();
            ++count;
        }
        double fudge = count > 0 ? sumHeight / (double)count / 10.0 : 0.1;
        for (ConnectingObject flow : bpd.getAllFlows().values()) {
            if (flow.getPath().isEmpty() || flow.getFrom() != null && flow.getTo() != null) continue;
            for (GraphicalElement node : bpd.getGraphicalElements().values()) {
                double objectX = this.getTrueX(node);
                double objectY = this.getTrueY(node);
                double objectHeight = node.getHeight();
                double objectWidth = node.getWidth();
                if (flow.getFrom() == null) {
                    Coordinate flowStart = (Coordinate)flow.getPath().getFirst();
                    if ((node instanceof Gateway || node instanceof Event) && this.isInside(flowStart, objectX - fudge, objectY - fudge, objectHeight + fudge * 2.0, objectWidth + fudge * 2.0)) {
                        flow.setFrom(node);
                    } else if (this.isInside(flowStart, objectX - fudge, objectY - fudge, objectHeight + fudge * 2.0, objectWidth + fudge * 2.0) && !this.isInside(flowStart, objectX + fudge, objectY + fudge, objectHeight - fudge * 2.0, objectWidth - fudge * 2.0)) {
                        flow.setFrom(node);
                    }
                }
                if (flow.getTo() != null) continue;
                Coordinate flowEnd = (Coordinate)flow.getPath().getLast();
                if ((node instanceof Gateway || node instanceof Event) && this.isInside(flowEnd, objectX - fudge, objectY - fudge, objectHeight + fudge * 2.0, objectWidth + fudge * 2.0)) {
                    flow.setTo(node);
                    continue;
                }
                if (!this.isInside(flowEnd, objectX - fudge, objectY - fudge, objectHeight + fudge * 2.0, objectWidth + fudge * 2.0) || this.isInside(flowEnd, objectX + fudge, objectY + fudge, objectHeight - fudge * 2.0, objectWidth - fudge * 2.0)) continue;
                flow.setTo(node);
            }
            _log.info("Connected unglued flow: " + flow.getID() + " '" + flow.getName() + "'  FromNode: '" + (flow.getFrom() == null ? "NULL" : flow.getFrom().getName()) + "' ToNode: '" + (flow.getTo() == null ? "NULL" : flow.getTo().getName()) + "'");
        }
    }

    private boolean containsOtherNodes(BusinessProcessDiagram bpd, FlowObject node) {
        boolean found = false;
        for (FlowObject otherNode : bpd.getAllNodes().values()) {
            if (!this.isInside((GraphicalElement)otherNode, (GraphicalElement)node)) continue;
            found = true;
            _log.fine(otherNode.getName() + "(" + otherNode.getID() + ") found inside " + node.getName() + "(" + node.getID() + ")");
            break;
        }
        return found;
    }

    private boolean isInside(GraphicalElement node, GraphicalElement otherNode) {
        double nodeX = this.getTrueX(node) + 0.01;
        double nodeY = this.getTrueY(node) + 0.01;
        double nodeW = (double)node.getWidth() - 0.02;
        double nodeH = (double)node.getHeight() - 0.02;
        double otherX = this.getTrueX(otherNode);
        double otherY = this.getTrueY(otherNode);
        double otherH = otherNode.getHeight();
        double otherW = otherNode.getWidth();
        boolean inside = node.getID() != otherNode.getID() && nodeX >= otherX && nodeX + nodeW <= otherX + otherW && nodeY >= otherY && nodeY + nodeH <= otherY + otherH;
        return inside;
    }

    private boolean isInside(Coordinate point, double x, double y, double height, double width) {
        double pX = point.getX();
        double pY = point.getY();
        return pX >= x && pX <= x + width && pY >= y && pY <= y + height;
    }

    private void setPoolsLanesObjects(BusinessProcessDiagram bpd, Pool defaultPool) {
        LinkedList tmplanes = new LinkedList(defaultPool.getLanes().values());
        for (Lane lane : tmplanes) {
            for (Pool pool : bpd.getPools().values()) {
                if (!this.isInside((GraphicalElement)lane, (GraphicalElement)pool)) continue;
                lane.setPool(pool);
            }
        }
        block2: for (FlowObject node : bpd.getAllNodes().values()) {
            block3: for (Pool pool : bpd.getPools().values()) {
                for (Lane lane : pool.getLanes().values()) {
                    if (!this.isInside((GraphicalElement)node, (GraphicalElement)lane)) continue;
                    node.setLane(lane);
                    continue block3;
                }
            }
            if (node.getLane() != null) continue;
            for (Pool pool : bpd.getPools().values()) {
                if (!this.isInside((GraphicalElement)node, (GraphicalElement)pool)) continue;
                node.setLane(pool);
                continue block2;
            }
        }
        if (!defaultPool.getLanes().isEmpty()) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            for (Lane lane : defaultPool.getLanes().values()) {
                minX = Math.min(minX, this.getTrueX((GraphicalElement)lane));
                minY = Math.min(minY, this.getTrueY((GraphicalElement)lane));
                maxX = Math.max(maxX, this.getTrueX((GraphicalElement)lane) + (double)lane.getWidth());
                maxY = Math.max(maxY, this.getTrueY((GraphicalElement)lane) + (double)lane.getHeight());
            }
            defaultPool.setPosition(minX, minY);
            defaultPool.setWidth(maxX - minX);
            defaultPool.setHeight(maxY - minY);
            defaultPool.setVisible(Boolean.valueOf(true));
        } else {
            defaultPool.remove();
        }
    }

    private double getTrueX(GraphicalElement e) {
        double trueX;
        switch (e.getObjectPin()) {
            case MIDDLE: {
                trueX = e.getX() - e.getWidth() / 2.0f;
                break;
            }
            default: {
                trueX = e.getX();
            }
        }
        return trueX;
    }

    private double getTrueY(GraphicalElement e) {
        double trueY;
        switch (e.getObjectPin()) {
            case UPPERLEFT: {
                trueY = e.getY() - e.getHeight();
                break;
            }
            case MIDDLE: {
                trueY = e.getY() - e.getHeight() / 2.0f;
                break;
            }
            default: {
                trueY = e.getY();
            }
        }
        return trueY;
    }

    private void assignEventTargets(BusinessProcessDiagram bpd) {
        for (FlowObject o : bpd.getAllNodes().values()) {
            if (!(o instanceof Event)) continue;
            Event event = (Event)o;
            for (FlowObject c : bpd.getAllNodes().values()) {
                if (!(c instanceof Subprocess) && !(c instanceof Task)) continue;
                Activity activity = (Activity)c;
                double eventX = event.getX();
                double eventY = event.getY();
                double eventHeight = event.getHeight();
                double eventWidth = event.getWidth();
                double objectX = activity.getX();
                double objectY = activity.getY();
                double objectHeight = activity.getHeight();
                double objectWidth = activity.getWidth();
                if (!(eventX <= objectX + objectWidth * 0.5 + eventWidth * 0.5) || !(eventX >= objectX - objectWidth * 0.5 - eventWidth * 0.5) || !(eventY <= objectY + objectHeight * 0.5 + eventHeight * 0.5) || !(eventY >= objectY - objectHeight * 0.5 - eventHeight * 0.5) || eventX <= objectX + objectWidth * 0.5 - eventWidth * 0.5 && eventX >= objectX - objectWidth * 0.5 + eventWidth * 0.5 && eventY <= objectY + objectHeight * 0.5 - eventHeight * 0.5 && eventY >= objectY - objectHeight * 0.5 + eventHeight * 0.5) continue;
                event.setTarget(activity);
                event.setEventType(Event.EventType.INTERMEDIATE);
            }
        }
    }

    private void convertToAssociation(BusinessProcessDiagram bpd, ConnectingObject flow) {
        Association a2 = new Association();
        a2.setName("NEW.".concat(flow.getName()));
        if (flow.getFrom() != null) {
            a2.setFrom(flow.getFrom());
            _log.fine("fromnode:" + flow.getFrom().getName());
        }
        if (flow.getTo() != null) {
            a2.setTo(flow.getTo());
            _log.fine("tonode:" + flow.getTo().getName());
        }
        a2.setDirection(Association.Direction.ONE);
        a2.setPath(flow.getPath());
        int ID = Integer.parseInt(flow.getID());
        flow.remove();
        String IDs = Integer.toString(ID);
        a2.setID(IDs);
        bpd.addFlow((ConnectingObject)a2);
    }

    private void convertToGroup(BusinessProcessDiagram bpd, FlowObject node) {
        _log.info("Converting " + node.getClass().getName() + " '" + node.getName() + "' to Group");
        Group g2 = new Group();
        g2.setName(node.getName());
        g2.setPosition(node.getX(), node.getY());
        g2.setWidth(node.getWidth());
        g2.setHeight(node.getHeight());
        g2.setObjectPin(node.getObjectPin());
        int ID = Integer.parseInt(node.getID());
        node.remove();
        String IDs = Integer.toString(ID);
        g2.setID(IDs);
        bpd.addNode((FlowObject)g2);
        for (FlowObject n2 : bpd.getAllNodes().values()) {
            if (!this.isInside((GraphicalElement)n2, (GraphicalElement)g2)) continue;
            g2.getGroupNodes().put(n2.getID(), n2);
        }
    }

    private void convertToSubprocess(BusinessProcessDiagram bpd, FlowObject node) {
        if (node instanceof Subprocess) {
            ((Subprocess)node).setExpanded(Boolean.valueOf(true));
        } else {
            _log.info("Converting " + node.getClass().getName() + " '" + node.getName() + "' to Subprocess");
            Subprocess s1 = new Subprocess();
            s1.setExpanded(Boolean.valueOf(true));
            s1.setName(node.getName());
            s1.setPosition(node.getX(), node.getY());
            s1.setWidth(node.getWidth());
            s1.setHeight(node.getHeight());
            s1.setObjectPin(node.getObjectPin());
            LinkedList tmpFlowsin = new LinkedList(node.getInflows());
            for (ConnectingObject flow : tmpFlowsin) {
                flow.setTo((GraphicalElement)s1);
            }
            LinkedList tmpFlowsout = new LinkedList(node.getOutflows());
            for (ConnectingObject flow : tmpFlowsout) {
                flow.setFrom((GraphicalElement)s1);
            }
            int ID = Integer.parseInt(node.getID());
            node.remove();
            String IDs = Integer.toString(ID);
            s1.setID(IDs);
            bpd.addNode((FlowObject)s1);
            node = s1;
        }
        for (FlowObject node2 : bpd.getAllNodes().values()) {
            if (!this.isInside((GraphicalElement)node2, (GraphicalElement)node)) continue;
            node2.setParentSubProcess((Subprocess)node);
            _log.fine("    " + node2.getName() + " is a member of " + node.getName());
        }
    }

    private void statusMessage(String msg, double progress) throws UserCancelException {
        int intProgress = (int)Math.round(progress);
        this.statusMessage(msg, intProgress);
    }

    private void statusMessage(String msg, int progress) throws UserCancelException {
        if (this._progressDlg != null) {
            if (!this._progressDlg.updateStatus(msg, progress)) {
                throw new UserCancelException("User Cancel");
            }
        } else if (this._notifier != null) {
            this._notifier.update(msg, (double)progress);
        } else if (msg != null) {
            System.out.println(progress + "%: " + msg);
        }
    }
}

