/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.visio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.DataObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Group;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Task;
import oracle.tutor.visio.MasterNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MasterMapLoader {
    private boolean _isExceptionThrown = false;
    private static Logger _log = Logger.getLogger(MasterMapLoader.class.getName());
    private LinkedList<Exception> _exceptionList = new LinkedList();
    private URL _masterMapXSD = null;
    private HashMap<String, GraphicalElement> _masterMap = new HashMap();
    private static HashMap<String, Map> _attrsMap = new HashMap();
    private XPath _xpath;

    public static void main(String[] args) {
        MasterMapLoader m = new MasterMapLoader();
        try {
            HashMap<String, GraphicalElement> map = m.getMasterMap(null);
            for (String key : map.keySet()) {
                GraphicalElement bpmnElement = (GraphicalElement)map.get(key);
                System.out.println();
                System.out.println("==========================================");
                System.out.println(key + " : " + bpmnElement);
                if (bpmnElement == null) {
                    System.out.println("==========================================");
                    continue;
                }
                Map customAttrs = bpmnElement.getAttributes();
                if (customAttrs != null && !customAttrs.isEmpty()) {
                    System.out.println("Custom Attrs");
                    for (String attrName : customAttrs.keySet()) {
                        if (customAttrs.get(attrName) instanceof String) {
                            System.out.println(attrName + " : " + (String)customAttrs.get(attrName));
                            continue;
                        }
                        System.out.println(attrName + " : " + customAttrs.get(attrName));
                    }
                }
                if (bpmnElement instanceof Task) {
                    Task task = (Task)bpmnElement;
                    System.out.println("Task.TaskType              : " + task.getTaskType());
                    System.out.println("Task.LoopType              : " + task.getLoopType());
                    System.out.println("Task.isCompnesation        : " + task.isCompensation());
                } else if (bpmnElement instanceof Subprocess) {
                    Subprocess subprocess = (Subprocess)bpmnElement;
                    System.out.println("Subprocess.isAdHoc         : " + subprocess.isAdHoc());
                    System.out.println("Subprocess.isExpanded      : " + subprocess.isExpanded());
                    System.out.println("Subprocess.isTransaction   : " + subprocess.isTransaction());
                    System.out.println("subprocess.isCompensation  : " + subprocess.isCompensation());
                    System.out.println("subprocess.getLoopType     : " + subprocess.getLoopType());
                } else if (bpmnElement instanceof Event) {
                    Event event = (Event)bpmnElement;
                    System.out.println("event.getEventType         : " + event.getEventType());
                    System.out.println("event.getTrigger           : " + event.getTrigger());
                } else if (bpmnElement instanceof Gateway) {
                    Gateway gateway = (Gateway)bpmnElement;
                    System.out.println("gateway.getGatewayType     : " + gateway.getGatewayType());
                    System.out.println("gateway.isMarkerVisible    : " + gateway.isMarkerVisible());
                } else if (bpmnElement instanceof Pool) {
                    Pool pool = (Pool)bpmnElement;
                    System.out.println("pool.isVisible             : " + pool.isVisible());
                } else if (bpmnElement instanceof SequenceFlow) {
                    SequenceFlow sequenceFlow = (SequenceFlow)bpmnElement;
                    System.out.println("sequenceFlow.isConditional : " + sequenceFlow.isConditional());
                    System.out.println("sequenceFlow.isDefault     :" + sequenceFlow.isDefault());
                } else if (bpmnElement instanceof Association) {
                    Association assoc = (Association)bpmnElement;
                    System.out.println("Association Properties");
                    System.out.println("assoc.getDirection         : " + assoc.getDirection());
                }
                System.out.println("===========================================");
            }
            System.out.println("No. of Masters : " + map.size());
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, GraphicalElement> getMasterMap(String xmlFolderPath) throws FileNotFoundException, IOException {
        XPathFactory xf = XPathFactory.newInstance();
        this._xpath = xf.newXPath();
        this._xpath.setNamespaceContext(new MasterNamespaceContext());
        this._masterMapXSD = this._getFileUrl("VisioMasterMap.xsd", xmlFolderPath, true);
        this.loadMasterMap(this._getFileUrl("VisioMasterMap.xml", xmlFolderPath, true));
        this.loadMasterMap(this._getFileUrl("VisioUserMap.xml", xmlFolderPath, false));
        return this._masterMap;
    }

    private URL _getFileUrl(String filename, String xmlFolderPath, Boolean errorIfMissing) throws FileNotFoundException {
        URL url = null;
        if (xmlFolderPath != null) {
            String filePath = xmlFolderPath.concat(File.separator).concat(filename);
            File file = new File(filePath);
            if (file.exists()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(file.getAbsolutePath() + " is not a valid path.");
                }
            } else if (errorIfMissing.booleanValue()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
        } else {
            url = this.getClass().getClassLoader().getResource(filename);
            if (url != null) {
                _log.info("Loaded resource '" + url.getPath() + "'");
            } else {
                if (errorIfMissing.booleanValue()) {
                    throw new RuntimeException("Unable to load " + filename + " from classpath.");
                }
                _log.warning("Unable to load '" + filename + "' from classpath.");
            }
        }
        return url;
    }

    private void loadMasterMap(URL mapFile) throws FileNotFoundException {
        if (mapFile != null) {
            NodeList masters = this.getMasters(mapFile);
            this.loadAttributesMap();
            for (int i = 0; i < masters.getLength(); ++i) {
                Node master = masters.item(i);
                String masterName = this.getAttrValue(master, "Name").toLowerCase();
                try {
                    GraphicalElement bpmnElement = null;
                    if (this.hasBPMNObjectChild(master)) {
                        bpmnElement = this.setElementProperties(master, false);
                    } else if (this.hasLikeAttribute(master)) {
                        String referencingMaster = this.getAttrValue(master, "Like").toLowerCase();
                        if (this._masterMap.get(referencingMaster) == null && !this._masterMap.containsKey(referencingMaster)) {
                            throw new Exception("referencing master '" + referencingMaster + "' is not loaded yet for '" + masterName + "'");
                        }
                        bpmnElement = this._masterMap.get(referencingMaster);
                    } else if (this.hasExtendsAttribute(master)) {
                        bpmnElement = this.setElementProperties(master, true);
                    }
                    if (this._masterMap.containsKey(masterName)) {
                        if (mapFile.getPath().toLowerCase().endsWith("visiomastermap.xml")) {
                            throw new Exception("Master named '" + masterName + "' already exists in VisioMasterMap.xml file");
                        }
                        if (!mapFile.getPath().toLowerCase().endsWith("visiousermap.xml")) continue;
                        _log.info("'" + masterName + "' is overwriting a prior entry");
                        this._masterMap.put(masterName, bpmnElement);
                        continue;
                    }
                    this._masterMap.put(masterName, bpmnElement);
                    continue;
                }
                catch (Exception e) {
                    this.setExceptionFlag(e);
                }
            }
        }
    }

    private NodeList getMasters(URL mapFile) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        NodeList masters = null;
        try {
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = null;
            doc = db.parse(mapFile.openStream());
            DOMSource source = new DOMSource(doc);
            Validator validator = null;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this._masterMapXSD);
            validator = schema.newValidator();
            try {
                validator.validate(source);
            }
            catch (SAXException e) {
                _log.severe("'" + mapFile.getFile() + "' input mapping xml file is not valid: " + e.getMessage());
                throw new RuntimeException("'" + mapFile.getFile() + "' input mapping xml file is not valid: " + e.getMessage());
            }
            try {
                XPathExpression exp = this._xpath.compile("//pre:Masters/pre:Master");
                masters = (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                _log.severe("Masters/Master xpath expression cannot be compiled/evaluated: " + e.getMessage());
                throw new RuntimeException("Masters/Master xpath expression cannot be compiled/evaluated: " + e.getMessage());
            }
        }
        catch (ParserConfigurationException e) {
            _log.severe(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            _log.severe(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (SAXException e) {
            _log.severe(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return masters;
    }

    private GraphicalElement setElementProperties(Node master, boolean cloneElement) throws Exception {
        GraphicalElement bpmnElement = null;
        String masterName = this.getAttrValue(master, "Name").toLowerCase();
        if (cloneElement) {
            String referencingMaster = this.getAttrValue(master, "Extends").toLowerCase();
            bpmnElement = this._masterMap.get(referencingMaster);
            if (bpmnElement == null) {
                throw new Exception("referencing master '" + this.getAttrValue(master, "Extends") + "' is not loaded yet for '" + masterName + "'");
            }
            try {
                bpmnElement = bpmnElement.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Exception("'" + this.getAttrValue(master, "Extends") + "' cannot be cloned: " + e.getMessage());
            }
        }
        if (bpmnElement == null) {
            String bpmnType = this.getXPathResultString(master, "./pre:BPMNObject/text()");
            if (bpmnType.equalsIgnoreCase("Task")) {
                bpmnElement = new Task();
            } else if (bpmnType.equalsIgnoreCase("Subprocess")) {
                bpmnElement = new Subprocess();
            } else if (bpmnType.equalsIgnoreCase("Event")) {
                bpmnElement = new Event();
            } else if (bpmnType.equalsIgnoreCase("Gateway")) {
                bpmnElement = new Gateway();
            } else if (bpmnType.equalsIgnoreCase("DataObject")) {
                bpmnElement = new DataObject();
            } else if (bpmnType.equalsIgnoreCase("Group")) {
                bpmnElement = new Group();
            } else if (bpmnType.equalsIgnoreCase("Annotation")) {
                bpmnElement = new Annotation();
            } else if (bpmnType.equalsIgnoreCase("Lane")) {
                bpmnElement = new Lane();
            } else if (bpmnType.equalsIgnoreCase("Pool")) {
                bpmnElement = new Pool();
            } else if (bpmnType.equalsIgnoreCase("MessageFlow")) {
                bpmnElement = new MessageFlow();
            } else if (bpmnType.equalsIgnoreCase("SequenceFlow")) {
                bpmnElement = new SequenceFlow();
            } else if (bpmnType.equalsIgnoreCase("Association")) {
                bpmnElement = new Association();
            } else if (bpmnType.equalsIgnoreCase("null")) {
                bpmnElement = null;
            } else {
                throw new Exception("No BPMN Object representation defined for '" + bpmnType + "'. Found in Master : " + masterName);
            }
        }
        this.setAttributes(bpmnElement, master);
        return bpmnElement;
    }

    private void setAttributes(GraphicalElement bpmnElement, Node master) throws Exception {
        NodeList attrs = this.getXPathResultNodeList(master, "./pre:Attributes/pre:Attribute");
        if (attrs != null && attrs.getLength() != 0) {
            if (bpmnElement == null) {
                throw new Exception("Attributes cannot be set for master : " + this.getAttrValue(master, "Name"));
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrType;
                Node attr = attrs.item(i);
                try {
                    attrType = this.getAttrType(attr);
                }
                catch (Exception e) {
                    this.setExceptionFlag(e);
                    continue;
                }
                if (attrType.equals("custom")) {
                    bpmnElement.setAttribute(this.getAttrValue(attr, "Name"), (Object)this.getAttrValue(attr, "Value"));
                    continue;
                }
                if (!attrType.equals("bpmn")) continue;
                if (bpmnElement instanceof Task) {
                    this.setTaskAttribute((Task)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof Subprocess) {
                    this.setSubprocessAttribute((Subprocess)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof Event) {
                    this.setEventAttribute((Event)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof Gateway) {
                    this.setGatewayAttribute((Gateway)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof SequenceFlow) {
                    this.setSequenceFlowAttribute((SequenceFlow)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof Association) {
                    this.setAssociationAttribute((Association)bpmnElement, master, attr);
                    continue;
                }
                if (bpmnElement instanceof Pool) {
                    this.setPoolAttribute((Pool)bpmnElement, master, attr);
                    continue;
                }
                if (!(bpmnElement instanceof Lane) && !(bpmnElement instanceof DataObject) && !(bpmnElement instanceof Annotation) && !(bpmnElement instanceof Group) && !(bpmnElement instanceof MessageFlow)) continue;
                this.setExceptionFlag(new Exception("'" + attrType + "' cannot be set for master : " + this.getAttrValue(master, "Name")));
            }
        }
    }

    private void setPoolAttribute(Pool pool, Node master, Node attr) throws Exception {
        Object attrValue = this.getBPMNAttrValue(attr, master);
        String attrName = this.getAttrValue(attr, "Name");
        if (attrName.equalsIgnoreCase("BoundaryVisible")) {
            pool.setVisible(Boolean.valueOf((Boolean)attrValue));
        }
    }

    private void setAssociationAttribute(Association association, Node master, Node attr) throws Exception {
        Object attrValue = this.getBPMNAttrValue(attr, master);
        String attrName = this.getAttrValue(attr, "Name");
        if (attrName.equalsIgnoreCase("Direction")) {
            association.setDirection((Association.Direction)attrValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSequenceFlowAttribute(SequenceFlow sequenceflow, Node master, Node attr) throws Exception {
        String attrName = this.getAttrValue(attr, "Name");
        String attrValue = this.getAttrValue(attr, "Value");
        if (!attrName.equalsIgnoreCase("ConditionType")) throw new Exception("Invalid attribute " + attrName + " found in master " + this.getAttrValue(master, "Name"));
        if (attrValue.equalsIgnoreCase("NONE")) {
            sequenceflow.setConditional(Boolean.valueOf(false));
            return;
        } else if (attrValue.equalsIgnoreCase("EXPRESSION")) {
            sequenceflow.setConditional(Boolean.valueOf(true));
            return;
        } else {
            if (!attrValue.equalsIgnoreCase("DEFAULT")) throw new Exception("Invalid attribute value '" + attrValue + "' for 'ConditionType'. Found in master : " + this.getAttrValue(master, "Name"));
            sequenceflow.setDefault(Boolean.valueOf(true));
        }
    }

    private void setGatewayAttribute(Gateway gateway, Node master, Node attr) throws Exception {
        String attrName = this.getAttrValue(attr, "Name");
        Object attrValue = null;
        if (!this.getAttrValue(attr, "Value").equalsIgnoreCase("Exclusive")) {
            attrValue = this.getBPMNAttrValue(attr, master);
        }
        if (attrName.equalsIgnoreCase("GatewayType") && !this.getAttrValue(attr, "Value").equalsIgnoreCase("Exclusive")) {
            gateway.setGatewayType((Gateway.GatewayType)attrValue);
        } else if (attrName.equalsIgnoreCase("ExclusiveType")) {
            gateway.setGatewayType((Gateway.GatewayType)attrValue);
        } else if (attrName.equalsIgnoreCase("MarkerVisible")) {
            gateway.setMarkerVisible(Boolean.valueOf((Boolean)attrValue));
        }
    }

    private void setEventAttribute(Event event, Node master, Node attr) throws Exception {
        Object attrValue = this.getBPMNAttrValue(attr, master);
        String attrName = this.getAttrValue(attr, "Name");
        if (attrName.equalsIgnoreCase("EventType")) {
            event.setEventType((Event.EventType)attrValue);
        } else if (attrName.equalsIgnoreCase("Trigger")) {
            event.setTrigger((Event.Trigger)attrValue);
        } else if (attrName.equalsIgnoreCase("EventDirection")) {
            event.setDirection((Event.Direction)attrValue);
        }
    }

    private void setSubprocessAttribute(Subprocess subprocess, Node master, Node attr) throws Exception {
        Object attrValue = this.getBPMNAttrValue(attr, master);
        String attrName = this.getAttrValue(attr, "Name");
        if (attrName.equalsIgnoreCase("isExpanded")) {
            subprocess.setExpanded(Boolean.valueOf((Boolean)attrValue));
        } else if (attrName.equalsIgnoreCase("isATransaction")) {
            subprocess.setTransaction(Boolean.valueOf((Boolean)attrValue));
        } else if (attrName.equalsIgnoreCase("LoopType")) {
            subprocess.setLoopType((Activity.LoopType)attrValue);
        } else if (attrName.equalsIgnoreCase("isForCompensation")) {
            subprocess.setCompensation(Boolean.valueOf((Boolean)attrValue));
        } else if (attrName.equalsIgnoreCase("AdHoc")) {
            subprocess.setAdHoc(Boolean.valueOf((Boolean)attrValue));
        }
    }

    private void setTaskAttribute(Task task, Node master, Node attr) throws Exception {
        Object attrValue = this.getBPMNAttrValue(attr, master);
        String attrName = this.getAttrValue(attr, "Name");
        if (attrName.equalsIgnoreCase("TaskType")) {
            task.setTaskType((Task.TaskType)attrValue);
        } else if (attrName.equalsIgnoreCase("LoopType")) {
            task.setLoopType((Activity.LoopType)attrValue);
        } else if (attrName.equalsIgnoreCase("isForCompensation")) {
            task.setCompensation(Boolean.valueOf((Boolean)attrValue));
        }
    }

    private Object getBPMNAttrValue(Node attr, Node master) throws Exception {
        String name = this.getAttrValue(attr, "Name");
        Object value = null;
        Map valueMap = _attrsMap.get(name);
        if (valueMap != null) {
            value = valueMap.get(this.getAttrValue(attr, "Value"));
            if (value == null && !name.equalsIgnoreCase("EventType")) {
                throw new Exception("Invalid value '" + this.getAttrValue(attr, "Value") + "' for attribute '" + name + "' in Master : " + this.getAttrValue(master, "Name"));
            }
        } else {
            throw new Exception("Invalid attribute '" + name + "' found in Master : " + this.getAttrValue(master, "Name"));
        }
        return value;
    }

    private String getAttrType(Node attr) throws XPathExpressionException, Exception {
        return this.getAttrType(attr, true);
    }

    private String getAttrType(Node attr, boolean destType) throws Exception {
        String type = null;
        if (destType) {
            type = this.getAttrValue(attr, "Type");
            if (type == null) {
                type = "bpmn";
            } else if (type.equalsIgnoreCase("bpmn")) {
                type = "bpmn";
            } else if (type.equalsIgnoreCase("custom")) {
                type = "custom";
            } else {
                throw new Exception("'" + attr + "' is not a valid attribute type");
            }
        }
        return type;
    }

    private NodeList getXPathResultNodeList(Node node, String xpath) throws Exception {
        NodeList nl = null;
        try {
            XPathExpression exp = this._xpath.compile(xpath);
            if (exp != null) {
                nl = (NodeList)exp.evaluate(node, XPathConstants.NODESET);
            }
        }
        catch (XPathExpressionException e) {
            throw new Exception("'" + xpath + "' cannot be compiled/evaluated on node '" + this.getAttrValue(node, "Name") + "' : " + e.getMessage());
        }
        return nl;
    }

    private String getXPathResultString(Node node, String xpath) throws Exception {
        String result = null;
        try {
            XPathExpression exp = this._xpath.compile(xpath);
            if (exp != null) {
                result = exp.evaluate(node).trim().replace("\n\n", "\n");
            }
        }
        catch (XPathExpressionException e) {
            throw new Exception("'" + xpath + "' cannot be compiled/evaluated on node '" + this.getAttrValue(node, "Name") + " ': " + e.getMessage());
        }
        return result;
    }

    private String getAttrValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        Node attr = attrs.getNamedItem(attrName);
        return attr != null ? attr.getNodeValue() : null;
    }

    private boolean hasExtendsAttribute(Node master) {
        return this.getAttrValue(master, "Extends") != null;
    }

    private boolean hasLikeAttribute(Node master) {
        return this.getAttrValue(master, "Like") != null;
    }

    private boolean hasBPMNObjectChild(Node master) throws Exception {
        String result = this.getXPathResultString(master, "./pre:BPMNObject/text()");
        return result != null && !result.equals("");
    }

    private void setExceptionFlag(Exception e) {
        _log.warning(e.getMessage());
        if (!this._isExceptionThrown) {
            this._isExceptionThrown = true;
        }
        this._exceptionList.add(e);
    }

    private void loadAttributesMap() {
        HashMap<String, Task.TaskType> taskTypeMap = new HashMap<String, Task.TaskType>();
        taskTypeMap.put("None", Task.TaskType.NONE);
        taskTypeMap.put("Script", Task.TaskType.SCRIPT);
        taskTypeMap.put("Reference", Task.TaskType.REFERENCE);
        taskTypeMap.put("Service", Task.TaskType.SERVICE);
        taskTypeMap.put("User", Task.TaskType.USER);
        taskTypeMap.put("Manual", Task.TaskType.MANUAL);
        taskTypeMap.put("Send", Task.TaskType.SEND);
        taskTypeMap.put("Receive", Task.TaskType.RECEIVE);
        HashMap<String, Activity.LoopType> loopTypeMap = new HashMap<String, Activity.LoopType>();
        loopTypeMap.put("Standard", Activity.LoopType.STANDARD);
        loopTypeMap.put("MultiInstance", Activity.LoopType.MULTIINSTANCE);
        HashMap<String, Event.EventType> eventTypeMap = new HashMap<String, Event.EventType>();
        eventTypeMap.put("Start", Event.EventType.START);
        eventTypeMap.put("Intermediate", Event.EventType.INTERMEDIATE);
        eventTypeMap.put("End", Event.EventType.END);
        eventTypeMap.put("null", null);
        HashMap<String, Event.Trigger> triggerMap = new HashMap<String, Event.Trigger>();
        triggerMap.put("None", Event.Trigger.NONE);
        triggerMap.put("Message", Event.Trigger.MESSAGE);
        triggerMap.put("Timer", Event.Trigger.TIMER);
        triggerMap.put("Conditional", Event.Trigger.CONDITIONAL);
        triggerMap.put("Signal", Event.Trigger.SIGNAL);
        triggerMap.put("Multiple", Event.Trigger.MULTIPLE);
        triggerMap.put("Error", Event.Trigger.ERROR);
        triggerMap.put("Cancel", Event.Trigger.CANCEL);
        triggerMap.put("Compensation", Event.Trigger.COMPENSATION);
        triggerMap.put("Link", Event.Trigger.LINK);
        triggerMap.put("Terminate", Event.Trigger.TERMINATE);
        HashMap<String, Event.Direction> eventDirectionMap = new HashMap<String, Event.Direction>();
        eventDirectionMap.put("Throw", Event.Direction.THROW);
        eventDirectionMap.put("Catch", Event.Direction.CATCH);
        HashMap<String, Gateway.GatewayType> gatewayTypeMap = new HashMap<String, Gateway.GatewayType>();
        gatewayTypeMap.put("Parallel", Gateway.GatewayType.AND);
        gatewayTypeMap.put("Inclusive", Gateway.GatewayType.OR);
        gatewayTypeMap.put("Complex", Gateway.GatewayType.COMPLEX);
        HashMap<String, Gateway.GatewayType> exclusiveTypeMap = new HashMap<String, Gateway.GatewayType>();
        exclusiveTypeMap.put("Event", Gateway.GatewayType.XOR_EVENT);
        exclusiveTypeMap.put("Data", Gateway.GatewayType.XOR_DATA);
        HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
        booleanMap.put("false", false);
        booleanMap.put("true", true);
        HashMap<String, Association.Direction> associationDirectionMap = new HashMap<String, Association.Direction>();
        associationDirectionMap.put("None", Association.Direction.NONE);
        associationDirectionMap.put("One", Association.Direction.ONE);
        associationDirectionMap.put("Both", Association.Direction.BOTH);
        _attrsMap.put("TaskType", taskTypeMap);
        _attrsMap.put("LoopType", loopTypeMap);
        _attrsMap.put("isComplete", booleanMap);
        _attrsMap.put("isForCompensation", booleanMap);
        _attrsMap.put("isExpanded", booleanMap);
        _attrsMap.put("isATransaction", booleanMap);
        _attrsMap.put("AdHoc", booleanMap);
        _attrsMap.put("EventType", eventTypeMap);
        _attrsMap.put("Trigger", triggerMap);
        _attrsMap.put("EventDirection", eventDirectionMap);
        _attrsMap.put("GatewayType", gatewayTypeMap);
        _attrsMap.put("ExclusiveType", exclusiveTypeMap);
        _attrsMap.put("MarkerVisible", booleanMap);
        _attrsMap.put("Direction", associationDirectionMap);
        _attrsMap.put("BoundaryVisible", booleanMap);
    }
}

