/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.rules.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpel.services.rules.common.IDecisionServiceConstants;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.bpm.soa.io.AbstractIO;
import oracle.bpm.soa.rules.exception.BpmBusinessRuleException;
import oracle.j2ee.ws.wsdl.extensions.schema.Constants;
import oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.repository.DictionaryFQN;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class RulesIO<E>
implements oracle.bpm.soa.rules.common.Constants,
IDecisionServiceConstants {
    private AbstractIO<E> io;
    private static final String XSD_RESOURCE_ROOT = "oracle/bpel/services/rules/wsdl";
    private static final String DECISIONSERVICE_TYPES_TEMPLATE_XSD = "DecisionServiceTypesTemplate.xsd";

    public RulesIO(AbstractIO<E> io) {
        this.io = io;
    }

    @Nullable
    public RuleDictionary loadDictionary(@NotNull E dictionaryFile, @NotNull DictionaryFinder finder) throws BpmBusinessRuleException {
        RuleDictionary dictionary = null;
        InputStream in = null;
        try {
            in = this.io.createInputStream(dictionaryFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            dictionary = RuleDictionary.readDictionary((Reader)reader, (DictionaryFinder)finder);
        }
        catch (Exception exc) {
            try {
                String fileName = this.io.getName(dictionaryFile);
                throw BpmBusinessRuleException.create(HumantaskMsg.ERROR_LOADING_BUSINESSRULE(fileName), exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return dictionary;
    }

    @Nullable
    public RuleDictionary loadDictionary(@NotNull E root, @NotNull String packageName, String dictName, @NotNull DictionaryFinder finder) throws BpmBusinessRuleException {
        RuleDictionary dictionary = null;
        InputStream in = null;
        try {
            E dictionaryFile = this.createDictionaryFile(root, packageName, dictName);
            in = this.io.createInputStream(dictionaryFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            dictionary = RuleDictionary.readDictionary((Reader)reader, (DictionaryFinder)finder);
        }
        catch (Exception exc) {
            try {
                throw BpmBusinessRuleException.create(HumantaskMsg.ERROR_LOADING_BUSINESSRULE(dictName), exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return dictionary;
    }

    @Nullable
    public E saveDictionary(@NotNull E root, @NotNull RuleDictionary dictionary) throws BpmBusinessRuleException {
        E dictionaryFile = null;
        OutputStream out = null;
        try {
            dictionaryFile = this.createDictionaryFile(root, dictionary);
            out = this.io.createOutputStream(dictionaryFile);
            dictionary.writeDictionary((Writer)new BufferedWriter(new OutputStreamWriter(out, "UTF-8")));
        }
        catch (Exception exc) {
            try {
                throw BpmBusinessRuleException.create(HumantaskMsg.ERROR_SAVING_BUSINESSRULE(dictionary.getName()), exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
        StreamUtils.close(out);
        return dictionaryFile;
    }

    public boolean deleteDictionary(E root, RuleDictionary dictionary) {
        E dictionaryFile = this.createDictionaryFile(root, dictionary);
        return this.io.deleteFile(dictionaryFile);
    }

    public String getRelativeProjectPathToDictionary(String projectName, RuleDictionary dictionary) {
        DictionaryFQN dictionaryFQN = this.getDictionaryFQN(dictionary.getPackage(), dictionary.getName());
        return projectName + this.io.getSeparator() + "oracle" + this.io.getSeparator() + "rules" + this.io.getSeparator() + dictionaryFQN.asPath();
    }

    public URL getDictionaryURL(E root, RuleDictionary dictionary) throws Exception {
        E dictionaryFile = this.createDictionaryFile(root, dictionary);
        return this.io.getFileURL(dictionaryFile);
    }

    public E[] listFiles(E root, String regexp) {
        return this.io.listFiles(root, regexp);
    }

    public E[] listFiles(E root) {
        return this.io.listFiles(root);
    }

    public boolean isDirectory(E file) {
        return this.io.isDirectory(file);
    }

    public String getName(E file) {
        return this.io.getName(file);
    }

    public String getFileName(E file) {
        return this.io.getFileName(file);
    }

    public E createChild(E parent, String name) {
        return this.io.createChild(parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(E sourceFile, File destFile) throws IOException {
        BufferedInputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(this.io.createInputStream(sourceFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile, false));
            int nchars = 0;
            byte[] bytes = new byte[8192];
            while ((nchars = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, nchars);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    public Writer getDecisionComponentWriter(E root, String dictionaryName) throws Exception {
        E decsFile = this.createDecisionComponentFile(root, dictionaryName);
        OutputStream out = this.io.createOutputStream(decsFile);
        return new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
    }

    public Reader getDecisionComponentReader(E root, String dictionaryName) throws Exception {
        E decsFile = this.createDecisionComponentFile(root, dictionaryName);
        InputStream in = this.io.createInputStream(decsFile);
        return new BufferedReader(new InputStreamReader(in, "UTF-8"));
    }

    public boolean existsWSDL(E root, String decisionServiceName) {
        E wsdlFile = this.io.createChild(root, decisionServiceName.concat(".wsdl"));
        return this.io.existFile(wsdlFile);
    }

    public Definition getDecisionServiceWSDL(E root, String decisionServiceName) throws Exception {
        Definition result = null;
        String contextURI = null;
        E wsdlFile = this.io.createChild(root, decisionServiceName.concat(".wsdl"));
        WSDLFactory wsdlFactory = WSDLFactory.newInstance((String)"oracle.webservices.wsdl.WSDLFactoryImpl", (ClassLoader)Thread.currentThread().getContextClassLoader());
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        ExtensionRegistry er = wsdlReader.getExtensionRegistry();
        if (er == null) {
            wsdlReader.setExtensionRegistry(this.getDefaultExtensionRegistry(wsdlFactory));
        } else {
            this.addDefaultSerializerAndDeserializer(er);
        }
        String wsdlURI = this.io.getFileURL(wsdlFile).toString();
        result = wsdlReader.readWSDL(contextURI, wsdlURI);
        if (result != null) {
            this.populateDocumentBaseURI(result, wsdlURI);
        }
        return result;
    }

    public void createDecisionServiceWSDL(E root, String decisionServiceName, Definition wsdlDefinition) throws Exception {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance((String)"oracle.webservices.wsdl.WSDLFactoryImpl");
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        this.writeDocumentToFile(root, decisionServiceName.concat(".wsdl"), wsdlWriter.getDocument(wsdlDefinition), true);
    }

    public boolean deleteDecisionServiceWSDL(E root, String decisionServiceName) {
        E wsdlFile = this.io.createChild(root, decisionServiceName.concat(".wsdl"));
        return this.io.deleteFile(wsdlFile);
    }

    public boolean deleteDecisionServiceSchema(E root, String decisionServiceName, String suffix) {
        E schemaDir = this.io.createChild(root, "xsd");
        E schemaFile = this.io.createChild(schemaDir, decisionServiceName.concat(suffix).concat(".xsd"));
        return this.io.deleteFile(schemaFile);
    }

    public boolean deleteDecisionComponent(E root, String dictionaryName) {
        return this.io.deleteFile(this.createDecisionComponentFile(root, dictionaryName));
    }

    public boolean writeDocumentToFile(E root, String fileName, Document xmlDocument, boolean overwrite) throws IOException, TransformerException {
        E destFile = this.io.createChild(root, fileName);
        return this.writeDocumentToDestFile(destFile, xmlDocument, overwrite);
    }

    public boolean writeDocumentToFile(E root, String childDir, String fileName, Document xmlDocument, boolean overwrite) throws IOException, TransformerException {
        E childFile = this.io.createChild(root, childDir);
        if (!this.io.existFile(childFile)) {
            this.io.createFolder(childFile);
        }
        E destFile = this.io.createChild(childFile, fileName);
        return this.writeDocumentToDestFile(destFile, xmlDocument, overwrite);
    }

    public URL getFileURL(E root) throws IOException {
        return this.io.getFileURL(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTypesXSD(E root, String childDir, TDecisionService decisionService) throws IOException {
        String decisionServiceXsdResource = "oracle/bpel/services/rules/wsdl/DecisionServiceTypesTemplate.xsd";
        E childFile = this.io.createChild(root, childDir);
        if (!this.io.existFile(childFile)) {
            this.io.createFolder(childFile);
        }
        String fileName = decisionService.getName() + "Types.xsd";
        String targetNamespace = decisionService.getTargetNamespace();
        E destFile = this.io.createChild(childFile, fileName);
        InputStream in = null;
        OutputStream out = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            String sourceString;
            out = this.io.createOutputStream(destFile);
            in = classLoader.getResourceAsStream("oracle/bpel/services/rules/wsdl/DecisionServiceTypesTemplate.xsd");
            bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            while ((sourceString = bufferedReader.readLine()) != null) {
                String targetString = sourceString.replaceAll("http://xmlns.oracle.com/bpel/rules", targetNamespace);
                bufferedWriter.write(targetString, 0, targetString.length());
                bufferedWriter.newLine();
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private boolean writeDocumentToDestFile(E destFile, Document xmlDocument, boolean overwrite) throws IOException, TransformerException {
        if (this.io.existFile(destFile)) {
            if (!overwrite) {
                return false;
            }
            this.io.deleteFile(destFile);
        }
        DOMSource source = new DOMSource(xmlDocument);
        StreamResult result = new StreamResult(this.io.createOutputStream(destFile));
        result.setSystemId(this.io.getFileURL(destFile).toString());
        this.transform(source, result);
        return true;
    }

    private void transform(Source source, Result result) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    private E createDictionaryFile(E root, RuleDictionary dictionary) {
        return this.createDictionaryFile(root, dictionary.getPackage(), dictionary.getName());
    }

    private E createDictionaryFile(E root, String packageName, String dictName) {
        DictionaryFQN dictionaryFQN = this.getDictionaryFQN(packageName, dictName);
        E rulesFolder = this.io.createChild(this.io.createChild(root, "oracle"), "rules");
        E dictionaryFolder = this.io.createChild(rulesFolder, this.getPackagePath(dictionaryFQN.asPath()));
        this.io.createFolder(dictionaryFolder);
        return this.io.createChild(rulesFolder, dictionaryFQN.asPath());
    }

    private DictionaryFQN getDictionaryFQN(String packageName, String dictName) {
        return new DictionaryFQN(packageName, dictName);
    }

    private String getPackagePath(@NotNull String dictionaryPath) {
        int index = dictionaryPath.lastIndexOf(this.io.getSeparator());
        return dictionaryPath.substring(0, index);
    }

    private E createDecisionComponentFile(E root, String dictionaryName) {
        return this.io.createChild(root, dictionaryName.concat(".decs"));
    }

    private ExtensionRegistry getDefaultExtensionRegistry(WSDLFactory wsdlFactory) {
        ExtensionRegistry er = ((WSDLFactoryImpl)wsdlFactory).newPopulatedExtensionRegistry();
        this.addDefaultSerializerAndDeserializer(er);
        return er;
    }

    private void addDefaultSerializerAndDeserializer(ExtensionRegistry er) {
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_1999, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_1999, er.getDefaultSerializer());
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2000, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2000, er.getDefaultSerializer());
        er.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2001, er.getDefaultDeserializer());
        er.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2001, er.getDefaultSerializer());
    }

    private void populateDocumentBaseURI(Definition def, String wsdlURI) {
        Map map;
        if (def.getDocumentBaseURI() == null) {
            def.setDocumentBaseURI(wsdlURI);
        }
        if ((map = def.getImports()) != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                List aList = (List)map.get(it.next());
                Import imp = (Import)aList.get(0);
                if (imp.getDefinition().getDocumentBaseURI() != null) continue;
                imp.getDefinition().setDocumentBaseURI(this.getDocumentBaseURI(wsdlURI, imp.getLocationURI()));
            }
        }
    }

    private String getDocumentBaseURI(String wsdlURI, String impLocation) {
        if (impLocation != null) {
            try {
                URL impURL = new URL(impLocation);
                return impURL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

