/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.rules.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DataType {
    public static final String BOOLEAN = "boolean";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String CHAR = "char";
    public static final String STRING = "string";
    public static final String BIG_INTEGER = "BigInteger";
    public static final String BIG_DECIMAL = "BigDecimal";
    public static final String SHORT_W = "Short";
    public static final String INTEGER_W = "Integer";
    public static final String LONG_W = "Long";
    public static final String FLOAT_W = "Float";
    public static final String DOUBLE_W = "Double";
    public static final String INTEGER = "Int";
    public static final String LONG_INTEGER = "Int(64)";
    public static final String REAL = "Real";
    public static final String BOOL = "Bool";
    private static final Map<String, String> typeMappings;
    private static final Collection<String> primitiveTypes;

    public static String getFullyQualifiedName(String typeName) {
        return typeMappings.get(typeName);
    }

    public static boolean isPrimitive(String typeName) {
        return primitiveTypes.contains(typeName);
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        typeMappings = mappings;
        mappings.put(BOOLEAN, BOOLEAN);
        mappings.put(SHORT, SHORT);
        mappings.put(INT, INT);
        mappings.put(LONG, LONG);
        mappings.put(FLOAT, FLOAT);
        mappings.put(DOUBLE, DOUBLE);
        mappings.put(CHAR, CHAR);
        mappings.put(STRING, "java.lang.String");
        mappings.put(BIG_INTEGER, "java.math.BigInteger");
        mappings.put(BIG_DECIMAL, "java.math.BigDecimal");
        mappings.put(SHORT_W, "java.lang.Short");
        mappings.put(INTEGER_W, "java.lang.Integer");
        mappings.put(LONG_W, "java.lang.Long");
        mappings.put(FLOAT_W, "java.lang.Float");
        mappings.put(DOUBLE_W, "java.lang.Double");
        mappings.put(INTEGER, INT);
        mappings.put(LONG_INTEGER, LONG);
        mappings.put(REAL, DOUBLE);
        mappings.put(BOOL, BOOLEAN);
        primitiveTypes = new HashSet<String>(Arrays.asList(BOOLEAN, SHORT, INT, LONG, FLOAT, DOUBLE, INTEGER, LONG_INTEGER, REAL, BOOL));
    }
}

