/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.rules;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.soa.rules.common.Constants;
import oracle.bpm.soa.rules.common.DataType;
import oracle.bpm.soa.rules.data.DFFact;
import oracle.bpm.soa.rules.exception.BpmBusinessRuleException;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.datamodel.DecisionFunctionFact;
import oracle.rules.sdk2.datamodel.DecisionFunctionFactTable;
import oracle.rules.sdk2.datamodel.DecisionFunctionRuleSet;
import oracle.rules.sdk2.datamodel.FactType;
import oracle.rules.sdk2.datamodel.JaxbNode;
import oracle.rules.sdk2.datamodel.Node;
import oracle.rules.sdk2.datamodel.NodeTable;
import oracle.rules.sdk2.datamodel.SchemaBrowser;
import oracle.rules.sdk2.datamodel.impt.JaxbClass;
import oracle.rules.sdk2.datamodel.impt.JaxbModel;
import oracle.rules.sdk2.datamodel.xml.XML2ObjModel;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DictionaryBuilder
implements Constants {
    private List<DFFact> m_dfInputs;
    private List<DFFact> m_dfOutputs;
    private RuleDictionary m_dictionary = null;
    private String m_dictionaryName = null;
    private List<URI> m_factURIList = new ArrayList<URI>();
    private String m_jaxbGenerationDir = null;
    private String m_packageName = null;
    private URI m_schemaPathRoot = null;

    private DictionaryBuilder() {
        this.m_dfInputs = new LinkedList<DFFact>();
        this.m_dfOutputs = new LinkedList<DFFact>();
    }

    public static DictionaryBuilder newInstance() {
        return new DictionaryBuilder();
    }

    public FactTypeImporter getFactTypeImporter() {
        return new FactTypeImporter();
    }

    public DictionaryBuilder setDictionaryName(String name) {
        if (!Str.isEmpty(name)) {
            this.m_dictionaryName = name;
        }
        return this;
    }

    public DictionaryBuilder setPackageName(String name) {
        if (!Str.isEmpty(name)) {
            this.m_packageName = name;
        }
        return this;
    }

    public DictionaryBuilder addFactSource(URI factSchemaURI) {
        this.m_factURIList.add(factSchemaURI);
        return this;
    }

    public DictionaryBuilder addDFInputs(List<DFFact> facts) {
        for (DFFact fact : facts) {
            this.addDFInput(fact);
        }
        return this;
    }

    public DictionaryBuilder addDFInput(DFFact fact) {
        if (!fact.isBuiltIn() || !DataType.isPrimitive(fact.getBuiltIn())) {
            fact.setTree(true);
        }
        this.m_dfInputs.add(fact);
        return this;
    }

    public DictionaryBuilder addDFOutputs(List<DFFact> facts) {
        this.m_dfOutputs.addAll(facts);
        return this;
    }

    public DictionaryBuilder addDFOutput(DFFact fact) {
        this.m_dfOutputs.add(fact);
        return this;
    }

    public DictionaryBuilder setJaxbGenDir(String dir) {
        this.m_jaxbGenerationDir = dir;
        return this;
    }

    public DictionaryBuilder setSchemaPathRoot(URI schemaPathRoot) {
        this.m_schemaPathRoot = schemaPathRoot;
        return this;
    }

    public RuleDictionary build() throws BpmBusinessRuleException {
        ArrayList warnings = new ArrayList();
        try {
            this.createDictionary();
            this.createFacts();
            this.createRuleset();
            this.m_dictionary.update(warnings);
            assert (warnings.isEmpty());
            this.createDecisionFunction();
            this.m_dictionary.update(warnings);
            return this.m_dictionary;
        }
        catch (Exception exc) {
            throw BpmBusinessRuleException.create(HumantaskMsg.ERROR_CREATING_BUSINESSRULE(this.m_dictionaryName), exc);
        }
    }

    private void createDictionary() throws SDKException {
        this.m_dictionary = RuleDictionary.createDictionary((String)this.m_dictionaryName, (DictionaryFinder)new DecisionPointDictionaryFinder());
        this.m_dictionary.setName(this.m_dictionaryName);
        this.m_dictionary.setAlias(this.m_dictionaryName);
        this.m_dictionary.setPackage(this.m_packageName);
    }

    private void createFacts() throws BpmBusinessRuleException {
        new FactTypeImporter().importAndResolve();
    }

    private void createRuleset() {
        this.m_dictionary.createEmptyRuleSet("Ruleset1");
    }

    private void createDecisionFunction() {
        DecisionFunction decisionFunction = (DecisionFunction)this.m_dictionary.getDataModel().getDecisionFunctionTable().add();
        DecisionFunctionRuleSet decisionFunctionRuleSet = (DecisionFunctionRuleSet)decisionFunction.getDecisionFunctionRuleSetTable().add();
        decisionFunction.setName("DecisionFunction1");
        decisionFunction.setAlias("DecisionFunction1");
        decisionFunction.setWebService(true);
        decisionFunctionRuleSet.setForm("rule set");
        decisionFunctionRuleSet.setRuleSetAlias("Ruleset1");
        this.addDecisionFunctionFacts(decisionFunction.getDecisionFunctionInputTable(), this.m_dfInputs);
        this.addDecisionFunctionFacts(decisionFunction.getDecisionFunctionOutputTable(), this.m_dfOutputs);
    }

    private void addDecisionFunctionFacts(DecisionFunctionFactTable decisionFunctionFactTable, List<DFFact> facts) {
        for (DFFact dfFact : facts) {
            DecisionFunctionFact decisionFunctionFact = (DecisionFunctionFact)decisionFunctionFactTable.add();
            decisionFunctionFact.setName(dfFact.getName());
            decisionFunctionFact.setAlias(dfFact.getName());
            String dfFactTypeFQN = !dfFact.isBuiltIn() ? dfFact.getTypeFQN() : DataType.getFullyQualifiedName(dfFact.getBuiltIn());
            assert (dfFactTypeFQN != null);
            FactType factType = this.m_dictionary.getCombinedDataModel().getFactTypeByName(dfFactTypeFQN);
            decisionFunctionFact.setType(factType.getAlias());
            decisionFunctionFact.setTree(dfFact.isTree());
            decisionFunctionFact.setList(dfFact.isList());
        }
    }

    public class FactTypeImporter {
        public void importFacts(@NotNull RuleDictionary dictionary, @NotNull String jaxbGenerationDir, @NotNull List<URI> schemaURIList, @NotNull URI schemaPathRoot) throws BpmBusinessRuleException {
            List<DFFact> dfInputs = Collections.emptyList();
            List<DFFact> dfOutputs = Collections.emptyList();
            this.importFacts(dictionary, jaxbGenerationDir, schemaURIList, schemaPathRoot, dfInputs, dfOutputs, true);
        }

        private void importAndResolve() throws BpmBusinessRuleException {
            this.importFacts(DictionaryBuilder.this.m_dictionary, DictionaryBuilder.this.m_jaxbGenerationDir, DictionaryBuilder.this.m_factURIList, DictionaryBuilder.this.m_schemaPathRoot, DictionaryBuilder.this.m_dfInputs, DictionaryBuilder.this.m_dfOutputs, false);
        }

        private void importFacts(@NotNull RuleDictionary dictionary, @NotNull String jaxbGenerationDir, @NotNull List<URI> schemaURIList, URI schemaPathRoot, @NotNull List<DFFact> dfInputs, @NotNull List<DFFact> dfOutputs, boolean reload) throws BpmBusinessRuleException {
            try {
                File tempDir = new File(Constants.TMP_DIR);
                long timestamp = System.nanoTime();
                File jaxbSourceDir = new File(tempDir, "jaxb_src" + timestamp);
                if (jaxbSourceDir.exists()) {
                    IOFactory.createFileIO().deleteDirectory(jaxbSourceDir);
                }
                boolean result = jaxbSourceDir.mkdirs();
                assert (result);
                SchemaBrowser schemaBrowser = new SchemaBrowser(dictionary, jaxbSourceDir.getAbsolutePath(), jaxbGenerationDir);
                if (schemaPathRoot != null) {
                    schemaBrowser.setSchemaPathRoot(schemaPathRoot);
                }
                schemaBrowser.clearSchemaPath();
                for (URI schemaURI : schemaURIList) {
                    JaxbModel xml2ObjModel = schemaBrowser.addSchemaPath(schemaURI);
                    this.resolveDecisionFunctionFacts(dfInputs, (XML2ObjModel)xml2ObjModel);
                    this.resolveDecisionFunctionFacts(dfOutputs, (XML2ObjModel)xml2ObjModel);
                }
                NodeTable nodeTable = schemaBrowser.getNodeTable();
                for (int i = 0; i < nodeTable.size(); ++i) {
                    Node node = nodeTable.getNode(i);
                    this.createFact(node, reload);
                }
                ArrayList warnings = new ArrayList();
                dictionary.update(warnings);
                assert (warnings.isEmpty());
            }
            catch (Exception exc) {
                String dictionaryName = dictionary.getName();
                throw BpmBusinessRuleException.create(HumantaskMsg.ERROR_IMPORTING_BUSINESSRULE_FACTS(dictionaryName), exc);
            }
        }

        private void resolveDecisionFunctionFacts(@NotNull List<DFFact> dfFacts, @NotNull XML2ObjModel xml2ObjModel) {
            Map elementMappings = xml2ObjModel.getGlobalElementMappingTable();
            Map complexTypeMappings = xml2ObjModel.getBeanTable();
            Map enumMappings = xml2ObjModel.getEnumTable();
            for (DFFact dfFact : dfFacts) {
                if (dfFact.isBuiltIn() || dfFact.getTypeFQN() != null) continue;
                SchemaObject dfSchemaObject = dfFact.getType();
                String typeFQN = (String)elementMappings.get(dfSchemaObject.getQName());
                if (typeFQN == null && (typeFQN = this.findType(complexTypeMappings, dfSchemaObject)) == null) {
                    typeFQN = this.findType(enumMappings, dfSchemaObject);
                }
                if (typeFQN == null) continue;
                dfFact.setTypeFQN(typeFQN);
            }
        }

        @Nullable
        private String findType(Map<String, ? extends JaxbClass> typeMappings, SchemaObject schemaObject) {
            for (Map.Entry<String, ? extends JaxbClass> entry : typeMappings.entrySet()) {
                if (!entry.getValue().getNodeName().trim().equals(schemaObject.getName().trim()) || !entry.getValue().getNamespace().trim().equals(schemaObject.getNamespace().trim())) continue;
                return entry.getValue().getFQN();
            }
            return null;
        }

        private void createFact(@NotNull Node node, boolean reload) {
            block3: {
                NodeTable children;
                block2: {
                    children = node.getNestedTable();
                    if (null != children && 0 != children.size()) break block2;
                    String loadFlag = node.getLoadFlag();
                    if (!reload && (loadFlag == null || loadFlag.equalsIgnoreCase("true"))) break block3;
                    List factTypeList = node.load();
                    for (FactType factType : factTypeList) {
                        if (!this.isObjectFactoryNode(node)) continue;
                        factType.setAlias(factType.getName().replace(".", "_"));
                        factType.setVisible(false);
                    }
                    break block3;
                }
                for (int j = 0; j < children.size(); ++j) {
                    Node childNode = children.getNode(j);
                    this.createFact(childNode, reload);
                }
            }
        }

        private boolean isObjectFactoryNode(Node n) {
            if (n instanceof JaxbNode) {
                String name = n.getName();
                return name != null && name.equals("ObjectFactory");
            }
            return false;
        }
    }
}

