/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.io;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.soa.humantask.Workflow;
import oracle.bpm.soa.humantask.impl.HumanTaskImpl;
import oracle.bpm.soa.humantask.impl.PayloadImpl;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import oracle.bpm.soa.humantask.impl.WorkflowImpl;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.bpm.soa.io.AbstractIO;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class HumanTaskIO<E>
implements HumanTask.IO<E>,
TaskConstants {
    private AbstractIO<E> io;

    public HumanTaskIO(AbstractIO<E> io) {
        this.io = io;
    }

    @Override
    public HumanTask loadTask(E task) throws HumanTaskException {
        String taskName = HumanTaskIO.removeExtension(this.io.getName(task));
        return this.loadTask(this.io.getParentFile(task), taskName);
    }

    @Override
    public HumanTask loadTask(E root, String taskName) throws HumanTaskException {
        HumanTask result;
        InputStream in = null;
        try {
            in = this.io.createInputStream(this.createTaskFile(root, taskName));
            TaskDefinition taskDefinition = (TaskDefinition)TaskDefinitionUtil.getInstance().unmarshal(in);
            PayloadType payload = taskDefinition.getWorkflowConfiguration().getPayload();
            String schemaDefinition = payload.getXmlSchemaDefinition();
            E xsdFolder = this.io.getFolder(root, schemaDefinition);
            XMLDocument xmlDocument = this.loadPayload(xsdFolder, this.getFilenameFromXmlSchemaDefinition(schemaDefinition));
            result = HumanTaskImpl.load(taskDefinition, xmlDocument);
        }
        catch (Exception e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_LOADING_HUMANTASK(taskName), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return result;
    }

    @Override
    public E saveTask(E root, HumanTask task) throws HumanTaskException {
        E taskFile = null;
        OutputStream out = null;
        try {
            String name = task.getName();
            taskFile = this.createTaskFile(root, name);
            HumanTaskImpl taskImpl = (HumanTaskImpl)task;
            TaskDefinition taskDefinition = (TaskDefinition)taskImpl.getModel();
            out = this.io.createOutputStream(taskFile);
            TaskDefinitionUtil.getInstance().schemaValidate((Object)taskDefinition);
            TaskDefinitionUtil.getInstance().marshal((Object)taskDefinition, out);
            if (!task.getWorkflowConfiguration().getPayload().isExternalSchema()) {
                String xmlSchemaDefinition = task.getWorkflowConfiguration().getPayload().getXmlSchemaDefinition();
                E xsdFolder = this.io.getFolder(root, xmlSchemaDefinition);
                this.savePayload(xsdFolder, name, task.getWorkflowConfiguration().getPayload());
            }
            this.saveWorkflow(root, name, taskImpl.getWorkflow());
        }
        catch (Exception e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_SAVING_HUMANTASK(this.io.getFileName(taskFile)), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
        StreamUtils.close(out);
        return taskFile;
    }

    @Override
    public void deleteTask(E root, HumanTask task) throws HumanTaskException {
        try {
            String name = task.getName();
            E xsdFolder = this.io.getFolder(root, "xsd");
            E taskFile = this.createTaskFile(root, name);
            E payloadFile = this.createPayloadFile(xsdFolder, name.concat("Payload.xsd"));
            E workflowFile = this.createWorkflowFile(xsdFolder, name);
            this.io.deleteFile(taskFile);
            this.io.deleteFile(payloadFile);
            this.io.deleteFile(workflowFile);
        }
        catch (Exception e) {
            throw HumanTaskException.create(HumantaskMsg.ERROR_DELETING_HUMANTASK(task.getName()), e);
        }
    }

    @Override
    public E createPayloadFile(E xsdFolder, String name) {
        return this.io.createChild(xsdFolder, name);
    }

    @Override
    public E createWorkflowFile(E xsdFolder, String taskName) {
        return this.io.createChild(xsdFolder, taskName + "WorkflowTask.xsd");
    }

    protected static String removeExtension(String name) {
        int index = name.lastIndexOf(".task");
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    private String getFilenameFromXmlSchemaDefinition(String xmlSchemaDefinition) {
        int index = xmlSchemaDefinition.lastIndexOf("/");
        if (index != -1) {
            return xmlSchemaDefinition.substring(index + 1, xmlSchemaDefinition.length());
        }
        return xmlSchemaDefinition;
    }

    private E savePayload(E xsdFolder, String taskName, Payload payload) throws HumanTaskException {
        E payloadFile = null;
        OutputStream out = null;
        try {
            this.io.createFolder(xsdFolder);
            String xmlSchemaDefinition = payload.getXmlSchemaDefinition();
            payloadFile = this.createPayloadFile(xsdFolder, this.getFilenameFromXmlSchemaDefinition(xmlSchemaDefinition));
            PayloadImpl payloadImpl = (PayloadImpl)payload;
            XMLDocument xmlDocument = payloadImpl.getXsdDocument(taskName);
            out = this.io.createOutputStream(payloadFile);
            DOMSource source = new DOMSource((Node)xmlDocument);
            StreamResult result = new StreamResult(out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_SAVING_PAYLOAD(this.io.getFileName(payloadFile), taskName), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
        StreamUtils.close(out);
        return payloadFile;
    }

    private E saveWorkflow(E root, String taskName, Workflow workflow) throws HumanTaskException {
        Object workflowFile = null;
        OutputStream out = null;
        try {
            E xsdFolder = this.io.getFolder(root, "xsd");
            workflowFile = this.createWorkflowFile(xsdFolder, taskName);
            if (!this.io.existFile(workflowFile)) {
                this.io.createFolder(xsdFolder);
                XMLDocument xmlDocument = ((WorkflowImpl)workflow).getDocument();
                out = this.io.createOutputStream(workflowFile);
                xmlDocument.print(out, "UTF-8");
            }
        }
        catch (Throwable e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_SAVING_WORKFLOW(this.io.getFileName(workflowFile), taskName), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
        StreamUtils.close(out);
        return workflowFile;
    }

    private E createTaskFile(E root, String taskName) {
        return this.io.createChild(root, taskName + ".task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private XMLDocument loadPayload(E xsdFolder, String name) {
        InputStream in = null;
        XMLDocument result = null;
        try {
            in = this.io.createInputStream(this.createPayloadFile(xsdFolder, name));
            DOMParser parser = new DOMParser();
            parser.parse(in);
            result = parser.getDocument();
        }
        catch (Throwable e) {
            StreamUtils.close(in);
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return result;
    }
}

