/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.io.InputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.Workflow;
import oracle.bpm.soa.humantask.impl.AbstractNamespaceContext;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkflowImpl
implements Workflow,
TaskConstants {
    private String taskName;
    private static final String SCHEMALOCATION_ATTR = "schemaLocation";
    private static final String PAYLOAD_TYPE_ATTR = "type";
    private static final String WORKFLOW_TEMPLATE = "/WorkflowTask.xsd";

    private WorkflowImpl(String taskName) {
        this.taskName = taskName;
    }

    public static WorkflowImpl create(String taskName) {
        return new WorkflowImpl(taskName);
    }

    public XMLDocument getDocument() throws HumanTaskException {
        XMLDocument document = this.getRawDocument();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(WorkflowNamespaceContext.getInstance());
        try {
            boolean updated = false;
            Node schemaNode = (Node)xpath.evaluate("/xsd:schema", document, XPathConstants.NODE);
            if (schemaNode != null) {
                Node elementNode;
                Element includeElement = document.createElement("xsd:include");
                includeElement.setAttribute(SCHEMALOCATION_ATTR, this.taskName + "Payload.xsd");
                schemaNode.insertBefore(includeElement, schemaNode.getFirstChild());
                Node importNode = (Node)xpath.evaluate("/xsd:schema/xsd:import[@schemaLocation='TaskEvidenceService.xsd']", document, XPathConstants.NODE);
                if (importNode instanceof Element) {
                    ((Element)importNode).setAttribute(SCHEMALOCATION_ATTR, "oramds:///soa/shared/workflow/TaskEvidenceService.xsd");
                }
                if ((elementNode = (Node)xpath.evaluate("/xsd:schema/xsd:element/xsd:complexType/xsd:sequence/xsd:element[@name='payload']", document, XPathConstants.NODE)) instanceof Element) {
                    ((Element)elementNode).setAttribute(PAYLOAD_TYPE_ATTR, "tns:" + this.taskName + "PayloadType");
                    updated = true;
                }
            }
            if (!updated) {
                throw HumanTaskException.create(HumantaskMsg.ERROR_UPDATING_WORKFLOW_TEMPLATE(WORKFLOW_TEMPLATE, this.taskName));
            }
        }
        catch (Throwable e) {
            throw HumanTaskException.create(HumantaskMsg.ERROR_UPDATING_WORKFLOW_TEMPLATE(WORKFLOW_TEMPLATE, this.taskName));
        }
        return document;
    }

    private XMLDocument getRawDocument() throws HumanTaskException {
        InputStream in = null;
        XMLDocument result = null;
        try {
            in = HumanTask.class.getResourceAsStream(WORKFLOW_TEMPLATE);
            DOMParser parser = new DOMParser();
            parser.parse(in);
            result = parser.getDocument();
        }
        catch (Throwable e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_LOADING_WORKFLOW_TEMPLATE(WORKFLOW_TEMPLATE));
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return result;
    }

    private static class WorkflowNamespaceContext
    extends AbstractNamespaceContext {
        private static WorkflowNamespaceContext instance;

        private WorkflowNamespaceContext() {
            this.register("tns", "http://xmlns.oracle.com/bpel/workflow/task");
            this.register("evidence", "http://xmlns.oracle.com/bpel/workflow/TaskEvidenceService");
            this.register("xsd", "http://www.w3.org/2001/XMLSchema");
            this.register("jaxb", "http://java.sun.com/xml/ns/jaxb");
        }

        public static NamespaceContext getInstance() {
            if (instance == null) {
                instance = new WorkflowNamespaceContext();
            }
            return instance;
        }
    }
}

