/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpel.services.workflow.metadata.config.model.ObjectFactory;
import oracle.bpel.services.workflow.metadata.config.model.TaskDisplayInfoListType;
import oracle.bpel.services.workflow.metadata.config.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.metadata.config.model.TaskFormType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.soa.humantask.TaskDisplayInfo;
import oracle.bpm.soa.humantask.TaskForm;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.OutcomesImpl;
import oracle.bpm.soa.humantask.impl.PayloadImpl;
import oracle.bpm.soa.humantask.impl.TaskDisplayInfoImpl;
import oracle.bpm.soa.humantask.impl.TaskFormImpl;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WorkflowConfigurationImpl
extends AbstractEntity<WorkflowConfigurationType>
implements WorkflowConfiguration {
    private OutcomesImpl outcomes;
    private PayloadImpl payload;
    private XMLDocument payloadDocument;
    private TaskForm taskForm;

    WorkflowConfigurationImpl(@NotNull WorkflowConfigurationType workflowConfiguration, @Nullable XMLDocument payloadDocument) {
        super(workflowConfiguration);
        this.payloadDocument = payloadDocument;
    }

    public static WorkflowConfigurationImpl create(TaskDefinition taskDef, @Nullable XMLDocument payloadDocument) {
        WorkflowConfigurationType workflowConfiguration = taskDef.getWorkflowConfiguration();
        if (workflowConfiguration == null) {
            workflowConfiguration = new ObjectFactory().createWorkflowConfiguration();
            taskDef.setWorkflowConfiguration(workflowConfiguration);
        }
        return new WorkflowConfigurationImpl(workflowConfiguration, payloadDocument);
    }

    @Override
    public OutcomesImpl getOutcomes() {
        if (this.outcomes == null) {
            this.outcomes = OutcomesImpl.create((WorkflowConfigurationType)this.getModel());
        }
        return this.outcomes;
    }

    @Override
    public boolean isGlobalCreation() {
        return ((WorkflowConfigurationType)this.getModel()).isGlobalCreationTask();
    }

    @Override
    public void setGlobalCreation(boolean value) {
        ((WorkflowConfigurationType)this.getModel()).setGlobalCreationTask(value);
    }

    @Override
    public boolean isEnableAutoClaim() {
        return ((WorkflowConfigurationType)this.getModel()).isEnableAutoClaim();
    }

    @Override
    public PayloadImpl getPayload() {
        if (this.payload == null) {
            this.payload = PayloadImpl.create((WorkflowConfigurationType)this.getModel(), this.getPayloadDocument());
        }
        return this.payload;
    }

    @Override
    public void setEnableAutoClaim(boolean value) {
        ((WorkflowConfigurationType)this.getModel()).setEnableAutoClaim(value);
    }

    @Override
    public boolean isShowCompleteGraphicalHistory() {
        return ((WorkflowConfigurationType)this.getModel()).isShowCompleteGraphicalHistory();
    }

    @Override
    public void setShowCompleteGraphicalHistory(boolean value) {
        ((WorkflowConfigurationType)this.getModel()).setShowCompleteGraphicalHistory(value);
    }

    @Override
    public TaskForm getTaskForm() {
        if (this.taskForm == null) {
            this.taskForm = TaskFormImpl.create((WorkflowConfigurationType)this.getModel());
        }
        return this.taskForm;
    }

    @Override
    public void setTaskForm(TaskForm value) {
        this.taskForm = value;
        ((WorkflowConfigurationType)this.getModel()).setTaskForm((TaskFormType)((TaskFormImpl)value).getModel());
    }

    @Override
    public List<TaskDisplayInfo> getTaskDisplayInfos() {
        ArrayList<TaskDisplayInfoImpl> result = new ArrayList<TaskDisplayInfoImpl>();
        TaskDisplayInfoListType infoList = ((WorkflowConfigurationType)this.getModel()).getTaskDisplayInfoList();
        if (infoList != null) {
            List list = this.getTaskDisplayInfoList();
            for (Object object : list) {
                result.add(TaskDisplayInfoImpl.create((TaskDisplayInfoType)object));
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setTaskDisplayInfos(List<TaskDisplayInfo> infos) {
        if (infos.isEmpty()) {
            ((WorkflowConfigurationType)this.getModel()).setTaskDisplayInfoList(null);
        } else {
            List list = this.getTaskDisplayInfoList();
            list.clear();
            for (TaskDisplayInfo info : infos) {
                list.add(((TaskDisplayInfoImpl)info).getModel());
            }
        }
    }

    @Override
    public void addTaskDisplayInfo(TaskDisplayInfo info) {
        List list = this.getTaskDisplayInfoList();
        list.add(((TaskDisplayInfoImpl)info).getModel());
    }

    private List getTaskDisplayInfoList() {
        TaskDisplayInfoListType infoList = ((WorkflowConfigurationType)this.getModel()).getTaskDisplayInfoList();
        if (infoList == null) {
            infoList = CONFIG_FACTORY.createTaskDisplayInfoListType();
            ((WorkflowConfigurationType)this.getModel()).setTaskDisplayInfoList(infoList);
        }
        return infoList.getTaskDisplayInfoList();
    }

    private XMLDocument getPayloadDocument() {
        return this.payloadDocument;
    }
}

