/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

abstract class AbstractNamespaceContext
implements NamespaceContext {
    private HashMap<String, String> extensions = new HashMap();
    private HashMap<String, String> namespaces = new HashMap();
    private static final String NS = "ns";
    private static final String XSD = "xsd";

    AbstractNamespaceContext() {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String uri = this.extensions.get(prefix);
        return uri != null ? uri : "";
    }

    public boolean existNamespaceURI(String prefix) {
        return !"".equals(this.getNamespaceURI(prefix));
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaces.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (Map.Entry<String, String> value : this.extensions.entrySet()) {
            if (value.getValue() == null || !value.getValue().equals(namespaceURI)) continue;
            prefixes.add(value.getKey());
        }
        return prefixes.iterator();
    }

    public void register(String prefix, String namespace) {
        this.namespaces.put(namespace, prefix);
        this.extensions.put(prefix, namespace);
    }

    public List<String> getNamespaces() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.namespaces.keySet());
        return result;
    }

    public void unregister(String prefix) {
        if (this.existNamespaceURI(prefix)) {
            String namespace = this.getNamespaceURI(prefix);
            this.namespaces.remove(namespace);
            this.extensions.remove(prefix);
        }
    }

    public String createNewPrefix(String namespaceURI) {
        String prefix;
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
            prefix = XSD;
        } else {
            int i = 0;
            while (this.existNamespaceURI(prefix = NS + i++)) {
            }
        }
        return prefix;
    }
}

