/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask;

import java.util.Locale;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;

public enum IdentityType implements I18nProvider
{
    USER("user", HumantaskMsg.USER),
    GROUP("group", HumantaskMsg.GROUP),
    APPLICATION_ROLE("application_role", HumantaskMsg.APPLICATION_ROLE);

    private Msg msg;
    private String value;

    private IdentityType(String value, Msg msg) {
        this.value = value;
        this.msg = msg;
    }

    public boolean isUser() {
        return this.equals(USER);
    }

    public boolean isGroup() {
        return this.equals(GROUP);
    }

    public boolean isApplicationRole() {
        return this.equals(APPLICATION_ROLE);
    }

    public String asString() {
        return this.value;
    }

    public static IdentityType create(String type) {
        IdentityType result = USER;
        if ("group".equals(type)) {
            result = GROUP;
        } else if ("application_role".equals(type)) {
            result = APPLICATION_ROLE;
        }
        return result;
    }

    @Override
    public String getString() {
        return this.msg.getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }
}

