/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.Factory;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.IdentityType;
import oracle.bpm.soa.humantask.NamesAndExpressions;
import oracle.bpm.soa.humantask.OutcomePercentage;
import oracle.bpm.soa.humantask.ParallelResponder;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.ParticipantList;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Resource;
import oracle.bpm.soa.humantask.Responder;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.ValueType;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HumanTaskBpm {
    public static final String DEFAULT_PERFORMER = "Participant1";
    public static final String BPM_PREFIX = "bpm";
    public static final String BPM_PERFORMER = "bpm:getPerformer()";
    public static final String BPM_LAST_PERFORMER = "bpm:getLastPerformer()";
    public static final String BPM_NAMESPACE = "http://xmlns.oracle.com/bpmn20/extensions";
    public static final String APPLICATION_CONTEXT = "OracleBPMProcessRolesApp";
    public static final String TASK_CREATOR_XPATH = "/task:task/task:creator";
    private static final String PATH_SEPARATOR = "/";
    private static final String ORACLE_NAMESPACE = "http://xmlns.oracle.com";
    private static final String PROCESS_OWNER = "ProcessOwner";

    private HumanTaskBpm() {
    }

    public static HumanTask createHumanTaskForBpm(String projectName, String humanTaskName) throws HumanTaskException {
        return HumanTaskBpm.createHumanTaskForBpm(projectName, humanTaskName, oracle.bpm.soa.humantask.PatternType.SIMPLE, null);
    }

    public static HumanTask createHumanTaskForBpm(String projectName, String humanTaskName, oracle.bpm.soa.humantask.PatternType patternType, @Nullable String appName) throws HumanTaskException {
        HumanTask humanTask = HumanTaskBpm.createHumanTask(humanTaskName);
        RoutingSlip routingSlip = humanTask.getRoutingSlip();
        RoutingSlip.GlobalConfiguration globalConfiguration = routingSlip.getGlobalConfiguration();
        RoutingSlip.TaskOwner taskOwner = globalConfiguration.getTaskOwner();
        taskOwner.setType(ValueType.STATIC);
        taskOwner.setIdentityType(IdentityType.APPLICATION_ROLE);
        taskOwner.setValue(projectName + "." + PROCESS_OWNER);
        globalConfiguration.setApplicationContext(APPLICATION_CONTEXT);
        humanTask.setTargetNamespace(ORACLE_NAMESPACE + (appName != null ? PATH_SEPARATOR + appName : "") + PATH_SEPARATOR + projectName + PATH_SEPARATOR + humanTaskName);
        switch (patternType) {
            case SIMPLE: {
                HumanTaskBpm.addSimplePattern(humanTask);
                break;
            }
            case MANAGEMENT: {
                HumanTaskBpm.addManagementPattern(humanTask);
                break;
            }
            case GROUP_VOTE: {
                HumanTaskBpm.addGroupVotePattern(humanTask);
                break;
            }
            case COMPLEX: {
                break;
            }
            case FYI: {
                HumanTaskBpm.addFyiPattern(humanTask);
                break;
            }
            case INITIATOR: {
                HumanTaskBpm.addInitiatorPattern(humanTask);
            }
        }
        return humanTask;
    }

    @Nullable
    public static LaneParticipantType getLaneParticipantType(RoutingSlip routingSlip) {
        NamesAndExpressions namesAndExpressions;
        ParticipantList participantList;
        LaneParticipantType result = null;
        Participant participant = HumanTaskBpm.getUniqueFirstParticipant(routingSlip);
        if (participant != null && participant.getParticipantList() != null && (participantList = participant.getParticipantList()).getType().isNamesAndExpressions() && (namesAndExpressions = participantList.as(ParticipantList.NamesAndExpressions.class).getNamesAndExpressions()).getBasedOnType().isValueBased()) {
            NamesAndExpressions.ValueBased valueBased = namesAndExpressions.toValueBased();
            result = HumanTaskBpm.getLaneParticipantType(valueBased.getResources());
        }
        return result;
    }

    public static boolean isPreviousLaneParticipantExcluded(RoutingSlip routingSlip) {
        List<RoutingSlip.ExcludedParticipantsType> excludedParticipants;
        boolean result = false;
        LaneParticipantType laneParticipantType = HumanTaskBpm.getLaneParticipantType(routingSlip);
        if (laneParticipantType != null && laneParticipantType.isCurrentLane() && (excludedParticipants = routingSlip.getExcludedParticipants()).size() == 1) {
            RoutingSlip.ExcludedParticipantsType excludedParticipantsType = excludedParticipants.get(0);
            result = excludedParticipantsType.isPreviousLaneParticipant();
        }
        return result;
    }

    @NotNull
    public static PatternType getPatternType(@NotNull HumanTask task) {
        PatternType pattern = PatternType.COMPLEX;
        WorkflowConfiguration workflowConfiguration = task.getWorkflowConfiguration();
        if (workflowConfiguration.isGlobalCreation()) {
            pattern = PatternType.INITIATOR;
        } else {
            Participant participant;
            RoutingSlip routingSlip = task.getRoutingSlip();
            Participants participants = routingSlip.getParticipants();
            boolean adhocRoutingSupported = participants.isAdhocRoutingSupported();
            if (!adhocRoutingSupported && (participant = HumanTaskBpm.getUniqueFirstParticipant(routingSlip)) != null) {
                Participant.Type type = participant.getType();
                if (type.isSingle()) {
                    pattern = PatternType.SIMPLE;
                } else if (type.isFyi()) {
                    pattern = PatternType.FYI;
                } else if (type.isSerial()) {
                    pattern = PatternType.MANAGEMENT;
                } else if (type.isParallel()) {
                    pattern = PatternType.GROUP_VOTE;
                }
            }
        }
        return pattern;
    }

    private static HumanTask createHumanTask(String humanTaskName) throws HumanTaskException {
        HumanTask humanTask = Factory.task().createHumanTask(humanTaskName);
        humanTask.addNamespaceDeclaration(BPM_PREFIX, BPM_NAMESPACE);
        return humanTask;
    }

    private static void addSimplePattern(HumanTask humanTask) {
        Participants.Stage stage = HumanTaskBpm.getFirstStage(humanTask);
        Participant.Single participant = Factory.routingSlip().createSingle(DEFAULT_PERFORMER);
        stage.add(participant);
        HumanTaskBpm.setBpmPerformerResource(participant);
    }

    private static void setBpmPerformerResource(Participant participant) {
        Resource resource = HumanTaskBpm.createBpmPerformerResource();
        ArrayList<Resource> resourceList = new ArrayList<Resource>(1);
        resourceList.add(resource);
        participant.setResources(resourceList);
    }

    private static void addManagementPattern(HumanTask humanTask) {
        Participants.Stage stage = HumanTaskBpm.getFirstStage(humanTask);
        Participant.Serial serialParticipant = Factory.routingSlip().createSerial(DEFAULT_PERFORMER);
        stage.add(serialParticipant);
        HumanTaskBpm.setBpmPerformerResource(serialParticipant);
    }

    private static void addGroupVotePattern(HumanTask humanTask) {
        Participants.Stage stage = HumanTaskBpm.getFirstStage(humanTask);
        Participant.ParallelSingle parallel = Factory.routingSlip().createParallelSingle(DEFAULT_PERFORMER);
        parallel.setCollaboration(false);
        stage.add(parallel);
        Responder responder = parallel.getResponder();
        Responder.Vote vote = responder.toVote();
        ParallelResponder parallelResponder = vote.getParallelResponder();
        parallelResponder.getDefaultOutcome().setValue("APPROVE");
        parallelResponder.getDefaultOutcome().setType(ValueType.STATIC);
        OutcomePercentage outcomePercentage = Factory.routingSlip().createOutcomePercentage();
        outcomePercentage.setType(ValueType.STATIC);
        outcomePercentage.setValue("50");
        ArrayList<OutcomePercentage> percentages = new ArrayList<OutcomePercentage>(1);
        percentages.add(outcomePercentage);
        parallelResponder.setOutcomePercentage(percentages);
        HumanTaskBpm.setBpmPerformerResource(parallel);
    }

    private static Resource createBpmPerformerResource() {
        return HumanTaskBpm.createResource(ValueType.XPATH, IdentityType.APPLICATION_ROLE, BPM_PERFORMER);
    }

    private static void addFyiPattern(HumanTask humanTask) {
        Participants.Stage stage = HumanTaskBpm.getFirstStage(humanTask);
        Participant.Fyi participant = Factory.routingSlip().createFyi(DEFAULT_PERFORMER);
        stage.add(participant);
        HumanTaskBpm.setBpmPerformerResource(participant);
    }

    private static void addInitiatorPattern(HumanTask humanTask) {
        Participants.Stage stage = HumanTaskBpm.getFirstStage(humanTask);
        Participant.Single participant = Factory.routingSlip().createSingle(DEFAULT_PERFORMER);
        stage.add(participant);
        Resource resource = HumanTaskBpm.createResource(ValueType.XPATH, IdentityType.USER, TASK_CREATOR_XPATH);
        ArrayList<Resource> resourceList = new ArrayList<Resource>(1);
        resourceList.add(resource);
        participant.setResources(resourceList);
        WorkflowConfiguration workflowConfiguration = humanTask.getWorkflowConfiguration();
        workflowConfiguration.setGlobalCreation(true);
        workflowConfiguration.getOutcomes().setValues(TaskConstants.OUTCOMES_INITIATOR_VALUES);
    }

    private static Participants.Stage getFirstStage(HumanTask humanTask) {
        return (Participants.Stage)humanTask.getRoutingSlip().getParticipants().getParticipants().get(0);
    }

    private static Resource createResource(ValueType valueType, IdentityType identityType, String value) {
        Resource resource = Factory.routingSlip().createResource();
        resource.setType(valueType);
        resource.setIdentityType(identityType);
        resource.setValue(value);
        return resource;
    }

    @Nullable
    private static Participant getUniqueFirstParticipant(RoutingSlip routingSlip) {
        Participant p;
        Participant.Type type;
        Participants.Stage stage;
        Participant participant;
        Participant result = null;
        Participants participants = routingSlip.getParticipants();
        if (participants.getParticipants().size() == 1 && (participant = participants.getParticipants().get(0)) instanceof Participants.Stage && (stage = (Participants.Stage)participant).getParticipants().size() == 1 && !(type = (p = stage.getParticipants().get(0)).getType()).isContainer() && !type.isParallelBlock()) {
            result = p;
        }
        return result;
    }

    @Nullable
    private static LaneParticipantType getLaneParticipantType(List<Resource> resources) {
        Resource resource;
        String value;
        LaneParticipantType result = null;
        if (resources.size() == 1 && (value = (resource = resources.get(0)).getValue()) != null) {
            if (value.contains(BPM_PERFORMER)) {
                result = LaneParticipantType.CURRENT_LANE;
            } else if (value.contains(BPM_LAST_PERFORMER)) {
                result = LaneParticipantType.PREVIOUS_LANE;
            }
        }
        return result;
    }

    public static enum PatternType implements I18nProvider
    {
        SIMPLE(HumantaskMsg.SIMPLE),
        FYI(HumantaskMsg.FYI),
        MANAGEMENT(HumantaskMsg.MANAGEMENT),
        GROUP_VOTE(HumantaskMsg.GROUP_VOTE),
        COMPLEX(HumantaskMsg.COMPLEX),
        INITIATOR(HumantaskMsg.INITIATOR);

        @NotNull
        private final transient Msg msg;

        private PatternType(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.getMsg().getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.getMsg().getString(locale);
        }

        @NotNull
        private Msg getMsg() {
            return this.msg;
        }

        public boolean isSimple() {
            return this.equals(SIMPLE);
        }

        public boolean isFyi() {
            return this.equals(FYI);
        }

        public boolean isManagement() {
            return this.equals(MANAGEMENT);
        }

        public boolean isGroupVote() {
            return this.equals(GROUP_VOTE);
        }

        public boolean isComplex() {
            return this.equals(COMPLEX);
        }

        public boolean isInitiator() {
            return this.equals(INITIATOR);
        }
    }

    public static enum LaneParticipantType implements I18nProvider
    {
        CURRENT_LANE(HumantaskMsg.CURRENT_LANE_PARTICIPANT),
        PREVIOUS_LANE(HumantaskMsg.PREVIOUS_LANE_PARTICIPANT);

        private Msg msg;

        private LaneParticipantType(Msg msg) {
            this.msg = msg;
        }

        public boolean isCurrentLane() {
            return this.equals(CURRENT_LANE);
        }

        public boolean isPreviousLane() {
            return this.equals(PREVIOUS_LANE);
        }

        public Msg getMsg() {
            return this.msg;
        }

        @Override
        public String getString() {
            return this.getMsg().getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.getMsg().getString(locale);
        }
    }
}

