/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask;

import java.util.Locale;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.ValueType;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;

public interface Expiration {
    public Type getType();

    public <T extends Expiration> T as(Class<T> var1);

    public static interface RenewAfter
    extends ExpireAfter {
        public int getNumberOfTimesRenewed();

        public void setNumberOfTimesRenewed(int var1);
    }

    public static interface NeverExpire
    extends Expiration {
    }

    public static interface ExpireAfter
    extends Expiration {
        public ValueType getValueType();

        public void setValueType(ValueType var1);

        public String getDuration();

        public void setDuration(String var1);

        public boolean isUseBusinessCalendar();

        public void setUseBusinessCalendar(boolean var1);
    }

    public static interface EscalateAfter
    extends ExpireAfter {
        public int getNumberOfTimesEscalated();

        public void setNumberOfTimesEscalated(int var1);

        public String getTitleOfLastUser();

        public void setTitleOfLastUser(String var1);
    }

    public static enum Type implements I18nProvider
    {
        NEVER_EXPIRE(HumantaskMsg.NEVER_EXPIRE, NeverExpire.class),
        EXPIRE_AFTER(HumantaskMsg.EXPIRE_AFTER, ExpireAfter.class),
        RENEW_AFTER(HumantaskMsg.RENEW_AFTER, RenewAfter.class),
        ESCALATE_AFTER(HumantaskMsg.ESCALATE_AFTER, EscalateAfter.class);

        private Msg msg;
        private Class<? extends Expiration> clazz;

        private Type(Msg msg, Class<? extends Expiration> clazz) {
            this.msg = msg;
            this.clazz = clazz;
        }

        public Msg getMsg() {
            return this.msg;
        }

        public boolean isNeverExpire() {
            return this.equals(NEVER_EXPIRE);
        }

        public boolean isExpireAfter() {
            return this.equals(EXPIRE_AFTER);
        }

        public boolean isRenewAfter() {
            return this.equals(RENEW_AFTER);
        }

        public boolean isEscalateAfter() {
            return this.equals(ESCALATE_AFTER);
        }

        @Override
        public String getString() {
            return this.getMsg().getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.getMsg().getString(locale);
        }

        public Class<? extends Expiration> getRawClass() {
            return this.clazz;
        }
    }
}

