/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.ui.inspector;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.inspector.PropertyModel;
import oracle.bpm.fusion.ui.inspector.BpmPropertyInfo;

public abstract class BpmPropertyModel<E>
extends PropertyModel {
    private E element;
    private Map<String, BpmPropertyInfo> propertiesMap = new HashMap<String, BpmPropertyInfo>();
    private static final Object[] COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_NAME, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_EDITOR_FACTORY_2, PropertyModel.COLUMN_IS_DRILLABLE, PropertyModel.COLUMN_MODEL, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_CATEGORY, PropertyModel.COLUMN_IS_HIDDEN};
    public static final int INDEX_COLUMN_ID = 0;
    public static final int INDEX_COLUMN_NAME = 1;
    public static final int INDEX_COLUMN_DISPLAY_NAME = 2;
    public static final int INDEX_COLUMN_VALUE = 3;
    public static final int INDEX_COLUMN_IS_READABLE = 4;
    public static final int INDEX_COLUMN_IS_WRITABLE = 5;
    public static final int INDEX_COLUMN_EDITOR_FACTORY2 = 6;
    public static final int INDEX_COLUMN_IS_DRILLABLE = 7;
    public static final int INDEX_COLUMN_MODEL = 8;
    public static final int INDEX_COLUMN_GROUP = 9;
    public static final int INDEX_COLUMN_CATEGORY = 10;
    public static final int INDEX_COLUMN_IS_HIDDEN = 11;

    protected BpmPropertyModel(E element) {
        this.element = element;
    }

    public E getElement() {
        return this.element;
    }

    public void addProperty(BpmPropertyInfo bpmPropertyInfo) {
        this.propertiesMap.put(bpmPropertyInfo.getName(), bpmPropertyInfo);
    }

    public BpmPropertyInfo getPropertyInfo(String propertyName) {
        return this.propertiesMap.get(propertyName);
    }

    public Object getPropertyValue(String propertyName) {
        return this.propertiesMap.get(propertyName).getValue();
    }

    public int getRowCount() {
        return this.propertiesMap.size();
    }

    public void invalidateValueData() {
    }

    public Object getValueAt(int row, int column) {
        BpmPropertyInfo propertyInfo = (BpmPropertyInfo)this.propertiesMap.values().toArray()[row];
        switch (column) {
            case 0: {
                return propertyInfo.getId();
            }
            case 1: {
                return propertyInfo.getName();
            }
            case 2: {
                return propertyInfo.getDisplayName();
            }
            case 3: {
                return propertyInfo.getValue();
            }
            case 4: {
                return propertyInfo.isReadable();
            }
            case 5: {
                return propertyInfo.isWritable();
            }
            case 6: {
                return propertyInfo.getEditor();
            }
            case 7: {
                return propertyInfo.isDrillable();
            }
            case 8: {
                return propertyInfo.getModel();
            }
            case 9: {
                return propertyInfo.getGroup();
            }
            case 10: {
                return propertyInfo.getCategory();
            }
            case 11: {
                return propertyInfo.isHidden();
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        BpmPropertyInfo propertyInfo = (BpmPropertyInfo)this.propertiesMap.values().toArray()[rowIndex];
        if (columnIndex == 3) {
            propertyInfo.setValue(aValue);
        }
        this.updateModel(propertyInfo.getName(), aValue);
    }

    public Object[] getColumnMapping() {
        return COLUMNS;
    }

    protected abstract void updateModel(String var1, Object var2);

    protected String getModelId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

