/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.ui.action;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class IdeMenuAdapter {
    private IdeMenuAdapter() {
    }

    public static void adaptActions(StudioNode objectNode, ContextMenu contextMenu) {
        ActionGroup group = objectNode.createActions();
        IdeMenuAdapter.adaptActions(contextMenu, group, objectNode, true);
    }

    public static void adaptActions(ContextMenu contextMenu, ActionGroup group, Object selection, boolean useNode) {
        if (group != null) {
            group.setSelection(DefaultSelection.createSingle((Object)selection));
            for (Component component : IdeMenuAdapter.adapt((BaseAction)group, contextMenu, true, useNode)) {
                contextMenu.add(component, 0.0f);
            }
        }
    }

    private static Collection<Component> adapt(BaseAction baseAction, ContextMenu contextMenu, boolean root, boolean useNode) {
        ArrayList<Component> items = new ArrayList();
        if (baseAction instanceof ActionGroup) {
            ActionGroup actionGroup = (ActionGroup)baseAction;
            if (root || Str.isEmpty(actionGroup.getMsg().toString())) {
                for (BaseAction action : actionGroup.getActions()) {
                    items.addAll(IdeMenuAdapter.adapt(action, contextMenu, false, useNode));
                }
            } else {
                Component item = IdeMenuAdapter.adapActionGroup(actionGroup, contextMenu, useNode);
                items.add(item);
            }
        } else if (baseAction == BaseAction.SEPARATOR) {
            JSeparator separator = new JSeparator();
            items = Collections.singleton(separator);
        } else if (baseAction.isShowOnDisabled() || baseAction.isEnabled()) {
            Component item = IdeMenuAdapter.adaptActionItem(baseAction, contextMenu, useNode);
            items.add(item);
        }
        return items;
    }

    private static Component adapActionGroup(ActionGroup actionGroup, ContextMenu contextMenu, boolean useNode) {
        JMenu menu = contextMenu.createMenu(IdeMenuAdapter.getText((BaseAction)actionGroup), null);
        actionGroup.putValue("Name", (Object)IdeMenuAdapter.getText((BaseAction)actionGroup));
        actionGroup.putValue("BPM_ACTION", (Object)true);
        actionGroup.putValue("SmallIcon", actionGroup.getSmallIcon() != null ? actionGroup.getSmallIcon().asSwingIcon() : null);
        menu.setAction((Action)actionGroup);
        for (BaseAction action : actionGroup.getActions()) {
            Collection<Component> components = IdeMenuAdapter.adapt(action, contextMenu, false, useNode);
            for (Component component : components) {
                menu.add(component);
            }
        }
        return menu;
    }

    private static Component adaptActionItem(final BaseAction baseAction, ContextMenu contextMenu, final boolean useNode) {
        int cmdId = Ide.findOrCreateCmdID((String)IdeMenuAdapter.getText(baseAction));
        IdeAction ideAction = IdeAction.get((int)cmdId);
        ideAction.setName(IdeMenuAdapter.getText(baseAction));
        ideAction.putValue("SmallIcon", (Object)IdeMenuAdapter.getIcon(baseAction));
        ideAction.putValue("BPM_ACTION", (Object)true);
        ideAction.setEnabled(baseAction.isEnabled());
        ideAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                if (baseAction != null) {
                    StudioNode node = (StudioNode)context.getNode();
                    Object pObject = useNode ? node.getObject() : context.getElement().getData();
                    baseAction.runWithSelection(pObject);
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        });
        return contextMenu.createMenuItem((ToggleAction)ideAction);
    }

    private static Icon getIcon(BaseAction baseAction) {
        return baseAction.getSmallIcon() != null ? baseAction.getSmallIcon().asSwingIcon() : null;
    }

    private static String getText(BaseAction baseAction) {
        Msg msg;
        String actionName = baseAction.getName();
        if (actionName == null && (msg = baseAction.getMsg()) != null && (actionName = msg.getString()) == null) {
            actionName = msg.getCode();
        }
        return actionName;
    }
}

