/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.workflow.editor.org;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.DialogOKListener;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.workflow.editor.IAddAction;
import oracle.tip.tools.ide.workflow.editor.org.OrganizationsDetailPanel;
import oracle.tip.tools.ide.workflow.resources.ImageCache;
import oracle.tip.tools.ide.workflow.util.WorkFlowHelpUtil;

public class OrganizationLookupAction
extends AbstractAction
implements IAddAction {
    private Project mProject = null;
    private OrganizationsDetailPanel.OrganizationData organizationData;

    public OrganizationLookupAction(Project project) {
        this.mProject = project;
        this.putValue("SmallIcon", ImageCache.getIcon((String)"add.png"));
        this.putValue("ShortDescription", FusionSoaMsg.ORGANIZATIONAL_UNIT_LOOKUP.toString());
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        this.addOrgUnits((Component)pEvent.getSource());
    }

    public void addOrgUnits(Component pComponent) {
        this.organizationData = this.lookUp(pComponent);
    }

    public OrganizationsDetailPanel.OrganizationData lookUp(Component pComponent) {
        GenericDialog dialog = new GenericDialog((Frame)UIHelper.getFrame((Component)pComponent));
        dialog.setModal(true);
        OrganizationsDetailPanel panel = new OrganizationsDetailPanel(this.mProject, dialog.getContentPane());
        dialog.setContent((JComponent)panel);
        dialog.setTitle(FusionSoaMsg.ORGANIZATIONAL_UNIT_LOOKUP.toString());
        dialog.setSize(550, 350);
        dialog.setButtons(28);
        dialog.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
        dialog.addOKListener((DialogOKListener)new LocalOKListener(panel));
        dialog.setHelpId("f1_bpm_orgorgunitlookupd_html");
        if (dialog.showDialog(false, true) == 200) {
            return panel.getData();
        }
        return null;
    }

    public OrganizationsDetailPanel.OrganizationData getOrganizationData() {
        return this.organizationData;
    }

    class LocalOKListener
    implements DialogOKListener {
        private OrganizationsDetailPanel mPanel = null;

        public LocalOKListener(OrganizationsDetailPanel panel) {
            this.mPanel = panel;
        }

        public void OKOccured() throws Exception {
            this.mPanel.validateData();
        }
    }
}

