/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.ui.extension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.fusion.soa.model.OperationDetails;
import oracle.bpm.fusion.soa.model.OperationInfo;
import oracle.bpm.fusion.soa.model.OperationsTableModel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.ui.extension.OperationDetailsPanel;
import oracle.bpm.log.Log;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import org.jetbrains.annotations.NotNull;

public class OperationDetailsDialog
extends JEWTDialog {
    private GridBagConstraints constraints;
    private Context context;
    private OperationDetailsPanel operationDetailsPanel;
    private OperationsTableModel operationsTableModel;
    private int rowToBeEdited;
    private OperationDetails selectedOperationDetails;
    private JPanel titlePanel;

    public OperationDetailsDialog(@NotNull JFrame frame, int rowSelected, OperationsTableModel operationsTableModel, @NotNull OperationDetails operationDetails) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/OperationDetailsDialog.<init> must not be null");
        }
        if (operationDetails == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/OperationDetailsDialog.<init> must not be null");
        }
        super((Frame)frame, FusionSoaMsg.EDIT_OPER_TITLE.toString(), 7);
        this.constraints = new GridBagConstraints();
        this.selectedOperationDetails = operationDetails;
        this.operationsTableModel = operationsTableModel;
        this.rowToBeEdited = rowSelected;
        this.display();
    }

    public OperationDetailsDialog(@NotNull JFrame frame, @NotNull Context context, @NotNull String name, boolean editMode) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/OperationDetailsDialog.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/OperationDetailsDialog.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/OperationDetailsDialog.<init> must not be null");
        }
        super((Frame)frame, FusionSoaMsg.EDIT_OPER_TITLE.toString(), 7);
        this.constraints = new GridBagConstraints();
        this.display();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void display() {
        this.initGUI();
        this.setVisible(true);
        this.setEnabled(true);
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            int i = this.rowToBeEdited;
            this.selectedOperationDetails.setDescriptionText(this.operationDetailsPanel.getDescription());
            this.operationsTableModel.setValueAt(this.operationDetailsPanel.getDescription(), i, 4);
            OperationInfo operinfo = (OperationInfo)this.operationsTableModel.getValueAt(i, 1);
            operinfo.setDisplayName(this.operationDetailsPanel.getDisplayName());
            this.operationsTableModel.setValueAt(operinfo, i, 1);
            this.selectedOperationDetails.setOperationDisplayName(this.operationDetailsPanel.getDisplayName());
            if (this.selectedOperationDetails.getInArgumentName() != null) {
                this.selectedOperationDetails.setInArgumentDescription(this.operationDetailsPanel.getInArgDesc());
                this.operationsTableModel.setValueAt(this.operationDetailsPanel.getInArgDesc(), ++i, 4);
            }
            if (this.selectedOperationDetails.getOutArgumentName() != null) {
                this.selectedOperationDetails.setOutArgumentDescription(this.operationDetailsPanel.getOutArgDesc());
                this.operationsTableModel.setValueAt(this.operationDetailsPanel.getOutArgDesc(), ++i, 4);
            }
            if (this.selectedOperationDetails.getErrorArgumentName() != null) {
                this.selectedOperationDetails.setErrorArgumentDescription(this.operationDetailsPanel.getErrorArgDesc());
                this.operationsTableModel.setValueAt(this.operationDetailsPanel.getErrorArgDesc(), ++i, 4);
            }
            super.closeDialog(true);
            this.getParent().setVisible(false);
            super.dispose();
        } else {
            super.setVisible(false);
            super.dismissDialog(cancelled);
        }
    }

    private void initGUI() {
        if (Log.isDebugging()) {
            Log.logDebug("Start processing");
        }
        JPanel promotionDialogPanel = new JPanel();
        this.setModal(true);
        this.setResizable(true);
        Dimension dialogSize = new Dimension(655, 570);
        this.setMinimumSize(dialogSize);
        this.setMaximumSize(new Dimension(1310, 1140));
        this.setPreferredSize(dialogSize);
        this.setSize(dialogSize);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultButton(1);
        try {
            this.operationDetailsPanel = new OperationDetailsPanel(this.selectedOperationDetails);
            this.setConstraints(0, 1, 0, 1, 1.0, 10.0, 10, 1);
            promotionDialogPanel.add((Component)this.operationDetailsPanel, this.constraints);
            this.setContent(promotionDialogPanel);
            this.setInitialFocus(this.operationDetailsPanel.getInitialFocusComponent());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContent(), "f1_bpm_buscateditopsd_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean validateDialog() {
        ArrayList msg = new ArrayList();
        return true;
    }

    private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.constraints.gridwidth = gridwidth;
        this.constraints.gridheight = gridheight;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        this.constraints.anchor = anchor;
        this.constraints.fill = fill;
    }
}

