/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.ui.extension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bpm.fusion.soa.controller.AdapterExtensionProvider;
import oracle.bpm.fusion.soa.model.OperationsTableModel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.ui.extension.AdapterExtensionPanel;
import oracle.bpm.fusion.soa.util.AdapterExtensionUtil;
import oracle.bpm.fusion.soa.util.BusinessCatalogValidations;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.project.CatalogServiceUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.ui.WizardTitlePanel;
import org.jetbrains.annotations.NotNull;

public class BusinessCatalogPromotionDialog
extends JEWTDialog {
    private AdapterExtensionPanel adapterExtensionPanel;
    private GridBagConstraints constraints;
    private AdapterExtensionProvider controller;
    private Boolean editMode;
    private AbstractTableModel model;
    private CatalogObject serviceObject;

    public BusinessCatalogPromotionDialog(@NotNull JFrame frame, @NotNull CatalogObject interfaceObject) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (interfaceObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        this(frame, interfaceObject, !interfaceObject.isSynthesized());
    }

    public BusinessCatalogPromotionDialog(@NotNull JFrame frame, @NotNull CatalogObject interfaceObject, boolean editMode) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (interfaceObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        super((Frame)frame, FusionSoaMsg.BUS_CAT_PROMOTION_TITLE.toString(), 7);
        this.constraints = new GridBagConstraints();
        this.editMode = false;
        this.controller = new AdapterExtensionProvider(interfaceObject, editMode);
        this.model = this.controller.getOperationsTableModel();
        this.serviceObject = interfaceObject;
        this.editMode = editMode;
        this.display();
    }

    public BusinessCatalogPromotionDialog(@NotNull JFrame frame, @NotNull Context context, @NotNull String relativeWsdlPath, @NotNull String serviceName, @NotNull Boolean eMode) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (relativeWsdlPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (eMode == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        this(frame, BusinessCatalogPromotionDialog.findServiceObject(context, serviceName), eMode);
    }

    public BusinessCatalogPromotionDialog(@NotNull JFrame frame, @NotNull Context context, @NotNull String relativeWsdlPath, @NotNull String serviceName, boolean eMode) {
        if (frame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (relativeWsdlPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.<init> must not be null");
        }
        this(frame, context, relativeWsdlPath, serviceName, (Boolean)eMode);
    }

    public void display() {
        this.initGUI();
        this.setVisible(true);
        this.setEnabled(true);
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            if (this.validateDialog()) {
                String bpmObjectName = this.adapterExtensionPanel.getBpmObjectName();
                String bpmObjectModule = this.adapterExtensionPanel.getBpmObjectModule();
                if (Log.isDebugging()) {
                    Log.logDebug("CreateDelegated BPM Object data");
                }
                this.controller.createDelegatedBpmObjectData(bpmObjectName, bpmObjectModule, this.adapterExtensionPanel.getBpmObjectDesc());
                if (Log.isDebugging()) {
                    Log.logDebug("Populate the Business catalog");
                }
                this.controller.populateBusinessCatalog(this.model);
                if (Log.isDebugging()) {
                    Log.logDebug("Populating the Business catalog completed");
                }
                super.dispose();
            } else {
                return;
            }
        }
        super.dismissDialog(cancelled);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static CatalogObject findServiceObject(Context context, String serviceName) {
        Project project = AdapterExtensionUtil.getProject(context);
        CatalogObject catalogObject = CatalogServiceUtil.findByTarget((String)serviceName, (Project)project);
        if (catalogObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/BusinessCatalogPromotionDialog.findServiceObject must not return null");
        }
        return catalogObject;
    }

    private void initGUI() {
        if (Log.isDebugging()) {
            Log.logDebug("Start processing");
        }
        JPanel promotionDialogPanel = new JPanel();
        this.setModal(true);
        this.setResizable(true);
        Dimension dialogSize = new Dimension(685, 570);
        this.setMinimumSize(dialogSize);
        this.setMaximumSize(new Dimension(1310, 1140));
        this.setPreferredSize(dialogSize);
        this.setSize(dialogSize);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultButton(1);
        try {
            Image adapterImage = ImageUtils.getImageResource(AdapterExtensionPanel.class, (String)"/oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/adapterWizard.png");
            ImageIcon adapterImageIcon = new ImageIcon(adapterImage);
            WizardTitlePanel titlePanel = new WizardTitlePanel(FusionSoaMsg.CATALOG_PROMOTION_TITLE.toString(), "", (Icon)adapterImageIcon);
            GridBagLayout grid = new GridBagLayout();
            promotionDialogPanel.setLayout(grid);
            this.constraints.insets = new Insets(0, 0, 0, 0);
            this.setConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 2);
            promotionDialogPanel.add((Component)titlePanel, this.constraints);
            String modName = null;
            if (this.editMode.booleanValue()) {
                modName = this.controller.getModule();
            }
            this.adapterExtensionPanel = new AdapterExtensionPanel(this.serviceObject.getProject(), (OperationsTableModel)this.model, this.serviceObject.getObjectType(), this.editMode, modName);
            this.setConstraints(0, 1, 0, 1, 1.0, 10.0, 10, 1);
            promotionDialogPanel.add((Component)this.adapterExtensionPanel, this.constraints);
            this.setContent(promotionDialogPanel);
            this.setInitialFocus(this.adapterExtensionPanel.getInitialFocusComponent());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContent(), "f1_bpm_buscatcustomizew_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean validateDialog() {
        String errorOperationMsg;
        ArrayList<String> msg = new ArrayList<String>();
        if (!this.editMode.booleanValue()) {
            String errorDuplName;
            String errorModuleMsg;
            String errorNameMsg = BusinessCatalogValidations.validateAdapterName(this.adapterExtensionPanel.getBpmObjectName());
            if (!Str.isEmpty(errorNameMsg)) {
                msg.add(errorNameMsg);
            }
            if (!Str.isEmpty(errorModuleMsg = BusinessCatalogValidations.validateModuleName(this.adapterExtensionPanel.getBpmObjectModule()))) {
                msg.add(errorModuleMsg);
            }
            if (!Str.isEmpty(errorDuplName = BusinessCatalogValidations.validateUniqueAdapter(this.serviceObject.getProject(), this.adapterExtensionPanel.getBpmObjectName(), this.adapterExtensionPanel.getBpmObjectModule()))) {
                msg.add(errorDuplName);
            }
        }
        if (!Str.isEmpty(errorOperationMsg = BusinessCatalogValidations.validateOperations(this.model))) {
            msg.add(errorOperationMsg);
        }
        if (!msg.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), msg.toArray());
            return false;
        }
        return true;
    }

    private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.constraints.gridwidth = gridwidth;
        this.constraints.gridheight = gridheight;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        this.constraints.anchor = anchor;
        this.constraints.fill = fill;
    }
}

