/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.transformation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.XSLTransformationService;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.tip.tools.ide.common.mapper.MapperSchema;
import oracle.tip.tools.ide.tx.addin.MapperCreator;
import oracle.tip.tools.ide.tx.addin.MapperExaminer;
import oracle.tip.tools.ide.tx.addin.MapperSource;
import oracle.tip.tools.ide.tx.addin.MapperTarget;
import org.jetbrains.annotations.NotNull;

public class XSLTransformationServiceImpl
implements XSLTransformationService {
    private static XSLTransformationService instance = null;

    private XSLTransformationServiceImpl() {
    }

    public static XSLTransformationService getInstance() {
        if (instance == null) {
            instance = new XSLTransformationServiceImpl();
        }
        return instance;
    }

    public void createXSLTransformation(@NotNull Project project, @NotNull String fileName, @NotNull Sequence<DataDeclaration> sources, @NotNull DataDeclaration target) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createXSLTransformation must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createXSLTransformation must not be null");
        }
        if (sources == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createXSLTransformation must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createXSLTransformation must not be null");
        }
        VFile newFile = this.getTransformationFile(project, fileName);
        URL fileURL = this.getFileURL(newFile);
        this.createNewXSLMap(fileURL, sources, target);
    }

    public boolean matchWithExistingXSLTransformation(@NotNull XSLTransformation existingTranformation, @NotNull Sequence<DataDeclaration> sources, @NotNull DataDeclaration target) {
        if (existingTranformation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.matchWithExistingXSLTransformation must not be null");
        }
        if (sources == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.matchWithExistingXSLTransformation must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.matchWithExistingXSLTransformation must not be null");
        }
        VFile vFile = existingTranformation.getSourceFile();
        URL url = this.getFileURL(vFile);
        MapperExaminer xslExaminer = new MapperExaminer(url);
        List existingMapperSources = (List)Cast.force(xslExaminer.getMapperSources());
        List existingMapperTargets = (List)Cast.force(xslExaminer.getMapperTargets());
        List<MapperSource> selectedMapperSources = this.toMapperSources(sources);
        List<MapperTarget> selectedMapperTargets = this.toMapperTargets(target);
        return this.match(existingMapperSources, selectedMapperSources) && this.match(existingMapperTargets, selectedMapperTargets);
    }

    public boolean isValidDeclaration(@NotNull DataDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.isValidDeclaration must not be null");
        }
        boolean result = false;
        TypeDescription delegate = declaration.getType().getDelegate();
        if (delegate.isArray()) {
            delegate = delegate.getElementType();
        }
        if (delegate.isSchemaObject()) {
            SchemaObject schemaObject = delegate.asSchemaObject();
            result = this.isComplexElement(schemaObject);
        }
        return result;
    }

    private void createNewXSLMap(@NotNull URL fileURL, @NotNull Sequence<DataDeclaration> sources, @NotNull DataDeclaration target) {
        if (fileURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createNewXSLMap must not be null");
        }
        if (sources == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createNewXSLMap must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.createNewXSLMap must not be null");
        }
        List<MapperSource> mapperSources = this.toMapperSources(sources);
        List<MapperTarget> mapperTargets = this.toMapperTargets(target);
        Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
        new MapperCreator(context).createMapper(fileURL, mapperSources, mapperTargets, true);
    }

    private VFile getTransformationFile(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getTransformationFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getTransformationFile must not be null");
        }
        VFileSystem fs = project.getWriter().getProjectFileSystem().getDataFileSystem();
        XSLTransformationsContainer container = project.getResourceFilesContainer().getXSLTransformationsContainer();
        VFile containerVFile = ((Adaptable)container).as(VFile.class);
        return fs.createFile(containerVFile, fileName + ".xsl");
    }

    private URL getFileURL(@NotNull VFile file) {
        URL result;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getFileURL must not be null");
        }
        try {
            VFileSystem fs = file.getFileSystem();
            File file1 = ((JavaFileSystem)fs).toJavaFile(file);
            String path = file1.getPath().replace("\\", "/");
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            result = new URL("file", "", path);
        }
        catch (MalformedURLException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private List<MapperSource> toMapperSources(@NotNull Sequence<DataDeclaration> sources) {
        if (sources == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.toMapperSources must not be null");
        }
        ArrayList<MapperSource> result = new ArrayList<MapperSource>();
        for (DataDeclaration source : sources) {
            MapperElement mapperElement = this.getMapperElement(source);
            if (mapperElement == null) continue;
            MapperSource mapperSource = new MapperSource(this.getMapperType(source), mapperElement.schemaURL, mapperElement.qName);
            QName paramQName = new QName(source.getName());
            mapperSource.setParam(paramQName);
            result.add(mapperSource);
        }
        return result;
    }

    private List<MapperTarget> toMapperTargets(@NotNull DataDeclaration target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.toMapperTargets must not be null");
        }
        ArrayList<MapperTarget> result = new ArrayList<MapperTarget>();
        MapperElement mapperElement = this.getMapperElement(target);
        if (mapperElement != null) {
            MapperTarget mapperTarget = new MapperTarget(this.getMapperType(target), mapperElement.schemaURL, mapperElement.qName);
            result.add(mapperTarget);
        }
        return result;
    }

    private MapperElement getMapperElement(@NotNull DataDeclaration dataDeclaration) {
        SchemaObject schemaObject;
        if (dataDeclaration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getMapperElement must not be null");
        }
        MapperElement result = new MapperElement();
        CatalogType type = dataDeclaration.getType();
        TypeDescription typeDescription = type.getDelegate();
        if (typeDescription.isArray()) {
            typeDescription = typeDescription.getElementType();
        }
        if (typeDescription.isSchemaObject() && this.isComplexElement(schemaObject = typeDescription.asSchemaObject())) {
            try {
                VFile fixedSchema = this.getFixedSchema(dataDeclaration);
                URL url = fixedSchema != null ? this.getFileURL(fixedSchema) : (schemaObject.getResourceLocation() != null ? this.getFileURL(schemaObject.getResourceLocation()) : schemaObject.getResourceUri().toURL());
                result.schemaURL = url;
                result.qName = new QName(schemaObject.getNamespace(), schemaObject.getName());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private VFile getFixedSchema(@NotNull DataDeclaration dataDeclaration) {
        ProjectObject containerParent;
        DataDeclarationContainer declarationContainer;
        if (dataDeclaration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getFixedSchema must not be null");
        }
        VFile result = null;
        if (dataDeclaration.getName().equals("execData") && (declarationContainer = dataDeclaration.getDeclarationContainer()) != null && declarationContainer instanceof CatalogMember && declarationContainer.getName().equals("invoke") && (containerParent = declarationContainer.getParentObject()) != null && containerParent instanceof HumanTask) {
            HumanTask humanTask = (HumanTask)containerParent;
            TypeDescription humanTaskDelegate = humanTask.getDelegate();
            ObjectTypeDescription humanTaskOtd = humanTaskDelegate.asObject();
            result = (VFile)humanTaskOtd.getTransientProperty("Workflowtask.file");
        }
        return result;
    }

    private int getMapperType(@NotNull DataDeclaration element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.getMapperType must not be null");
        }
        return element.getType().getDelegate().asSchemaObject().isFromSchema() ? 1 : 2;
    }

    private boolean isComplexElement(@NotNull SchemaObject schemaObject) {
        if (schemaObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.isComplexElement must not be null");
        }
        return !schemaObject.isBasicType() && schemaObject.isElement();
    }

    private boolean match(@NotNull List<? extends MapperSchema> schemas1, @NotNull List<? extends MapperSchema> schemas2) {
        if (schemas1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.match must not be null");
        }
        if (schemas2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/transformation/XSLTransformationServiceImpl.match must not be null");
        }
        if (schemas1.size() == schemas2.size()) {
            for (int i = 0; i < schemas1.size(); ++i) {
                MapperSchema schema1 = schemas1.get(i);
                MapperSchema schema2 = schemas2.get(i);
                if (schema1.getClass() != schema2.getClass() || !Any.equals(schema1.getElement(), schema2.getElement())) {
                    return false;
                }
                if (!(schema1 instanceof MapperSource)) continue;
                MapperSource source1 = (MapperSource)schema1;
                MapperSource source2 = (MapperSource)schema2;
                if (Any.equals(source1.getParam(), source2.getParam())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static class MapperElement {
        public QName qName;
        public URL schemaURL;

        private MapperElement() {
        }
    }
}

