/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.soabrowser;

import java.net.URL;
import javax.xml.namespace.QName;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.SOASchemaBrowserDialog;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.SOASchemaInfo;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.jdeveloper.JDevProject;
import oracle.tip.tools.ide.common.typeexplorer.DefaultSchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import org.jetbrains.annotations.NotNull;

public class SOASchemaBrowserDialogImpl
implements SOASchemaBrowserDialog {
    private IDEProject ideProject;
    private oracle.bpm.project.model.Project project;
    private SOASchemaInfo soaSchemaInfo;

    public SOASchemaBrowserDialogImpl(@NotNull oracle.bpm.project.model.Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/soabrowser/SOASchemaBrowserDialogImpl.<init> must not be null");
        }
        this.project = project;
    }

    public boolean showDialog() {
        TypeChooser chooser = new TypeChooser(null);
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.setSchemaImportHandler((SchemaImportHandler)new DefaultSchemaImportHandler(this.getIDEProject()));
        ProjectSchemaDataSource ds = new ProjectSchemaDataSource(this.getIDEProject(), true, true);
        CompoundDataSource inputElementDS = new CompoundDataSource();
        inputElementDS.addDataSource((TreeExplorerDataSource)ds);
        if (chooser.display((TreeExplorerDataSource)inputElementDS) == 0) {
            this.project.getComponentCatalog().sync();
            URL url = chooser.getTypeExplorer().getURLForSelectedNode();
            TypeObject typeObject = chooser.getTypeObject();
            XmlElementType type = typeObject.getType() == 2 ? XmlElementType.TYPE : XmlElementType.ELEMENT;
            int fileType = typeObject.getFileType();
            boolean isWsdl = fileType == 5 || fileType == 3 || fileType == 0;
            boolean isExternal = fileType == 6 || fileType == 5 || fileType == 7;
            QName qName = typeObject.getQName();
            this.soaSchemaInfo = new SOASchemaInfo(url, qName, type, isExternal, isWsdl);
            return true;
        }
        return false;
    }

    public SOASchemaInfo getSOASchemaInfo() {
        return this.soaSchemaInfo;
    }

    private IDEProject getIDEProject() {
        if (this.ideProject == null) {
            Adaptable adaptable = (Adaptable)this.project;
            Project project = adaptable.as(Project.class);
            this.ideProject = new JDevProject(project);
        }
        return this.ideProject;
    }
}

