/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.simulation;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.JScrollPane;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsManager;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AsAdapterEvent;
import oracle.rc.asadapter.connection.StoreListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.fabric.asbrowser.ListSOAServersCallback;
import oracle.tip.tools.ide.fabric.asbrowser.SOAServer;
import oracle.tip.tools.ide.fabric.deploy.wizard.treetable.SOAColumn;
import oracle.tip.tools.ide.fabric.deploy.wizard.treetable.SOANode;
import oracle.tip.tools.ide.fabric.deploy.wizard.treetable.SOATreeTable;
import oracle.tip.tools.ide.fabric.deploy.wizard.treetable.SOATreeTableModel;

public class ObtainRoundTripConnectionAction
extends BaseAction {
    private Properties soaServerConnectionInfo;

    public ObtainRoundTripConnectionAction() {
        super(FusionStudioMsg.ROUNDTRIP_CONNECTION);
        this.requires(Void.class);
    }

    public void run() {
        ConfigureConnectionDialog dialog = new ConfigureConnectionDialog();
        this.soaServerConnectionInfo = dialog.doShow() ? dialog.getSoaServerConnectionInfo() : null;
    }

    public Properties getConnectionId() {
        return this.soaServerConnectionInfo;
    }

    private class SoaServerSelectionDialog
    extends OkCancelDialog {
        private final SOATreeTableModel model;
        private SOAServer selectedSoaServer;

        public SoaServerSelectionDialog(List<SOAServer> soaServers) {
            super(Ui.getRoot(), FusionStudioMsg.CONFIGURE_RT_CONNECTION);
            this.model = new SOATreeTableModel(soaServers);
            this.buildUi();
        }

        public void ok() {
            List selectedLeaves = this.model.getSelectedLeaves();
            if (selectedLeaves.size() == 1) {
                this.setVisible(false);
                this.selectedSoaServer = (SOAServer)((SOANode)selectedLeaves.iterator().next()).getUserObject();
            } else {
                MessageDialog.showError((Msg)DesignerMsg.WRONG_SOA_SERVER_SELECTION);
            }
        }

        public SOAServer getSelectedSoaServer() {
            return this.selectedSoaServer;
        }

        public boolean doShow() {
            this.pack();
            this.setSize(Dimension.valueOf(this.getSize().getWidth(), 200));
            this.setLocationRelativeTo((UiComponent)this.getParent());
            this.setVisible(true);
            return this.userAccepted();
        }

        private void buildUi() {
            this.getContentPane().asSwing().setLayout(new GridBagLayout());
            SOANode root = (SOANode)this.model.getRoot();
            Enumeration nodes = root.depthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                SOANode node = (SOANode)nodes.nextElement();
                if (!node.containsDefaultPartition() || !node.isTargetableNode()) continue;
                this.model.setValueAt((Object)Boolean.TRUE, (Object)node, SOAColumn.DEPLOY.ordinal());
            }
            SOATreeTable soaTreeTable = new SOATreeTable(this.model);
            GraphUtils.addComponent((Container)this.getContentPane().asSwing(), (Component)new JScrollPane((Component)soaTreeTable), (int)0, (int)-1, (int)1, (int)10, (int)10, (int)1, (Insets)new Insets(6, 0, 0, 0), (int)10, (int)10, (double)1.0, (double)1.0);
            this.repaint();
        }
    }

    private class ConfigureConnectionDialog
    extends OkCancelDialog
    implements ListSOAServersCallback {
        private ComboBox<String> soaInfraCombo;
        private Properties soaServerConectionInfo;
        private List<SOAServer> soaServers;
        private StoreListener storeListener;

        public ConfigureConnectionDialog() {
            super(Ui.getRoot(), FusionStudioMsg.CONFIGURE_RT_CONNECTION);
            this.buildUi();
            this.startListeningAppServerManager();
            this.addVisibilityListener(new VisibilityListener(){

                public void onDispose() {
                    ConfigureConnectionDialog.this.stopListeningAppServerManager();
                }
            });
        }

        public void ok() {
            String selectedConnection = (String)this.soaInfraCombo.getSelectedItem();
            BPMConnectionsManager.getInstance().getSoaServers(selectedConnection, this.getContentPane().asSwing(), this);
            if (this.soaServers != null && this.soaServers.size() > 0) {
                this.setVisible(false);
                SoaServerSelectionDialog soaServerDialog = new SoaServerSelectionDialog(this.soaServers);
                if (soaServerDialog.doShow() && soaServerDialog.getSelectedSoaServer() != null) {
                    if (soaServerDialog.getSelectedSoaServer().getHttpsURL() != null) {
                        this.soaServerConectionInfo = AppServerManager.getInstance().getAppServer(selectedConnection).getAppServerProvider().getProperties();
                        this.soaServerConectionInfo.put("host", soaServerDialog.getSelectedSoaServer().getHttpsURL().getHost());
                        this.soaServerConectionInfo.put("port", String.valueOf(soaServerDialog.getSelectedSoaServer().getHttpsURL().getPort()));
                    } else if (soaServerDialog.getSelectedSoaServer().getHttpURL() != null) {
                        this.soaServerConectionInfo = AppServerManager.getInstance().getAppServer(selectedConnection).getAppServerProvider().getProperties();
                        this.soaServerConectionInfo.put("host", soaServerDialog.getSelectedSoaServer().getHttpURL().getHost());
                        this.soaServerConectionInfo.put("port", String.valueOf(soaServerDialog.getSelectedSoaServer().getHttpURL().getPort()));
                    }
                    this.soaServerConectionInfo.put("useSSL", String.valueOf(soaServerDialog.getSelectedSoaServer().isSSLEnabled()));
                }
            }
        }

        public boolean doShow() {
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
            this.setVisible(true);
            return this.userAccepted();
        }

        public Properties getSoaServerConnectionInfo() {
            return this.soaServerConectionInfo;
        }

        public void handleSuccess(List<SOAServer> soaServers) {
            this.soaServers = soaServers;
        }

        public void handleException(Exception e) {
            MessageDialog.showError((Msg)DesignerMsg.CANNOT_RETRIEVE_SOA_SERVERS);
            throw new ExecutionException(e);
        }

        private void startListeningAppServerManager() {
            this.storeListener = new StoreListener(){

                public void storeEvent(AsAdapterEvent asAdapterEvent) {
                    if (StoreListener.OBJECT_ADDED.equals(asAdapterEvent.getType())) {
                        ConfigureConnectionDialog.this.soaInfraCombo.addItem((Object)((String)asAdapterEvent.getData()));
                    }
                }
            };
            AppServerManager.getInstance().addStoreListener(this.storeListener);
        }

        private void stopListeningAppServerManager() {
            AppServerManager.getInstance().removeStoreListener(this.storeListener);
        }

        private void buildUi() {
            Panel mainPanel = Panel.createPanelWithBorder((UiContainer)this.getContentPane());
            mainPanel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
            Label comboLabel = Label.create((UiContainer)mainPanel, (Msg)FusionStudioMsg.ROUNDTRIP_CONNECTION);
            this.soaInfraCombo = UiFactory.createComboBox((UiContainer)mainPanel, this.getSoaInfraServers());
            if (this.soaInfraCombo.getItemCount() > 0) {
                this.soaInfraCombo.setSelectedIndex(0);
            }
            Button newConnectionButton = Button.createIconic((UiContainer)mainPanel, (Msg)UIMsg.ADD);
            newConnectionButton.addActionListener(this.getNewConnectionActionListener());
            mainPanel.add((UiComponent)comboLabel);
            mainPanel.add(this.soaInfraCombo, (Object)"growx, wmin 200");
            mainPanel.add((UiComponent)newConnectionButton);
            this.setIconImage(Image.create((Msg)this.getMsg()));
            this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        private Collection<String> getSoaInfraServers() {
            return AppServerManager.getInstance().list();
        }

        private ActionListener getNewConnectionActionListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AppServerManager.getInstance().runNewAppServerWizardDialog();
                    ConfigureConnectionDialog.this.updateSoaInfraConnectionsList();
                }
            };
        }

        private void updateSoaInfraConnectionsList() {
            this.soaInfraCombo.removeAllItems();
            for (String soaInfraServer : this.getSoaInfraServers()) {
                this.soaInfraCombo.addItem((Object)soaInfraServer);
                this.soaInfraCombo.setSelectedItem((Object)soaInfraServer);
            }
        }
    }
}

