/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.rules.ParametersEntry;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.util.Identifier;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.JDevDictionaryFileBuilder;
import oracle.tip.tools.ide.rules.sdkmodel.SchemaElem;
import org.jetbrains.annotations.Nullable;

public class BusinessRuleUtils {
    private BusinessRuleUtils() {
    }

    public static BusinessRule createBusinessRule(final oracle.bpm.project.model.Project project, final WizardData data) throws ProjectException {
        final Any.Holder result = new Any.Holder();
        VFileSystem dataFileSystem = project.getLoader().getProjectFileSystem().getDataFileSystem();
        dataFileSystem.runWithEventsDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Transactable root = (Transactable)project.getCatalogRoot();
                    try {
                        root.beginTransaction();
                        Project jdevProject = (Project)BusinessRuleUtils.adaptTo(project, Project.class);
                        result.value = BusinessRuleUtils.createBusinessRule(jdevProject, data);
                        try {
                            ComponentCatalog catalog = project.getComponentCatalog();
                            catalog.sync();
                            String businessRuleName = data.getName();
                            String normalizedName = Identifier.classname(businessRuleName);
                            String rulesPackage = data.getPackageName();
                            rulesPackage = XmlUtils.buildValidQualifiedModuleName((String)rulesPackage);
                            rulesPackage = !Str.isEmpty(rulesPackage) ? "." + rulesPackage : "";
                            String humanTaskCatalogId = "Rules" + rulesPackage + "." + normalizedName;
                            result.value = project.findCatalogObject(humanTaskCatalogId);
                        }
                        catch (Throwable e) {
                            result.value = new ProjectException((ProjectObject)project, FusionSoaMsg.ERROR_CATALOGING_BUSINESS_RULE(data.getName()), e);
                        }
                    }
                    finally {
                        root.endTransaction();
                    }
                }
                catch (Throwable e) {
                    result.value = new ProjectException((ProjectObject)project, FusionSoaMsg.ERROR_CREATING_BUSINESS_RULE(data.getName()), e);
                }
            }
        });
        if (result.value instanceof ProjectException) {
            throw (ProjectException)((Object)result.value);
        }
        return result.value instanceof BusinessRule ? (BusinessRule)result.value : null;
    }

    public static void applyToWizardData(Collection<ParametersEntry> entries, WizardData data) {
        HashSet<SchemaElem> inXSDs = new HashSet<SchemaElem>();
        HashSet<SchemaElem> outXSDs = new HashSet<SchemaElem>();
        for (ParametersEntry entry : entries) {
            DataDeclaration dataDeclaration = entry.getDataDeclaration();
            SchemaObject schemaObject = BusinessRuleUtils.getSchemaObject(dataDeclaration);
            if (schemaObject == null || !schemaObject.isElement() && !schemaObject.isBasicType()) continue;
            SchemaElem element = BusinessRuleUtils.createSchemaElem(dataDeclaration.getName(), schemaObject);
            if (entry.isInput()) {
                inXSDs.add(element);
                continue;
            }
            outXSDs.add(element);
        }
        ArrayList inputXSD = new ArrayList(inXSDs);
        ArrayList outputXSD = new ArrayList(outXSDs);
        data.setInputVarsXSD(inputXSD);
        data.setOutputVarsXSD(outputXSD);
    }

    @Nullable
    static SchemaObject getSchemaObject(DataDeclaration dataDeclaration) {
        SchemaObject result = null;
        CatalogType catalogType = dataDeclaration.getType();
        TypeDescription typeDescription = catalogType.getDelegate();
        try {
            result = typeDescription.asSchemaObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private static URL createBusinessRule(Project jdevProject, WizardData data) throws Exception {
        JDevDictionaryFileBuilder builder = new JDevDictionaryFileBuilder(jdevProject);
        return builder.createRuleDictionary(data);
    }

    private static SchemaElem createSchemaElem(String name, SchemaObject schemaObject) {
        QName qName;
        SchemaElem element = new SchemaElem();
        element.m_schemaFileName = "";
        if (schemaObject.isElement()) {
            VFile vFile = schemaObject.getResourceLocation();
            try {
                URI uri = null;
                if (vFile != null) {
                    element.m_schemaFileName = vFile.getName();
                    if (vFile.getFileSystem() instanceof JavaFileSystem) {
                        JavaFileSystem jfs = (JavaFileSystem)vFile.getFileSystem();
                        File file = jfs.toJavaFile(vFile);
                        uri = file.toURI();
                    }
                } else {
                    uri = schemaObject.getResourceUri();
                }
                if (uri != null && uri.isAbsolute()) {
                    element.m_schemaURL = uri.toURL();
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        element.m_elemType = qName = schemaObject.getQName();
        element.m_elemName = qName;
        element.m_aliasInfo = name;
        return element;
    }

    private static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }
}

